/*
 *      $Source: /home/fergia/CVS//tcfs-openbsd/tcfslib-1.0.0/lib/tcfs_tab.c,v $
 *      $Revision: 1.1.1.1 $
 *      $Date: 2000/06/07 12:21:31 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <fstab.h>
#include "tcfs_global.h"
#include "tcfs_tab.h"
#include "tcfs_errno.h"

#define WHITESPACE " \t\r\n"

int
tcfs_get_label(const char *label2search, char *path, int *ciphernumber)
{
        FILE *fp;
        char *label, *line, *p, *tag, *mountpoint, *cipherfield;
        int found = 0;

        if ((fp = fopen(_PATH_FSTAB,"r")) == NULL)
                return (0);

        if ((line = calloc(1024, sizeof(char))) == NULL)
                goto out;

        while (!feof(fp) && !found) {
                p = line;
                fgets (p, 1024, fp);
                p = p + strspn(p, WHITESPACE);
                while (!found) {
                        strsep(&p, WHITESPACE);  /* device */
                        if (p == NULL)
                                break;
                        p = p + strspn(p, WHITESPACE);
                        mountpoint = strsep(&p, WHITESPACE); /* mount point */
			if (p == NULL)
                                break;
                        tag = strsep(&p, WHITESPACE); /* file system */
                        if (p == NULL || strcmp(tag, "tcfs"))
                                break;

                        /* find the correct label */
                        label = strstr(p, "label=");
                        cipherfield = strstr(p, "cipher=");
                        if (label == NULL)
                                break;
                        p = label + 6;
                        label = strsep(&p, WHITESPACE ",");
                        if (!strlen(label) || strcmp(label, label2search))
                                break;

                        if (path) {
                                strcpy(path, mountpoint);
                                found = 1;
                        }
                        
                        if (ciphernumber) {
                                if (cipherfield == NULL)
 					break;
                                p = cipherfield + 7;
                                cipherfield = strsep(&p, WHITESPACE ",");
                                if (!strlen(cipherfield))
                                        break;

                                *ciphernumber = strtol(cipherfield, &p, 0);
                                if (cipherfield != p) 
                                        found = 1;
                        }
                }
        }
        free(line);
 out:
        fclose (fp);

        return found;
}

/* It gives back a tab_entry struct associated with label. On error it returns NULL */

tab_entry * tcfs_gettab_label(const char *label) {
	
	FILE* tab;
	tab_entry *entry=malloc(sizeof(tab_entry));
	int cipher;
	
	tcfs_errno=OK;
	if (!tcfs_get_label(label, entry->mount_point, &cipher))
		tcfs_errno=ER_TAB_NOTFOUND;
		
	if (tcfs_errno==OK) {
		strcpy(entry->label,label);
		entry->cipher_num=cipher;

#ifdef TCFS_DEBUG
	fprintf(stderr,"label:%s,mount:%s,cipher:%d",entry->label,entry->mount_point,entry->cipher_num);
#endif
		return(entry);
	}
	
	free(entry);
	return(NULL);
}

