/*
 *      $Source: /home/fergia/CVS/tcfs-openbsd/tcfsutils-1.0.0/src/tcfsadduser.c,v $
 *      $Revision: 1.2 $
 *      $Date: 2000/06/07 13:24:23 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */


#include "tcfslib.h"
#include "tcfsutils.h"
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <sys/types.h> 
#include <pwd.h>


int main(int argc, char* argv[]) {

	const char* optstring=ADDUSER_OPTSTRING;
	const char* usage=ADDUSER_USAGE;
		
	int val;
	option_flags flag;
	char user[UserLen+1];
	tcfspwdb* user_info;

	RESET_WORD(flag);

        printf ("\nTCFS Utilities: version %d.%d.%d\n", MAJOR, MINOR, RELEASE);
	while ((val=getopt(argc,argv,optstring))!=-1) {

		switch(val) {
			case USER:
				strncpy(user,optarg,UserLen);
				user[UserLen]='\0';
				SET_ISUSER(flag);
				break;
			case VERBOSE:
				SET_ISVERBOSE(flag);
				break;
			case HELP:
				printf(usage,argv[0],USER,VERBOSE,HELP);
				exit(0);
			default:
				printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
				exit(-1);
		}
	}

	if (optind!=argc) {
		printf("Invalid option -- %s\n",argv[optind]);
		printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
		exit(-1);
	}	

	if (!TEST_ISUSER_SET(flag)) {
		char *last;

		printf("Insert the user name to add in the TCFS key's file: ");
		fgets(user,UserLen+1,stdin);
		if ((last=strrchr(user,'\n'))!=NULL) *last='\0';
	}

	if (getpwnam(user)==NULL) {
		printf("User <%s> has not a valid account.\n",user);
		if (TEST_ISVERBOSE_SET(flag)) 
			printf("Be sure to create a valid account for user <%s> first.\n",user);
		printf("\n");
		exit(-1);
	}

  	
	if ((user_info=tcfs_pwdb_alloc())==NULL) {
		printf("%s\n\n",tcfs_strerror(tcfs_errno));
		exit(-1);
	}

	if (tcfs_pwdb_edit(user_info,TCFS_DBUSER,user)!=0) {
		printf("%s\n\n",tcfs_strerror(tcfs_errno));
		exit(-1);
	}

	if (TEST_ISVERBOSE_SET(flag))
		printf("Inserting entry for user <%s> into TCFS key's file...\n",user); 

	if (tcfs_pwfile_store(user,user_info,TCFS_DBINSERT)!=0) {
		printf("%s\n",tcfs_strerror(tcfs_errno));

		if (TEST_ISVERBOSE_SET(flag)) 
			printf("Possible causes:\n\t1) The TCFS key's file hasn't the write permission.\n\t2) The entry for user <%s> already exists.\n\t3) The TCFS key's file may be corrupted.\n\n",user);
		else printf("\n");

		exit(-1);
	}

	printf("Entry for user <%s> was inserted.\n",user); 
	printf("\n");
	
	return 0;
}
	
