/*
 *      $Source: /home/fergia/CVS/tcfs-openbsd/tcfsutils-1.0.0/src/tcfsgenkey.c,v $
 *      $Revision: 1.2 $
 *      $Date: 2000/06/07 13:24:23 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include "tcfslib.h"
#include "tcfsutils.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <termios.h>
#include <ctype.h>

extern int auth(char*,char*);

int main (int argc, char *argv[])
{
	const char* optstring=GENKEY_OPTSTRING;
	const char* usage=GENKEY_USAGE;
	int val;
	option_flags flag;
	char *key=NULL, *password, *user, *cryptedkey, *have_key;
	
	tcfspwdb* entry;

	RESET_WORD(flag);

 	printf ("\nTCFS Utilities: version %d.%d.%d\n", MAJOR, MINOR, RELEASE);
	while ((val=getopt (argc,argv,optstring))!=-1) {

		switch (val)
		{
			case HELP:
				printf(usage,argv[0],VERBOSE,HELP);
                                exit(0);

			case VERBOSE:
				SET_ISVERBOSE(flag);
				break;
			default:
				 printf("Try '%s -%c' for more information.\n\n",argv[0],HELP);
                                exit(-1);
		}
	}

	if (optind!=argc) {
                printf("Invalid option -- %s\n",argv[optind]);
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
                exit(-1);
        }      
	
	if (geteuid()!=0) {
		printf("Command %s must have root privileges.\n\n",argv[0]);
		exit(-1);
	}

	user=getlogin();	
	password=getpass("Insert your password, please: ");
	
	 if (auth (user, password)==-1) {
        	 memset(password,'\0',strlen(password));
                 printf ("Invalid password for user <%s>.\n",user);

		if (TEST_ISVERBOSE_SET(flag))
			printf("Be sure to insert the correct password.\n");

		printf("\n");
                exit(-1);
        }

	
	if ((entry=tcfs_pwfile_fetch(user))==NULL) {
	
		printf("%s\n",tcfs_strerror(tcfs_errno));	
		
		if (tcfs_errno==ER_GDBMNODATA) {
			printf("User <%s> doesn't have a valid entry into TCFS key's file.\n",user);
	
			if (TEST_ISVERBOSE_SET(flag) && tcfs_errno==ER_GDBMNODATA)
				printf("Contact your system administrator to get a TCFS entry.\n");
		}

		printf("\n");
		exit(-1);
	}	

	have_key=malloc(UUKEYSIZE);
	tcfs_pwdb_fetch(entry,TCFS_DBKEY,have_key);

#ifdef TCFS_DEBUG
                fprintf(stderr,"\thave_key: %s\n",have_key);
#endif

	/* Check if you want to replace the key, if it already exists. */	
	if (strlen(have_key)>0) {
		struct termios new,old;
		char option;
		
		printf("Warning: \n\tUser <%s> has already a TCFS key.\n",user);
		printf("\tIf you'll go on, all the files crypted with the old key, will be lost.\n");
		printf("\tBefore going on, make sure to decrypt such files.\n");
		printf("\tYou'll crypt them with the new key later.\n");
		printf("Do you want to go on? (Y/N)");
		fflush(stdout);

		tcgetattr(STDIN_FILENO,&old);
		memcpy(&new,&old,sizeof(struct termios));

		new.c_lflag&=~ECHO;
		new.c_lflag&=~ICANON;
		new.c_cc[VMIN]=1;
		new.c_cc[VTIME]=0;

		tcsetattr(STDIN_FILENO,TCSANOW,&new);

		do {
			read(STDIN_FILENO,&option,sizeof(char));
			option=toupper(option);
		} while ((option!='Y') && (option!='N'));
		
		tcsetattr(STDIN_FILENO,TCSANOW,&old);
		printf("\n");

#ifdef TCFS_DEBUG
	fprintf(stderr,"%s: value of option: %c\n",argv[0],option);
#endif
		
	
		if (option=='N') {	
		
			printf("Wise decision.\n\n");
			exit(-1);
		}
	}

	free(have_key);

	printf("Press %d random keys, please: ",MAX_KEY_PRESS);

	key=gentcfskey();	 
	
	printf("\n");

	if (TEST_ISVERBOSE_SET(flag))
		printf("Key for user <%s> generated.\n",user);
	
#ifdef TCFS_DEBUG
	{
        	int i;

                fprintf (stderr,"%s: %s key: ", argv[0], user);
                for (i=0;i<KEYSIZE;i++)
	                fprintf (stderr,"%X:", key[i]);
                fprintf (stderr,"\n");
        }
#endif

	if (TEST_ISVERBOSE_SET(flag)) 
		printf("Encrypting key just generated...\n");
	if ((cryptedkey=tcfs_encrypt_key(key, password,TCFS_USER_KEY))==NULL) {

		printf("%s\n\n",tcfs_strerror(tcfs_errno));
		exit(-1);

	}

#ifdef TCFS_DEBUG
	{
        	int i;

                fprintf (stderr,"%s: %s key: ", argv[0], user);
                for (i=0;i<KEYSIZE;i++)
	                fprintf (stderr,"%X:", key[i]);
                fprintf (stderr,"\n");
        }
#endif
	free(key);

#ifdef TCFS_DEBUG
	{
        	 unsigned char *key;
                 int i;

                 if ((key=tcfs_decrypt_key (cryptedkey, password, TCFS_USER_KEY))==NULL) {
	                 fprintf(stderr,"%s: Error on decrypting key\n\n",argv[0]);
                         exit (-1);
                 }

                 fprintf (stderr,"%s: %s key: ",argv[0],user);
                 for (i=0;i<KEYSIZE;i++)
        	          fprintf (stderr,"%X:", key[i]);
                 fprintf(stderr,"\n");

                 free (key);
       	}
#endif

	memset(password,'\0',strlen(password));

	
	if (tcfs_pwdb_edit(entry,TCFS_DBKEY,cryptedkey)!=0) {

		printf("%s\n\n",tcfs_strerror(tcfs_errno));		
		exit(-1);

	}

#ifdef TCFS_DEBUG
                fprintf(stderr,"%s: entry:\n",argv[0]);
                fprintf(stderr,"\tuser: %s\n",entry->user);
                fprintf(stderr,"\tkey: %s\n",entry->key);
#endif

	if (TEST_ISVERBOSE_SET(flag)) 
		printf("Updating entry for user <%s>...\n",user);

	if (tcfs_pwfile_store(user,entry,TCFS_DBREPLACE)!=0) {

		printf("%s\n",tcfs_strerror(tcfs_errno));

		if (TEST_ISVERBOSE_SET(flag)) 
                        printf("Possible causes:\n\t1) The TCFS key's file hasn't the write permission.\n\t2) The TCFS key's file may be corrupted.\n");
                
		printf("\n");
                exit(-1);
	}

	printf("Updating completed: key succesfully generated.\n\n");

	return 0;
}


