/*
 *      $Source: /home/fergia/CVS/tcfs-openbsd/tcfsutils-1.0.0/src/tcfsrmkey.c,v $
 *      $Revision: 1.2 $
 *      $Date: 2000/06/07 13:24:24 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <grp.h>
#include "tcfslib.h"
#include "tcfsutils.h"

#define DIM 256

int main (int argc, char *argv[])
{
	const char* optstring=REMOVEKEY_OPTSTRING;
	const char* usage=REMOVEKEY_USAGE;
	int val, result;
	gid_t gid;	
	uid_t uid;
	char group_name[MAX], label[DIM], filesystem[DIM];
	option_flags flag;
	char *user;

	RESET_WORD(flag);

	printf ("\nTCFS Utilities: version %d.%d.%d\n", MAJOR, MINOR, RELEASE);
	while ((val=getopt (argc,argv,optstring))!=-1) {

		switch (val)
		{
			case GID:
				gid=(gid_t)atoi(optarg);
				SET_ISGID(flag);
				break;
			case GROUP_NAME:
				strcpy(group_name,optarg);
				SET_ISGROUPNAME(flag);
				break;
			case HELP:
				printf(usage,argv[0],LABEL,MOUNT_POINT,GID,GROUP_NAME,VERBOSE,HELP);
                                exit(0);
			case VERBOSE:
				SET_ISVERBOSE(flag);
				break;
			 case LABEL:
                                SET_ISLABEL(flag);
                                strcpy(label,optarg);
                                break;
                        case MOUNT_POINT:
                                SET_ISMOUNTPOINT(flag);
                                strcpy(filesystem,optarg);
                                break;  
			default:
				 printf("Try '%s -%c' for more information.\n\n",argv[0],HELP);
                                exit(-1);
		}
	}

	if (optind!=argc) {
                printf("Invalid option -- %s\n",argv[optind]);
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
                exit(-1);
        }     

	/* Check the options' constistency */
	if (TEST_ISGROUPNAME_SET(flag) && TEST_ISGID_SET(flag)) {
		printf("You've specified both the gid option and the group name option.\n");
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
		exit(-1);
	}

	 if (TEST_ISLABEL_SET(flag) && TEST_ISMOUNTPOINT_SET(flag)) {
                printf("You've specified both the label option and the mount point option.\n");
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
                exit(-1);
        }
	/* End of consistency check */

	/* Get filesystem on which make operations */
        if ((!TEST_ISLABEL_SET(flag) && !TEST_ISMOUNTPOINT_SET(flag)) || TEST_ISLABEL_SET(flag)) {
                tab_entry* entry;
                
                if ((entry=tcfs_gettab_label(TEST_ISLABEL_SET(flag)?label:"default"))==NULL) {
                        printf("%s\n",tcfs_strerror(tcfs_errno));
                        
                        if (TEST_ISVERBOSE_SET(flag))
                                printf("Make sure to give a correct label or that the tcfstab file exists.\n");

                        printf("\n");
                        exit(-1);
                }
                
                strcpy(filesystem,entry->mount_point);

        }
        
#ifdef TCFS_DEBUG
        fprintf(stderr,"Filesystem on wich I make operations: %s\n",filesystem);
#endif
	
	/* Get the group id value if group name option is set */
	if (TEST_ISGROUPNAME_SET(flag)) {
		struct group* group_info;
	
		if ((group_info=getgrnam(group_name))==NULL) {
			printf("Group with group name <%s> doesn't exist.\n",group_name);
			if (TEST_ISVERBOSE_SET(flag))
				printf("Contact your system's administrator to create this group.\n");
			printf("\n");
			exit(-1);
		}
		gid=group_info->gr_gid;
	}

	user=getlogin();
	uid=getuid();

#ifdef TCFS_DEBUG
	fprintf(stderr,"%s: user: %s uid: %d.\n",argv[0],getlogin(),getuid());
#endif

	printf("Removing key for TCFS filesystem '%s'...\n",filesystem);

	if (TEST_ISGROUPNAME_SET(flag) || TEST_ISGID_SET(flag)) 
		result=tcfs_group_disable(filesystem,uid,gid);
	else 
		result=tcfs_user_disable(filesystem,uid);

	if (result!=0) {

		printf("%s\n",tcfs_strerror(tcfs_errno));

		if (TEST_ISVERBOSE_SET(flag)) 
                        printf("Make sure that there is a TCFS key for filesystem '%s'.\n",filesystem);
                
		printf("\n");
                exit(-1);
	}

	printf("Removing completed.\n\n");
	
	return 0;
}
