/*
 *      $Source: /home/fergia/CVS/tcfs-openbsd/tcfsutils-1.0.0/src/tcfsrmuser.c,v $
 *      $Revision: 1.2 $
 *      $Date: 2000/06/07 13:24:24 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include "tcfslib.h"
#include "tcfsutils.h"
#include <unistd.h>
#include <string.h>
#include <stdio.h>


int main(int argc, char* argv[]) {

	const char* optstring=RMUSER_OPTSTRING;
	const char* usage=RMUSER_USAGE;
		
	int val;
	char user[UserLen+1];
	tcfspwdb* user_info;
	option_flags flag;

	RESET_WORD(flag);

	printf ("\nTCFS Utilities: version %d.%d.%d\n", MAJOR, MINOR, RELEASE);
	while ((val=getopt(argc,argv,optstring))!=-1) {

		switch(val) {
			case USER:
				strncpy(user,optarg,UserLen);
				user[UserLen]='\0';
				SET_ISUSER(flag);
				break;
			case VERBOSE:
				SET_ISVERBOSE(flag);
				break;
			case HELP:
				printf(usage,argv[0],USER,VERBOSE,HELP);
				exit(0);
			default:
				printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
				exit(-1);
		}
	}

	if (optind!=argc) {
		printf("Invalid option -- %s\n",argv[optind]);
		printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
		exit(-1);
	}	

	if (!TEST_ISUSER_SET(flag)) {
		char *last;

		printf("Insert the user name to remove from the TCFS key's file: ");
		fgets(user,UserLen+1,stdin);
		if ((last=strrchr(user,'\n'))!=NULL) *last='\0';
	}

	if ((user_info=tcfs_pwdb_alloc())==NULL) {
		printf("%s\n\n",tcfs_strerror(tcfs_errno));
		exit(-1);
	}

	if (tcfs_pwdb_edit(user_info,TCFS_DBUSER,user)!=0) {
		printf("%s\n\n",tcfs_strerror(tcfs_errno));
		exit(-1);
	}

	if (TEST_ISVERBOSE_SET(flag)) 
		printf("Removing user <%s> from the TCFS database...\n",user); 

	if (tcfs_pwfile_store(user,user_info,TCFS_DBDELETE)!=0) {
		printf("%s\n",tcfs_strerror(tcfs_errno));

		if (TEST_ISVERBOSE_SET(flag)) 
			printf("Possible causes:\n\t1) The TCFS key's file hasn't the write permission.\n\t2) The entry doesn't exist.\n\t3) The TCFS key's file may be corrupted.\n\t4) The TCFS key's file doesn't exist.\n\n");
		else printf("\n");

		exit(-1);
	}

	printf("Removing completed.\n"); 
	printf("\n");


	return 0;
}
	
