/*
 *      $Source: /home/fergia/CVS/tcfs-openbsd/tcfsutils-1.0.0/src/tcfsrun.c,v $
 *      $Revision: 1.2 $
 *      $Date: 2000/06/07 13:24:24 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include "tcfslib.h"
#include "tcfsutils.h"

#define DIM 256
#define DEFAULT_COMMAND	"sh"

int main (int argc, char *argv[]) {

	const char* optstring=RUN_OPTSTRING;
	const char* usage=RUN_USAGE;
	int val, status;
	option_flags flag;
	char label[DIM], filesystem[DIM], command[DIM], *tcfskey;
	pid_t pid;
	uid_t uid;

	RESET_WORD(flag);
 	printf ("\nTCFS Utilities: version %d.%d.%d\n", MAJOR, MINOR, RELEASE);
	while ((val=getopt (argc,argv,optstring))!=-1) {

		switch (val)
		{
			 case LABEL:
                                SET_ISLABEL(flag);
                                strcpy(label,optarg);
                                break;
                        case MOUNT_POINT:
                                SET_ISMOUNTPOINT(flag);
                                strcpy(filesystem,optarg);
                                break;  
			case HELP:
				printf(usage,argv[0],LABEL,MOUNT_POINT,VERBOSE,HELP);
                                exit(0);
			case VERBOSE:
				SET_ISVERBOSE(flag);
				break;
			default:
				printf("Try '%s -%c' for more information.\n\n",argv[0],HELP);
                                exit(-1);
		}
	}

	if ((argc==1) || (optind==argc)) strcpy(command,DEFAULT_COMMAND);
        else strcpy(command,argv[optind]);

	/* Check the options' constistency */

	if (TEST_ISLABEL_SET(flag) && TEST_ISMOUNTPOINT_SET(flag)) {
                printf("You've specified both the label option and the mount point option.\n");
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
                exit(-1);
        }

	/* End of consistency check */
	
	/* Get filesystem on which make operations */
        if ((!TEST_ISLABEL_SET(flag) && !TEST_ISMOUNTPOINT_SET(flag)) || TEST_ISLABEL_SET(flag)) {
                tab_entry* entry;
                
                if ((entry=tcfs_gettab_label(TEST_ISLABEL_SET(flag)?label:"default"))==NULL) {
                        printf("%s\n",tcfs_strerror(tcfs_errno));
                        
                        if (TEST_ISVERBOSE_SET(flag))
                                printf("Make sure to give a correct label or that the tcfstab file exists.\n");

                        printf("\n");
                        exit(-1);
                }
                
                strcpy(filesystem,entry->mount_point);

        }

	printf("Insert key for filesystem '%s':",filesystem);
	tcfskey=getpass("");
	uid=getuid();

#ifdef TCFS_DEBUG
	fprintf(stderr,"Command '%s'...\n",command);
	fprintf(stderr,"UID '%d'...\n",uid);
#endif
	
	if (TEST_ISVERBOSE_SET(flag))
        	printf("Creating process for '%s'...\n",command);
	
	if ((pid=fork())<0) {
		printf("Error on creating new process.\n\n");
		exit(-1);
	}

	/* Child process */
	if (pid==0) {	
		
		if (TEST_ISVERBOSE_SET(flag))
        		printf("Passing key for process...\n");

		if (tcfs_process_enable(filesystem, uid, getpid(), tcfskey)!=0) {
			printf("%s\n",tcfs_strerror(tcfs_errno));	

			if (TEST_ISVERBOSE_SET(flag)) 
				printf("Make sure that '%s' is a valid TCFS filesystem mounted.\n",filesystem);

			printf("\n");
			exit(-1);
		}
		
		if (setuid(uid)==-1) {
			printf("Error on setting user id of process.\n\n");
			exit(-1);
		}

#ifdef TCFS_DEBUG 
	fprintf(stderr,"Child: uid:%d, effective:%d\n",getuid(),geteuid());
	fprintf(stderr,"Child: argv+optind:%s\n",argv[optind]);
#endif
		
		if (TEST_ISVERBOSE_SET(flag))
        		printf("Executing command '%s'...\n",command);

	 	if (execvp(command,argv+optind)<0) { 
			printf("Error on executing command '%s'.\n",command);
			exit(-1);
		}

	}

	/* Parent process */

	if (wait(&status)==-1) {
		printf("Error on waiting for termination of process.\n\n");
		exit(-1);
	}

#ifdef TCFS_DEBUG 
	fprintf(stderr,"Father: uid:%d, effective:%d\n",getuid(),geteuid());
#endif

	if (tcfs_process_disable(filesystem,uid,pid)==0) printf("\n");

	return 0;
}
