/*
 *      $Source: /home/fergia/CVS//tcfs-openbsd/tcfslib-1.0.0/include/tcfs_database.h,v $
 *      $Revision: 1.1.1.1 $
 *      $Date: 2000/06/07 12:21:30 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

/* START OF DATABASE SECTION */

#include <sys/types.h>

/* For text database */
#define NUM_OF_PWDBFIELD	2
#define MAX_LINE 		UserLen+KeyLen+NUM_OF_PWDBFIELD

typedef struct tcfspwdb_r {
	char user[UserLen+1];
	char key[KeyLen+1];
} tcfspwdb;

typedef struct tcfsgpwdb_r {
	char user[UserLen+1];
	char groupkey[KeyLen+1];
	gid_t gid;
	unsigned int numofparts;
	unsigned int threshold;
} tcfsgpwdb;

#define TCFS_PWDBPATH 		"/usr/tcfs/etc/tcfspwdb" /* Must be /etc/tcfspwdb */
#define TCFS_PWDBSIZE		1024
#define TCFS_PWDBMODE		0644

#define TCFS_GPWDBPATH 		"/usr/tcfs/etc/tcfsgpwdb" 
#define TCFS_GPWDBSIZE		TCFS_PWDBSIZE
#define TCFS_GPWDBMODE		TCFS_PWDBMODE

#define TCFS_DBNULL		0
#define TCFS_DBINSERT		1
#define TCFS_DBREPLACE		2 
#define TCFS_DBDELETE		3


#define TCFS_DBUSER	0x01	/* edit user flag */
#define TCFS_DBKEY	0x02	/* edit key flag */
#define TCFS_DBGID	0x04	/* edit gid flag */
#define TCFS_DBPARTS	0x08	/* edit number of parts flag */
#define TCFS_DBTHRSHO	0x10	/* edit threeshold flag */

#define TCFS_DIMGID	5 	/* the group id's range is between 0 and 10^5-1 */


/* Prototypes for TCFS key's database management */

tcfspwdb* tcfs_pwdb_alloc(void);
tcfsgpwdb* tcfs_gpwdb_alloc(void);
void tcfs_pwdb_free(tcfspwdb*);
void tcfs_gpwdb_free(tcfsgpwdb*);
int tcfs_pwdb_edit(tcfspwdb*, int, ...);
int tcfs_gpwdb_edit(tcfsgpwdb*, int, ...);
int tcfs_pwdb_fetch(tcfspwdb*, int, ...);
int tcfs_gpwdb_fetch(tcfsgpwdb*, int, ...);
int tcfs_pwfile_store(char*, tcfspwdb*, unsigned int);
int tcfs_gpwfile_store(char*, gid_t, tcfsgpwdb*, unsigned int);
tcfspwdb* tcfs_pwfile_fetch(char*);
tcfsgpwdb* tcfs_gpwfile_fetch(char*, gid_t);
int tcfs_gpwfile_scan(gid_t, int*, int);
int tcfs_change_userkey(char*, char*, char*);
int tcfs_change_groupkey(char*, char*, char*);

/* END OF DATABASE SECTION */




