
/*
 *      $Source: /home/fergia/CVS//tcfs-openbsd/tcfslib-1.0.0/include/tcfs_errno.h,v $
 *      $Revision: 1.1.1.1 $
 *      $Date: 2000/06/07 12:21:30 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

/* START OF ERROR SECTION */

/* tcfs_errno is defined in tcfs_global.c */ 
extern int tcfs_errno;

enum
{
	OK=0,		/* 0 - Ok, no error */
	ER_MEM,        	/* 1 - Out of memory error - u */
	ER_ENABLE,     	/* 2 - Error sending key - u*/
	ER_DISABLE,     /* 3 - Error getting key - u*/
	ER_STATUS,       /* 4 - Error getting status - u*/
	ER_UNKGDBMOPER, /* 5 - Unknown GDBM operation */ 
	ER_GDBMOPEN,	/* 6 - Failed to open the GDBM [group] key's file */
	ER_GDBMSTORE, 	/* 7 - Failed to store an entry in the GDBM [group] 					key's file */
	ER_GDBMDELETE,	/* 8 - Failed to delete an entry in the GDBM [group] 					key's file */
	ER_GDBMEXIST,	/* 9 - Failed to acces to the GDBM [group] key's file. 				Reason:	file doesn't exist */
	ER_GDBMNODATA, 	/* 10 - No data found in the GDBM [group] key's file */
	ER_MAXUSER,	/* 11 - User's length must be less or equal then 					Userlen */
	ER_MAXKEY,	/* 12 - The key's lenght must be less or equal then				PassLen */
	ER_PWTEXTOPEN,	/* 13 - Failed to open the text key's file */
	ER_PWTEXTLOCKED,/* 14 - The text key's file is just open in write mode 				*/
	ER_PWTEXTLOCK,	/* 15 - Failed to lock text key's file */
	ER_PWTEXTEXIST,	/* 16 - Entry is in text key's file. I can't replace it 			*/ 
	ER_PWTEXTNOTEXIST,	/* 17 - Entry is not in the text key's file. */
	ER_PWTEXTREPLACE,	/* 18 - Failed to replace an entry in the text 					key's file. */	
	
	ER_BASE64_MAX,	/* 19 - You've specified a string to encode greater than			the max allowed. */
	ER_BASE64_ILLCHR,	/* 20 - illegal base64 character */
	ER_BASE64_MUL,	/* 21 - The length of string to decode must be multiple 			of 4 */
	
	ER_CONF_FILE,	/* 22 - Error on read the dynamic library's 					configuration file */
	ER_BAD_CONF_FILE,	/* 23 - Bad format of dynamic library's 					configuration file */
	ER_LOAD_LIBRARY,	/* 24 - Error on loading dynamic library */
	ER_LOAD_FUNCTION,	/* 25 - Error on loading a function from dynamic library */

	ER_MOUNT,	/* 26 - Error on mount systemcall. */
	ER_NO_TCFS_MOUNTED, /* 27 - tcfs file mounted */
	ER_TCFS_OPEN,	/* 28 - Failed to read a tcfs filesystem */
	ER_TCFS_DECRYPT,	/* 29 - Error on decrypting key. Unexpected key length */

	ER_NOTERMINAL,	/* 30 - Input device is not a terminal device */
	ER_SETTERMINAL,	/* 31 - Error setting terminale device */
	
	ER_NO_TCFS,	/* 32 - You have not specified a TCFS file system */
	ER_GET_FLAGS,	/* 33 - Error getting file flags */
	ER_SET_FLAGS,	/* 34 - Error setting file flags */
	ER_TAB_OPEN,	/* 35 - Error on open tcfstab file */
	ER_TAB_BAD,	/* 36 - Bad format for tcfstab file */ 
	ER_TAB_NOTFOUND	/* 37 - tab entry not found */
};

#define MAX_ERRORS	38


/* Prototypes for errors management */

const char* tcfs_strerror(int);

/* END OF ERROR SECTION */


