/*
 *      $Source: /home/fergia/CVS//tcfs-openbsd/tcfslib-1.0.0/lib/tcfs_errno.c,v $
 *      $Revision: 1.1.1.1 $
 *      $Date: 2000/06/07 12:21:31 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include "tcfs_errno.h"

static const char *tcfs_errors_list[MAX_ERRORS]=
{
	"Ok",
	"Error getting memory.",
	"Error while sending key.",
	"Error while removing key.",
	"Error while getting TCFS filesystem's status.",
	"Unknow gdbm operation.",
	"Failed to open the TCFS key's database.",
	"Failed to store an entry into TCFS key's database.",
	"Failed to delete an entry into TCFS key's database.",
	"Failed to access to TCFS key's database.",
	"No data found into TCFS key's database.",
	"Reached the maximum value of user's length.",
	"Reached the maximum value of key's length.",
	"Failed to open the text key's file.",
	"Text key's file is just open in write mode.",
	"Failed to lock text key's file.",
	"Entry is in text key's file. I can't replace it.", 
	"Entry is not in the text key's file.",
	"Failed to replace an entry in the text	key's file.", 	
	"The string to encode is greater than the maximum allowed.",
	"Illegal base64 character.",
	"The length of string to decode isn't multiple of 4.",
	"Error on read the dynamic library's configuration file.",
	"Bad format of dynamic library's configuration file.",
	"Error on loading dynamic library.",
	"Error on loading a function from dynamic library.",
	"Error on calling mount system call.",
	"No TCFS filesystem mounted.",
	"Failed to read a TCFS filesystem.",
	"Error on decrypting key: unexpected key length.",
	"Input device is not a terminal device.",
	"Error setting terminal properties.",
	"The file system specified is not a TCFS file system.", 
	"Error getting file's flags.",
	"Error setting file's flags.",
	"Error opening tcfstab file.",
	"Bad format of tcfstab file.",
	"Entry not found in tcfstab file." 
};

const char* tcfs_strerror(int error) {
	
	if ((error<0) || (error>=MAX_ERRORS))
		return("Unkonwn error.");

	return(tcfs_errors_list[error]);
}

