/*
 *      $Source: /home/fergia/CVS//tcfs-openbsd/tcfslib-1.0.0/lib/tcfs_genkey.c,v $
 *      $Revision: 1.1.1.1 $
 *      $Date: 2000/06/07 12:21:31 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include <time.h>
#include <termios.h>
#include <unistd.h>
#include <stdlib.h>

#include "kdes.h"
#include "tcfs_global.h"
#include "tcfs_errno.h"
#include "md5.h"

char *gentcfskey (void)
{
	
	const short SIZE_CHAR=sizeof(char);
	const short SIZE_TIME=sizeof(time_t);

	/* This is the offset used to insert information about the caracters pressed */
	const short OFFSET=2*SIZE_TIME+SIZE_CHAR;

	const short MAX_KEY=10;
	const int DIM=4096;

	int i=0, keycount=0;
	time_t tm=0;
	struct termios oldtty, newtty;
	char *buffer;
	OctetString *in, *res;
	des_key_schedule ks;
	
	tcfs_errno=OK;

	if ((buffer=malloc(DIM))==NULL) {
		tcfs_errno=ER_MEM;
		return (char*)0;
	}

	if (tcgetattr (STDIN_FILENO, &oldtty)<0)
	{
		tcfs_errno=ER_NOTERMINAL;
		free(buffer);
		return (char*)0;
	}

	memcpy (&newtty, &oldtty, sizeof (struct termios));
	newtty.c_lflag &= ~ICANON;
	newtty.c_lflag &= ~ECHO;
	newtty.c_cc[VMIN]=1;
	newtty.c_cc[VTIME]=0;
	fflush(stdout);
	
	if (tcsetattr (STDIN_FILENO, TCSANOW, &newtty)<0)
	{
		tcfs_errno=ER_SETTERMINAL;
		free(buffer);
		return(char*)0;
	}

	tm=time(NULL);
	for (keycount=0;keycount<MAX_KEY;keycount++)
	{
		char c=0;
		if (read(STDIN_FILENO, &c, SIZE_CHAR)==SIZE_CHAR)
		{
			time_t oldtime;
	
			oldtime=tm;
			tm=time(NULL);
			
			*(buffer+keycount*OFFSET)=c;
			memcpy ((char*)(buffer+keycount*OFFSET+SIZE_CHAR),(time_t*)&oldtime,SIZE_TIME);
			memcpy ((char*)(buffer+keycount*OFFSET+SIZE_CHAR+SIZE_TIME),(time_t*)&tm,SIZE_TIME);

			write(STDOUT_FILENO,"*",SIZE_CHAR);
			fsync(STDOUT_FILENO);
		}
	}

	if (tcsetattr (STDIN_FILENO, TCSANOW, &oldtty)<0)
	{
		tcfs_errno=ER_SETTERMINAL;
		free(buffer);
		return (char*)0;
	}

	in=(OctetString*)malloc(sizeof(OctetString));
	res=(OctetString*)malloc(sizeof(OctetString));
	res->octets=(char*)malloc(KEYSIZE);
	in->octets=buffer;
	in->noctets=KEYSIZE;
	md5_hash (in, res, SEC_END);

	while ((i*8)<=KEYSIZE)
	 {
	   des_set_key ((des_cblock *)res->octets, ks);
	   des_ecb_encrypt ((des_cblock *)(buffer+i*8), (des_cblock *)(buffer+i*8), ks, DES_ENCRYPT);
	   des_set_key ((des_cblock *)res->octets+KEYSIZE, ks);
	   des_ecb_encrypt ((des_cblock *)(buffer+i*8), (des_cblock *)(buffer+i*8), ks, DES_DECRYPT);
	   des_set_key ((des_cblock *)res->octets, ks);
	   des_ecb_encrypt ((des_cblock *)(buffer+i*8), (des_cblock *)(buffer+i*8), ks, DES_ENCRYPT);
	   i++;
 	 }

	*(buffer+KEYSIZE)='\0';
	free(res->octets);
	free(res);
	free(in);

	return buffer;
}
