/*
 *      $Source: /home/fergia/CVS//tcfs-openbsd/tcfsutils-1.0.0/include/tcfsutils.h,v $
 *      $Revision: 1.1.1.1 $
 *      $Date: 2000/06/07 12:21:33 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#define MAX 256
#define MAX_KEY_PRESS 10

/* Name of options */
#define	VERBOSE		'v'
#define USER		'u'
#define HELP		'h'
#define GID		'g'
#define GROUP_NAME	'G'
#define PART		'p'
#define THRESHOLD	't'
#define KEY		'k'
#define ENCODED		'e'
#define VERSION		'V'
#define LABEL		'l'
#define MOUNT_POINT	'm'

/* Value of optstring to give to getopt */ 

#define ADDUSER_OPTSTRING	"+hu:v"
/* It's reduntant define this value again. But it's done for compatibility. */
#define RMUSER_OPTSTRING	"+hu:v"
#define ADDGROUP_OPTSTRING	"+g:G:p:t:vh"
#define RMGROUP_OPTSTRING	"+g:G:vh"
#define GENKEY_OPTSTRING	"+hv"
#define PUTKEY_OPTSTRING	"+g:G:k:e:hvl:m:"
#define REMOVEKEY_OPTSTRING	"+g:G:hvl:m:"
#define STAT_OPTSTRING		"+hvl:m:"
#define RUN_OPTSTRING		"+hvl:m:"
#define RECOVER_OPTSTRING	"+hvgu"

/* Value of utility usage */
#define ADDUSER_USAGE	"Add an user entry in the TCFS key's file.\nUsage: %s [options]...\nOptions:\n\t-%c <name>\tAdd an entry for <name> in the TCFS key's file.\n\t-%c \t\tMake the output more verbose.\n\t-%c \t\tDisplay this information.\n\n"

#define RMUSER_USAGE	"Remove an user entry from the TCFS key's file.\nUsage: %s [options]...\nOptions:\n\t-%c <name>\tRemove the entry for <name> from the TCFS key's file.\n\t-%c \t\tMake the output more verbose.\n\t-%c \t\tDisplay this information.\n\n"

#define ADDGROUP_USAGE	"Add a group entry in the TCFS group key's file.\nUsage: %s [options]...\nOptions:\n\t-%c <gid>\tAdd an entry for group with group id <gid>.\n\t-%c <name>\tAdd an entry for group with group name <name>.\n\t-%c <part>\tAdd an entry for group with number of parts <part>.\n\t-%c <threshold>\tAdd an entry for group with threshold <threshold>.\n\t-%c \t\tMake the output more verbose.\n\t-%c \t\tDisplay this information.\nNote that you can specify only one between the gid option and the group name option. If you set both the option, then an error occurs.\n\n"

#define RMGROUP_USAGE	"Remove all the group's entry from the TCFS group key's file.\nUsage: %s [options]...\nOptions:\n\t-%c <gid>\tRemove all the group's entry with group id <gid>.\n\t-%c <name>\tRemove all the group's entry with group name <name>.\n\t-%c \t\tMake the output more verbose.\n\t-%c \t\tDisplay this information.\nNote that you can specify only one between the gid option and the group name option. If you set both the option, then an error occurs.\n\n"

#define GENKEY_USAGE	"Generate user key and add it into TCFS key's file.\nUsage: %s [options]...\nOptions:\n\t-%c \tMake the output more verbose.\n\t-%c \tDisplay this information.\n\n"

#define PUTKEY_USAGE	"Pass user/share key, for a filesystem, to the kernel.\nUsage: %s [options]...\nOptions:\n\t-%c <label>\tPass key for filesystem indicated by <label>.\n\t-%c <mnt-point>\tPass key for filesystem mounted on <mnt-point>.\n\t-%c <gid>\tPass share key of group with group id <gid>.\n\t-%c <name>\tPass share key of group with group name <name>.\n\t-%c <key>\tPass clear key <key> to the kernel.\n\t-%c <encoded>\tPass encoded key <encoded> to the kernel.\n\t-%c\t\tMake the output more verbose.\n\t-%c \t\tDisplay this information.\nYou can give a combination of the above options.\nSome wrong combinations are listed below:\n\t[group name] option with [gid] option;\n\t[key] option with [encoded] option;\n\t[label] option with [mount point] option;\n\t[key] or [encoded] option with [group name] or [gid] option.\n\n"

#define REMOVEKEY_USAGE	"Remove user/share key, for a filesystem, from the kernel.\nUsage: %s [options]...\nOptions:\n\t-%c <label>\tRemove key for filesystem indicated by <label>.\n\t-%c <mnt-point>\tRemove key for filesystem mounted on <mnt-point>.\n\t-%c <gid>\tRemove share key of group with group id <gid>.\n\t-%c <name>\tRemove share key of group with group name <name>.\n\t-%c\t\tMake the output more verbose.\n\t-%c \t\tDisplay this information.\nNote that you can't specify both the gid option and the group name option. If you set both the options, then an error occurs. You can't specify both the [label] option with the [mount point] option.\n\n"

#define FLAG_USAGE "Show/change file's flags.\nUsage: %s [options] [file]...\nOptions:\n\t+X\tSets user cipher flag of [file].\n\t-X\tDeletes user cipher flag of [file].\n\t+G\tSets group cipher flag of [file].\n\t-G\tDeletes group cipher flag of [file].\n\t-%c\tDisplay this imformation.\nCalled without [options] it shows flags' value of [file] (if [file] is a directory name, it shows flags' value of files into directory). Called without [options] and [file] it shows flags' value of files into current directory.\nYou can give only one between +X -X +G -G options.\n\n"

#define STAT_USAGE "Show informations about TCFS filesystem mounted.\nUsage: %s [options]...\nOptions:\n\t-%c <label>\tShow info about filesystem indicated by <label>.\n\t-%c <mnt-point>\tShow info about filesystem mounted on <mnt-point>.\n\t-%c\t\tMake the output more verbose.\n\t-%c\t\tDisplay this information.\nYou can't specify both the <label> option and the <mnt-point> option.\nCalled without option it shows informations about TCFS filesystem with <defualt> label.\n\n"

#define RUN_USAGE "Run a process passing a key for it.\nUsage: %s [options] [command]...\nOptions:\n\t-%c <label>\tProcess' key is for filesystem indicated by <label>.\n\t-%c <mnt-point>\tProcess' key is for filesystem mounted on <mnt-point>.\n\t-%c\t\tMake the output more verbose.\n\t-%c\t\tDisplay this information.\nYou can't specify both the <label> option and the <mnt-point> option.\nCalled without command it runs 'sh'.\n\n"

#define RECOVER_USAGE "Recover a TCFS key/share.\nUsage: %s [options]...\nOptions:\n\t-%c\t\tRecover a TCFS key.\n\t-%c\t\tRecover a TCFS share.\n\t-%c\t\tMake the output more verbose.\n\t-%c\t\tDisplay this information.\nBy default it recovers TCFS key.\n\n"

typedef struct {
	unsigned long int word; 
} option_flags;

#define USER_FLAG		0x00000001
#define VERBOSE_FLAG		0x00000002
#define GID_FLAG		0x00000004
#define GROUPNAME_FLAG		0x00000008
#define PART_FLAG		0x00000010
#define THRESHOLD_FLAG		0x00000020
#define KEY_FLAG		0x00000040
#define	ENCODED_FLAG		0x00000080
#define	VERSION_FLAG		0x00000100
#define LABEL_FLAG		0x00000200
#define MOUNTPOINT_FLAG		0x00000400 

#define RESET_WORD(val)	val.word=0

#define SET_ISUSER(val)		(val.word|= USER_FLAG)
#define SET_ISVERBOSE(val)	(val.word|= VERBOSE_FLAG) 
#define SET_ISGID(val)		(val.word|= GID_FLAG)
#define SET_ISGROUPNAME(val)	(val.word|= GROUPNAME_FLAG)
#define SET_ISPART(val)		(val.word|= PART_FLAG)
#define SET_ISTHRESHOLD(val)	(val.word|= THRESHOLD_FLAG)
#define SET_ISKEY(val)		(val.word|= KEY_FLAG)
#define SET_ISENCODED(val)	(val.word|= ENCODED_FLAG)
#define SET_ISVERSION(val)	(val.word|= VERSION_FLAG)
#define SET_ISLABEL(val)	(val.word|= LABEL_FLAG)
#define SET_ISMOUNTPOINT(val)	(val.word|= MOUNTPOINT_FLAG)

#define TEST_ISUSER_SET(val)		(val.word & USER_FLAG)
#define TEST_ISVERBOSE_SET(val)		(val.word & VERBOSE_FLAG)
#define TEST_ISGID_SET(val)		(val.word & GID_FLAG)
#define TEST_ISGROUPNAME_SET(val)	(val.word & GROUPNAME_FLAG)
#define TEST_ISPART_SET(val)		(val.word & PART_FLAG)
#define TEST_ISTHRESHOLD_SET(val)	(val.word & THRESHOLD_FLAG)
#define TEST_ISKEY_SET(val)		(val.word & KEY_FLAG)
#define TEST_ISENCODED_SET(val)		(val.word & ENCODED_FLAG)
#define TEST_ISVERSION_SET(val)		(val.word & VERSION_FLAG)
#define TEST_ISLABEL_SET(val)		(val.word & LABEL_FLAG)
#define TEST_ISMOUNTPOINT_SET(val)	(val.word & MOUNTPOINT_FLAG)
