/*
 *      $Source: /home/fergia/CVS/tcfs-openbsd/tcfsutils-1.0.0/src/tcfsaddgroup.c,v $
 *      $Revision: 1.2 $
 *      $Date: 2000/06/07 13:24:23 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include "tcfslib.h"
#include "tcfsutils.h"
#include <stdio.h>
#include <unistd.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
#include <stdlib.h> 
#include <time.h> 

extern char* gentcfskey(void);
extern int auth(char*,char*);

int threshold;
unsigned char coeff[KEYSIZE][256];
unsigned char *group_key=NULL;	/* Pointer to a 64-bit TCFS group key */

union bobbit
{
	unsigned char byte;
	struct
	{ 
		unsigned char b1:1;
		unsigned char b2:1;
		unsigned char b3:1;
		unsigned char b4:1;
		unsigned char b5:1;
		unsigned char b6:1;
		unsigned char b7:1;
		unsigned char b8:1;
	} bf;
};

int tcfsgetuid (char *login) 
{    
	struct passwd *entry;

	if ((entry=getpwnam(login))!=NULL) 
		return (entry->pw_uid);

	return -1;
}    
		
/* Check wheter the user belong to group gid. On success return 0 */
int belong_group(char* user, gid_t gid) {
	struct passwd *user_info;

	user_info=getpwnam(user);

	if (user_info->pw_gid!=gid) {
		struct group *group_info;
		int i=0;
	
		group_info=getgrgid(gid);
		while ((group_info->gr_mem[i]!=NULL) && (strcmp(group_info->gr_mem[i],user)!=0))
			i++;
		
		if (group_info->gr_mem[i]==NULL) return -1;
		else return 0;
	}

	return 0;
}		
		
void gencoeff ()
{    
	int i, j;

	srand(time(NULL));

	for (i=0;i<KEYSIZE;i++){
		for (j=1;j<threshold;j++){
			coeff[j][i]=rand()%257;
		}
	}
}


int eleva (int x, int y, int z)
{
	int mask=0x80000000;
	int res=1,i;

	for (i=0;i<32;i++)
	{
		res=(res*res)%z;
		if (y & mask)
			res=(x*res)%z;
		mask=mask>>1;
	}

	return res;
}

unsigned char *gengrpkey (char *login)
{
	int  x1, i, j, k=0;
	unsigned int x;

	unsigned char *res=NULL;
	unsigned int tmp;
	union bobbit obits;

	res=(unsigned char*)malloc(KEYSIZE+KEYSIZE/8);

	x1 = tcfsgetuid(login);
	x = (x1 % 257);

#ifdef TCFS_DEBUG
	fprintf (stderr,"La chiave utente di %u e':\n", x);
#endif

	for (i=0;i<KEYSIZE;i++)
	{
		tmp=0;
		for (j=1;j<threshold;j++) {
			tmp+=(eleva(x1,j,257)*coeff[j][i]) % 257;

#ifdef TCFS_DEBUG
			fprintf (stderr,"x1= %u\tj=%d\tcoeff[%d][%d]=%u\ttmp=%u\tchiave: ", x1, j, j, i, coeff[j][i], tmp);
#endif

			}
		tmp+=(unsigned int)group_key[i];
		tmp%=257;

		memcpy (res+k++, &tmp, 1);

#ifdef TCFS_DEBUG
		fprintf (stderr,"%X\n", *(res+k-1));
#endif

		switch (i%8){
			case 0:
				obits.bf.b1=tmp>>8;
				break;
			case 1:
				obits.bf.b2=tmp>>8;
				break;
			case 2:
				obits.bf.b3=tmp>>8;
				break;
			case 3:
				obits.bf.b4=tmp>>8;
				break;
			case 4:
				obits.bf.b5=tmp>>8;
				break;
			case 5:
				obits.bf.b6=tmp>>8;
				break;
			case 6:
				obits.bf.b7=tmp>>8;
				break;
			case 7:
				obits.bf.b8=tmp>>8;
				break;
		}

		if ((i%8)==7) {
			res[k]=obits.byte;
			k++;

#ifdef DEBUG_TCFS
			fprintf (stderr,"%u\n", res[k-1]);
#endif

			obits.byte=0;
		}
	}

	return res;
}

int main (int argc, char *argv[])
{
	const char* optstring=ADDGROUP_OPTSTRING;
	const char* usage=ADDGROUP_USAGE;
	int val,found;
	option_flags flag;
	gid_t gid;
	char group_name[MAX];
	int part, i=0;
	tcfsgpwdb* group_entry;
	

	RESET_WORD(flag);

	printf ("\nTCFS Utilities: version %d.%d.%d\n", MAJOR, MINOR, RELEASE);
	while ((val=getopt (argc,argv,optstring))!=-1) {

		switch (val)
		{
			case GID:
				gid=(gid_t) atoi(optarg);
				SET_ISGID(flag);
				break;
			case GROUP_NAME:
				strcpy(group_name,optarg);
				SET_ISGROUPNAME(flag);
				break;
			case PART:
				part=(unsigned int) atoi(optarg);
				SET_ISPART(flag);
				break;
			case THRESHOLD:
				threshold=(unsigned int) atoi(optarg);
				SET_ISTHRESHOLD(flag);
				break;
			case HELP:
				printf(usage,argv[0],GID,GROUP_NAME,PART,THRESHOLD,VERBOSE,HELP);
                                exit(0);

			case VERBOSE:
				SET_ISVERBOSE(flag);
				break;
			default:
				 printf("Try '%s -%c' for more information.\n\n",argv[0],HELP);
                                exit(-1);
		}
	}

	if (optind!=argc) {
                printf("Invalid option -- %s\n",argv[optind]);
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
                exit(-1);
        }       
	
	/* Check the consistency of option: if both gid and group name are set */
	if (TEST_ISGROUPNAME_SET(flag) && TEST_ISGID_SET(flag)) {
		printf("You've specified both the gid option and the group name option.\n");
	 	printf("Try '%s -%c' for more information.\n\n",argv[0],HELP);
		exit(-1);
	}

	if (!TEST_ISGROUPNAME_SET(flag) && !TEST_ISGID_SET(flag)) {

		printf("Insert the group id or the group name to add in the database: ");
		fgets(group_name,MAX,stdin);
		group_name[strlen(group_name)-1]='\0';
		gid=(gid_t) atoi(group_name);

		if (gid==0 && *group_name!='0') 
			SET_ISGROUPNAME(flag);
		else
			SET_ISGID(flag);		

	}

	/* At this point only one between is_groupname and is_gid is set. */	
	if (TEST_ISGROUPNAME_SET(flag)) { 
	
		struct group *group_info;

		group_info=getgrnam(group_name);
		if (group_info==NULL) {
			printf("Group with group name <%s> doesn't exist.\n",group_name);
			if (TEST_ISVERBOSE_SET(flag))
				printf("Be sure to create a valid group with group name <%s> first.\n",group_name);
			printf("\n");
			exit(-1);
		}
 
		gid=group_info->gr_gid;
	}
	else 
		if (getgrgid(gid)==NULL) {
			printf("Group with group id <%d> doesn't exist.\n",gid);
			if (TEST_ISVERBOSE_SET(flag))
				printf("Be sure to create a valid group with group id <%d> first.\n",gid);
			printf("\n");
			exit(-1);
		}

	/* Check wheter the gid is already in the TCFS group key's file */
	if (tcfs_gpwfile_scan(gid,&found,TCFS_DBNULL)==0) {
	
		if (found==1) {
			printf("Group with group id <%d> is already into TCFS group key's file.\n",gid)	;

			if (TEST_ISVERBOSE_SET(flag))
				printf("Be sure to remove it first.\n");
		
			printf("\n");
			exit(-1);
		}
	}	
	
	if (TEST_ISPART_SET(flag) && part<=1 && TEST_ISVERBOSE_SET(flag))
		printf("You've specified a bad value for -%c option. Insert the value again.\n",PART);

	if (!TEST_ISPART_SET(flag) || part<=1) {

		char buffer[MAX];
		
		printf ("Insert the number of members for the TCFS group with ID #%d: ",gid);
		do {
			fgets(buffer,MAX,stdin);
			buffer[strlen(buffer)-1]='\0';
			if ((part=atoi(buffer))<=1) 
				printf("Insert a positive number greater than 1, please: ");
			else break;
		} while (1);
	}	

	if (TEST_ISTHRESHOLD_SET(flag) && (threshold<1 || threshold>part) && TEST_ISVERBOSE_SET(flag))
                printf("You've specified a bad value for -%c option. Insert the value again.\n",THRESHOLD);

        if (!TEST_ISTHRESHOLD_SET(flag) || threshold<1 || threshold>part) {

                char buffer[MAX];

                printf ("Insert the threshold for the TCFS group with ID #%d: ",gid);
                do {
                        fgets(buffer,MAX,stdin);
                        buffer[strlen(buffer)-1]='\0';
                        if ((threshold=atoi(buffer))<1 || threshold>part)
                                printf("Insert a positive number greater than 0 and less than %d, please: ",part+1);
                        else break;
                } while (1);
        }

	printf("Press %d random keys, please: ",MAX_KEY_PRESS);

	group_key=gentcfskey();

	printf("\n");

#ifdef TCFS_DEBUG
	{
		int i;

		fprintf (stderr,"%s: value of secret key:",argv[0]);

		for (i=0;i<KEYSIZE;i++)
			fprintf (stderr,"%X:",group_key[i]);

		fprintf (stderr,"\n");
	}
#endif

	gencoeff();

#ifdef TCFS_DEBUG
	{
		int i,j;

		fprintf(stderr,"%s: coefficienti generati:\n",argv[0]);
		for (i=0;i<KEYSIZE;i++) {
			for (j=1;j<threshold;j++)
				fprintf(stderr,"%d ",coeff[j][i]);
			fprintf(stderr,"\n");
		}
	}
#endif


	while (i<part) {
		char user[MAX], *passwd=NULL;
		unsigned char *newkey=NULL, *cryptedkey=NULL;

		printf("Insert the %d",i+1);
		switch(i+1) {
			case 1:
				printf("st ");
				break;
			case 2:
				printf("nd ");
				break;
			case 3:
                                printf("d ");
                                break;
			default:
				printf("th ");
				break;
		}
		printf("user for group with group id <%d>: ",gid);

		fgets(user,MAX,stdin);
		user[strlen(user)-1]='\0';
		passwd=getpass("Insert password for user : ");

		if (auth (user, passwd)==-1) {
			memset(passwd,'\0',strlen(passwd));
			printf ("Invalid password or user <%s> does not exist.\n",user);
			continue;
		}
		
		if (belong_group(user,gid)!=0) {
			
			memset(passwd,'\0',strlen(passwd));
			printf("Group with group id <%d> is neither the initial group nor an additional group for user <%s>\n",gid,user);
			continue;

		}
		
 
		newkey=(unsigned char*)malloc(KEYSIZE*2);
		memcpy (newkey, gengrpkey (user), KEYSIZE+KEYSIZE/8);
		*(newkey+KEYSIZE+2)='\0';

#ifdef TCFS_DEBUG
		{
			int i;

			fprintf (stderr,"%s: %s newkey: ", argv[0], user);
			for (i=0;i<KEYSIZE+2;i++)
				fprintf (stderr,"%X:", newkey[i]);
			fprintf (stderr,"\n");
		}	
#endif

		if ((cryptedkey=tcfs_encrypt_key(newkey, passwd,TCFS_GROUP_KEY))==NULL) {
			printf("%s\n",tcfs_strerror(tcfs_errno));

			if (TEST_ISVERBOSE_SET(flag))
				printf("Removing inserted entry...\n");

			tcfs_gpwfile_scan(gid,&found,TCFS_DBDELETE);
				
			if (TEST_ISVERBOSE_SET(flag)) {
				if (found==1)
					printf("Inserted entry were removed.\n");
				else
					printf("There are no entries to remove.\n");
			}
				
			printf("\n");	
			exit(-1);

		}

		free (newkey);

#ifdef TCFS_DEBUG
		{
			unsigned char *key;
			int i;

			if ((key=tcfs_decrypt_key (cryptedkey, passwd, TCFS_GROUP_KEY))==NULL) {
				fprintf(stderr,"%s: Error on decrypting key\n\n",argv[0]);
				exit (-1);
			}	

			fprintf (stderr,"%s: %s key: ",argv[0],user);
			for (i=0;i<KEYSIZE+2;i++)
				fprintf (stderr,"%X:", key[i]);
			fprintf(stderr,"\n");

			free (key);
		}	
#endif

		memset(passwd,'\0',strlen(passwd));
	
		if ((group_entry=tcfs_gpwdb_alloc())==NULL) {
			printf("%s\n\n",tcfs_strerror(tcfs_errno));
			
			if (TEST_ISVERBOSE_SET(flag))
				printf("Removing inserted entry...\n");

			tcfs_gpwfile_scan(gid,&found,TCFS_DBDELETE);
				
			if (TEST_ISVERBOSE_SET(flag)) {
				if (found==1)
					printf("Inserted entry were removed.\n");
				else
					printf("There are no entries to remove.\n");
			}
				
			printf("\n");	
			exit(-1);
		}

		if (tcfs_gpwdb_edit(group_entry,TCFS_DBUSER|TCFS_DBKEY|TCFS_DBGID|TCFS_DBPARTS|TCFS_DBTHRSHO,user,cryptedkey,gid,part,threshold)!=0) {
	                printf("%s\n\n",tcfs_strerror(tcfs_errno));
			
			if (TEST_ISVERBOSE_SET(flag))
				printf("Removing inserted entry...\n");

			tcfs_gpwfile_scan(gid,&found,TCFS_DBDELETE);
				
			if (TEST_ISVERBOSE_SET(flag)) {
				if (found==1)
					printf("Inserted entry were removed.\n");
				else
					printf("There are no entries to remove.\n");
			}

			printf("\n");	
        	        exit(-1);
		}

#ifdef TCFS_DEBUG
		fprintf(stderr,"%s: group_entry:\n",argv[0]);
		fprintf(stderr,"\tuser: %s\n",group_entry->user);
		fprintf(stderr,"\tgroup key: %s\n",group_entry->groupkey);
		fprintf(stderr,"\tgid: %d\n",group_entry->gid);
		fprintf(stderr,"\tpart: %d\n",group_entry->numofparts);
		fprintf(stderr,"\tthreshold: %d\n",group_entry->threshold);
#endif
		

		if (TEST_ISVERBOSE_SET(flag))
	                printf("Inserting group entry for <%s> into TCFS group key's file...\n",user);
		
		if (tcfs_gpwfile_store(user,gid,group_entry,TCFS_DBINSERT)!=0) {
	                printf("%s\n",tcfs_strerror(tcfs_errno));

	                if (TEST_ISVERBOSE_SET(flag))
        	                printf("Possible causes:\n\t1) The TCFS group key's file hasn't the write permission.\n\t2) The entry for user <%s> with group id <%d> already exists.\n\t3) The TCFS group key's file may be corrupted.\n",user,gid);

			if (TEST_ISVERBOSE_SET(flag))
				printf("Removing inserted entry...\n");

			tcfs_gpwfile_scan(gid,&found,TCFS_DBDELETE);
				
			if (TEST_ISVERBOSE_SET(flag)) {
				if (found==1)
					printf("Inserted entry were removed.\n");
				else
					printf("There are no entries to remove.\n");
			}
	
			printf("\n");	
        	        exit(-1);
        	}
       		
		if (TEST_ISVERBOSE_SET(flag))
			printf("Group entry for <%s> inserted.\n",user);

		free (cryptedkey);
		tcfs_gpwdb_free(group_entry);

		i++;

	}

	printf("All group keys were inserted.\n\n");

	return 0;
}


