/*
 *      $Source: /home/fergia/CVS/tcfs-openbsd/tcfsutils-1.0.0/src/tcfsflag.c,v $
 *      $Revision: 1.2 $
 *      $Date: 2000/06/07 13:24:23 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include "tcfslib.h"
#include "tcfsutils.h"

#define SET_USER	0x00000001
#define UNSET_USER	0x00000002
#define SET_GROUP	0x00000004
#define UNSET_GROUP	0x00000008
#define SHOW_HELP	0x00000010
#define UNKNOWN		0x00000080

#define DIM 256

unsigned long int flag=0;

int parse_command(char **argv, int argc, int current) {
	
	char* p;
	
	if (argv[current]==NULL) return(0);

	p=argv[current];
	p++;	
	switch (argv[current][0]) {

		case '-':
			if (strcmp(p,"h")==0) {
				flag |= SHOW_HELP; 
				return(0);
			}
		 	if (strcmp(p,"X")==0) {
				flag |= UNSET_USER;
				return(0);
			}
		 	if (strcmp(p,"G")==0) {
				flag |= UNSET_GROUP;
				return(0);
			}
			else {	
				printf("%s: Unrecognized option: %s\n",argv[0],argv[current]);
				return -1;
			}
			break;
		case '+':
		 	if (strcmp(p,"X")==0) {
                                flag |= SET_USER;
				return(0);
			}
		 	if (strcmp(p,"G")==0) {
				flag |= SET_GROUP;
				return(0);
			}
                        else {
                        	printf("%s: Unrecognized option: %s\n",argv[0],argv[current]);
				return(-1);
                        }    
			break; 
		default:
			return (0);
			break;
	}
	return(0);
}

int flags(const char* file, int type) {

	int fd;
	tcfs_flags flag_tcfs;

	RESET_FLAG(&flag_tcfs);

	fd=open(file,O_RDONLY,777);

	//Show flags
	if (type==0) { 

		flag_tcfs=tcfs_getflags(fd);
		if (tcfs_errno!=OK) {
			printf("%s\n",tcfs_strerror(tcfs_errno));
			printf("%s may be corrupted.\n\n",file);
			close(fd);
			return(-1);
		}

		(FI_CFLAG(&flag_tcfs)==1)?printf("X"):printf("-");
		(FI_GSHAR(&flag_tcfs)==1)?printf("G"):printf("-");
		printf(" %s\n",file);
	}
	else { //Set flags

		if (type & SET_USER) {
			printf("Setting user flag on %s.\n",file);
			FI_SET_CF(&flag_tcfs);
		}
		if (type & UNSET_USER) { 
			printf("Clearing user flag on %s.\n",file);
			FI_UNSET_CF(&flag_tcfs);
		}
		if (type & SET_GROUP) {
			printf("Setting group flag on %s.\n",file);
			FI_SET_GS(&flag_tcfs);
		}
		if (type & UNSET_GROUP) {
			printf("Clearing group flag on %s.\n",file);
			FI_UNSET_GS(&flag_tcfs);
		}

		tcfs_setflags(fd,flag_tcfs);  		
		if (tcfs_errno!=OK) {
			printf("%s: %s\n",file,tcfs_strerror(tcfs_errno));
			printf("Make sure that there is a TCFS key for %s.\n\n",file);	
			close(fd);
			return(-1);
		}
	}

	close(fd);
	return(0);
}

int show_dir(const char* path) {

	DIR* dir;
	struct dirent *dir_entry;
	char name[DIM];
	
	if ((dir=opendir(path))==NULL) {
		printf("Error on reading directory '%s'.\n\n",path);
		return(-1);
	}

	while ((dir_entry=readdir(dir))!=NULL) {
		
		if ((strcmp(dir_entry->d_name,".")==0) || (strcmp(dir_entry->d_name,"..")==0)) continue; 
	
		strcpy(name,"\0");
		strcat(name,path);
		if (name[strlen(name)-1]!='/')
			strcat(name,"/");
		strcat(name,dir_entry->d_name);
		if (flags(name,0)==-1) 
			return(-1);
	} 
	
	closedir(dir);
	printf("\n");
	return(0);	
} 


int main (int argc, char **argv)
{
	const char* usage=FLAG_USAGE;
	int current=1;
	
	printf ("\nTCFS Utilities: version %d.%d.%d\n", MAJOR, MINOR, RELEASE);

	if (argc==1) {/* Show dir flags */
		if (show_dir(".")==-1) 
			exit(-1);
		exit(0);	
	}
		
	if (parse_command (argv,argc,current)==-1) {
		printf("Try '%s -h' for more information\n\n",argv[0]);
                exit(0);
	}
	current++;

	if (flag & SHOW_HELP) {
		printf(usage,argv[0],HELP);
		exit(0);
	}

	if ((!(flag & SET_USER)) && (!(flag & UNSET_USER)) && (!(flag & SET_GROUP)) && (!(flag & UNSET_GROUP))) {

		/* Check whether argv[1] is a file or a directory*/
		struct stat buf;

		if (stat(argv[1],&buf)==-1) {
			printf("Error accessing file '%s'\n\n",argv[1]);
			exit(-1);
		}
		if (S_ISDIR(buf.st_mode)) { 
			if (show_dir(argv[1])==-1)
				exit(-1);
		}
		else {
			if (flags(argv[1],0)==-1)
				exit(-1);
			printf("\n");
		}

		exit(0);
	}		

	if (((flag & SET_USER) && (flag & UNSET_USER)) || ((flag & SET_GROUP) && (flag & UNSET_GROUP))) {
		printf("You've specified incompatible options.\n");
		printf("Try '%s -h' for more information.\n\n",argv[0]);
		exit(-1);
	}

	if (argv[current]==NULL) {
		printf("File name required.\n");
		printf("Try '%s -h' for more information.\n\n",argv[0]);
		exit(-1);
	}

	if (flags(argv[current],flag)==-1) exit(-1);
	else printf("Flags were set.\n\n"); 
	
	return(0);	
		
}
