/*
 *      $Source: /home/fergia/CVS/tcfs-openbsd/tcfsutils-1.0.0/src/tcfsputkey.c,v $
 *      $Revision: 1.2 $
 *      $Date: 2000/06/07 13:24:24 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include "tcfslib.h"
#include "tcfsutils.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <grp.h>
#include <sys/types.h>

#define DIM 256

extern int auth(char*,char*);

int main (int argc, char *argv[])
{
	const char* optstring=PUTKEY_OPTSTRING;
	const char* usage=PUTKEY_USAGE;
	int val, length, result, part, threshold;
	gid_t gid;	
	char group_name[MAX];
	option_flags flag;
	char label[DIM], filesystem[DIM];
	char *key=malloc(UUKEYSIZE), *password, *user, *clear_key;
	tcfspwdb* user_entry;
	tcfsgpwdb* group_entry;

	RESET_WORD(flag);

  	printf ("\nTCFS Utilities: version %d.%d.%d\n", MAJOR, MINOR, RELEASE);
	while ((val=getopt (argc,argv,optstring))!=-1) {

		switch (val)
		{
			case GID:
				gid=(gid_t)atoi(optarg);
				SET_ISGID(flag);
				break;
			case GROUP_NAME:
				strcpy(group_name,optarg);
				SET_ISGROUPNAME(flag);
				break;
			case KEY:
				SET_ISKEY(flag);
				strcpy(key,optarg);
				break;
			case ENCODED:
				SET_ISENCODED(flag);
				strcpy(key,optarg);
				break;
			case LABEL:
				SET_ISLABEL(flag);
				strcpy(label,optarg);
				break;
			case MOUNT_POINT:
				SET_ISMOUNTPOINT(flag);
				strcpy(filesystem,optarg);
				break;	
			case HELP:
				printf(usage,argv[0],LABEL,MOUNT_POINT,GID,GROUP_NAME,KEY,ENCODED,VERBOSE,HELP);
                                exit(0);
			case VERBOSE:
				SET_ISVERBOSE(flag);
				break;
			default:
				 printf("Try '%s -%c' for more information.\n\n",argv[0],HELP);
                                exit(-1);
		}
	}

	if (optind!=argc) {
                printf("Invalid option -- %s\n",argv[optind]);
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
                exit(-1);
        }     

	/* Check the options' constistency */
	if (TEST_ISGROUPNAME_SET(flag) && TEST_ISGID_SET(flag)) {
		printf("You've specified both the gid option and the group name option.\n");
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
		exit(-1);
	}
			 
	if (TEST_ISKEY_SET(flag) && TEST_ISENCODED_SET(flag)) {
		printf("You've specified both the key option and the encoded option.\n");
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
		exit(-1);
	}

	if (TEST_ISLABEL_SET(flag) && TEST_ISMOUNTPOINT_SET(flag)) {
		printf("You've specified both the label option and the mount point option.\n");  
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
                exit(-1);
        }
	
	if ((TEST_ISKEY_SET(flag) || TEST_ISENCODED_SET(flag)) && (TEST_ISGID_SET(flag) || TEST_ISGROUPNAME_SET(flag))) {
		printf("You've specified both the [key]/[encoded] option with [group name]/[gid] otpion.\n");  
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
                exit(-1);
        }

	/* End of consistency check */

	
	/* Get filesystem on which make operations */
	if ((!TEST_ISLABEL_SET(flag) && !TEST_ISMOUNTPOINT_SET(flag)) || TEST_ISLABEL_SET(flag)) {
		tab_entry* entry;
		
		if ((entry=tcfs_gettab_label(TEST_ISLABEL_SET(flag)?label:"default"))==NULL) { 
			printf("%s\n",tcfs_strerror(tcfs_errno));
			
			if (TEST_ISVERBOSE_SET(flag))
				printf("Make sure to give a correct label or that the tcfstab file exists.\n");

			printf("\n");
			exit(-1);
		}
		
		strcpy(filesystem,entry->mount_point);

	}
	
#ifdef TCFS_DEBUG
	fprintf(stderr,"Filesystem on wich I make operations: %s\n",filesystem);
#endif

	/* Get the group id value if group name option is set */
	if (TEST_ISGROUPNAME_SET(flag)) {
		struct group* group_info;
	
		if ((group_info=getgrnam(group_name))==NULL) {
			printf("Group with group name <%s> doesn't exist.\n",group_name);

			if (TEST_ISVERBOSE_SET(flag))
				printf("Contact your system's administrator to create group <%s>.\n",group_name);
			printf("\n");
			exit(-1);
		}
		gid=group_info->gr_gid;
	}	

	if (geteuid()!=0) {
		printf("Command %s must have root privileges.\n\n",argv[0]);
		exit(-1);
	}

	user=getlogin();	
	password=getpass("Insert your password, please: ");

	if (auth (user, password)==-1) {
       		memset(password,'\0',strlen(password));
                printf ("Invalid password for user <%s>.\n",user);

		if (TEST_ISVERBOSE_SET(flag))
			printf("Be sure to insert the proper password.\n");
			
		printf("\n");
       	        exit(-1);
       	}	

		
	/* Check the existence of a TCFS account */
	if (TEST_ISGID_SET(flag) || TEST_ISGROUPNAME_SET(flag)) {	
		if ((group_entry=tcfs_gpwfile_fetch(user,gid))==NULL) {
	
			printf("%s\n",tcfs_strerror(tcfs_errno));
		
			if (tcfs_errno==ER_GDBMNODATA) {
				printf("You don't have an entry into TCFS group key's file.\n");
	
				if (TEST_ISVERBOSE_SET(flag))
					printf("Contact your system's administrator to get an entry into TCFS group key's file.\n");
			}
		
			printf("\n");
			exit(-1);
		}	
		tcfs_gpwdb_fetch(group_entry,TCFS_DBPARTS|TCFS_DBTHRSHO,&part,&threshold);
	}
	else {
		if ((user_entry=tcfs_pwfile_fetch(user))==NULL) {
	
			printf("%s\n",tcfs_strerror(tcfs_errno));
		
			if (tcfs_errno==ER_GDBMNODATA) {
				printf("You don't have an entry into TCFS key's file.\n");
	
				if (TEST_ISVERBOSE_SET(flag) && tcfs_errno==ER_GDBMNODATA)
					printf("Contact your system's administrator to get an entry into TCFS key's file.\n");
			}
		
			printf("\n");
			exit(-1);
		}	
	}

	/* Retrieving key */
	if (!TEST_ISKEY_SET(flag) && !TEST_ISENCODED_SET(flag)) {

		if (!TEST_ISGID_SET(flag) && !TEST_ISGROUPNAME_SET(flag)) {
			tcfs_pwdb_fetch(user_entry,TCFS_DBKEY,key);

			if (strlen(key)==0) {
				printf("You don't have a TCFS key.\n");
				if (TEST_ISVERBOSE_SET(flag))
					printf("You must generate a key first or you can give it with the [-%c]/[-%c] option.\n",KEY,ENCODED);
				printf("\n");
				exit(-1);
			}
		}
		else {
			/* There is no need to check the key's existence. It is 			generated with tcfsaddgroup */
			tcfs_gpwdb_fetch(group_entry,TCFS_DBKEY,key);

#ifdef TCFS_DEBUG
	fprintf(stderr,"%s: part:%d threshold: %d.\n",argv[0],part,threshold);
#endif
		}	
	}	

				 
#ifdef TCFS_DEBUG
                fprintf(stderr,"%s: key is %s\n",argv[0],key);
#endif

	/* Get the clear key */
	if (TEST_ISENCODED_SET(flag)) {

		memset(password,'\0',strlen(password));
		if ((clear_key=tcfs_base64_decode(key,&length))==NULL) {
			printf("%s\n",tcfs_strerror(tcfs_errno));

			if (TEST_ISVERBOSE_SET(flag))
				printf("Make sure to insert a correct base 64 encoded key.\n");
			printf("\n");
			exit(-1);
		}
	}
	else if (TEST_ISKEY_SET(flag)) {
		memset(password,'\0',strlen(password));
		clear_key=key;
	}
	else {
		if (TEST_ISGROUPNAME_SET(flag) || TEST_ISGID_SET(flag))
			clear_key=tcfs_decrypt_key(key,password,TCFS_GROUP_KEY);
		else
			clear_key=tcfs_decrypt_key(key,password,TCFS_USER_KEY);

		if (clear_key==NULL) {
			printf("%s\n",tcfs_strerror(tcfs_errno));
			
			if (TEST_ISVERBOSE_SET(flag)) 
				printf("Make sure to use the right cipher.\n");
		
			printf("\n");  
			memset(password,'\0',strlen(password));
			exit(-1);
		}

#ifdef TCFS_DEBUG
	{
	char *k;
	if (TEST_ISGROUPNAME_SET(flag) || TEST_ISGID_SET(flag))
		k=tcfs_encrypt_key(clear_key,password,TCFS_GROUP_KEY);
	else
		k=tcfs_encrypt_key(clear_key,password,TCFS_USER_KEY);
	fprintf(stderr,"%s: key: %s\n",argv[0],k);
	}
#endif
	
	}		
	
	memset(password,'\0',strlen(password));

#ifdef TCFS_DEBUG
	{	
		int i;
		
		fprintf(stderr,"%s: clear key:",argv[0]);
		for (i=0;i<24;i++)	
			fprintf(stderr," %X",clear_key[i]);
		fprintf(stderr,"\n");
	}
#endif

	if (TEST_ISVERBOSE_SET(flag)) 
		printf("Passing key for TCFS filesystem '%s'...\n",filesystem);

	if (TEST_ISGROUPNAME_SET(flag) || TEST_ISGID_SET(flag)) {

#ifdef TCFS_DEBUG
	fprintf(stderr,"filesystem: %s, uid: %d, gid: %d, threshold: %d\n",filesystem,getuid(),gid,threshold);
#endif
 
		result=tcfs_group_enable(filesystem,getuid(),gid,threshold,clear_key);
	}
	else 
		result=tcfs_user_enable(filesystem,getuid(),clear_key);

	if (result!=0) {
		printf("%s\n",tcfs_strerror(tcfs_errno));

		if (TEST_ISVERBOSE_SET(flag) && tcfs_errno==ER_ENABLE) 
                        printf("Make sure that the key hasn't been already passed.\n");
                
		printf("\n");
                exit(-1);
	}

	printf("Passing completed.\n\n");
	
	return 0;
}
