/*
 *      $Source: /home/fergia/CVS/tcfs-openbsd/tcfsutils-1.0.0/src/tcfsrecover.c,v $
 *      $Revision: 1.2 $
 *      $Date: 2000/06/07 13:24:24 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include "tcfslib.h"
#include "tcfsutils.h"
#include <termios.h>
#include <stdio.h>
#include <unistd.h>
#include <pwd.h>
#include <string.h>
#include <ctype.h>

int main (int argc, char *argv[])
{
	const char* optstring=RECOVER_OPTSTRING;
	const char* usage=RECOVER_USAGE;
	int val;
	option_flags flag;
	char *user, old[_PASSWORD_LEN+1], new[_PASSWORD_LEN+1];	

	
	RESET_WORD(flag);

	printf ("\nTCFS Utilities: version %d.%d.%d\n", MAJOR, MINOR, RELEASE);
	
	while ((val=getopt (argc,argv,optstring))!=-1) {

		switch (val)
		{
			case GID:
				SET_ISGID(flag);
				break;
			case USER:
				SET_ISUSER(flag);
				break;
			case HELP:
				printf(usage,argv[0],USER,GID,VERBOSE,HELP);
                                exit(0);

			case VERBOSE:
				SET_ISVERBOSE(flag);
				break;
			default:
				 printf("Try '%s -%c' for more information.\n\n",argv[0],HELP);
                                exit(-1);
		}
	}
	
	if (optind!=argc) {
                printf("Invalid option -- %s\n",argv[optind]);
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
                exit(-1);
        }       
	
	{
		struct termios new,old;
		char option;

		printf("Warning:\n\tTake care when use this command.\n\tIt must be used only to recover a TCFS key/share lost.\n");
 
		printf("Do you want to go on? (Y/N)");
		fflush(stdout);

		tcgetattr(STDIN_FILENO,&old);
        	memcpy(&new,&old,sizeof(struct termios));

 	       	new.c_lflag&=~ECHO;
        	new.c_lflag&=~ICANON;
        	new.c_cc[VMIN]=1;
		new.c_cc[VTIME]=0;

		tcsetattr(STDIN_FILENO,TCSANOW,&new);

		do {
        		read(STDIN_FILENO,&option,sizeof(char));
                	option=toupper(option);
        	} while ((option!='Y') && (option!='N'));
                
        	tcsetattr(STDIN_FILENO,TCSANOW,&old);
		printf("\n");

#ifdef TCFS_DEBUG
        fprintf(stderr,"%s: value of option: %c\n",argv[0],option);
#endif
                
 	       if (option=='N') {      
                
			printf("Wise decision.\n\n");
			exit(-1);
        	}
	}
	
	if ((user=getlogin())==NULL) {
		printf("Can't get login name.\n");
		exit(-1);
	}
	
	//Set default option
	if (!TEST_ISGID_SET(flag)) SET_ISUSER(flag);

	strcpy(old,getpass("Please give the password that was used to encrypt TCFS key/share:"));
	strcpy(new,getpass("Please give the password that will be used to encrypt TCFS key/share:"));
	
	if (TEST_ISUSER_SET(flag)) {
	
		if (TEST_ISVERBOSE_SET(flag))
			printf("Updating TCFS key database...\n");

		if (tcfs_change_userkey(user,old,new)!=0) {

			printf("%s\n",tcfs_strerror(tcfs_errno));
			if (TEST_ISVERBOSE_SET(flag))
 	                       printf("TCFS key database not updated. Try again later...\n");
		
		}
		
		else if (TEST_ISVERBOSE_SET(flag))
			printf("TCFS key database updated...\n");
	}

	if (TEST_ISGID_SET(flag)) {
	
		if (TEST_ISVERBOSE_SET(flag))
                        printf("Updating TCFS share database...\n");

		if (tcfs_change_groupkey(user,old,new)!=0) {

                        printf("%s\n",tcfs_strerror(tcfs_errno));
                        if (TEST_ISVERBOSE_SET(flag))
                               printf("TCFS share database not updated. Try again later...\n");
                                      
                }
	
		
		else if (TEST_ISVERBOSE_SET(flag))
			printf("TCFS share database updated...\n");
	}
	
       	printf("\n");
	return 0;
}
