/*
 *      $Source: /home/fergia/CVS/tcfs-openbsd/tcfsutils-1.0.0/src/tcfsrmgroup.c,v $
 *      $Revision: 1.2 $
 *      $Date: 2000/06/07 13:24:24 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include "tcfslib.h"
#include "tcfsutils.h"
#include <stdio.h>
#include <unistd.h>
#include <grp.h>
#include <sys/types.h>
#include <stdlib.h>

int main (int argc, char *argv[])
{
	const char* optstring=RMGROUP_OPTSTRING;
	const char* usage=RMGROUP_USAGE;
	int val,found;
	option_flags flag;
	gid_t gid;
	char group_name[MAX];

	RESET_WORD(flag);

        printf ("\nTCFS Utilities: version %d.%d.%d\n", MAJOR, MINOR, RELEASE);
	while ((val=getopt (argc,argv,optstring))!=-1) {

		switch (val)
		{
			case GID:
				gid=(gid_t) atoi(optarg);
				SET_ISGID(flag);
				break;
			case GROUP_NAME:
				strcpy(group_name,optarg);
				SET_ISGROUPNAME(flag);
				break;
			case HELP:
				printf(usage,argv[0],GID,GROUP_NAME,VERBOSE,HELP);
                                exit(0);

			case VERBOSE:
				SET_ISVERBOSE(flag);
				break;
			default:
				 printf("Try '%s -%c' for more information.\n\n",argv[0],HELP);
                                exit(-1);
		}
	}

	if (optind!=argc) {
                printf("Invalid option -- %s\n",argv[optind]);
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
                exit(-1);
        }       
	
	if (TEST_ISGROUPNAME_SET(flag) && TEST_ISGID_SET(flag)) {
		printf("You've specified both the gid option and the group name option.\n");
	 	printf("Try '%s -%c' for more information.\n\n",argv[0],HELP);
		exit(-1);
	}

	if (!TEST_ISGROUPNAME_SET(flag) && !TEST_ISGID_SET(flag)) {

		printf("Insert the group id or the group name to remove from the database: ");
		fgets(group_name,MAX,stdin);
		group_name[strlen(group_name)-1]='\0';
		gid=(gid_t) atoi(group_name);

		if (gid==0 && *group_name!='0') 
			SET_ISGROUPNAME(flag);
		else
			SET_ISGID(flag);		

	}

	/* At this point only one between is_groupname and is_gid is set. */	
	if (TEST_ISGROUPNAME_SET(flag)) { 
	
		struct group *group_info;

		group_info=getgrnam(group_name);
		if (group_info==NULL) {
			printf("The group with group name <%s> doesn't exist.\n",group_name);
			if (TEST_ISVERBOSE_SET(flag))
				printf("Be sure to give a correct value.\n");
			printf("\n");
			exit(-1);
		}
 
		gid=group_info->gr_gid;
	}

	if (TEST_ISVERBOSE_SET(flag)) 
		printf("Removing all the entries with group id <%d> from the TCFS group key's file...\n",gid);
		
	if (tcfs_gpwfile_scan(gid,&found,TCFS_DBDELETE)!=0) {
		printf("%s\n",tcfs_strerror(tcfs_errno));

	        if (TEST_ISVERBOSE_SET(flag)) {
        	                printf("Possible causes:\n\t1) The TCFS group key's file hasn't the write permission.\n\t2) The TCFS group key's file may be corrupted.\n");
				printf("Entries were not removed.\n");
		}

		printf("\n");
		exit(-1);
	}	
	else 
		if (found==0) 
			printf("There are no entries with group id <%d> in the TCFS group key's file.\n\n",gid);			
		else
			printf("All the entries were removed.\n\n");

	return 0;
}


