/*
 *      $Source: /home/fergia/CVS/tcfs-openbsd/tcfsutils-1.0.0/src/tcfstat.c,v $
 *      $Revision: 1.2 $
 *      $Date: 2000/06/07 13:24:25 $
 *      $State: Exp $
 *      $Author: fergia $
 *      $Lockers$
 */

#include <stdio.h>
#include <unistd.h>
#include "tcfslib.h"
#include "tcfsutils.h"

#define DIM 256

int main (int argc, char *argv[]) {

	const char* optstring=STAT_OPTSTRING;
	const char* usage=STAT_USAGE;
	int val;
	option_flags flag;
	char label[DIM], filesystem[DIM];
	tcfs_status status;

	RESET_WORD(flag);
 	printf ("\nTCFS Utilities: version %d.%d.%d\n", MAJOR, MINOR, RELEASE);
	while ((val=getopt (argc,argv,optstring))!=-1) {

		switch (val)
		{
			 case LABEL:
                                SET_ISLABEL(flag);
                                strcpy(label,optarg);
                                break;
                        case MOUNT_POINT:
                                SET_ISMOUNTPOINT(flag);
                                strcpy(filesystem,optarg);
                                break;  
			case HELP:
				printf(usage,argv[0],LABEL,MOUNT_POINT,VERBOSE,HELP);
                                exit(0);
			case VERBOSE:
				SET_ISVERBOSE(flag);
				break;
			default:
				printf("Try '%s -%c' for more information.\n\n",argv[0],HELP);
                                exit(-1);
		}
	}

	if (optind!=argc) {
                printf("Invalid option -- %s\n",argv[optind]);
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
                exit(-1);
        }     

	/* Check the options' constistency */

	 if (TEST_ISLABEL_SET(flag) && TEST_ISMOUNTPOINT_SET(flag)) {
                printf("You've specified both the label option and the mount point option.\n");
                printf("Try '%s -%c' for more information.\n\n",argv[0],HELP); 
                exit(-1);
        }

	/* End of consistency check */
	
	 /* Get filesystem on which make operations */
        if ((!TEST_ISLABEL_SET(flag) && !TEST_ISMOUNTPOINT_SET(flag)) || TEST_ISLABEL_SET(flag)) {
                tab_entry* entry;
                
                if ((entry=tcfs_gettab_label(TEST_ISLABEL_SET(flag)?label:"default"))==NULL) {
                        printf("%s\n",tcfs_strerror(tcfs_errno));
                        
                        if (TEST_ISVERBOSE_SET(flag))
                                printf("Make sure to give a correct label or that the tcfstab file exists.\n");

                        printf("\n");
                        exit(-1);
                }
                
                strcpy(filesystem,entry->mount_point);

        }

	if (TEST_ISVERBOSE_SET(flag))
        	printf("Getting status about TCFS filesystem '%s'...\n",filesystem);

	if (tcfs_getstatus(filesystem, &status)!=0) {

		printf("%s\n",tcfs_strerror(tcfs_errno));

		if (TEST_ISVERBOSE_SET(flag))
               		printf("Make sure that '%s' is a valid TCFS filesystem mounted.\n",filesystem);

                        printf("\n");
                        exit(-1);
	}
	
	printf("Displaying information about TCFS filesystem '%s'...\n",filesystem);
	printf("\n-- General information --\n"); 
	printf("Status: %d\n",status.status);
	printf("TCFS version: %d\n",status.tcfs_version);
	printf("\n-- Key information --\n"); 
	printf("Number of user keys: %d\n",status.n_ukey);
	printf("Number of group keys: %d\n",status.n_gkey);
	printf("\n-- Cipher information --\n"); 
	printf("Cipher used: %s\n",status.cipher_desc);
	printf("Cipher version: %d\n",status.cipher_version);
	printf("Key size: %d bytes\n",status.cipher_keysize);

	printf("\n");
	return 0;
}
