{============================================================================
  
  MDC.PAS v2.0.0, Message Digest 5 Cipher Transform (15 January 1995)
  (C) Copyright 1994-1995 Robert Rothenburg Walking-Owl

  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
===========================================================================}
unit mdc;

interface

const
  mdc_hashsize  = 16; { 128-bits of hash }
  mdc_datasize  = 64; { 512-bits of data }
  mdc_numsteps  = 64; { no. of steps, actually 4 rounds * 16 steps }

type
  digest = array [ 0..(mdc_hashsize-1) ] of byte;
  { actually, digest = array [ 0..3 ] of longint }

  magicconstanttable = array [ 0..(mdc_numsteps-1) ] of longint;
  mdcblock           = array [ 0..(mdc_datasize-1) ] of byte;

const
  default_iv: digest = (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);

{ Important: remember to wipe these values when the program is done.  It's }
{ also a good idea to trap ctrl-break and runtime errors and wipe the data }
{ when these occur as well.                                                }
var
  saviv,
  iv:      digest;
  ivindex: word;
  savkey,
  auxkey:  mdcblock;

procedure memcopy(var source, dest; size: word); far;
procedure memfill(var block; size: word; ch: char); far;

procedure mdctransform(var data, hash); far;
procedure mdcsetconst(table: pointer); far;

procedure initkey(var key; keylength: word; var user_iv; iterations: word);
  far;
procedure encryptcfb(var block; numbytes: word); far;
procedure decryptcfb(var block; numbytes: word); far;

procedure savestate; far;
procedure restorestate; far;

implementation

procedure memcopy(var source, dest; size: word);
  external; {$l memcopy.obj}
procedure memfill(var block; size: word; ch: char);
  external; {$l memfill.obj }

procedure savestate;
begin
  memcopy(auxkey,savkey,sizeof(auxkey));
  memcopy(iv,saviv,sizeof(iv));
end;

procedure restorestate;
begin
  memcopy(savkey,auxkey,sizeof(auxkey));
  memcopy(saviv,iv,sizeof(iv));
end;

procedure mdctransform(var data, hash);
  external; {$l mdc.obj }

procedure mdcsetconst(table: pointer); external;

{ these procedures are based on mdc.c from the hpack 0.79a0 sources. }

procedure initkey(var key; keylength: word; var user_iv; iterations: word);
var
  keydata: magicconstanttable;
begin
  memfill(keydata, sizeof(keydata), #0);
{ in this case, bigendian, as in mdc.c }
  keydata[ 0 ] := hi( keylength );
  keydata[ 1 ] := lo( keylength );
{ key is truncated, but it need not be in other implementations, although }
{ 254 bytes (2032 bits) is a relatively large key.                        }
  if keylength>(sizeof(keydata)-sizeof(word))
     then keylength := (sizeof(keydata)-sizeof(word));
  memcopy( key, keydata[sizeof(word)], keylength );
  ivindex := 0;
  memcopy( user_iv, iv, mdc_hashsize );
  memfill( auxkey, mdc_datasize, #0);
  mdcsetconst( nil );
  while (iterations<>0) do begin
      encryptcfb(keydata, sizeof(keydata));
      mdcsetconst(addr(keydata));
      dec(iterations);
    end;
  encryptcfb(keydata,mdc_datasize);
  memcopy(keydata,auxkey,mdc_datasize);
  ivindex := 0;
  memfill(keydata,sizeof(keydata), #0); { wipe keydata }
{ note: remember to wipe the contents of key, auxkey and iv when done! }
end;

procedure encryptcfb(var block; numbytes: word);
(*external; {$l mdccrypt.obj} *)
var
  buffer:       array [ 0..65520 ] of byte absolute block;
  i,
  bytestouse,
  index:        word;
begin
  index := 0;
  if ivindex<>0
    then begin
        bytestouse := mdc_hashsize - ivindex;
        if numbytes<bytestouse
           then bytestouse := numbytes;
        for i := 0 to pred(bytestouse)
          do buffer[ i ] := buffer[ i ] xor iv[ i+ivindex ];
        memcopy(buffer, iv[ ivindex ], bytestouse);
        dec(numbytes, bytestouse);
        inc(index,    bytestouse);
        inc(ivindex,  bytestouse);
      end;
  while (numbytes<>0)
    do begin
        ivindex := mdc_hashsize;
        if numbytes<ivindex
          then ivindex := numbytes;
        mdctransform(auxkey, iv);
        for i := 0 to pred(ivindex)
          do buffer[ i+index ] := buffer[ i+index ] xor iv[ i ];
        memcopy(buffer[ index ], iv, ivindex);
        dec(numbytes, ivindex);
        inc(index,    ivindex);
        ivindex := ivindex mod mdc_hashsize;
      end;
end;

procedure decryptcfb(var block; numbytes: word);
var
  buffer:       array [ 0..65520 ] of byte absolute block;
  temp:         digest;
  i,
  bytestouse,
  index:        word;
begin
  index := 0;
  if ivindex<>0
    then begin
        bytestouse := mdc_hashsize - ivindex;
        if numbytes<bytestouse
           then bytestouse := numbytes;
        memcopy(buffer, temp, bytestouse);
        for i := 0 to pred(bytestouse)
          do buffer[ i ] := buffer[ i ] xor iv[ i+ivindex ];
        memcopy(temp, iv[ ivindex ], bytestouse);
        dec(numbytes, bytestouse);
        inc(index,    bytestouse);
        inc(ivindex,  bytestouse);
      end;
  while (numbytes<>0)
    do begin
        ivindex := mdc_hashsize;
        if numbytes<ivindex
          then ivindex := numbytes;
        mdctransform(auxkey, iv);
        memcopy(buffer[ index ], temp, ivindex);
        for i := 0 to pred(ivindex)
          do buffer[ i+index ] := buffer[ i+index ] xor iv[ i ];
        memcopy(temp, iv, ivindex);
        dec(numbytes, ivindex);
        inc(index,    ivindex);
        ivindex := ivindex mod mdc_hashsize;
      end;
  memfill(temp,sizeof(temp),#0);
end;


end.
