{============================================================================
  
  MDCrypto.PAS v1.0.4, Message Digest 5 Cipher Transform (20 January 1995)
  (C) Copyright 1995 Robert Rothenburg Walking-Owl

    History: 1.0.3 (17 Jan 95) MD5 object optimized for speed.
             1.0.4             Fixed bug in MD5 object Final routine.

  Requires MDC.ASM v2.1.0 or later (for 386 machines). Units may work for
  earlier versions of Turbo Pascal which support objects.

  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
===========================================================================}
unit MDCrypto;

interface

const
  MD5_HashSize  = 16; MDC_HashSize = MD5_HashSize; { 128-bits of hash  }
  MD5_DataSize  = 64; MDC_DataSize = MD5_DataSize; { 512-bits of data  }
  MD5_NumSteps  = 64; MDC_NumSteps = MD5_NumSteps; { 16 steps/4 rounds }
{$ifdef __MD5}
  ContextSize   = 64* MD5_DataSize;           { Size of Context buffer }
{$endif}
  DefaultIterations = 100; { default Iterations used for InitKey }

type
  Digest = Array [ 0..(MDC_HashSize-1) ] of Byte;
  { actually, Digest = Array [ 0..3 ] of LongInt }
  MagicConstantTable = Array [ 0..(MD5_NumSteps-1) ] of LongInt;
  MDCBlock           = Array [ 0..(MD5_DataSize-1) ] of Byte;
  LubyRackoffBlock   = Array [ 0..1 ] of Digest;

{- Message Digest (MD5) Object ---------------------------------------------}
{$ifdef __MD5}                 { define if no corresponding MD5 unit exists }
  PMD5 = ^TMD5;
  TMD5 = object
      private
        CtxBuffer: Array [0..(ContextSize-1)] of Byte;
        CtxSize:   Word;
        Count:     LongInt;
        MD5Digest: Digest;
        procedure BlockHash(var Block; Size: Word); virtual;
      public
        constructor Init;
        procedure Hash(var Block; Size: Word); virtual;
        destructor Final(var RMD5: Digest);
    end;
{$endif}

{$define __KeyConstants}  { Use MD5 constants derived from key }

{- Message Digest Cipher (MDC) Object --------------------------------------}
  PMDCrypt = ^TMDCrypt;
  TMDCrypt = object
    private
      ivSave,iv:           Digest;
      ivIndexSave,ivIndex: Word;
      AuxKeySave,AuxKey:   MDCBlock;
      Constants:           MagicConstantTable;
    public
      constructor
        InitKey(var Key; KeyLength: Word; var User_iv; Iterations: Word);
       { Key -> user's key (in text form)                             }
       { KeyLength -> length of key                                   }
       { for User_iv use MD_default_iv (16 null bytes)                }
       { Iterations -> No. iterations to initialize key (100 is good) }
      procedure EncryptCFB(var Block; NumBytes: Word); virtual;
      procedure DecryptCFB(var Block; NumBytes: Word); virtual;
      procedure SaveState; virtual;    { save current state of iv }
      procedure RestoreState; virtual; { restore state of iv }
      destructor Done; { cleans up variables                 }
    { Note: it's important to wipe any key info from memory or disk when }
    { done. One should also trap runtime errors or Ctrl-Breaks and call  }
    { the Done destructor as well as wipe key info.                      }
    end;

{- Luby-Rackoff MD5 Object -------------------------------------------------}
{$undef __ECBCBC}             { to enable ECB and CBC modes define __ECBCBC }
  PLRCrypt = ^TLRCrypt;
  TLRCrypt = object
    private
{$ifdef __ECBCBC}
      PreviousBlockSave,
      PreviousBlock,
{$endif}
      ivSave,iv:           Array[0..Pred(SizeOf(LubyRackoffBlock))] of Byte;
      ivIndexSave,ivIndex: Word;
      Kl,Kr:          Digest;
      Constants:      MagicConstantTable;
      procedure LubyRackoffRound(var Result: Digest; x,Left,Right: Digest);
        virtual;
      procedure EncryptB(var Buffer); virtual;
{$ifdef __ECBCBC}
      procedure DecryptB(var Buffer); virtual;
      procedure LRBlockXOR(var a,b: LubyRackoffBlock); virtual;
{$endif}
    public
{$ifdef __ECBCBC} { these were written mainly for debugging, but they work }
      procedure EncryptECB(var Block; NumBlocks: Word); virtual;
      procedure DecryptECB(var Block; NumBlocks: Word); virtual;
      procedure EncryptCBC(var Block; NumBlocks: Word); virtual;
      procedure DecryptCBC(var Block; NumBlocks: Word); virtual;
{$endif}
      constructor
        InitKey(var Key; KeyLength: Word; var User_iv; Iterations: Word);
       { for User_iv use LR_default_iv (32 null bytes) }
      procedure EncryptCFB(var Block; NumBytes: Word); virtual;
      procedure DecryptCFB(var Block; NumBytes: Word); virtual;
      procedure SaveState; virtual;
      procedure RestoreState; virtual;
      destructor Done;
    end;

{ since the MDCTransform routine is written for the 386, we might as well }
{ use fast 386 copy and fill routines...                                  }
procedure MemCopy(var source, dest; Size: Word); far;
procedure MemFill(var Block; Size: Word; ch: char); far;

const
  MD_default_iv: Digest = (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
  LR_default_iv: LubyRackoffBlock = ((0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
                                     (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0));

implementation

{ Since the MDCTransform routine uses 32-bit instructions, it only makes }
{ sense to use 32-bit equivalents of Move() and FillChar() procedures.   }
procedure MemCopy(var source, dest; Size: Word); external;    {$L MemCopy}
procedure MemFill(var Block; Size: Word; ch: char); external; {$L MemFill}

{ Basically, MDCTransform does an MD5 transformation: the difference is  }
{ one can change the "Magic Constants" used.                             }
{ Note: MDC.ASM *must* be assembled with __OOP defined!                  }
procedure MDCTransform(var ConsTbl, Data, Hash); far; external; {$L MDC}
function MDCDefault: Pointer; far; external;
{ MDCDefault returns a pointer to a table of default MD5 constants. }

{- Message Digest (MD5) Object ---------------------------------------------}

const
  MD5_Init:   Digest = ($01,$23,$45,$67,$89,$AB,$CD,$EF,
                        $FE,$DC,$BA,$98,$76,$54,$32,$10);
{$ifdef __MD5}

constructor TMD5.Init;
begin
  CtxSize := 0;
  Count   := 0;
  MemCopy(MD5_Init,MD5Digest,SizeOf(Digest));
end;

procedure TMD5.BlockHash(var Block; Size: Word);
var
  Buffer: Array [ 0..65520 ] of Byte absolute Block;
  CtxRem,
  j,i:    Word;
begin
  if Size<>0 then begin
      i := 0;
      repeat
        if CtxSize=SizeOf(CtxBuffer)
          then begin
              j := 0;
              repeat
                MDCTransform(MDCDefault^,CtxBuffer[j],MD5Digest);
                Inc(j,MD5_DataSize);
              until j=SizeOf(CtxBuffer);
              CtxSize := 0;
            end;
        CtxRem := SizeOf(CtxBuffer)-CtxSize;
        if CtxRem>(Size-i) then CtxRem := (Size-i);
        MemCopy(Buffer[i],CtxBuffer[CtxSize],CtxRem);
        Inc(CtxSize,CtxRem);
        Inc(i,CtxRem);
      until i=Size;
    end;
end;

procedure TMD5.Hash(var Block; Size: Word);
begin
  BlockHash(Block,Size);
  Count := Count + Size;
end;

destructor TMD5.Final(var RMD5: Digest);
var
  Buffer: Array[0..Pred(MD5_DataSize+(2*SizeOf(LongInt))+8)] of Byte;
  j,
  Size:   Word;
  LoCount,
  HiCount: LongInt;
begin
  j := (CtxSize mod MD5_DataSize);
  if j<56 then Size := 56-j else Size := (MD5_DataSize-j)+56;
  MemFill(Buffer,Size,#0); Buffer[0] := $80;
{ Size := 1;
  while ((Size+CtxSize) mod MD5_DataSize)<>56
    do begin
         Buffer[ Size ] := 0;
         Inc(Size);
       end; }
  LoCount := Count ShL 3; HiCount := Count ShR 29;
  MemCopy(LoCount,Buffer[Size],4); Inc(Size,4);
  MemCopy(HiCount,Buffer[Size],4); Inc(Size,4);
  BlockHash(Buffer,Size);
  if CtxSize<>0
    then begin
      j := 0;
      repeat
        MDCTransform(MDCDefault^,CtxBuffer[j],MD5Digest);
        Inc(j,MD5_DataSize);
      until j>=CtxSize;
     end;
  MemCopy(MD5Digest,RMD5,SizeOf(Digest));
end;
{$endif}

{- Message Digest Cipher (MDC) Object --------------------------------------}

constructor TMDCrypt.
   InitKey(var Key; KeyLength: Word; var User_iv; Iterations: Word);
var
  KeyData: MagicConstantTable;
begin
  MemFill(KeyData, SizeOf(KeyData), #0);
{ in this case, bigendian, as in MDC.c }
  KeyData[ 0 ] := hi( KeyLength );
  KeyData[ 1 ] := lo( KeyLength );
{ Key is truncated, but it need not be in other implementations, although }
{ 254 bytes (2032 bits) is a relatively large key.                        }
  if KeyLength>(SizeOf(KeyData)-SizeOf(Word))
     then KeyLength := (SizeOf(KeyData)-SizeOf(Word));
  MemCopy( Key, KeyData[SizeOf(Word)], KeyLength );
  ivIndex := 0;
  MemCopy( User_iv, iv, MDC_HashSize );
  MemFill( AuxKey, MDC_DataSize, #0);
  MemCopy( MDCDefault^, Constants, SizeOf(MagicConstantTable));
  while (Iterations<>0) do begin
      EncryptCFB(KeyData, SizeOf(KeyData));
{$ifdef __KeyConstants}
      MemCopy(KeyData,Constants,SizeOf(MagicConstantTable));
{$endif}
      Dec(Iterations);
    end;
  EncryptCFB(KeyData,MDC_DataSize);
  MemCopy(KeyData,AuxKey,MDC_DataSize);
  ivIndex := 0;
  MemFill(KeyData,SizeOf(KeyData), #0); { wipe KeyData }
end;

destructor TMDCrypt.Done;
begin
  MemFill(iv,SizeOf(iv),#0);
  MemFill(ivSave,SizeOf(ivSave),#0);
  ivIndex := 0;
  ivIndexSave := 0;
  MemFill(AuxKey,SizeOf(AuxKey),#0);
  MemFill(AuxKeySave,SizeOf(AuxKeySave),#0);
  MemFill(Constants,SizeOf(MagicConstantTable),#0);
end;

procedure TMDCrypt.EncryptCFB(var Block; NumBytes: Word);
var
  Buffer:       Array [ 0..65520 ] of Byte absolute Block;
  i,
  BytesToUse,
  Index:        Word;
begin
  Index := 0;
  if ivIndex<>0
    then begin
        BytesToUse := MDC_HashSize - ivIndex;
        if NumBytes<BytesToUse
           then BytesToUse := NumBytes;
        for i := 0 to Pred(BytesToUse)
          do Buffer[ i ] := Buffer[ i ] xor iv[ i+ivIndex ];
        MemCopy(Buffer, iv[ ivIndex ], BytesToUse);
        Dec(NumBytes, BytesToUse);
        Inc(Index,    BytesToUse);
        Inc(ivIndex,  BytesToUse);
      end;
  while (NumBytes<>0)
    do begin
        ivIndex := MDC_HashSize;
        if NumBytes<ivIndex
          then ivIndex := NumBytes;
        MDCTransform(Constants,AuxKey, iv);
        for i := 0 to Pred(ivIndex)
          do Buffer[ i+Index ] := Buffer[ i+Index ] xor iv[ i ];
        MemCopy(Buffer[ Index ], iv, ivIndex);
        Dec(NumBytes, ivIndex);
        Inc(Index,    ivIndex);
        ivIndex := ivIndex mod MDC_HashSize;
      end;
end;

procedure TMDCrypt.DecryptCFB(var Block; NumBytes: Word);
var
  Buffer:       Array [ 0..65520 ] of Byte absolute Block;
  Temp:         Digest;
  i,
  BytesToUse,
  Index:        Word;
begin
  Index := 0;
  if ivIndex<>0
    then begin
        BytesToUse := MDC_HashSize - ivIndex;
        if NumBytes<BytesToUse
           then BytesToUse := NumBytes;
        MemCopy(Buffer, Temp, BytesToUse);
        for i := 0 to Pred(BytesToUse)
          do Buffer[ i ] := Buffer[ i ] xor iv[ i+ivIndex ];
        MemCopy(Temp, iv[ ivIndex ], BytesToUse);
        Dec(NumBytes, BytesToUse);
        Inc(Index,    BytesToUse);
        Inc(ivIndex,  BytesToUse);
      end;
  while (NumBytes<>0)
    do begin
        ivIndex := MDC_HashSize;
        if NumBytes<ivIndex
          then ivIndex := NumBytes;
        MDCTransform(Constants,AuxKey, iv);
        MemCopy(Buffer[ Index ], Temp, ivIndex);
        for i := 0 to Pred(ivIndex)
          do Buffer[ i+Index ] := Buffer[ i+Index ] xor iv[ i ];
        MemCopy(Temp, iv, ivIndex);
        Dec(NumBytes, ivIndex);
        Inc(Index,    ivIndex);
        ivIndex := ivIndex mod MDC_HashSize;
      end;
  MemFill(Temp,SizeOf(Temp),#0);
end;

procedure TMDCrypt.SaveState;
begin
  ivIndexSave := ivIndex;
  MemCopy(iv,ivSave,SizeOf(iv));
  MemCopy(AuxKey,AuxKeySave,SizeOf(AuxKey));
end;

procedure TMDCrypt.RestoreState;
begin
  ivIndex := ivIndexSave;
  MemCopy(ivSave,iv,SizeOf(iv));
  MemCopy(AuxKeySave,AuxKey,SizeOf(AuxKey));
end;

{- Luby-Rackoff MD5 Object -------------------------------------------------}

const
  LubyRackoff_iv: MDCBlock = (
     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   $80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0);

procedure TLRCrypt.LubyRackoffRound(var Result: Digest; x,Left,Right: Digest);
{ Result = x xor MD5Hash(Left,Right) }
var
  i:     Byte;
  Block: MDCBlock;
begin
  MemCopy(MD5_Init,Result,SizeOf(Digest));
  MemCopy(LubyRackoff_iv,Block,SizeOf(MDCBlock));
  MemCopy(Left,Block[0],SizeOf(Digest));
  MemCopy(Right,Block[SizeOf(Digest)],SizeOf(Digest));
  MDCTransform(Constants,Block,Result);
{ this could be sped up in ASM by xoring dwords at a time }
  for i := 0 to Pred(SizeOf(Digest))
    do Result[i] := Result[i] xor x[i];
  MemFill(Block,SizeOf(Block),#0);
end;

procedure TLRCrypt.EncryptB(var Buffer);
{ L0 = Block[0]; R0 = Block[1] }
var
  R1,L1: Digest;
  Block: LubyRackoffBlock absolute Buffer;
begin
  LubyRackoffRound(R1,Block[1],Kl,Block[0]);
  LubyRackoffRound(L1,Block[0],Kr,R1);
  LubyRackoffRound(Block[1],R1,Kl,L1);
  LubyRackoffRound(Block[0],L1,Kr,Block[1]);
  MemFill(R1,SizeOf(Digest),#0); MemFill(L1,SizeOf(Digest),#0);
end;

{$ifdef __ECBCBC}
procedure TLRCrypt.DecryptB(var Buffer);
var
  R1,L1: Digest;
  Block: LubyRackoffBlock absolute Buffer;
begin
  LubyRackoffRound(L1,Block[0],Kr,Block[1]);
  LubyRackoffRound(R1,Block[1],Kl,L1);
  LubyRackoffRound(Block[0],L1,Kr,R1);
  LubyRackoffRound(Block[1],R1,Kl,Block[0]);
  MemFill(R1,SizeOf(Digest),#0); MemFill(L1,SizeOf(Digest),#0);
end;

procedure TLRCrypt.EncryptECB(var Block; NumBlocks: Word);
{ Note: (buffersize mod SizeOf(LubyRackoffBlock)) MUST = 0! }
var
  Buffer:  Array [ 0..2046 ] of LubyRackoffBlock absolute Block;
  i:       Word;
  LRBlock: LubyRackoffBlock;
begin
  i := 0;
  repeat
    EncryptB(Buffer[i]);
    Inc(i); Dec(NumBlocks);
  until NumBlocks=0;
end;

procedure TLRCrypt.DecryptECB(var Block; NumBlocks: Word);
var
  Buffer:  Array [ 0..2046 ] of LubyRackoffBlock absolute Block;
  i:       Word;
  LRBlock: LubyRackoffBlock;
begin
  i := 0;
  repeat
    DecryptB(Buffer[i]);
    Inc(i); Dec(NumBlocks);
  until NumBlocks=0;
end;

procedure TLRCrypt.LRBlockXOR(var a,b: LubyRackoffBlock);
var
  a1: Array[0..Pred(SizeOf(LubyRackoffBlock) div 2)] of Word absolute a;
  b1: Array[0..Pred(SizeOf(LubyRackoffBlock) div 2)] of Word absolute b;
  i:  Word;
begin
  { Again, doing this in dwords is faster... }
  for i := 0 to Pred(SizeOf(LubyRackoffBlock) div 2)
    do a1[i] := a1[i] xor b1[i];
end;

procedure TLRCrypt.EncryptCBC(var Block; NumBlocks: Word);
{ Note: (buffersize mod SizeOf(LubyRackoffBlock)) MUST = 0! }
var
  Buffer:  Array [ 0..2046 ] of LubyRackoffBlock absolute Block;
  i:       Word;
begin
  i := 0;
  repeat
    LRBlockXOR(Buffer[i],PreviousBlock);
    EncryptB(Buffer[i]);
    MemCopy(Buffer[i],PreviousBlock,SizeOf(LubyRackoffBlock));
    Inc(i); Dec(NumBlocks);
  until NumBlocks=0;
end;

procedure TLRCrypt.DecryptCBC(var Block; NumBlocks: Word);
var
  Buffer:  Array [ 0..2046 ] of LubyRackoffBlock absolute Block;
  i:       Word;
  Temp:    LubyRackoffBlock;
begin
  i := 0;
  repeat
    MemCopy(PreviousBlock,Temp,SizeOf(LubyRackoffBlock));
    MemCopy(Buffer[i],PreviousBlock,SizeOf(LubyRackoffBlock));
    DecryptB(Buffer[i]);
    LRBlockXOR(Buffer[i],Temp);
    Inc(i); Dec(NumBlocks);
  until NumBlocks=0;
  MemFill(Temp,SizeOf(Temp),#0);
end;
{$endif}

constructor TLRCrypt.
  InitKey(var Key; KeyLength: Word; var User_iv; Iterations: Word);
var
  KeyData: MagicConstantTable;
begin
  MemCopy(MDCDefault^,Constants,SizeOf(MagicConstantTable));
{$ifdef __ECBCBC}
  MemFill(PreviousBlock,SizeOf(LubyRackoffBlock),#0);
{$endif}
  MemFill(KeyData, SizeOf(KeyData), #0);
{ in this case, bigendian, as in MDC.c }
  KeyData[ 0 ] := hi( KeyLength );
  KeyData[ 1 ] := lo( KeyLength );
{ Key is truncated, but it need not be in other implementations, although }
{ 254 bytes (2032 bits) is a relatively large key.                        }
  if KeyLength>(SizeOf(KeyData)-SizeOf(Word))
     then KeyLength := (SizeOf(KeyData)-SizeOf(Word));
  MemCopy( Key, KeyData[SizeOf(Word)], KeyLength );
  ivIndex := 0;
  MemCopy( User_iv, iv, SizeOf(LubyRackoffBlock) );
  MemFill(Kl,SizeOf(Kl),#0); MemFill(Kr,SizeOf(Kr),#0);
  MemCopy( MDCDefault^, Constants, SizeOf(MagicConstantTable));
  while (Iterations<>0) do begin
      EncryptCFB(KeyData, SizeOf(KeyData));
{$ifdef __KeyConstants}
      MemCopy(KeyData,Constants,SizeOf(MagicConstantTable));
{$endif}
      Dec(Iterations);
    end;
  EncryptCFB(KeyData, SizeOf(KeyData));
  MemCopy(KeyData[0],Kl,SizeOf(Digest));
  MemCopy(KeyData[SizeOf(Digest)],Kr,SizeOf(Digest));
  ivIndex := 0;
  MemFill(KeyData,SizeOf(KeyData), #0); { wipe KeyData }
end;

procedure TLRCrypt.EncryptCFB(var Block; NumBytes: Word);
var
  Buffer:       Array [ 0..65520 ] of Byte absolute Block;
  i,
  BytesToUse,
  Index:        Word;
begin
  Index := 0;
  if ivIndex<>0
    then begin
        BytesToUse := MDC_HashSize - ivIndex;
        if NumBytes<BytesToUse
           then BytesToUse := NumBytes;
        for i := 0 to Pred(BytesToUse)
          do Buffer[ i ] := Buffer[ i ] xor iv[ i+ivIndex ];
        MemCopy(Buffer, iv[ ivIndex ], BytesToUse);
        Dec(NumBytes, BytesToUse);
        Inc(Index,    BytesToUse);
        Inc(ivIndex,  BytesToUse);
      end;
  while (NumBytes<>0)
    do begin
        ivIndex := MDC_HashSize;
        if NumBytes<ivIndex
          then ivIndex := NumBytes;
        EncryptB(iv);
        for i := 0 to Pred(ivIndex)
          do Buffer[ i+Index ] := Buffer[ i+Index ] xor iv[ i ];
        MemCopy(Buffer[ Index ], iv, ivIndex);
        Dec(NumBytes, ivIndex);
        Inc(Index,    ivIndex);
        ivIndex := ivIndex mod MDC_HashSize;
      end;
end;

procedure TLRCrypt.DecryptCFB(var Block; NumBytes: Word);
var
  Buffer:       Array [ 0..65520 ] of Byte absolute Block;
  Temp:         Digest;
  i,
  BytesToUse,
  Index:        Word;
begin
  Index := 0;
  if ivIndex<>0
    then begin
        BytesToUse := MDC_HashSize - ivIndex;
        if NumBytes<BytesToUse
           then BytesToUse := NumBytes;
        MemCopy(Buffer, Temp, BytesToUse);
        for i := 0 to Pred(BytesToUse)
          do Buffer[ i ] := Buffer[ i ] xor iv[ i+ivIndex ];
        MemCopy(Temp, iv[ ivIndex ], BytesToUse);
        Dec(NumBytes, BytesToUse);
        Inc(Index,    BytesToUse);
        Inc(ivIndex,  BytesToUse);
      end;
  while (NumBytes<>0)
    do begin
        ivIndex := MDC_HashSize;
        if NumBytes<ivIndex
          then ivIndex := NumBytes;
        EncryptB(iv);
        MemCopy(Buffer[ Index ], Temp, ivIndex);
        for i := 0 to Pred(ivIndex)
          do Buffer[ i+Index ] := Buffer[ i+Index ] xor iv[ i ];
        MemCopy(Temp, iv, ivIndex);
        Dec(NumBytes, ivIndex);
        Inc(Index,    ivIndex);
        ivIndex := ivIndex mod MDC_HashSize;
      end;
  MemFill(Temp,SizeOf(Temp),#0);
end;

procedure TLRCrypt.SaveState;
begin
  ivIndexSave := ivIndex;
  MemCopy(iv,ivSave,SizeOf(iv));
{$ifdef __ECBCBC}
  MemCopy(PreviousBlock,PreviousBlockSave,SizeOf(PreviousBlock));
{$endif}
end;

procedure TLRCrypt.RestoreState;
begin
  ivIndex := ivIndexSave;
  MemCopy(ivSave,iv,SizeOf(iv));
{$ifdef __ECBCBC}
  MemCopy(PreviousBlock,PreviousBlockSave,SizeOf(PreviousBlock));
{$endif}
end;


destructor TLRCrypt.Done;
begin
  MemFill(Constants,SizeOf(MagicConstantTable),#0);
  MemFill(Kl,SizeOf(Kl),#0); MemFill(Kr,SizeOf(Kr),#0);
{$ifdef __ECBCBC}
  MemFill(PreviousBlock,SizeOf(PreviousBlock),#0);
  MemFill(PreviousBlockSave,SizeOf(PreviousBlockSave),#0);
{$endif}
  MemFill(iv,SizeOf(iv),#0); MemFill(ivSave,SizeOf(ivSave),#0);
  ivIndex := 0; ivIndexSave := 0;
end;

{ We could easily add a Karn implementation here; however Karn (a two round }
{ anscestor of Luby-Rackoff) in some respects is not secure.                }

end.
