COMMENT |
============================================================================
  
  MD4.ASM v2.2.0, Message Digest 4 Transform (20 January 1995)
  (C) Copyright 1994-1995 Robert Rothenburg Walking-Owl
  
    History: 1.0    Original release (16 Oct 94)
             2.0    ASM code rewritten (Jan 95).
             2.2.0  ASM code written to use MDContext record, for
                    "compatability" with C implementations.

  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
============================================================================
| Note: source has been assembled successfully with TASM 3.2

; - MD4 Assembly Options (Conditional Defines): ----------------------------

__CONTEXT           EQU       1     ; Use MDContext structure

; Miscellaneous optimizations:

__LOCALVARS         EQU         1   ; Locals in STACK (otherwise in CODE)
__NOPROCS           EQU         1   ; Use macros not procs for F-I funcs.
__FASTERMETHOD      EQU         1   ; Optimized calculations for F and G (*)
__COPYINIT          EQU         1   ; 
__FASTCALLS         EQU         1   ;

; __FASTERMETHOD is based on recommendations in NIST SHA specification

; Note: the MD4 specification describes an extention (taken up partially
;       with RIPE-MD) for a 256-bit output, where a second MD4 transform
;       runs in parallel, with the following modifications:
;
;       The initial state of ABCD is 00112233 44556677 8899aab bccddeeff
;
;       The "magic constants" in rounds 2 and 3 are changed from sqrt(2)
;       and sqrt(2) to cuberoot(2) and cuberoot(3), so that they are
;       50a28be6 and 5c4dd124, respectively.
;
;       Finally, after every block is transformed, the values of the two
;       A registers are exchanged.
;
;       The final message digest if obtained by appending the result of
;       the second copy with the result of the first copy.
                    
; - MD4 Unconditional Defines: ---------------------------------------------

__NOSTOR            EQU         1   ; Copy A,B,C,D regs. as block (faster?)
__MISCOPT           EQU         1   ; Misc. optimization for H and I func

A         EQU       <DWORD PTR es: [di]>    ; chaining variables
B         EQU       <DWORD PTR es: [di+4]>  ;
C         EQU       <DWORD PTR es: [di+8]>  ;
D         EQU       <DWORD PTR es: [di+12]> ;

X         EQU       <DWORD PTR ds: [si]>    ;

        IFDEF   __CONTEXT
ctxlobits EQU       <DWORD PTR es: [di][16]> ; low  no. bits count
ctxhibits EQU       <DWORD PTR es: [di][20]> ; high  "   "     "
ctxinput  EQU       <DWORD PTR es: [di][24]> ; context input buffer
ctxlofin  EQU       <DWORD PTR es: [di][80]> ; 
ctxhifin  EQU       <DWORD PTR es: [di][84]>

; MDContext structure is as follows:
;
;   unsigned long buf[4]                ; 16 bytes, current hash value
;   unsigned long bits[2]               ; current count of bits
;   unsigned char in[64]                ; current buffer
;
; (See note in MD5.ASM about optimizations.)

        ENDIF


; - Miscellaneous macros: --------------------------------------------------

STOR      MACRO     dest, src
           mov      eax,  src
          IFDEF     __LOCALVARS
            mov     dest, eax
          ELSE
            mov     cs: dest, eax
          ENDIF       
         ENDM        

ADDD     MACRO      i, j      ; eax=j; i=i+eax
           mov      eax, j
           add      i, eax
         ENDM        

      IFDEF     __CONTEXT
MCPY     MACRO
           LOCAL        @0
           cld
           shr          cx,     1
           jnc          @0
           movsb
 @0:       rep          movsw
         ENDM

MSET     MACRO             
           LOCAL        @0
           xor          ax,     ax
           shr          cx,     1
           jnc          @0
           stosb
 @0:       rep          stosw
         ENDM
      
XFORM    MACRO         
           pusha
           push        es
           add         di,     24
           push        di
           push        es
           push        dx
          IFDEF      __FASTCALLS  
           push        cs
           mov         ax, OFFSET MD4Transform
           call        ax
          ELSE
           call        cs: MD4Transform
          ENDIF
           popa
         ENDM
      ENDIF

                    DOSSEG
                    .MODEL      LARGE
                    .386

                    .CODE


; - Auxiliary function F(x,y,z)=xy v not(x)z -------------------------------

; if __FASTERMETHOD is defined, F(x,y,z)=z xor (x)(y xor z)

; result = eax, x = ebx, y = ecx, z = edx

                    IFDEF          __NOPROCS
F                     MACRO     
                    ELSE        
F                     PROC      NEAR
                    ENDIF       
                    IFDEF          __FASTERMETHOD
                      mov         eax,      ecx
                      xor         eax,      edx
                      and         eax,      ebx
                      xor         eax,      edx
                    ELSE        
                      mov         eax,      ebx
                      and         eax,      ecx
                      not         ebx
                      and         ebx,      edx
                      or          eax,      ebx
                    ENDIF       
                    IFDEF          __NOPROCS
                      ENDM        
                    ELSE        
                      ret         
F                     ENDP      
                    ENDIF       

; -------------------------------------------------------------------------
; FF(a,b,c,d,X[k],s,t) denotes a = ((a + F(b,c,d) + X[k]) <<< s)
; -------------------------------------------------------------------------

FF                    MACRO     a, b, c, d, X, s
                      mov         ebx,      b
                      mov         ecx,      c
                      mov         edx,      d
                      IFDEF          __NOPROCS
                        F           
                      ELSE        
                        call        F
                      ENDIF       
                      add       eax,      a
                      add       eax,      X
                      rol       eax,      s
                      mov       a,        eax
                    ENDM        

S11                  EQU     3
S12                  EQU     7
S13                  EQU     11
S14                  EQU     19

; - Auxiliary function G(x,y,z)=xy v xz v yz -------------------------------

; if __FASTERMETHOD is defined, G(x,y,z)=xy v z(x v y)

                    IFDEF          __NOPROCS
G                     MACRO     
                    ELSE        
G                     PROC      NEAR
                    ENDIF
                    IFDEF       __FASTERMETHOD
                      mov         eax,      ebx
                      or          eax,      ecx
                      and         eax,      edx
                      and         ebx,      ecx
                      or          eax,      ebx
                    ELSE        
                      mov         eax,      ebx
                      and         eax,      ecx
                      and         ebx,      edx
                      and         ecx,      edx
                      or          eax,      ebx
                      or          eax,      ecx
                    ENDIF
                    IFDEF          __NOPROCS
                    ENDM        
                    ELSE        
                      ret         
G                     ENDP      
                    ENDIF       
; --------------------------------------------------------------------------
; GG(a,b,c,d,X[k],s,t) denotes a = ((a + G(b,c,d) + X[k] + t) <<< s)
; --------------------------------------------------------------------------

GG                  MACRO       a, b, c, d, X, s
                      mov         ebx,      b
                      mov         ecx,      c
                      mov         edx,      d
                      IFDEF       __NOPROCS
                        G
                      ELSE        
                        call        G
                      ENDIF       
                      add         eax,      a
                      add         eax,      x
                      add         eax,      5a827999H  ; t
                      rol         eax,      s
                      mov         a,        eax
                    ENDM        

S21                 EQU       3
S22                 EQU       5
S23                 EQU       9
S24                 EQU       13
 
; - Auxiliary function H(x,y,z)=x xor y xor z ------------------------------
                    
                    IFDEF          __NOPROCS
H                      MACRO     
                    ELSE        
H                      PROC      NEAR
                    ENDIF       
                    mov         eax,        ebx
                    xor         eax,        ecx
                    xor         eax,        edx
                    IFDEF          __NOPROCS
                    ENDM        
                    ELSE        
                      ret         
H                   ENDP      
                    ENDIF       

; --------------------------------------------------------------------------
; HH(a,b,c,d,X[k],s,t) denotes a = ((a + H(b,c,d) + X[k] + t) <<< s)
; --------------------------------------------------------------------------

HH                    MACRO     a, b, c, d, X, s
                      mov         ebx,      b
                      mov         ecx,      c
                      mov         edx,      d
                      IFDEF          __NOPROCS
                        H            
                      ELSE        
                        call        H 
                      ENDIF       
                      add         eax,      a
                      add       eax,      X
                      add       eax,      6ed9eba1H ; t
                      rol       eax,      s
                      mov       a,        eax
                    ENDM        

S31                   EQU     3
S32                   EQU     9
S33                   EQU     11
S34                   EQU     15
                    


; - Temporary Registers: ---------------------------------------------------

                    IFNDEF      __LOCALVARS
AA                    LABEL     DWORD
                      DD          (?)
BB                    LABEL     DWORD
                      DD          (?)
CC                    LABEL     DWORD
                      DD          (?)
DD0                   LABEL     DWORD
                      DD          (?)
                    ENDIF

; - Initializate Digest: ---------------------------------------------------
                 
                 IFNDEF __TRANSFORMONLY
; if __TRANSFORMONLY defined, no MD4Init routine will assembled.
                    PUBLIC      PASCAL MD4Init
MD4Init             PROC        PASCAL FAR digest: DWORD
                    IFDEF     __COPYINIT
                      push      ds
                      mov       ax,       cs
                      mov       ds,       ax
                      mov       si,       OFFSET initial_values
                    ENDIF       
                    les         di,       digest
                    IFNDEF    __COPYINIT
                      mov       A,      67452301h
                      mov       B,     0EFCDAB89h
                      mov       C,      98BADCFEh
                      mov       D,      10325476h
                     IFDEF    __CONTEXT 
                      mov     ctxlobits, 0
                      mov     ctxhibits, 0  
                     ENDIF
                    ELSE 
                     IFDEF    __CONTEXT 
                      mov       cx,     6
                     ELSE
                      mov       cx,     4
                     ENDIF
                      cld         
                      rep         movsd
                      pop         ds
                    ENDIF       
                    ret        
                    
                    IFDEF       __COPYINIT or __CONTEXT
initial_values      LABEL     DWORD
  DD                  67452301h
  DD                 0EFCDAB89h
  DD                  98BADCFEh
  DD                  10325476h
IFDEF __CONTEXT
  DD  2 DUP (?)         
ENDIF
                    ENDIF
MD4Init             ENDP

; - Update Context Buffer: -------------------------------------------------
                 IFDEF  __CONTEXT
                    PUBLIC      PASCAL MD4Update
MD4Update           PROC        PASCAL FAR ctx: DWORD, buff: DWORD, len: WORD
                    push        ds
                    lds         si,     buff
                    les         di,     ctx
 @0:                cmp         len,    0
                    jz          SHORT   @3
                    mov         eax,    ctxlobits
                    shr         eax,    3
                    and         ax,     3Fh
                    mov         cx,     40h
                    sub         cx,     ax
                    cmp         cx,     len
                    jna         SHORT @1
                    mov         cx,    len
 @1:                sub         len,   cx
                    mov         bx,    ax
                    mov         ax,    cx
                    and         eax,   0FFFFh
                    shl         eax,    3
                    add         ctxlobits, eax
                    adc         ctxhibits, 0  
                    mov         dx,     di
                    add         di,     24
                    add         di,     bx
                    add         bx,     cx
                    MCPY
                    mov         di,     dx
                    cmp         bx,     40h
                    jnz         SHORT @2
                    XFORM
 @2:                jmp         SHORT @0
 @3:                   
                    pop          ds
                    ret
MD4Update           ENDP

; - Wrap-up Context Buffer: ------------------------------------------------

                    PUBLIC      PASCAL MD4Final
MD4Final            PROC        PASCAL FAR digest: DWORD, ctx: DWORD
                    push        ds
                    les         di,     ctx
                    mov         eax,    ctxlobits
                    shr         eax,    3
                    and         ax,     3Fh
                    mov         bx,     ax
                    mov         dx,     di
                    add         di,     24
                    add         di,     bx
                    mov         al,     80h
                    cld
                    stosb
                    inc         bx
                    mov         cx,     40h
                    sub         cx,     bx
                    cmp         bx,     38h
                    jb          SHORT @4
                    MSET
                    mov         di,     dx
                    XFORM
                    add         di,     24
                    mov         cx,     38h             
 @4:                MSET
                    mov         di,     dx
                    STOR        ctxlofin, ctxlobits
                    STOR        ctxhifin, ctxhibits
                    XFORM
                    mov         si,     di
                    mov         ax,     es
                    mov         ds,     ax
                    les         di,     digest
                    mov         cx,     16
                    MCPY
                    mov         es,     ax        ; wipe buffer in case
                    mov         di,     dx        ; there is anything
                    mov         cx,     (16+8+64) ; sensitive
                    MSET
                    pop         ds
                    ret
MD4Final            ENDP

                  ENDIF
                 ENDIF
; - MD4 Transformation: ----------------------------------------------------

                    PUBLIC      PASCAL MD4Transform
MD4Transform        PROC        PASCAL FAR hashdata: DWORD,digest: DWORD
                  IFDEF          __LOCALVARS
                    LOCAL       AA: DWORD, BB: DWORD, CC: DWORD, DD0: DWORD
                  ENDIF       
                    push        ds
                    IFDEF          __NOSTOR
                      lds         si,       digest
                      IFDEF          __LOCALVARS
                        lea         di,     OFFSET AA
                        mov         ax,     ss
                      ELSE        
                        mov         di,     OFFSET AA
                        mov         ax,     cs
                      ENDIF       
                      mov         es,       ax
                      mov         cx,       4
                      cld         
                      rep         movsd
                    ENDIF       
                    lds         si,         hashdata      ; *data[64]
                    les         di,         digest        ; *hash[16]
                    IFNDEF         __NOSTOR
                      STOR        AA,       A             ;
                      STOR        BB,       B
                      STOR        CC,       C
                      STOR        DD0,      D
                    ENDIF
; -Round 1 -----------------------------------------------------------------
                    FF          A, B, C, D, X.[4*0], S11
                    FF          D, A, B, C, X.[4*1], S12
                    FF          C, D, A, B, X.[4*2], S13
                    FF          B, C, D, A, X.[4*3], S14
                    FF          A, B, C, D, X.[4*4], S11
                    FF          D, A, B, C, X.[4*5], S12
                    FF          C, D, A, B, X.[4*6], S13
                    FF          B, C, D, A, X.[4*7], S14
                    FF          A, B, C, D, X.[4*8], S11
                    FF          D, A, B, C, X.[4*9], S12
                    FF          C, D, A, B, X.[4*10], S13
                    FF          B, C, D, A, X.[4*11], S14
                    FF          A, B, C, D, X.[4*12], S11
                    FF          D, A, B, C, X.[4*13], S12
                    FF          C, D, A, B, X.[4*14], S13
                    FF          B, C, D, A, X.[4*15], S14
; - Round 2 ----------------------------------------------------------------
                    GG          A, B, C, D, X.[4*0], S21
                    GG          D, A, B, C, X.[4*4], S22
                    GG          C, D, A, B, X.[4*8], S23
                    GG          B, C, D, A, X.[4*12], S24
                    GG          A, B, C, D, X.[4*1], S21
                    GG          D, A, B, C, X.[4*5], S22
                    GG          C, D, A, B, X.[4*9], S23
                    GG          B, C, D, A, X.[4*13], S24
                    GG          A, B, C, D, X.[4*2], S21
                    GG          D, A, B, C, X.[4*6], S22
                    GG          C, D, A, B, X.[4*10], S23
                    GG          B, C, D, A, X.[4*14], S24
                    GG          A, B, C, D, X.[4*3], S21
                    GG          D, A, B, C, X.[4*7], S22
                    GG          C, D, A, B, X.[4*11], S23
                    GG          B, C, D, A, X.[4*15], S24
; - Round 3 ----------------------------------------------------------------
                    HH          A, B, C, D, X.[4*0], S31
                    HH          D, A, B, C, X.[4*8], S32
                    HH          C, D, A, B, X.[4*4], S33
                    HH          B, C, D, A, X.[4*12], S34
                    HH          A, B, C, D, X.[4*2], S31
                    HH          D, A, B, C, X.[4*10], S32
                    HH          C, D, A, B, X.[4*6], S33
                    HH          B, C, D, A, X.[4*14], S34
                    HH          A, B, C, D, X.[4*1], S31
                    HH          D, A, B, C, X.[4*9], S32
                    HH          C, D, A, B, X.[4*5], S33
                    HH          B, C, D, A, X.[4*13], S34
                    HH          A, B, C, D, X.[4*3], S31
                    HH          D, A, B, C, X.[4*11], S32
                    HH          C, D, A, B, X.[4*7], S33
                    HH          B, C, D, A, X.[4*15], S34
; --------------------------------------------------------------------------
                    ADDD        A, AA   ;
                    ADDD        B, BB
                    ADDD        C, CC
                    ADDD        D, DD0
                    pop         ds               ;
                    ret
MD4transform        ENDP
                  END
