{============================================================================

  MD5.PAS v2.2, Message Digest 5 Cipher Transform (20 January 1995)
  (C) Copyright 1994-1995 Robert Rothenburg Walking-Owl

    History: 1.0    Original release (Sep 94)
             2.0    ASM and PAS code rewritten entirely for OOP (Jan 95).
             2.1    MD5 object optimized for speed.
             2.1.2  Fixed bug in MD5 object Final routine.
             2.2.0  ASM code written to use MDContext record. OOP abandoned
                    for "compatability" with C implementations.

  Requires MD5.ASM v2.2.0 or later (for 386 machines). Units may work for
  earlier versions of Turbo Pascal which support objects.

  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
===========================================================================}
unit MD5;

interface

type

  MDContext = record
      buf:  Array [0..15] of Byte; { MD5 Context  }
      bits: Array [0..7] of Byte;  { bit-count    }
      inb:  Array [0..63] of Byte; { input buffer }
    end;

procedure MD5Init(var ctx: MDContext); far;
procedure MD5Update(var ctx: MDContext; var buff; len: word); far;
procedure MD5Final(var digest; var ctx: MDContext); far;
procedure MD5Transform(var inb, buf); far;

procedure MD5File(var f: file; var digest);  { Assumes file is open }
procedure MD5Buff(var buff; len: word; var digest);

implementation

procedure MD5Init(var ctx: MDContext); external; {$l MD5}
procedure MD5Update(var ctx: MDContext; var buff; len: word); external;
procedure MD5Final(var digest; var ctx: MDContext); external;
procedure MD5Transform(var inb, buf); external;

procedure MD5File(var f: file; var digest); { MD5 of file }
var
  ctx: MDContext;
  i:   Word;
  inb: Array [0..4195] of Byte;
begin
  MD5Init(ctx);
  repeat
    BlockRead(f,inb,SizeOf(inb),i);
    if i<>0 then MD5Update(ctx,inb,i);
  until (i=0);
  MD5Final(digest,ctx);
end;

procedure MD5Buff(var buff; len: word; var digest); { MD5 of buffer }
var
  ctx: MDContext;
begin
  MD5Init(ctx);
  MD5Update(ctx,buff,len);
  MD5Final(digest,ctx);
end;

end.



