{============================================================================

  SHA.PAS v2.0, Message Digest 5 Cipher Transform (20 January 1995)
  (C) Copyright 1994-1995 Robert Rothenburg Walking-Owl

    History: 1.0    Original release (Oct 94)
             2.0    ASM and PAS code rewritten (Jan 95).

  Requires SHA.ASM v2.0 or later (for 386/486 machines). Units may work for
  earlier versions of Turbo Pascal which support objects.

  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
===========================================================================}
unit SHA;

interface

type

  SHSInfo = record
      buf:  Array [0..19] of Byte; { SHA Context  }
      bits: Array [0..7] of Byte;  { bit-count    }
      inb:  Array [0..63] of Byte; { input buffer }
    end;

procedure SHAInit(var ctx: SHSInfo); far;
procedure SHAUpdate(var ctx: SHSInfo; var buff; len: word); far;
procedure SHAFinal(var digest; var ctx: SHSInfo); far;
procedure SHATransform(var inb, buf); far;

procedure SHAFile(var f: file; var digest);  { Assumes file is open }
procedure SHABuff(var buff; len: word; var digest);

implementation

procedure SHAInit(var ctx: SHSInfo); external; {$l SHA}
procedure SHAUpdate(var ctx: SHSInfo; var buff; len: word); external;
procedure SHAFinal(var digest; var ctx: SHSInfo); external;
procedure SHATransform(var inb, buf); external;

procedure SHAFile(var f: file; var digest); { SHA of file }
var
  ctx: SHSInfo;
  i:   Word;
  inb: Array [0..4195] of Byte;
begin
  SHAInit(ctx);
  repeat
    BlockRead(f,inb,SizeOf(inb),i);
    if i<>0 then SHAUpdate(ctx,inb,i);
  until (i=0);
  SHAFinal(digest,ctx);
end;

procedure SHABuff(var buff; len: word; var digest); { SHA of buffer }
var
  ctx: SHSInfo;
begin
  SHAInit(ctx);
  SHAUpdate(ctx,buff,len);
  SHAFinal(digest,ctx);
end;


end.



