/* This file is in the public domain */

#include <string>

#include <opencl/filters.h>

#include <opencl/square.h>
#include <opencl/randpool.h>
#include <opencl/x917.h>
using namespace OpenCL;

/* Not to useful generally; XORs it's input with random bytes */
template<typename R>
class RNG_Filter : public Filter
   {
   public:
      void write(const byte[], u32bit);
   private:
      static const u32bit BUFFERSIZE = OpenCL::DEFAULT_BUFFERSIZE;
      R rng;
      SecureBuffer<byte, BUFFERSIZE> buffer;
      u32bit position;
   };

template<typename B>
void RNG_Filter<B>::write(const byte input[], u32bit length)
   {
   buffer.copy(position, input, length);
   if(position + length >= BUFFERSIZE)
      {
      rng.randomize(buffer, BUFFERSIZE);
      send(buffer, BUFFERSIZE);
      input += (BUFFERSIZE - position);
      length -= (BUFFERSIZE - position);
      while(length >= BUFFERSIZE)
         {
         /* This actually totally ignores the input, but it doesn't matter,
            because this is only for benchmark purposes and we just want to
            test speed. Anyway, if the RNG is good you can't tell the diff */
         rng.randomize(buffer, BUFFERSIZE);
         send(buffer, BUFFERSIZE);
         input += BUFFERSIZE;
         length -= BUFFERSIZE;
         }
       buffer.copy(input, length);
      position = 0;
      }
   position += length;
   }

Filter* lookup_rng(const std::string& algname)
   {
   if(algname == "X917<Square>")
      return new RNG_Filter< X917<Square> >;
   else if(algname == "Randpool")
      return new RNG_Filter<Randpool>;
   else return 0;
   }
