#!/usr/bin/perl -w

use strict;

# WARNING: This file is machine-generated; any changes will be lost.
# Instead, change mkconfig.pl and the system description files.

# This file is in the public domain.

my $CONFIGFILE = "Config";

my %ARCH = (
   "68020"        => "m68k",
   "68030"        => "m68k",
   "68040"        => "m68k",
   "68060"        => "m68k",
   "alpha"        => "alpha",
   "alphaev4"     => "alpha",
   "alphaev5"     => "alpha",
   "alphaev56"    => "alpha",
   "alphaev6"     => "alpha",
   "alphaev67"    => "alpha",
   "alphapca56"   => "alpha",
   "hppa"         => "hppa",
   "hppa1.0"      => "hppa",
   "hppa1.1"      => "hppa",
   "hppa2.0"      => "hppa",
   "i386"         => "ia32",
   "i486"         => "ia32",
   "i586"         => "ia32",
   "i686"         => "ia32",
   "ia32"         => "ia32",
   "ia64"         => "ia64",
   "m68k"         => "m68k",
   "mips"         => "mips",
   "mips64"       => "mips64",
   "powerpc"      => "powerpc",
   "ppc601"       => "powerpc",
   "ppc602"       => "powerpc",
   "ppc603"       => "powerpc",
   "ppc604"       => "powerpc",
   "r10000"       => "mips64",
   "r3000"        => "mips",
   "r4000"        => "mips64",
   "r4400"        => "mips64",
   "r5000"        => "mips64",
   "r6000"        => "mips",
   "r8000"        => "mips64",
   "sparc"        => "sparc",
   "sparc64"      => "sparc64",
   "ultra"        => "sparc64",
   "ultra2"       => "sparc64",
   "ultra2i"      => "sparc64",
   "v7"           => "sparc",
   "v8"           => "sparc",
   "v9"           => "sparc",
);

my %ARCH_ALIAS = (
   "680x0"        => "m68k",
   "68k"          => "m68k",
   "80x86"        => "ia32",
   "alphaaxp"     => "alpha",
   "axp"          => "alpha",
   "hp-pa"        => "hppa",
   "hp-pa-risc"   => "hppa",
   "hp-parisc"    => "hppa",
   "ix86"         => "ia32",
   "merced"       => "ia64",
   "pa-risc"      => "hppa",
   "parisc"       => "hppa",
   "ppc"          => "powerpc",
   "x86"          => "ia32",
);

my %DEFAULT_SUBMODEL = (
   "alpha"        => "alphaev4",
   "hppa"         => "hppa1.0",
   "ia32"         => "i386",
   "ia64"         => "ia64",
   "m68k"         => "68020",
   "mips"         => "r3000",
   "mips64"       => "r4400",
   "powerpc"      => "ppc601",
   "sparc"        => "v7",
   "sparc64"      => "ultra",
);

my %SUBMODEL_ALIAS = (
   "athlon"       => "i686",
   "cypress"      => "v7",
   "ev4"          => "alphaev4",
   "ev5"          => "alphaev5",
   "ev56"         => "alphaev56",
   "ev6"          => "alphaev6",
   "ev67"         => "alphaev67",
   "hypersparc"   => "v8",
   "k6"           => "i586",
   "mipsbe"       => "mips3000",
   "mipsle"       => "mips3000",
   "pca56"        => "alphapca56",
   "r10k"         => "r10000",
   "r3k"          => "r3000",
   "r4k"          => "r4000",
   "r5k"          => "r5000",
   "r6k"          => "r6000",
   "r8k"          => "r8000",
   "sparcv7"      => "v7",
   "sparcv8"      => "v8",
   "sparcv9"      => "v9",
   "supersparc"   => "v8",
);

my %OS_SUPPORTS_ARCH = (
   "beos"       => [ "ia32", "powerpc", ],
   "cygwin"     => [ "ia32", ],
   "freebsd"    => [ "alpha", "ia32", ],
   "hpux"       => [ "hppa", ],
   "irix"       => [ "mips", "mips64", ],
   "linux"      => [ "alpha", "hppa", "ia32", "ia64", "m68k", "mips", 
                     "mips64", "powerpc", "sparc", "sparc64", ],
   "solaris"    => [ "ia32", "ia64", "sparc", "sparc64", ],
   "tru64"      => [ "alpha", ],
);

my @OS_SUPPORTS_SHARED = (
   "beos",
   "freebsd",
   "hpux",
   "irix",
   "linux",
   "solaris",
   "tru64",
);

my %CC_BINARY_NAME = (
   "compaq"       => "cxx",
   "gcc"          => "g++",
   "hpcc"         => "CC",
   "kcc"          => "KCC",
   "mipspro"      => "CC",
   "pgi"          => "pgCC",
   "suncc"        => "CC",
);

my %CC_OPT_FLAGS = (
   "compaq"       => "-O4 -fast",
   "gcc"          => "-O3 -fstrict-aliasing",
   "hpcc"         => "+O4 +Oinlinebudge=150",
   "kcc"          => "+K3 --inline_auto_space_time=65 --abstract_pointer",
   "mipspro"      => "-O3 -OPT:alias=TYPED",
   "pgi"          => "-fast -Minline",
   "suncc"        => "-x04",
);

my %CC_WARN_FLAGS = (
   "compaq"       => "",
   "gcc"          => "-W -Wall",
   "hpcc"         => "+w",
   "kcc"          => "",
   "mipspro"      => "-fullwarn",
   "pgi"          => "",
   "suncc"        => "+w",
);

my %CC_LANG_FLAGS = (
   "compaq"       => "-std ansi",
   "gcc"          => "-ansi -pedantic",
   "hpcc"         => "-ext +eh -z",
   "kcc"          => "--strict -D__KAI_STRICT",
   "mipspro"      => "-ansi -LANG:ansi-for-init-scope=ON",
   "pgi"          => "",
   "suncc"        => "",
);

my %CC_NO_DEBUG_FLAGS = (
   "compaq"       => "",
   "gcc"          => "-fomit-frame-pointer",
   "hpcc"         => "",
   "kcc"          => "",
   "mipspro"      => "",
   "pgi"          => "",
   "suncc"        => "",
);

my %CC_MACHINE_OPT_FLAGS = (
   "compaq"     => { 
        "alpha"      => "-arch=SUBMODEL",
        },
   "gcc"        => { 
        "alpha"      => "-mcpu=SUBMODEL",
        "alphaev67"  => "-mcpu=ev6",
        "hppa"       => "-march=SUBMODEL",
        "i386"       => "-mcpu=i486",
        "ia32"       => "-march=SUBMODEL",
        "m68k"       => "-mSUBMODEL",
        "mips"       => "-mips1 -mcpu=SUBMODEL",
        "mips64"     => "-mips3 -mcpu=SUBMODEL",
        "powerpc"    => "-mcpu=powerpc",
        "r10000"     => "-mips4 -mcpu=r8000",
        "sparc"      => "-mcpu=SUBMODEL",
        "sparc64"    => "-mcpu=v9",
        },
   "hpcc"       => { 
        "hppa"       => "+DASUBMODEL",
        "hppa1.0"    => "",
        },
   "kcc"        => { 
        },
   "mipspro"    => { 
        "mips"       => "-mips1",
        "mips64"     => "-mips3",
        "r10000"     => "-mips4 -r10000",
        "r5000"      => "-mips4 -r5000",
        "r8000"      => "-mips4 -r8000",
        },
   "pgi"        => { 
        "i586"       => "-tp p5",
        "i686"       => "-tp p6",
        "ia32"       => "-tp px",
        },
   "suncc"      => { 
        "i386"       => "-xtarget=386",
        "i486"       => "-xtarget=486",
        "i586"       => "-xtarget=pentium",
        "i686"       => "-xtarget=pentium_pro",
        "sparc"      => "-xchip=ultra -xarch=SUBMODEL",
        "sparc64"    => "-xchip=SUBMODEL -xarch=v9",
        "v9"         => "-xchip=ultra -xarch=v8",
        },
);

my %CC_MACHINE_OPT_FLAGS_RE = (
   "compaq"     => { 
        "alpha"      => "alpha",
        },
   "gcc"        => { 
        "alpha"      => "alpha",
        "hppa"       => "hppa",
        },
   "hpcc"       => { 
        "hppa"       => "hppa",
        },
   "kcc"        => { 
        },
   "mipspro"    => { 
        },
   "pgi"        => { 
        },
   "suncc"      => { 
        },
);

my %CC_SO_OBJ_FLAGS = (
   "compaq"       => "",
   "gcc"          => "-fPIC",
   "hpcc"         => "+Z",
   "kcc"          => "",
   "mipspro"      => "-KPIC",
   "pgi"          => "-fPIC",
   "suncc"        => "-KPIC",
);

my %CC_MACH_OPT_LINK_FLAGS = (
   "gcc"        => { 
        "mips"       => "-mabi=n32",
        "mips64"     => "-mabi=64",
        "sparc64"    => "-m64",
        },
   "mipspro"    => { 
        "mips"       => "-n32",
        "mips64"     => "-64",
        },
);

my %CC_SO_LINK_FLAGS = (
   "compaq"     => { 
        "default"    => "-shared -soname \$(SONAME)",
        },
   "gcc"        => { 
        "default"    => "-shared -fPIC -Wl,-soname,\$(SONAME)",
        "hpux"       => "-shared -fPIC -Wl,+h,\$(SONAME)",
        "solaris"    => "-shared -fPIC -Wl,-h,\$(SONAME) -mimpure-text",
        },
   "hpcc"       => { 
        "default"    => "-Wl,+h,\$(SONAME)",
        },
   "kcc"        => { 
        "default"    => "--soname \$(SONAME)",
        },
   "mipspro"    => { 
        "default"    => "-shared -Wl,-soname,\$(SONAME)",
        },
   "pgi"        => { 
        "linux"      => "-shared -fPIC -Wl,-soname,\$(SONAME)",
        "solaris"    => "-G -fPIC -Wl,-h,\$(SONAME)",
        },
   "suncc"      => { 
        "default"    => "-G -h\$(SONAME)",
        },
);

my %CC_SUPPORTS_OS = (
   "compaq"     => [ "linux", "tru64", ],
   "gcc"        => [ "beos", "cygwin", "freebsd", "hpux", "irix", "linux", 
                     "solaris", "tru64", ],
   "hpcc"       => [ "hpux", ],
   "kcc"        => [ "hpux", "irix", "linux", "solaris", "tru64", ],
   "mipspro"    => [ "irix", ],
   "pgi"        => [ "linux", "solaris", ],
   "suncc"      => [ "solaris", ],
);

my %CC_SUPPORTS_ARCH = (
   "compaq"     => [ "alpha", ],
   "gcc"        => [ "alpha", "hppa", "ia32", "ia64", "m68k", "mips", 
                     "mips64", "powerpc", "sparc", "sparc64", ],
   "hpcc"       => [ "hppa", ],
   "kcc"        => [ "alpha", "hppa", "ia32", "mips", "mips64", "sparc", 
                     "sparc64", ],
   "mipspro"    => [ "mips", "mips64", ],
   "pgi"        => [ "ia32", ],
   "suncc"      => [ "ia32", "sparc", "sparc64", ],
);

my %REALNAME = (
   "alpha"        => "DEC Alpha",
   "beos"         => "BeOS",
   "compaq"       => "Compaq C++",
   "cygwin"       => "Cygwin",
   "freebsd"      => "FreeBSD",
   "gcc"          => "GNU C++",
   "hpcc"         => "HP-UX C++",
   "hppa"         => "HP-PA",
   "hpux"         => "HP-UX",
   "ia32"         => "IA-32",
   "ia64"         => "IA-64",
   "irix"         => "SGI IRIX",
   "kcc"          => "KAI C++",
   "linux"        => "Linux",
   "m68k"         => "Motorola 680x0",
   "mips"         => "MIPS",
   "mips64"       => "MIPS 64-bit",
   "mipspro"      => "SGI MIPSPro C++",
   "pgi"          => "Portland Group C++",
   "powerpc"      => "PowerPC",
   "solaris"      => "Solaris",
   "sparc"        => "Sun SPARC",
   "sparc64"      => "Sun 64-bit SPARC",
   "suncc"        => "Sun Workshop Pro C++",
   "tru64"        => "Compaq Tru64",
);

if($#ARGV < 0 or $#ARGV > 2) { help(); }

my $no_debug = 0;
my $system_string = "";
my $arg;

foreach $arg (@ARGV)
   {
   $arg =~ tr/A-Z/a-z/;
   if($arg eq "--help") { help(); }
   elsif($arg eq "--no-debug") { $no_debug = 1; }
   else { $system_string = $arg; }
   }

my ($cc,$os,$submodel) = split(/-/,$system_string);
if(!defined($cc) or !defined($os) or !defined($submodel)) { help(); }

if(!defined($CC_SUPPORTS_ARCH{$cc}))
   { die "ERROR: Compiler $cc isn't known\n"; }
if(!defined($OS_SUPPORTS_ARCH{$os}) and $os ne "generic")
   { die "ERROR: OS $os isn't known\n"; }

# Get the canonical submodel name (like r8k -> r8000)
if(defined($SUBMODEL_ALIAS{$submodel}))
   { $submodel = $SUBMODEL_ALIAS{$submodel}; }

my $arch = undef;
# Convert an arch alias to it's real name (like axp -> alpha)
if(defined($ARCH_ALIAS{$submodel}))
   { $arch = $ARCH_ALIAS{$submodel}; $submodel = $arch; }
# If it's a regular submodel type, figure out what arch it is
elsif(defined($ARCH{$submodel}))
   { $arch = $ARCH{$submodel}; }
elsif($submodel eq "generic") { $arch = "generic"; }
else { die "ERROR: Arch $submodel isn't known\n"; }

# If we got a generic family name as the model type
if($submodel eq $arch and $submodel ne "generic")
   {
   $submodel = $DEFAULT_SUBMODEL{$arch};
   if($submodel ne $arch)
      {
      print "WARNING: Using $submodel as default type for family ",
            $REALNAME{$arch},"\n";
      }
   }

# Does the OS support the architecture?
unless($arch eq "generic" or $os eq "generic" or
        grep (/$arch/, @{$OS_SUPPORTS_ARCH{$os}}))
   { die "ERROR: $REALNAME{$os} doesn't run on $REALNAME{$arch}\n"; }

# Does the compiler support the architecture?
unless($arch eq "generic" or grep (/$arch/, @{$CC_SUPPORTS_ARCH{$cc}}))
   { die "ERROR: $REALNAME{$cc} doesn't run on $REALNAME{$arch}\n"; }

# Does the compiler support the OS?
unless($os eq "generic" or grep (/$os/, @{$CC_SUPPORTS_OS{$cc}}))
   { die "ERROR: $REALNAME{$cc} doesn't run on $REALNAME{$os}\n"; }

my $opt_flags = $CC_OPT_FLAGS{$cc};
if($no_debug and $CC_NO_DEBUG_FLAGS{$cc} ne "")
   { $opt_flags .= " ".$CC_NO_DEBUG_FLAGS{$cc}; }

my $mach_flags = "";
if(defined($CC_MACHINE_OPT_FLAGS{$cc}{$submodel}))
   { $mach_flags = $CC_MACHINE_OPT_FLAGS{$cc}{$submodel}; }
elsif(defined($CC_MACHINE_OPT_FLAGS{$cc}{$arch}))
   {
   $mach_flags = $CC_MACHINE_OPT_FLAGS{$cc}{$arch};
   my $processed_modelname = $submodel;
   if(defined($CC_MACHINE_OPT_FLAGS_RE{$cc}{$arch}))
      { $processed_modelname =~
           s/$CC_MACHINE_OPT_FLAGS_RE{$cc}{$arch}//; }
   $mach_flags =~ s/SUBMODEL/$processed_modelname/g;
   }

my $so_link_flags = "";
if($os eq "generic") { }
elsif(defined($CC_SO_LINK_FLAGS{$cc}{$os}))
   { $so_link_flags = $CC_SO_LINK_FLAGS{$cc}{$os}; }
elsif(defined($CC_SO_LINK_FLAGS{$cc}{"default"}))
   { $so_link_flags = $CC_SO_LINK_FLAGS{$cc}{"default"}; }

my $ccname = $CC_BINARY_NAME{$cc};
if(defined($CC_MACH_OPT_LINK_FLAGS{$cc}{$arch}))
   { $ccname .= " ".$CC_MACH_OPT_LINK_FLAGS{$cc}{$arch}; }
if(defined($CC_MACH_OPT_LINK_FLAGS{$cc}{$submodel}))
   { $ccname .= " ".$CC_MACH_OPT_LINK_FLAGS{$cc}{$submodel}; }

print_output($ccname, $opt_flags, $mach_flags,
             $CC_LANG_FLAGS{$cc},
             $CC_WARN_FLAGS{$cc},
             $CC_SO_OBJ_FLAGS{$cc},
             $so_link_flags,$os);
exit;

sub help
   {
   print <<ENDOFHELP;
Usage: $0 [--no-debug] <compiler>-<os>-<cpu>

Use --no-debug to configure the compiler to enable further optimizations
which may prevent debugging on some systems.

You may use 'generic' for OS and CPU, which will disable any specializations
that would ordinarily be made (useful if your OS/CPU aren't listed).

CPU can either be a generic family name (eg ia32, alpha), or a specific model
(i686, ev5). Common aliases for each type (both family and model) are
supported but not listed.

ENDOFHELP
   print "Known OSes: ", join(" ", sort(keys %OS_SUPPORTS_ARCH)),"\n";
   print "Known compilers: ", join(" ", sort(keys %CC_SUPPORTS_ARCH)),"\n";
   print "Known CPUs: ", join(" ", sort(keys %DEFAULT_SUBMODEL)),"\n";
   exit;
   }

sub print_output
   {
   my($CXX,$OPT_FLAGS,$MACH_FLAGS,$LANG_FLAGS,$WARN_FLAGS,
      $SO_OBJ_FLAGS, $SO_LINK_FLAGS,$os) = @_;

   my $MAKE_SHARED = 0;
   if(($SO_OBJ_FLAGS ne "" or $SO_LINK_FLAGS ne "") and
      grep (/$os/, @OS_SUPPORTS_SHARED))
       { $MAKE_SHARED = 1; }
   open CONFIGFILE, ">$CONFIGFILE" or
      die "Couldn't open output file ($!)\n";

   print CONFIGFILE<<END_CONFIG;
CXX           = $CXX
OPT_FLAGS     = $OPT_FLAGS
MACH_FLAGS    = $MACH_FLAGS
LANG_FLAGS    = $LANG_FLAGS
WARN_FLAGS    = $WARN_FLAGS
END_CONFIG

   if($MAKE_SHARED)
      {
      print CONFIGFILE<<END_SO_INFO;
MAKE_SHARED   = yes
SO_OBJ_FLAGS  = $SO_OBJ_FLAGS
SO_LINK_FLAGS = $SO_LINK_FLAGS
END_SO_INFO
      }
   else
      {
      print CONFIGFILE "MAKE_SHARED   = no\n";
      }
   }

