##################################################
# Version numbers and other config options       #
##################################################
%define MAJOR 0
%define MINOR 7
%define PATCH 1

%define NAME OpenCL
%define LC_NAME opencl

##################################################
# Main Logic                                     #
##################################################

%define VERSION %{MAJOR}.%{MINOR}.%{PATCH}

Name: %{NAME}
Summary: A C++ crypto library
Version: %{VERSION}
Release: 1
Copyright: BSD
Group: Libraries/Cryptography
Source: http://prdownload.sourceforge.net/opencl/OpenCL-%{VERSION}.tgz
URL: http://opencl.sourceforge.net
Packager: Jack Lloyd <lloyd@acm.jhu.edu>
BuildRoot: /tmp/RPMBUILD-%{NAME}-%{VERSION}
Prefix: /usr/local

%description
%{NAME} is a C++ cryptography library, designed for high portability and ease
of use. It includes a wide selection of block and stream ciphers, hash
functions, MACs, and various utility classes and functions, plus a high-level
filter based interface. Public key algorithms, including IEEE 1363 support, are
planned for future releases.

%package devel
Summary: Development files for %{NAME}
Group: Libraries/Cryptography
Requires: %{NAME} = %{VERSION}
%description devel
The %{NAME}-devel package contains the header files and libraries needed to
develop programs that use the %{NAME} cryptography library.

%prep
%setup -n %{NAME}-%{VERSION}

%build
./configure.pl gcc-%{_target_os}-%{_target_cpu}
make shared static 2>/dev/null

%clean
rm -rf $RPM_BUILD_ROOT

%install
ROOT="$RPM_BUILD_ROOT/usr/local"
make OWNER=`id -u` GROUP=`id -g` INSTALLROOT="$ROOT" install

# Need this since we're installing shared libs...
%post
if ! grep "^$RPM_INSTALL_PREFIX/lib$" /etc/ld.so.conf 2>&1 >/dev/null
then
   echo "$RPM_INSTALL_PREFIX/lib" >>/etc/ld.so.conf
fi
/sbin/ldconfig

%post devel
if [ $RPM_INSTALL_PREFIX != "/usr" ]
then
   ln -s $RPM_INSTALL_PREFIX/include/%{LC_NAME} /usr/include/%{LC_NAME}
fi

%postun
/sbin/ldconfig
set +e # some of these rmdirs will probably fail, that's ok
rmdir $RPM_INSTALL_PREFIX/share/doc/%{NAME}-%{VERSION} 2>&1 >/dev/null
rmdir $RPM_INSTALL_PREFIX/share/doc 2>&1 >/dev/null
rmdir $RPM_INSTALL_PREFIX/lib 2>&1 >/dev/null

%postun devel
if [ $RPM_INSTALL_PREFIX != "/usr" ]
then
   if [ -f /usr/include/%{LC_NAME} ]
   then
      rm -f /usr/include/%{LC_NAME}
   fi
fi
set +e # some of these rmdirs will probably fail, that's ok
rmdir $RPM_INSTALL_PREFIX/share/doc/%{NAME}-%{VERSION} 2>&1 >/dev/null
rmdir $RPM_INSTALL_PREFIX/share/doc 2>&1 >/dev/null
rmdir $RPM_INSTALL_PREFIX/lib 2>&1 >/dev/null
rmdir $RPM_INSTALL_PREFIX/include/%{LC_NAME} 2>&1 >/dev/null
rmdir $RPM_INSTALL_PREFIX/include 2>&1 >/dev/null

%files
%attr(-,root,root) %docdir /usr/local/share/doc/%{NAME}-%{VERSION}/
%attr(-,root,root) /usr/local/share/doc/%{NAME}-%{VERSION}/license.txt
%attr(-,root,root) /usr/local/share/doc/%{NAME}-%{VERSION}/readme.txt
%attr(-,root,root) /usr/local/share/doc/%{NAME}-%{VERSION}/thanks.txt
%attr(-,root,root) /usr/local/lib/lib%{LC_NAME}.so
%attr(-,root,root) /usr/local/lib/lib%{LC_NAME}-%{MAJOR}.so
%attr(-,root,root) /usr/local/lib/lib%{LC_NAME}-%{MAJOR}.%{MINOR}.so
%attr(-,root,root) /usr/local/lib/lib%{LC_NAME}-%{MAJOR}.%{MINOR}.%{PATCH}.so

%files devel
%attr(-,root,root) %docdir /usr/local/share/doc/%{NAME}-%{VERSION}/
%attr(-,root,root) /usr/local/share/doc/%{NAME}-%{VERSION}/pgpkeys.asc
%attr(-,root,root) /usr/local/share/doc/%{NAME}-%{VERSION}/api.tex
%attr(-,root,root) /usr/local/share/doc/%{NAME}-%{VERSION}/api.ps
%attr(-,root,root) /usr/local/share/doc/%{NAME}-%{VERSION}/relnotes.txt
%attr(-,root,root) /usr/local/share/doc/%{NAME}-%{VERSION}/todo.txt
%attr(-,root,root) /usr/local/lib/lib%{LC_NAME}.a
%attr(-,root,root) /usr/local/include/%{LC_NAME}/

