/*************************************************
* ARC4 Header File                               *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_ARC4_H__
#define OPENCL_ARC4_H__

#include <opencl/opencl.h>

namespace OpenCL {

class ARC4 : public StreamCipher
   {
   public:
      static const u32bit KEYLENGTH = 32;
      void set_key(const byte[], u32bit = KEYLENGTH) throw(InvalidKeyLength);
      void clear() throw();
      ARC4() : StreamCipher(1, KEYLENGTH) { clear(); }
      ~ARC4() { clear(); }
   private:
      static const u32bit BUFFERSIZE = DEFAULT_BUFFERSIZE;
      void cipher(const byte[], byte[], u32bit);
      void generate();
      SecureBuffer<u32bit, 256> state;
      SecureBuffer<byte, BUFFERSIZE> buffer;
      u32bit X, Y, position;
   };

}

#endif
