/*************************************************
* Checksum Header File                           *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_CHECKSUM_H__
#define OPENCL_CHECKSUM_H__

#include <opencl/opencl.h>

namespace OpenCL {

/*************************************************
* Adler32                                        *
*************************************************/
class Adler32 : public HashFunction
   {
   public:
      static const u32bit HASHLENGTH = 4;
      void update(const byte[], u32bit);
      void final(byte[HASHLENGTH]);
      void clear() throw() { S1 = 1; S2 = 0; }
      Adler32() : HashFunction(HASHLENGTH) { clear(); }
      ~Adler32() { clear(); }
   private:
      void hash(const byte[], u32bit);
      u32bit S1, S2;
   };

/*************************************************
* CRC24                                          *
*************************************************/
class CRC24 : public HashFunction
   {
   public:
      static const u32bit HASHLENGTH = 3;
      void update(const byte[], u32bit);
      void final(byte[HASHLENGTH]);
      void clear() throw() { crc_val = 0xB704CE; }
      CRC24() : HashFunction(HASHLENGTH) { clear(); }
      ~CRC24() { clear(); }
   private:
      static const u32bit TABLE[256];
      u32bit crc_val;
   };

/*************************************************
* CRC32                                          *
*************************************************/
class CRC32 : public HashFunction
   {
   public:
      static const u32bit HASHLENGTH = 4;
      void update(const byte[], u32bit);
      void final(byte[HASHLENGTH]);
      void clear() throw() { crc_val = 0xFFFFFFFF; }
      CRC32() : HashFunction(HASHLENGTH) { clear(); }
      ~CRC32() { clear(); }
   private:
      static const u32bit TABLE[256];
      u32bit crc_val;
   };

}

#endif
