/*************************************************
* Exceptions Header File                         *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_EXCEPTION_H__
#define OPENCL_EXCEPTION_H__

#include <exception>
#include <string>
#include <opencl/config.h>

namespace OpenCL {

class Exception : public std::exception
   {
   public:
      const char* what() const throw() { return msg.c_str(); }
      Exception(const std::string& m = "Unknown Error") { set_msg(m); }
      virtual ~Exception() throw() {}
   protected:
      void set_msg(const std::string& m) { msg = "OpenCL: " + m; }
   private:
      std::string msg;
   };

struct InvalidArgument : public Exception
   {
   InvalidArgument(const std::string& str = "") : Exception(str) {}
   };

struct InvalidKeyLength : public InvalidArgument
   {
   InvalidKeyLength(const std::string&, u32bit);
   };

struct FormatError : public Exception
   {
   FormatError(const std::string& str = "") : Exception(str) {}
   };

struct DecodingError : public FormatError
   {
   DecodingError(const std::string& name)
      : FormatError("A decoding error occcured in " + name) {}
   };

struct Stream_IO_Error : public Exception
   {
   Stream_IO_Error(const std::string& error)
      : Exception("I/O error: " + error) {}
   };

}

#endif
