/*************************************************
* MD5 Header File                                *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_MD5_H__
#define OPENCL_MD5_H__

#include <opencl/opencl.h>

namespace OpenCL {

class MD5 : public HashFunction
   {
   public:
      static const u32bit BLOCKSIZE = 64, HASHLENGTH = 16;
      void update(const byte[], u32bit);
      void final(byte[HASHLENGTH]);
      void clear() throw();
      MD5() : HashFunction(HASHLENGTH) { clear(); }
   private:
      void hash(const byte[BLOCKSIZE]);
      void FF(u32bit&, u32bit, u32bit, u32bit, u32bit, u32bit, u32bit) const;
      void GG(u32bit&, u32bit, u32bit, u32bit, u32bit, u32bit, u32bit) const;
      void HH(u32bit&, u32bit, u32bit, u32bit, u32bit, u32bit, u32bit) const;
      void II(u32bit&, u32bit, u32bit, u32bit, u32bit, u32bit, u32bit) const;
      SecureBuffer<byte, BLOCKSIZE> buffer;
      SecureBuffer<u32bit, 16> M;
      SecureBuffer<u32bit, 4> digest;
      u32bit position;
      u64bit count;
   };

}

#endif
