/*************************************************
* RIPE-MD160 Header File                         *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_RMD160_H__
#define OPENCL_RMD160_H__

#include <opencl/opencl.h>

namespace OpenCL {

class RIPEMD160 : public HashFunction
   {
   public:
      static const u32bit BLOCKSIZE = 64, HASHLENGTH = 20;
      void update(const byte[], u32bit);
      void final(byte[HASHLENGTH]);
      void clear() throw();
      RIPEMD160() : HashFunction(HASHLENGTH) { clear(); }
   private:
      void hash(const byte[BLOCKSIZE]);
      void F1(u32bit&, u32bit, u32bit&, u32bit, u32bit,
              u32bit, byte, u32bit) const;
      void F2(u32bit&, u32bit, u32bit&, u32bit, u32bit,
              u32bit, byte, u32bit) const;
      void F3(u32bit&, u32bit, u32bit&, u32bit, u32bit,
              u32bit, byte, u32bit) const;
      void F4(u32bit&, u32bit, u32bit&, u32bit, u32bit,
              u32bit, byte, u32bit) const;
      void F5(u32bit&, u32bit, u32bit&, u32bit, u32bit,
              u32bit, byte, u32bit) const;
      SecureBuffer<byte, BLOCKSIZE> buffer;
      SecureBuffer<u32bit, 16> M;
      SecureBuffer<u32bit, 5> digest;
      u32bit position;
      u64bit count;
   };

}

#endif
