/*************************************************
* SAFER-SK128 Header File                        *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_SAFER_SK128_H__
#define OPENCL_SAFER_SK128_H__

#include <opencl/opencl.h>

namespace OpenCL {

class SAFER_SK128 : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 8, KEYLENGTH = 16, DEFAULT_ROUNDS = 10;
      void encrypt(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void decrypt(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void encrypt(byte block[BLOCKSIZE]) const { encrypt(block, block); }
      void decrypt(byte block[BLOCKSIZE]) const { decrypt(block, block); }
      void set_key(const byte[], u32bit = KEYLENGTH) throw(InvalidKeyLength);
      void clear() throw() { EK.clear(); }
      SAFER_SK128(u32bit = DEFAULT_ROUNDS);
   private:
      static const byte EXP[256], LOG[512];
      void PHT(byte& X, byte& Y)  const { Y += X; X += Y; }
      void IPHT(byte& X, byte& Y) const { X -= Y; Y -= X; }
      const u32bit ROUNDS;
      SecureVector<byte> EK;
   };

}

#endif
