/*************************************************
* Serpent Header File                            *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_SERPENT_H__
#define OPENCL_SERPENT_H__

#include <opencl/opencl.h>

namespace OpenCL {

class Serpent : public BlockCipher
   {
   public:
      static const u32bit BLOCKSIZE = 16, KEYLENGTH = 32;
      void encrypt(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void decrypt(const byte[BLOCKSIZE], byte[BLOCKSIZE]) const;
      void encrypt(byte block[BLOCKSIZE]) const { encrypt(block, block); }
      void decrypt(byte block[BLOCKSIZE]) const { decrypt(block, block); }
      void set_key(const byte[], u32bit = KEYLENGTH) throw(InvalidKeyLength);
      void clear() throw() { round_key.clear(); }
      Serpent() : BlockCipher(BLOCKSIZE, KEYLENGTH / 2, KEYLENGTH, 8) {}
   private:
      void SBoxE0(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxE1(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxE2(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxE3(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxE4(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxE5(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxE6(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxE7(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxD0(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxD1(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxD2(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxD3(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxD4(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxD5(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxD6(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void SBoxD7(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void transform(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void i_transform(u32bit&, u32bit&, u32bit&, u32bit&) const;
      void key_xor(u32bit, u32bit&, u32bit&, u32bit&, u32bit&) const;
      SecureBuffer<u32bit, 132> round_key;
   };

}

#endif
