/*************************************************
* SHA1 Header File                               *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_SHA1_H__
#define OPENCL_SHA1_H__

#include <opencl/opencl.h>

namespace OpenCL {

class SHA1 : public HashFunction
   {
   public:
      static const u32bit BLOCKSIZE = 64, HASHLENGTH = 20;
      void update(const byte[], u32bit);
      void final(byte[HASHLENGTH]);
      void clear() throw();
      SHA1() : HashFunction(HASHLENGTH) { clear(); }
   private:
      friend class SEAL;
      void hash(const byte[BLOCKSIZE]);
      void F1(u32bit, u32bit&, u32bit, u32bit, u32bit&, u32bit) const;
      void F2(u32bit, u32bit&, u32bit, u32bit, u32bit&, u32bit) const;
      void F3(u32bit, u32bit&, u32bit, u32bit, u32bit&, u32bit) const;
      void F4(u32bit, u32bit&, u32bit, u32bit, u32bit&, u32bit) const;
      SecureBuffer<byte, BLOCKSIZE> buffer;
      SecureBuffer<u32bit, 80> W;
      SecureBuffer<u32bit, 5> digest;
      u32bit position;
      u64bit count;
   };

}

#endif
