/*************************************************
* SHA2-256 Header File                           *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_SHA2_256_H__
#define OPENCL_SHA2_256_H__

#include <opencl/opencl.h>

namespace OpenCL {

class SHA2_256 : public HashFunction
   {
   public:
      static const u32bit BLOCKSIZE = 64, HASHLENGTH = 32;
      void update(const byte[], u32bit);
      void final(byte[HASHLENGTH]);
      void clear() throw();
      SHA2_256() : HashFunction(HASHLENGTH) { clear(); }
   private:
      void hash(const byte[BLOCKSIZE]);
      void F1(u32bit, u32bit, u32bit, u32bit&, u32bit, u32bit,
              u32bit, u32bit&, u32bit, u32bit) const;
      u32bit rho(u32bit, u32bit, u32bit, u32bit) const;
      u32bit sigma(u32bit, u32bit, u32bit, u32bit) const;
      SecureBuffer<byte, BLOCKSIZE> buffer;
      SecureBuffer<u32bit, 64> W;
      SecureBuffer<u32bit, 8> digest;
      u32bit position;
      u64bit count;
   };

}

#endif
