/*************************************************
* SHA2-512 Header File                           *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_SHA2_512_H__
#define OPENCL_SHA2_512_H__

#include <opencl/opencl.h>

namespace OpenCL {

class SHA2_512 : public HashFunction
   {
   public:
      static const u32bit BLOCKSIZE = 128, HASHLENGTH = 64;
      void update(const byte[], u32bit);
      void final(byte[HASHLENGTH]);
      void clear() throw();
      SHA2_512() : HashFunction(HASHLENGTH) { clear(); }
   private:
      static const u64bit MAGIC[80];
      void hash(const byte[BLOCKSIZE]);
      void F1(u64bit, u64bit, u64bit, u64bit&, u64bit, u64bit,
              u64bit, u64bit&, u64bit, u64bit) const;
      u64bit rho(u64bit, u32bit, u32bit, u32bit) const;
      u64bit sigma(u64bit, u32bit, u32bit, u32bit) const;
      SecureBuffer<byte, BLOCKSIZE> buffer;
      SecureBuffer<u64bit, 80> W;
      SecureBuffer<u64bit, 8> digest;
      u32bit position;
      u64bit count;
   };

}

#endif
