/*************************************************
* SymmetricKey Header File                       *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_SYMKEY_H__
#define OPENCL_SYMKEY_H__

#include <string>
#include <opencl/opencl.h>

namespace OpenCL {

/*************************************************
* SymmetricKey                                   *
*************************************************/
class SymmetricKey
   {
   public:
      operator const byte* () const { return key; }
      u32bit length() const { return key.size(); }

      void change(const byte in[], u32bit len) { key.copy(in, len); }
      void change(const std::string&);
      void change(RandomNumberGenerator&, u32bit);

      SymmetricKey(const std::string& str = "") { change(str); }
      SymmetricKey(const byte in[], u32bit len) { change(in, len); }
      SymmetricKey(RandomNumberGenerator& r, u32bit len) { change(r, len); }
   private:
      SecureVector<byte> key;
   };

typedef SymmetricKey BlockCipherKey;
typedef SymmetricKey BlockCipherModeIV;
typedef SymmetricKey StreamCipherKey;
typedef SymmetricKey MACKey;

}

#endif
