/*************************************************
* Tiger Header File                              *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#ifndef OPENCL_TIGER_H__
#define OPENCL_TIGER_H__

#include <opencl/opencl.h>

namespace OpenCL {

class Tiger : public HashFunction
   {
   public:
      static const u32bit BLOCKSIZE = 64, HASHLENGTH = 24;
      void update(const byte[], u32bit);
      void final(byte[HASHLENGTH]);
      void clear() throw();
      Tiger() : HashFunction(HASHLENGTH) { clear(); }
   private:
      static const u64bit SBOX1[256], SBOX2[256], SBOX3[256], SBOX4[256];
      void hash(const byte[BLOCKSIZE]);
      void round(u64bit&, u64bit&, u64bit&, u64bit, u32bit) const;
      SecureBuffer<byte, BLOCKSIZE> buffer;
      SecureBuffer<u64bit, 8> X;
      SecureBuffer<u64bit, 3> digest;
      u32bit position;
      u64bit count;
   };

}

#endif
