/*************************************************
* MD2 Source File                                *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#include <opencl/md2.h>

namespace OpenCL {

/*************************************************
* MD2 Hash                                       *
*************************************************/
void MD2::hash(const byte input[BLOCKSIZE])
   {
   X.copy(16, input, BLOCKSIZE);
   xor_buf(X + 32, X, X + 16, BLOCKSIZE);
   byte temp = 0;
   for(u32bit j = 0; j != 18; j++)
      {
      for(u32bit k = 0; k != 48; k++)
         temp = X[k] ^= SBOX[temp];
      temp += j;
      }
   temp = checksum[15];
   for(u32bit j = 0; j != BLOCKSIZE; j++)
      temp = checksum[j] ^= SBOX[input[j] ^ temp];
   }

/*************************************************
* Update a MD2 Hash                              *
*************************************************/
void MD2::update(const byte input[], u32bit length)
   {
   buffer.copy(position, input, length);
   if(position + length >= BLOCKSIZE)
      {
      hash(buffer);
      input += (BLOCKSIZE - position);
      length -= (BLOCKSIZE - position);
      while(length >= BLOCKSIZE)
         {
         hash(input);
         input += BLOCKSIZE;
         length -= BLOCKSIZE;
         }
      buffer.copy(input, length);
      position = 0;
      }
   position += length;
   }

/*************************************************
* Finalize a MD2 Hash                            *
*************************************************/
void MD2::final(byte output[HASHLENGTH])
   {
   for(u32bit j = position; j != BLOCKSIZE; j++)
      buffer[j] = (byte)(BLOCKSIZE - position);
   hash(buffer);
   hash(checksum);
   for(u32bit j = 0; j != HASHLENGTH; j++)
      output[j] = X[j];
   clear();
   }

/*************************************************
* Clear memory of sensitive data                 *
*************************************************/
void MD2::clear() throw()
   {
   X.clear();
   checksum.clear();
   buffer.clear();
   position = 0;
   }

}
