/*************************************************
* MISTY1 Source File                             *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#include <opencl/misty1.h>

namespace OpenCL {

/*************************************************
* MISTY1 Encryption                              *
*************************************************/
void MISTY1::encrypt(const byte in[BLOCKSIZE], byte out[BLOCKSIZE]) const
   {
   u16bit B0 = make_u16bit(in[0], in[1]), B1 = make_u16bit(in[2], in[3]),
          B2 = make_u16bit(in[4], in[5]), B3 = make_u16bit(in[6], in[7]);

   FL(B0, B1, 0,14); FL(B2, B3,10, 4);
   FO(B0, B1, B2, B3, 0,13, 2, 9, 7,11, 4);
   FO(B2, B3, B0, B1, 1,14, 3,10, 0,12, 5);
   FL(B0, B1, 1,15); FL(B2, B3,11, 5);
   FO(B0, B1, B2, B3, 2,15, 4,11, 1,13, 6);
   FO(B2, B3, B0, B1, 3, 8, 5,12, 2,14, 7);
   FL(B0, B1, 2, 8); FL(B2, B3,12, 6);
   FO(B0, B1, B2, B3, 4, 9, 6,13, 3,15, 0);
   FO(B2, B3, B0, B1, 5,10, 7,14, 4, 8, 1);
   FL(B0, B1, 3, 9); FL(B2, B3,13, 7);
   FO(B0, B1, B2, B3, 6,11, 0,15, 5, 9, 2);
   FO(B2, B3, B0, B1, 7,12, 1, 8, 6,10, 3);
   FL(B0, B1, 4,10); FL(B2, B3,14, 0);

   out[0] = get_byte(0, B2); out[1] = get_byte(1, B2);
   out[2] = get_byte(0, B3); out[3] = get_byte(1, B3);
   out[4] = get_byte(0, B0); out[5] = get_byte(1, B0);
   out[6] = get_byte(0, B1); out[7] = get_byte(1, B1);
   }

/*************************************************
* MISTY1 Decryption                              *
*************************************************/
void MISTY1::decrypt(const byte in[BLOCKSIZE], byte out[BLOCKSIZE]) const
   {
   u16bit B0 = make_u16bit(in[4], in[5]), B1 = make_u16bit(in[6], in[7]),
          B2 = make_u16bit(in[0], in[1]), B3 = make_u16bit(in[2], in[3]);

   FLINV(B0, B1, 4,10); FLINV(B2, B3,14, 0);
   FO(B2, B3, B0, B1, 7,12, 1, 8, 6,10, 3);
   FO(B0, B1, B2, B3, 6,11, 0,15, 5, 9, 2);
   FLINV(B0, B1, 3, 9); FLINV(B2, B3,13, 7);
   FO(B2, B3, B0, B1, 5,10, 7,14, 4, 8, 1);
   FO(B0, B1, B2, B3, 4, 9, 6,13, 3,15, 0);
   FLINV(B0, B1, 2, 8); FLINV(B2, B3,12, 6);
   FO(B2, B3, B0, B1, 3, 8, 5,12, 2,14, 7);
   FO(B0, B1, B2, B3, 2,15, 4,11, 1,13, 6);
   FLINV(B0, B1, 1,15); FLINV(B2, B3,11, 5);
   FO(B2, B3, B0, B1, 1,14, 3,10, 0,12, 5);
   FO(B0, B1, B2, B3, 0,13, 2, 9, 7,11, 4);
   FLINV(B0, B1, 0,14); FLINV(B2, B3,10, 4);

   out[0] = get_byte(0, B0); out[1] = get_byte(1, B0);
   out[2] = get_byte(0, B1); out[3] = get_byte(1, B1);
   out[4] = get_byte(0, B2); out[5] = get_byte(1, B2);
   out[6] = get_byte(0, B3); out[7] = get_byte(1, B3);
   }

/*************************************************
* MISTY1 FL Function                             *
*************************************************/
void MISTY1::FL(u16bit& T0, u16bit& T1, u32bit K1, u32bit K2) const
   {
   T1 ^= T0 & EK[K1];
   T0 ^= T1 | EK[K2];
   }

/*************************************************
* MISTY1 FLINV Function                          *
*************************************************/
void MISTY1::FLINV(u16bit& T0, u16bit& T1, u32bit K1, u32bit K2) const
   {
   T0 ^= T1 | EK[K2];
   T1 ^= T0 & EK[K1];
   }

/*************************************************
* MISTY1 FO Function                             *
*************************************************/
void MISTY1::FO(u16bit in0, u16bit in1, u16bit& out0, u16bit& out1,
                u32bit K1, u32bit K2, u32bit K3, u32bit K4,
                u32bit K5, u32bit K6, u32bit K7) const
   {
   in0  = FI(in0 ^ EK[K1], EK[K2 + 8], EK[K2 + 16]) ^ in1;
   in1  = FI(in1 ^ EK[K3], EK[K4 + 8], EK[K4 + 16]) ^ in0;
   in0  = FI(in0 ^ EK[K5], EK[K6 + 8], EK[K6 + 16]) ^ in1;
   in1 ^= EK[K7]; out0 ^= in1; out1 ^= in0;
   }

/*************************************************
* MISTY1 FI Function                             *
*************************************************/
u16bit MISTY1::FI(u16bit input, u16bit key7, u16bit key9) const
   {
   u16bit D9 = input >> 7, D7 = input & 0x7F;
   D9 = S9[D9] ^ D7;
   D7 = (S7[D7] ^ key7 ^ D9) & 0x7F;
   D9 = S9[D9 ^ key9] ^ D7;
   return (u16bit)((D7 << 9) | D9);
   }

/*************************************************
* MISTY1 Key Setup                               *
*************************************************/
void MISTY1::set_key(const byte key[], u32bit length) throw(InvalidKeyLength)
   {
   if(!valid_keylength(length))
      throw InvalidKeyLength("MISTY1", length);
   for(u32bit j = 0; j != KEYLENGTH; j++)
      EK[j] = make_u16bit(key[2*j], key[2*j+1]);
   for(u32bit j = 0; j != 8; j++)
      {
      EK[j+ 8] = FI(EK[j], EK[(j+1) % 8] >> 9, EK[(j+1) % 8] & 0x1FF);
      EK[j+16] = EK[j+8] >> 9;
      EK[j+24] = EK[j+8] & 0x1FF;
      }
   }

}
