/*************************************************
* RC5 Source File                                *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#include <opencl/rc5.h>

namespace OpenCL {

/*************************************************
* RC5 Encryption                                 *
*************************************************/
void RC5::encrypt(const byte in[BLOCKSIZE], byte out[BLOCKSIZE]) const
   {
   u32bit A = make_u32bit(in[3], in[2], in[1], in[0]),
          B = make_u32bit(in[7], in[6], in[5], in[4]);
   A += S[0]; B += S[1];
   for(u32bit j = 1; j != rounds+1; j++)
      {
      A = rotate_left(A ^ B, B % 32) + S[2*j];
      B = rotate_left(B ^ A, A % 32) + S[2*j+1];
      }
   out[0] = get_byte(3, A); out[1] = get_byte(2, A);
   out[2] = get_byte(1, A); out[3] = get_byte(0, A);
   out[4] = get_byte(3, B); out[5] = get_byte(2, B);
   out[6] = get_byte(1, B); out[7] = get_byte(0, B);
   }

/*************************************************
* RC5 Decryption                                 *
*************************************************/
void RC5::decrypt(const byte in[BLOCKSIZE], byte out[BLOCKSIZE]) const
   {
   u32bit A = make_u32bit(in[3], in[2], in[1], in[0]),
          B = make_u32bit(in[7], in[6], in[5], in[4]);
   for(u32bit j = rounds; j != 0; j--)
      {
      B = rotate_right(B - S[2*j+1], A % 32) ^ A;
      A = rotate_right(A - S[2*j  ], B % 32) ^ B;
      }
   B -= S[1]; A -= S[0];
   out[0] = get_byte(3, A); out[1] = get_byte(2, A);
   out[2] = get_byte(1, A); out[3] = get_byte(0, A);
   out[4] = get_byte(3, B); out[5] = get_byte(2, B);
   out[6] = get_byte(1, B); out[7] = get_byte(0, B);
   }

/*************************************************
* RC5 Key Setup                                  *
*************************************************/
void RC5::set_key(const byte key[], u32bit length) throw(InvalidKeyLength)
   {
   if(!valid_keylength(length))
      throw InvalidKeyLength("RC5", length);
   const u32bit WORD_KEYLENGTH = (((length - 1) / 4) + 1);
   S[0] = 0xB7E15163;
   for(u32bit j = 1; j != S.size(); j++)
      S[j] = S[j-1] + 0x9E3779B9;

   u32bit A = 0, B = 0;
   SecureBuffer<u32bit, 8> K;
   for(s32bit j = length-1; j >= 0; j--)
      K[j/4] = (K[j/4] << 8) + key[j];
   for(u32bit j = 0; j != 3*std::max(WORD_KEYLENGTH, S.size()); j++)
      {
      S[j % S.size()] = A = rotate_left(S[j % S.size()] + A + B, 3);
      K[j % WORD_KEYLENGTH] = B = rotate_left(K[j % WORD_KEYLENGTH] + A + B,
                                               (A + B) % 32);
      }
   }

}
