/*************************************************
* S-Box Functions for Serpent                    *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#include <opencl/serpent.h>

namespace OpenCL {

void Serpent::SBoxE0(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B3 ^= B0; B4  = B1; B1 &= B3; B4 ^= B2; B1 ^= B0; B0 |= B3; B0 ^= B4;
   B4 ^= B3; B3 ^= B2; B2 |= B1; B2 ^= B4; B4 = ~B4; B4 |= B1; B1 ^= B3;
   B1 ^= B4; B3 |= B0; B1 ^= B3; B4 ^= B3;
   T0 = B1; T1 = B4; T2 = B2; T3 = B0; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxE1(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B0 = ~B0; B2 = ~B2; B4  = B0; B0 &= B1; B2 ^= B0; B0 |= B3; B3 ^= B2;
   B1 ^= B0; B0 ^= B4; B4 |= B1; B1 ^= B3; B2 |= B0; B2 &= B4; B0 ^= B1;
   B1 &= B2; B1 ^= B0; B0 &= B2; B0 ^= B4;
   T0 = B2; T1 = B0; T2 = B3; T3 = B1; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxE2(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B4  = B0; B0 &= B2; B0 ^= B3; B2 ^= B1; B2 ^= B0; B3 |= B4; B3 ^= B1;
   B4 ^= B2; B1  = B3; B3 |= B4; B3 ^= B0; B0 &= B1; B4 ^= B0; B1 ^= B3;
   B1 ^= B4; B4 = ~B4;
   T0 = B2; T1 = B3; T2 = B1; T3 = B4; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxE3(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B4  = B0; B0 |= B3; B3 ^= B1; B1 &= B4; B4 ^= B2; B2 ^= B3; B3 &= B0;
   B4 |= B1; B3 ^= B4; B0 ^= B1; B4 &= B0; B1 ^= B3; B4 ^= B2; B1 |= B0;
   B1 ^= B2; B0 ^= B3; B2  = B1; B1 |= B3; B1 ^= B0;
   T0 = B1; T1 = B2; T2 = B3; T3 = B4; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxE4(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B1 ^= B3; B3 = ~B3; B2 ^= B3; B3 ^= B0; B4  = B1; B1 &= B3; B1 ^= B2;
   B4 ^= B3; B0 ^= B4; B2 &= B4; B2 ^= B0; B0 &= B1; B3 ^= B0; B4 |= B1;
   B4 ^= B0; B0 |= B3; B0 ^= B2; B2 &= B3; B0 = ~B0; B4 ^= B2;
   T0 = B1; T1 = B4; T2 = B0; T3 = B3; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxE5(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B0 ^= B1; B1 ^= B3; B3 = ~B3; B4  = B1; B1 &= B0; B2 ^= B3; B1 ^= B2;
   B2 |= B4; B4 ^= B3; B3 &= B1; B3 ^= B0; B4 ^= B1; B4 ^= B2; B2 ^= B0;
   B0 &= B3; B2 = ~B2; B0 ^= B4; B4 |= B3; B2 ^= B4;
   T0 = B1; T1 = B3; T2 = B0; T3 = B2; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxE6(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B2 = ~B2; B4  = B3; B3 &= B0; B0 ^= B4; B3 ^= B2; B2 |= B4; B1 ^= B3;
   B2 ^= B0; B0 |= B1; B2 ^= B1; B4 ^= B0; B0 |= B3; B0 ^= B2; B4 ^= B3;
   B4 ^= B0; B3 = ~B3; B2 &= B4; B2 ^= B3;
   T0 = B0; T1 = B1; T2 = B4; T3 = B2; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxE7(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B4  = B1; B1 |= B2; B1 ^= B3; B4 ^= B2; B2 ^= B1; B3 |= B4; B3 &= B0;
   B4 ^= B2; B3 ^= B1; B1 |= B4; B1 ^= B0; B0 |= B4; B0 ^= B2; B1 ^= B4;
   B2 ^= B1; B1 &= B0; B1 ^= B4; B2 = ~B2; B2 |= B0; B4 ^= B2;
   T0 = B4; T1 = B3; T2 = B1; T3 = B0; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxD0(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B2 = ~B2; B4  = B1; B1 |= B0; B4 = ~B4; B1 ^= B2; B2 |= B4; B1 ^= B3;
   B0 ^= B4; B2 ^= B0; B0 &= B3; B4 ^= B0; B0 |= B1; B0 ^= B2; B3 ^= B4;
   B2 ^= B1; B3 ^= B0; B3 ^= B1; B2 &= B3; B4 ^= B2;
   T0 = B0; T1 = B4; T2 = B1; T3 = B3; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxD1(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B4  = B1; B1 ^= B3; B3 &= B1; B4 ^= B2; B3 ^= B0; B0 |= B1; B2 ^= B3;
   B0 ^= B4; B0 |= B2; B1 ^= B3; B0 ^= B1; B1 |= B3; B1 ^= B0; B4 = ~B4;
   B4 ^= B1; B1 |= B0; B1 ^= B0; B1 |= B4; B3 ^= B1;
   T0 = B4; T1 = B0; T2 = B3; T3 = B2; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxD2(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B2 ^= B3; B3 ^= B0; B4  = B3; B3 &= B2; B3 ^= B1; B1 |= B2; B1 ^= B4;
   B4 &= B3; B2 ^= B3; B4 &= B0; B4 ^= B2; B2 &= B1; B2 |= B0; B3 = ~B3;
   B2 ^= B3; B0 ^= B3; B0 &= B1; B3 ^= B4; B3 ^= B0;
   T0 = B1; T1 = B4; T2 = B2; T3 = B3; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxD3(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B4  = B2; B2 ^= B1; B0 ^= B2; B4 &= B2; B4 ^= B0; B0 &= B1; B1 ^= B3;
   B3 |= B4; B2 ^= B3; B0 ^= B3; B1 ^= B4; B3 &= B2; B3 ^= B1; B1 ^= B0;
   B1 |= B2; B0 ^= B3; B1 ^= B4; B0 ^= B1;
   T0 = B2; T1 = B1; T2 = B3; T3 = B0; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxD4(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B4  = B2; B2 &= B3; B2 ^= B1; B1 |= B3; B1 &= B0; B4 ^= B2; B4 ^= B1;
   B1 &= B2; B0 = ~B0; B3 ^= B4; B1 ^= B3; B3 &= B0; B3 ^= B2; B0 ^= B1;
   B2 &= B0; B3 ^= B0; B2 ^= B4; B2 |= B3; B3 ^= B0; B2 ^= B1;
   T0 = B0; T1 = B3; T2 = B2; T3 = B4; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxD5(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B1 = ~B1; B4  = B3; B2 ^= B1; B3 |= B0; B3 ^= B2; B2 |= B1; B2 &= B0;
   B4 ^= B3; B2 ^= B4; B4 |= B0; B4 ^= B1; B1 &= B2; B1 ^= B3; B4 ^= B2;
   B3 &= B4; B4 ^= B1; B3 ^= B4; B4 = ~B4; B3 ^= B0;
   T0 = B1; T1 = B4; T2 = B3; T3 = B2; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxD6(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B0 ^= B2; B4  = B2; B2 &= B0; B4 ^= B3; B2 = ~B2; B3 ^= B1; B2 ^= B3;
   B4 |= B0; B0 ^= B2; B3 ^= B4; B4 ^= B1; B1 &= B3; B1 ^= B0; B0 ^= B3;
   B0 |= B2; B3 ^= B1; B4 ^= B0;
   T0 = B1; T1 = B2; T2 = B4; T3 = B3; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

void Serpent::SBoxD7(u32bit& B0, u32bit& B1, u32bit& B2, u32bit& B3) const
   {
   u32bit B4, T0, T1, T2, T3;
   B4  = B2; B2 ^= B0; B0 &= B3; B4 |= B3; B2 = ~B2; B3 ^= B1; B1 |= B0;
   B0 ^= B2; B2 &= B4; B3 &= B4; B1 ^= B2; B2 ^= B0; B0 |= B2; B4 ^= B1;
   B0 ^= B3; B3 ^= B4; B4 |= B0; B3 ^= B2; B4 ^= B2;
   T0 = B3; T1 = B0; T2 = B1; T3 = B4; B0 = T0; B1 = T1; B2 = T2; B3 = T3;
   }

}
