/*************************************************
* S-Box and Diffusion Tables for SHARK           *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#include <opencl/shark.h>

namespace OpenCL {

const byte SHARK::SE[256] = {
0xB1, 0xCE, 0xC3, 0x95, 0x5A, 0xAD, 0xE7, 0x02, 0x4D, 0x44, 0xFB, 0x91, 0x0C,
0x87, 0xA1, 0x50, 0xCB, 0x67, 0x54, 0xDD, 0x46, 0x8F, 0xE1, 0x4E, 0xF0, 0xFD,
0xFC, 0xEB, 0xF9, 0xC4, 0x1A, 0x6E, 0x5E, 0xF5, 0xCC, 0x8D, 0x1C, 0x56, 0x43,
0xFE, 0x07, 0x61, 0xF8, 0x75, 0x59, 0xFF, 0x03, 0x22, 0x8A, 0xD1, 0x13, 0xEE,
0x88, 0x00, 0x0E, 0x34, 0x15, 0x80, 0x94, 0xE3, 0xED, 0xB5, 0x53, 0x23, 0x4B,
0x47, 0x17, 0xA7, 0x90, 0x35, 0xAB, 0xD8, 0xB8, 0xDF, 0x4F, 0x57, 0x9A, 0x92,
0xDB, 0x1B, 0x3C, 0xC8, 0x99, 0x04, 0x8E, 0xE0, 0xD7, 0x7D, 0x85, 0xBB, 0x40,
0x2C, 0x3A, 0x45, 0xF1, 0x42, 0x65, 0x20, 0x41, 0x18, 0x72, 0x25, 0x93, 0x70,
0x36, 0x05, 0xF2, 0x0B, 0xA3, 0x79, 0xEC, 0x08, 0x27, 0x31, 0x32, 0xB6, 0x7C,
0xB0, 0x0A, 0x73, 0x5B, 0x7B, 0xB7, 0x81, 0xD2, 0x0D, 0x6A, 0x26, 0x9E, 0x58,
0x9C, 0x83, 0x74, 0xB3, 0xAC, 0x30, 0x7A, 0x69, 0x77, 0x0F, 0xAE, 0x21, 0xDE,
0xD0, 0x2E, 0x97, 0x10, 0xA4, 0x98, 0xA8, 0xD4, 0x68, 0x2D, 0x62, 0x29, 0x6D,
0x16, 0x49, 0x76, 0xC7, 0xE8, 0xC1, 0x96, 0x37, 0xE5, 0xCA, 0xF4, 0xE9, 0x63,
0x12, 0xC2, 0xA6, 0x14, 0xBC, 0xD3, 0x28, 0xAF, 0x2F, 0xE6, 0x24, 0x52, 0xC6,
0xA0, 0x09, 0xBD, 0x8C, 0xCF, 0x5D, 0x11, 0x5F, 0x01, 0xC5, 0x9F, 0x3D, 0xA2,
0x9B, 0xC9, 0x3B, 0xBE, 0x51, 0x19, 0x1F, 0x3F, 0x5C, 0xB2, 0xEF, 0x4A, 0xCD,
0xBF, 0xBA, 0x6F, 0x64, 0xD9, 0xF3, 0x3E, 0xB4, 0xAA, 0xDC, 0xD5, 0x06, 0xC0,
0x7E, 0xF6, 0x66, 0x6C, 0x84, 0x71, 0x38, 0xB9, 0x1D, 0x7F, 0x9D, 0x48, 0x8B,
0x2A, 0xDA, 0xA5, 0x33, 0x82, 0x39, 0xD6, 0x78, 0x86, 0xFA, 0xE4, 0x2B, 0xA9,
0x1E, 0x89, 0x60, 0x6B, 0xEA, 0x55, 0x4C, 0xF7, 0xE2 };

const byte SHARK::SD[256] = {
0x35, 0xBE, 0x07, 0x2E, 0x53, 0x69, 0xDB, 0x28, 0x6F, 0xB7, 0x76, 0x6B, 0x0C,
0x7D, 0x36, 0x8B, 0x92, 0xBC, 0xA9, 0x32, 0xAC, 0x38, 0x9C, 0x42, 0x63, 0xC8,
0x1E, 0x4F, 0x24, 0xE5, 0xF7, 0xC9, 0x61, 0x8D, 0x2F, 0x3F, 0xB3, 0x65, 0x7F,
0x70, 0xAF, 0x9A, 0xEA, 0xF5, 0x5B, 0x98, 0x90, 0xB1, 0x87, 0x71, 0x72, 0xED,
0x37, 0x45, 0x68, 0xA3, 0xE3, 0xEF, 0x5C, 0xC5, 0x50, 0xC1, 0xD6, 0xCA, 0x5A,
0x62, 0x5F, 0x26, 0x09, 0x5D, 0x14, 0x41, 0xE8, 0x9D, 0xCE, 0x40, 0xFD, 0x08,
0x17, 0x4A, 0x0F, 0xC7, 0xB4, 0x3E, 0x12, 0xFC, 0x25, 0x4B, 0x81, 0x2C, 0x04,
0x78, 0xCB, 0xBB, 0x20, 0xBD, 0xF9, 0x29, 0x99, 0xA8, 0xD3, 0x60, 0xDF, 0x11,
0x97, 0x89, 0x7E, 0xFA, 0xE0, 0x9B, 0x1F, 0xD2, 0x67, 0xE2, 0x64, 0x77, 0x84,
0x2B, 0x9E, 0x8A, 0xF1, 0x6D, 0x88, 0x79, 0x74, 0x57, 0xDD, 0xE6, 0x39, 0x7B,
0xEE, 0x83, 0xE1, 0x58, 0xF2, 0x0D, 0x34, 0xF8, 0x30, 0xE9, 0xB9, 0x23, 0x54,
0x15, 0x44, 0x0B, 0x4D, 0x66, 0x3A, 0x03, 0xA2, 0x91, 0x94, 0x52, 0x4C, 0xC3,
0x82, 0xE7, 0x80, 0xC0, 0xB6, 0x0E, 0xC2, 0x6C, 0x93, 0xEC, 0xAB, 0x43, 0x95,
0xF6, 0xD8, 0x46, 0x86, 0x05, 0x8C, 0xB0, 0x75, 0x00, 0xCC, 0x85, 0xD7, 0x3D,
0x73, 0x7A, 0x48, 0xE4, 0xD1, 0x59, 0xAD, 0xB8, 0xC6, 0xD0, 0xDC, 0xA1, 0xAA,
0x02, 0x1D, 0xBF, 0xB5, 0x9F, 0x51, 0xC4, 0xA5, 0x10, 0x22, 0xCF, 0x01, 0xBA,
0x8F, 0x31, 0x7C, 0xAE, 0x96, 0xDA, 0xF0, 0x56, 0x47, 0xD4, 0xEB, 0x4E, 0xD9,
0x13, 0x8E, 0x49, 0x55, 0x16, 0xFF, 0x3B, 0xF4, 0xA4, 0xB2, 0x06, 0xA0, 0xA7,
0xFB, 0x1B, 0x6E, 0x3C, 0x33, 0xCD, 0x18, 0x5E, 0x6A, 0xD5, 0xA6, 0x21, 0xDE,
0xFE, 0x2A, 0x1C, 0xF3, 0x0A, 0x1A, 0x19, 0x27, 0x2D };

const byte SHARK::Log[256] = {
0x00, 0x00, 0x01, 0x86, 0x02, 0x0D, 0x87, 0x4C, 0x03, 0xD2, 0x0E, 0xAE, 0x88,
0x22, 0x4D, 0x93, 0x04, 0x1A, 0xD3, 0xCB, 0x0F, 0x98, 0xAF, 0xA8, 0x89, 0xF0,
0x23, 0x59, 0x4E, 0x35, 0x94, 0x09, 0x05, 0x8F, 0x1B, 0x6E, 0xD4, 0x39, 0xCC,
0xBB, 0x10, 0x68, 0x99, 0x77, 0xB0, 0xDF, 0xA9, 0x72, 0x8A, 0xFA, 0xF1, 0xA0,
0x24, 0x52, 0x5A, 0x60, 0x4F, 0x2F, 0x36, 0xDC, 0x95, 0x32, 0x0A, 0x1F, 0x06,
0xA5, 0x90, 0x49, 0x1C, 0x5D, 0x6F, 0xB8, 0xD5, 0xC1, 0x3A, 0xB5, 0xCD, 0x63,
0xBC, 0x3D, 0x11, 0x44, 0x69, 0x81, 0x9A, 0x27, 0x78, 0xC4, 0xB1, 0xE6, 0xE0,
0xEA, 0xAA, 0x55, 0x73, 0xD8, 0x8B, 0xF6, 0xFB, 0x16, 0xF2, 0xF4, 0xA1, 0x40,
0x25, 0x42, 0x53, 0xE4, 0x5B, 0xA3, 0x61, 0xBF, 0x50, 0xF8, 0x30, 0x2D, 0x37,
0x8D, 0xDD, 0x66, 0x96, 0x18, 0x33, 0xEE, 0x0B, 0xFD, 0x20, 0xD0, 0x07, 0x57,
0xA6, 0xC9, 0x91, 0xAC, 0x4A, 0x84, 0x1D, 0xDA, 0x5E, 0x9E, 0x70, 0x75, 0xB9,
0x6C, 0xD6, 0xE8, 0xC2, 0x7F, 0x3B, 0xB3, 0xB6, 0x47, 0xCE, 0xEC, 0x64, 0x2B,
0xBD, 0xE2, 0x3E, 0x14, 0x12, 0x29, 0x45, 0x7D, 0x6A, 0x9C, 0x82, 0xC7, 0x9B,
0xC6, 0x28, 0x7C, 0x79, 0x7A, 0xC5, 0x7B, 0xB2, 0x46, 0xE7, 0x7E, 0xE1, 0x13,
0xEB, 0x2A, 0xAB, 0x83, 0x56, 0xC8, 0x74, 0x6B, 0xD9, 0x9D, 0x8C, 0x65, 0xF7,
0x2C, 0xFC, 0xCF, 0x17, 0xED, 0xF3, 0x3F, 0xF5, 0x15, 0xA2, 0xBE, 0x41, 0xE3,
0x26, 0xC3, 0x43, 0x80, 0x54, 0xD7, 0xE5, 0xE9, 0x5C, 0xB7, 0xA4, 0x48, 0x62,
0x3C, 0xC0, 0xB4, 0x51, 0x5F, 0xF9, 0x9F, 0x31, 0x1E, 0x2E, 0xDB, 0x38, 0xBA,
0x8E, 0x6D, 0xDE, 0x71, 0x67, 0x76, 0x97, 0xA7, 0x19, 0xCA, 0x34, 0x08, 0xEF,
0x58, 0x0C, 0x4B, 0xFE, 0x85, 0x21, 0x92, 0xD1, 0xAD };

const byte SHARK::ALog[255] = {
0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0xF5, 0x1F, 0x3E, 0x7C, 0xF8,
0x05, 0x0A, 0x14, 0x28, 0x50, 0xA0, 0xB5, 0x9F, 0xCB, 0x63, 0xC6, 0x79, 0xF2,
0x11, 0x22, 0x44, 0x88, 0xE5, 0x3F, 0x7E, 0xFC, 0x0D, 0x1A, 0x34, 0x68, 0xD0,
0x55, 0xAA, 0xA1, 0xB7, 0x9B, 0xC3, 0x73, 0xE6, 0x39, 0x72, 0xE4, 0x3D, 0x7A,
0xF4, 0x1D, 0x3A, 0x74, 0xE8, 0x25, 0x4A, 0x94, 0xDD, 0x4F, 0x9E, 0xC9, 0x67,
0xCE, 0x69, 0xD2, 0x51, 0xA2, 0xB1, 0x97, 0xDB, 0x43, 0x86, 0xF9, 0x07, 0x0E,
0x1C, 0x38, 0x70, 0xE0, 0x35, 0x6A, 0xD4, 0x5D, 0xBA, 0x81, 0xF7, 0x1B, 0x36,
0x6C, 0xD8, 0x45, 0x8A, 0xE1, 0x37, 0x6E, 0xDC, 0x4D, 0x9A, 0xC1, 0x77, 0xEE,
0x29, 0x52, 0xA4, 0xBD, 0x8F, 0xEB, 0x23, 0x46, 0x8C, 0xED, 0x2F, 0x5E, 0xBC,
0x8D, 0xEF, 0x2B, 0x56, 0xAC, 0xAD, 0xAF, 0xAB, 0xA3, 0xB3, 0x93, 0xD3, 0x53,
0xA6, 0xB9, 0x87, 0xFB, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x75, 0xEA,
0x21, 0x42, 0x84, 0xFD, 0x0F, 0x1E, 0x3C, 0x78, 0xF0, 0x15, 0x2A, 0x54, 0xA8,
0xA5, 0xBF, 0x8B, 0xE3, 0x33, 0x66, 0xCC, 0x6D, 0xDA, 0x41, 0x82, 0xF1, 0x17,
0x2E, 0x5C, 0xB8, 0x85, 0xFF, 0x0B, 0x16, 0x2C, 0x58, 0xB0, 0x95, 0xDF, 0x4B,
0x96, 0xD9, 0x47, 0x8E, 0xE9, 0x27, 0x4E, 0x9C, 0xCD, 0x6F, 0xDE, 0x49, 0x92,
0xD1, 0x57, 0xAE, 0xA9, 0xA7, 0xBB, 0x83, 0xF3, 0x13, 0x26, 0x4C, 0x98, 0xC5,
0x7F, 0xFE, 0x09, 0x12, 0x24, 0x48, 0x90, 0xD5, 0x5F, 0xBE, 0x89, 0xE7, 0x3B,
0x76, 0xEC, 0x2D, 0x5A, 0xB4, 0x9D, 0xCF, 0x6B, 0xD6, 0x59, 0xB2, 0x91, 0xD7,
0x5B, 0xB6, 0x99, 0xC7, 0x7B, 0xF6, 0x19, 0x32, 0x64, 0xC8, 0x65, 0xCA, 0x61,
0xC2, 0x71, 0xE2, 0x31, 0x62, 0xC4, 0x7D, 0xFA };

const u64bit SHARK::TE0[256] = {
0x060D838F16F3A365, 0xA68857EE5CAE56F6, 0xEBF516353C2C4D89, 0x652174BE88E85BDC,
0x0D4E9A8086C17921, 0x27BA7D33CFFA58A1, 0x88D9E104A237B530, 0x693B8755A4FBE816,
0xDAC9591826B254A0, 0x45C2E369FB336AF3, 0xA96E1FB87B3E4EF4, 0xB7578F1435EB7EF0,
0x839AF80B32056F74, 0xAE37F55CC71F277A, 0xA4208538FDFF37D5, 0x35991E74AD3CDB6F,
0xBA191594B32A07D1, 0x5344D1772E572B7B, 0xE7EFE5DE103FFE43, 0xA3796FDC41DE5E5B,
0x2CF9643C5FC882E5, 0xFFDBF6FD48196D22, 0x33949DFBBBCF780A, 0x7D15679DD0CEC8BD,
0x5F5E229C024498B1, 0x1223634762C683CE, 0xDCC4DA973041F7C5, 0x0B43190F9032DA44,
0xC05598EDDFC5A6E2, 0x9E5FD31A7753F4B8, 0x9AFA8243C0F136FE, 0xCC4F6B06F3D61528,
0xDF38612A3BC25C0D, 0x43CF60E6EDC0C996, 0xCFB3D0BBF855BEE0, 0x96E071A8ECE28534,
0x21B7FEBCD909FBC4, 0x8ED4628BB4C41655, 0x30682646B04CD3C2, 0xB5FF5DC294BA1FD3,
0x75AAC52F4B7FB931, 0xE809AD8837AFE641, 0x0EB2213D8D42D2E9, 0x9852509561A057DD,
0xAA92A40570BDE53C, 0x7B18E412C63D6BD8, 0xA7DC3E85F67C9C1D, 0xD8618BCE87E33583,
0xE34AB487A79D3C05, 0x20E397D773DB312F, 0x05F138321D7008AD, 0x17D25B757FB68B63,
0x8A7133D20366D413, 0x0000000000000000, 0xEAA17F5E96FE8762, 0xC101F18675176C09,
0xBEBC44CD0488C597, 0xDB9D30738C609E4B, 0xABC6CD6EDA6F2FD7, 0x5AAF1AAE1F34901C,
0xB00E65F089CA177E, 0xD47B7825ABF08649, 0x924520F15B404772, 0x1686321ED5644188,
0x618425E73F4A999A, 0xE21EDDEC0D4FF6EE, 0xD787C398A0732D81, 0x1F6DF9C7E407FAEF,
0x79B036C4676C0AFB, 0x0FE6485627901802, 0x9CF701CCD602959B, 0xBFE82DA6AE5A0F7C,
0x990639FECB729D36, 0xCA42E889E525B64D, 0xB3F2DE4D8249BCB6, 0x4033DB5BE643625E,
0x4167B2304C91A8B5, 0x108BB191C397E2ED, 0x1834132358269361, 0x541D3B93927642F5,
0x90EDF227FA112651, 0x1DC52B1145569BCC, 0xE6BB8CB5BAED34A8, 0xD276FBAABD03252C,
0x313C4F2D1A9E1929, 0xFD73242BE9480C01, 0x9BAEEB286A23FC15, 0xC9BE5334EEA61D85,
0xC70C720963E4CF6C, 0x3EDA077B3D0E012B, 0x97B418C346304FDF, 0x32C0F490111DB2E1,
0x2BA08ED8E3E9EB6B, 0x8B255AB9A9B41EF8, 0x91B99B4C50C3ECBA, 0xFE8F9F96E2CBA7C9,
0x3A7F56228AACC36D, 0xB15A0C9B2318DD95, 0x5953A11314B73BD4, 0xF3C10516640ADEE8,
0xEDF895BA2ADFEEEC, 0xADCB4EE1CC9C8CB2, 0xDE6C0841911096E6, 0x84C312EF8E2406FA,
0xA83A76D3D1EC841F, 0x1C91427AEF845127, 0x3665A5C9A6BF70A7, 0xF6303D24797AD645,
0xCD1B026D5904DFC3, 0x1BC8A89E53A538A9, 0x7EE9DC20DB4D6375, 0x51EC03A18F064A58,
0xC4F0C9B4686764A4, 0xDD90B3FC9A933D2E, 0x7A4C8D796CEFA133, 0x73A746A05D8C1A54,
0x0759EAE4BC21698E, 0xC8EA3A5F4474D76E, 0x38D784F42BFDA24E, 0x231F2C6A78589AE7,
0xC3A92350D4460D2A, 0x72F32FCBF75ED0BF, 0xBD40FF700F0B6E5F, 0x157A89A3DEE7EA40,
0x873FA95285A7AD32, 0x4D7D41DB60821B7F, 0x1E3990AC4ED53004, 0x0A1770643AE010AF,
0x9311499AF1928D99, 0x64751DD5223A9137, 0xFA2ACECF5569658F, 0x7C410EF67A1C0256,
0x56B5E945332723D6, 0x6F3604DAB2084B73, 0xE95DC4E39D7D2CAA, 0x13770A2CC8144925,
0xBC14961BA5D9A4B4, 0xB9E5AE29B8A9AC19, 0xF169D7C0C55BBFCB, 0x2446C68EC479F369,
0x806643B63986C4BC, 0x7FBDB54B719FA99E, 0x04A55159B7A2C246, 0xEE042E07215C4524,
0x5BFB73C5B5E65AF7, 0x0C1AF3EB2C13B3CA, 0xA22D06B7EB0C94B0, 0xB8B1C742127B66F2,
0x285C3565E86A40A3, 0x3B2B3F49207E0986, 0x3C72D5AD9C5F6008, 0x770217F9EA2ED812,
0xFC274D40439AC6EA, 0x4FD5930DC1D37A5C, 0x2E51B6EAFE99E3C6, 0x6B93558305AA8935,
0x19607A48F2F4598A, 0x08BFA2B29BB1718C, 0x3F8E6E1097DCCBC0, 0x3983ED9F812F68A5,
0xAC9F278A664E4659, 0x82CE916098D7A59F, 0xC2FD4A3B7E94C7C1, 0x66DDCF03836BF014,
0xE1E2665106CC5D26, 0x74FEAC44E1AD73DA, 0x8D28D936BF47BD9D, 0x62789E5A34C93252,
0x81322ADD93540E57, 0xCB1681E24FF77CA6, 0x2512AFE56EAB3982, 0xD18A4017B6808EE4,
0x705BFD1D560FB19C, 0x4B70C2547671B81A, 0x49D81082D720D939, 0xE0B60F3AAC1E97CD,
0x4E81FA666B01B0B7, 0x951CCA15E7612EFC, 0x463E58D4F0B0C13B, 0x632CF7319E1BF8B9,
0x5CA2992109C73379, 0xF764544FD3A81CAE, 0x6AC73CE8AF7843DE, 0x9F0BBA71DD813E53,
0x85977B8424F6CC11, 0x5807C878BE65F13F, 0x686FEE3E0E2922FD, 0x78E45FAFCDBEC010,
0x6CCABF67B98BE0BB, 0x11DFD8FA69452806, 0xCEE7B9D05287740B, 0x50B86ACA25D480B3,
0x5DF6F04AA315F992, 0x5E0A4BF7A896525A, 0x03FCBBBD0B83ABC8, 0x8F800BE01E16DCBE,
0xD32292C117D1EFC7, 0xE5473708B16E9F60, 0x224B4501D28A500C, 0xFB7EA7A4FFBBAF64,
0x3D26BCC6368DAAE3, 0x866BC0392F7567D9, 0x3731CCA20C6DBA4C, 0xB603E67F9F39B41B,
0xA1D1BD0AE08F3F78, 0xD935E2A52D31FF68, 0xAF639C376DCDED91, 0x0154696BAAD2CAEB,
0xECACFCD1800D2407, 0xF03DBEAB6F897520, 0x02A8D2D6A1516123, 0xF498EFF2D82BB766,
0x710F9476FCDD7B77, 0xF8821C19F43804AC, 0xF9D675725EEACE47, 0x1A9CC1F5F977F242,
0x5210B81C8485E190, 0x6D9ED60C13592A50, 0xF2956C7DCED81403, 0xBB4D7CFF19F8CD3A,
0x4C2928B0CA50D194, 0x6E626DB118DA8198, 0xE4135E631BBC558B, 0x9DA368A77CD05F70,
0xA574EC53572DFD3E, 0x09EBCBD93163BB67, 0x4A24AB3FDCA372F1, 0x429B098D4712037D,
0x57E1802E99F5E93D, 0xEF50476C8B8E8FCF, 0xA085D4614A5DF593, 0x34CD771F07EE1184,
0xC6581B62C9360587, 0x2DAD0D57F51A480E, 0x898D886F08E57FDB, 0xD6D3AAF30AA1E76A,
0x76567E9240FC12F9, 0xB4AB34A93E68D538, 0xB2A6B726289B765D, 0x8C7CB05D15957776,
0x554952F838A4881E, 0xD52F114E01224CA2, 0x60D04C8C95985371, 0x6789A66829B93AFF,
0x2F05DF81544B292D, 0x476A31BF5A620BD0, 0xF5CC869972F97D8D, 0x488C79E97DF213D2,
0x44968A0251E1A018, 0x26EE14586528924A, 0xD0DE297C1C52440F, 0xC5A4A0DFC2B5AE4F,
0x29085C0E42B88A48, 0x142EE0C8743520AB, 0x2AF4E7B3493B2180, 0x9448A37E4DB3E417 };

const u64bit SHARK::TE1[256] = {
0xE2795BA105BA30CE, 0x65B5D634F5E0FBDD, 0x2D7D7F1464DD8C55, 0xEEFBF778ADD1C20B,
0x1EB0FBD1F11968E7, 0xE6073F45CE30CD8D, 0x21FFD3CDCCB67E90, 0xDF0941CFA750A262,
0xC61DF5B1B75EF18A, 0xC5C7DEFA9DC337C6, 0x2581B729073C83D3, 0xA5E97513167173CF,
0xDD3673BD381526B9, 0xE8BAA1EEF91EBB93, 0x3B314CF8F625EB34, 0x579D4BC8D5FC5DF8,
0xBB598EC2E7681B28, 0xC8A06B1A80708794, 0x1C8FC9A36E5CEC3C, 0xF60A5A3F0807D374,
0x1ACE9F353A9395A4, 0x7E9E50387AAB2CEE, 0xB5E41069D0466D36, 0x8CEA6EE3B92602D9,
0xF952DDAD8AF1E7FD, 0xB19A748D1BCC9075, 0x2464AE10B2E4C144, 0xFCC9A070F4A35829,
0xFA88F6E6A06C21B1, 0x2C98662DD105CEC2, 0x9065A740D77AEEE5, 0xCB7A4051AAED41D8,
0x55A279BA4AB9D923, 0x27BE855B98790708, 0xBABC97FB52B059BF, 0xA19711F7DDFB8E8C,
0x047E64E4CB8AFD43, 0xC386886CC90C4E5E, 0xC422C7C3281B7551, 0xFB6DEFDF15B46326,
0x01E51939B5D84297, 0x5CBBA8BE9C809432, 0x6F762C7B09447080, 0xCEE13D8CD4BFFE0C,
0x54476083FF619BB4, 0x6E933542BC9C3217, 0x4AF79B520E78F353, 0x98996F7DB49BE163,
0xA07208CE6823CC1B, 0x2B3C29823012F5CD, 0x93BF8C0BFDE728A9, 0x2225F886E62BB8DC,
0x7F7B4901CF736E79, 0x0000000000000000, 0x023F32729F4584DB, 0xD5CABB805BF4293F,
0x07A44FAFE1173B0F, 0xE95FB8D74CC6F904, 0x7B052DE504F9933A, 0x6AED51A67716CF54,
0x68D263D4E8534B8F, 0xA96BD9CABE1A810A, 0x1D6AD09ADB84AEAB, 0x0D67B5E01DB3B052,
0x52063615ABAEE22C, 0x8F3045A893BBC495, 0xD8AD0E604647996D, 0xAF2A8F5CEAD5F892,
0x3017AF8EBF5922FE, 0x4034611DF2DC780E, 0x721CFCE1D2C0DE2B, 0x28E602C91A8F3381,
0xE1A370EA2F27F682, 0x29031BF0AF577116, 0x1914B47E100E53E8, 0x567852F160241F6F,
0x793A1F979BBC17E1, 0xEF1EEE411809809C, 0x6211999B14F7C0D2, 0x059B7DDD7E52BFD4,
0x43EE4A56D841BE42, 0xF1AE1590E910E87B, 0x33CD84C595C4E4B2, 0x4B12826BBBA0B1C4,
0xEB608AA5D3837DDF, 0x201ACAF4796E3C07, 0xBF27EA262CE2E66B, 0x58C5CC5A570A6971,
0x37B3E0215E4E19F1, 0xAB54EBB8215F05D1, 0x8ED55C9126638602, 0x9AA65D0F2BDE65B8,
0xD7F589F2C4B1ADE4, 0x5039046734EB66F7, 0x6CAC073023D9B6CC, 0x51DC1D5E81332460,
0x17A92AD5272025F6, 0x47902EB213CB4301, 0x1B2B860C8F4BD733, 0x4F6CE68F702A4C87,
0xCF0424B56167BC9B, 0x997C76440143A3F4, 0x7AE034DCB121D1AD, 0x100D657AC6371EF9,
0x0AC3FA4FFCA48B5D, 0xDEEC58F61288E0F5, 0x265B9C622DA1459F, 0xDCD36A848DCD642E,
0xE4380D3751754956, 0x13D74E31ECAAD8B5, 0xFD2CB949417B1ABE, 0x9624F1D683B5977D,
0x4675378BA6130196, 0x0B26E376497CC9CA, 0x41D1782447043A99, 0xE39C4298B0627259,
0xCD3B16C7FE223840, 0x7787813CAC9261FF, 0x492DB01924E5351F, 0x5AFAFE28C84FEDAA,
0x8B4E214C583139D6, 0xCCDE0FFE4BFA7AD7, 0x76629805194A2368, 0x7CA1624AE5EEA835,
0x61CBB2D03E6A069E, 0x48C8A920913D7788, 0x8068C23A114DF01C, 0xD38BED160F3B50A7,
0x32289DFC201CA625, 0xC1B9BA1E5649CA85, 0xED21DC33874C0447, 0xA3A8238542BE0A57,
0x5B1FE7117D97AF3D, 0x3D701A6EA2EA92AC, 0x73F9E5D867189CBC, 0x9ED839EBE05498FB,
0x5920D563E2D22BE6, 0xCA9F59681F35034F, 0x11E87C4373EF5C6E, 0x97C1E8EF366DD5EA,
0xACF0A417C0483EDE, 0xD26EF42FBAE31230, 0xBCFDC16D067F2027, 0xBEC2F31F993AA4FC,
0x45AF1CC08C8EC7DA, 0x31F2B6B70A816069, 0xD9481759F39FDBFA, 0xE5DD140EE4AD0BC1,
0xA6335E583CECB583, 0x38EB67B3DCB82D78, 0xF5D07174229A1538, 0x5F6183F5B61D527E,
0x0F58879282F63489, 0x164C33EC92F86761, 0x444A05F93956854D, 0x818DDB03A495B28B,
0x4D53D4FDEF6FC85C, 0x8D0F77DA0CFE404E, 0x8416A6DEDAC70D5F, 0x666FFD7FDF7D3D91,
0xB63E3B22FADBAB7A, 0xF2743EDBC38D2E37, 0xA40C6C2AA3A93158, 0x9F3D20D2558CDA6C,
0xFEF692026BE6DCF2, 0x2EA7545F4E404A19, 0xB2405FC631515639, 0x23C0E1BF53F3FA4B,
0x83B2E9713BD03650, 0x0641569654CF7998, 0xB883A589CDF5DD64, 0x3AD455C143FDA9A3,
0x925A9532483F6A3E, 0xAAB1F28194874746, 0xF435684D974257AF, 0xD1B4DF64907ED47C,
0x390E7E8A69606FEF, 0xD051C65D25A696EB, 0xB4010950659E2FA1, 0x0C82ACD9A86BF2C5,
0x88940A0772ACFF9A, 0xF39127E276556CA0, 0xAECF96655F0DBA05, 0x03DA2B4B2A9DC64C,
0x3F4F281C3DAF1677, 0x3469CB6A74D3DFBD, 0xF04B0CA95CC8AAEC, 0x1F55E2E844C12A70,
0x4CB6CDC45AB78ACB, 0xC05CA327E3918812, 0x95FEDA9DA9285131, 0xB966BCB0782D9FF3,
0xA7D647618934F714, 0xD61090CB7169EF73, 0x71C6D7AAF85D1867, 0xECC4C50A329446D0,
0x6450CF0D4038B94A, 0x420B536F6D99FCD5, 0x75B8B34E33D7E524, 0xC26391557CD40CC9,
0xDA923C12D9021DB6, 0x4E89FFB6C5F20E10, 0x0919D104D6394D11, 0x8AAB3875EDE97B41,
0xA88EC0F30BC2C39D, 0xB7DB221B4F03E9ED, 0xC7F8EC880286B31D, 0x2F424D66FB98088E,
0xE04669D39AFFB415, 0x3EAA3125887754E0, 0x5E849ACC03C510E9, 0x8257F0488E0874C7,
0xBD18D854B3A762B0, 0xB3A546FF848914AE, 0x9CE70B997F111C20, 0x3C9503571732D03B,
0xE7E2267C7BE88F1A, 0x63F480A2A12F8245, 0x602EABE98BB24409, 0x941BC3A41CF013A6,
0x678AE4466AA57F06, 0x1232570859729A22, 0x6D491E099601F45B, 0x5D5EB1872958D6A5,
0x1473019E0DBDE3BA, 0xA24D3ABCF76648C0, 0x85F3BFE76F1F4FC8, 0x08FCC83D63E10F86,
0x745DAA77860FA7B3, 0x9180BE7962A2AC72, 0x87CC8D95F05ACB13, 0x78DF06AE2E645576,
0x18F1AD47A5D6117F, 0x358CD253C10B9D2A, 0x0EBD9EAB372E761E, 0xF7EF4306BDDF91E3,
0x7023CE934D855AF0, 0xD42FA2B9EE2C6BA8, 0x3656F918EB965B66, 0x9D0212A0CAC95EB7,
0x2AD930BB85CAB75A, 0x862994AC45828984, 0x7D447B735036EAA2, 0xB07F6DB4AE14D2E2,
0x6B08489FC2CE8DC3, 0x9B4344369E06272F, 0xAD15BD2E75907C49, 0xDB77252B6CDA5F21,
0xEA85939C665B3F48, 0xC945722335A8C503, 0x159618A7B865A12D, 0x69377AED5D8B0918,
0x8971133EC774BD0D, 0x53E32F2C1E76A0BB, 0xF8B7C4943F29A56A, 0xFF138B3BDE3E9E65 };

const u64bit SHARK::TE2[256] = {
0x7C6A2EB5FDABECC6, 0x401CDA0A752BBEA0, 0x1925217156DC57C4, 0x56DEC6D301D70787,
0x41C751FF73C6AC58, 0xC9067697A92CB5F9, 0x3391C917AAA0BC85, 0xAE0A9A4C0E742AFE,
0xAA8CA972162A62F4, 0x5AA193912935DF99, 0x86FD9135FE27E5BA, 0xFFCA074B1D3F538E,
0x0E3CB65D24CDFC1B, 0x4384B2E07FE9885D, 0xC73AC0CA8DE149E2, 0x48E5BC7645972EB4,
0xBE0D56B46EF9FFD6, 0x200E6D05C0EF5F50, 0xE1F17DEE597F7ABD, 0x0243E31F0C2F2405,
0xF4AB09DD2741F567, 0xE4ACC52547CC204F, 0x348F92C3B83CC272, 0x53837E181F645D75,
0xD8DA319ACF4C7229, 0x81E3CAE1ECBB9B4D, 0xD6E687C7EB818E32, 0x3DAD7F4A8E6D409E,
0x28F70B79F053CF44, 0x493E3783437A3C4C, 0xB27203F6461B27C8, 0xD02357E6FFF0E23D,
0xE8D390676F2EF851, 0x26CBBD24D49E335F, 0xEE1640467B5F945E, 0x4AA65F6949B80AB1,
0xB56C58225487593F, 0x4FFBE7A2570B5043, 0x0ABA85633C93B411, 0x78EC1D8BE5F5A4CC,
0x501B16F215A66B88, 0x271036D1D27321A7, 0x7FF2465FF769DA3B, 0x35541936BED1D08A,
0xB8C886957A8893D9, 0x2FE950ADE2CFB1B3, 0xF90FD76A094E3F81, 0x2DAAB3B2EEE095B6,
0x1ABD499B5C1E6139, 0x0C7F554228E2D81E, 0x425F391579049AA5, 0xC3BCF3F495BF01E8,
0xB4B7D3D7526A4BC7, 0x0000000000000000, 0xA0362C112AB9D6E5, 0x91E406198C364E65,
0x454162C16B98E452, 0x139FA4126A4FE3D5, 0x01DB8BF506ED12F8, 0x9A85088FB648E88C,
0x3AB3249E9CF13E69, 0xD57EEF2DE143B8CF, 0xB1EA6B1C4CD91135, 0x7AAFFE94E9DA80C9,
0xAD92F2A604B61C03, 0xA3AE44FB207BE018, 0xEB4BF88D65ECCEAC, 0xC0249B1E9F7D3715,
0xA8CF4A6D1A0546F1, 0xC6E14B3F8B0C5B1A, 0xCE182D43BBB0CB0E, 0xFC526FA117FD6573,
0x8C471456C2B451AB, 0xAC497953025B0EFB, 0x0486333E185E480A, 0x18FEAA845031453C,
0xA1EDA7E42C54C41D, 0x06C5D02114716C0F, 0x055DB8CB1EB35AF2, 0xE5774ED0412132B7,
0x36CC71DCB413E677, 0x470281DE67B7C057, 0x58E2708E251AFB9C, 0xA914C1981CE85409,
0xB3A9880340F63530, 0x638ADFE5BF06D70D, 0x0B610E963A7EA6E9, 0x927C6EF386F47898,
0xED8E28AC719DA2A3, 0x7548C33CCBFA6E2A, 0xF3B5520935DD8B90, 0x8D9C9FA3C4594353,
0x31D22A08A68F9880, 0x0DA4DEB72E0FCAE6, 0x8FDF7CBCC8766756, 0x5DBFC8453BA9A16E,
0x8E04F749CE9B75AE, 0x83A029FEE094BF48, 0xA4B01F2F32E79EEF, 0x1C7899BA486F0D36,
0x654F0FC4AB77BB02, 0x7DB1A540FB46FE3E, 0x51C09D07134B7970, 0xCB459588A50391FC,
0x3FEE9C558242649B, 0xFE118CBE1BD24176, 0x76D0ABD6C13858D7, 0x5E27A0AF316B9793,
0x69305A868395631C, 0x3B68AF6B9A1C2C91, 0x6DB669B89BCB2B16, 0xA72877C53825A812,
0xD3BB3F0CF532D4C0, 0x6FF58AA797E40F13, 0x96FA5DCD9EAA3092, 0x2C713847E80D874E,
0xC57923D581CE6DE7, 0x2B6F6393FA91F9B9, 0x0922ED89365182EC, 0x324A42E2AC4DAE7D,
0x16C21CD974FCB927, 0x956235279468066F, 0x7B747561EF379231, 0x449AE9346D75F6AA,
0xF570822821ACE79F, 0x5939FB7B23F7E964, 0x7937967EE318B634, 0x84BE722AF208C1BF,
0x08F9667C30BC9014, 0xEFCDCBB37DB286A6, 0xA6F3FC303EC8BAEA, 0xEA9073786301DC54,
0x62515410B9EBC5F5, 0xD260B4F9F3DFC638, 0x9E033BB1AE16A086, 0x38F0C78190DE1A6C,
0xC267780193521310, 0x80384114EA5689B5, 0x9B5E837AB0A5FA74, 0xF73361372D83C39A,
0x3009A1FDA0628A78, 0xD4A564D8E7AEAA37, 0xFB4C347505611B84, 0x5B7A18642FD8CD61,
0x239605EFCA2D69AD, 0xF8D45C9F0FA32D79, 0xBB50EE7F704AA524, 0x392B4C7496330894,
0x0FE73DA82220EEE3, 0x3717FA29B2FEF48F, 0xF26ED9FC33309968, 0xD73D0C32ED6C9CCA,
0xDA99D285C363562C, 0xDE1FE1BBDB3D1E26, 0x738D131DDF8B0225, 0x292C808CF6BEDDBC,
0xBC4EB5AB62D6DBD3, 0x039868EA0AC236FD, 0xCC5BCE5CB79FEF0B, 0xB031E0E94A3403CD,
0xC4A2A82087237F1F, 0xB72FBB3D58A87D3A, 0xAFD111B908993806, 0x68EBD173857871E4,
0x9D9B535BA4D4967B, 0xE9081B9269C3EAA9, 0x71CEF002D3A42620, 0x93A7E50680196A60,
0x891AAC9DDC070B59, 0x155A74337E3E8FDA, 0x4E206C5751E642BB, 0x9721D6389847226A,
0x12442FE76CA2F12D, 0x2553D5CEDE5C05A2, 0xA275CF0E2696F2E0, 0x24885E3BD8B1175A,
0x670CECDBA7589F07, 0x749348C9CD177CD2, 0x64948431AD9AA9FA, 0x2AB4E866FC7CEB41,
0xE6EF263A4BE3044A, 0xE734ADCF4D0E16B2, 0x903F8DEC8ADB5C9D, 0xF02D3AE33F1FBD6D,
0x725698E8D96610DD, 0x1DA3124F4E821FCE, 0x1719972C7211ABDF, 0x11DC470D6660C7D0,
0xEC55A3597770B05B, 0xBFD6DD416814ED2E, 0x57054D26073A157F, 0x1E3B7AA544402933,
0x5FFC2B5A3786856B, 0x61C93CFAB329F308, 0x3E3517A084AF7663, 0xF6E8EAC22B6ED162,
0x1007CCF8608DD528, 0x66D7672EA1B58DFF, 0x8B594F82D0282F5C, 0x1FE0F15042AD3BCB,
0x4B7DD49C4F551849, 0x4C638F485DC966BE, 0xCFC3A6B6BD5DD9F6, 0x46D90A2B615AD2AF,
0x8565F9DFF4E5D347, 0x94B9BED292851497, 0xFA97BF80038C097C, 0xB9130D607C658121,
0xDC5C02A4D7123A23, 0x224D8E1ACCC07B55, 0x87261AC0F8CAF742, 0xD901BA6FC9A160D1,
0xAB57228710C7700C, 0x21D5E6F0C6024DA8, 0x98C6EB90BA67CC89, 0x827BA20BE679ADB0,
0x991D6065BC8ADE71, 0x5546AE390B15317A, 0xA56B94DA340A8C17, 0x071E5BD4129C7EF7,
0xE02AF61B5F926845, 0x6B73B9998FBA4719, 0xDFC46A4EDDD00CDE, 0x770B2023C7D54A2F,
0x7E29CDAAF184C8C3, 0xBA8B658A76A7B7DC, 0x9C40D8AEA2398483, 0x9FD8B044A8FBB27E,
0xDB425970C58E44D4, 0xE269150453BD4C40, 0x3C76F4BF88805266, 0xF1F6B11639F2AF95,
0x549D25CC0DF82382, 0x4DB804BD5B247446, 0x8A82C477D6C53DA4, 0x5258F5ED19894F8D,
0x6E2E015291091DEB, 0xC1FF10EB999025ED, 0xBD953E5E643BC92B, 0xC8DDFD62AFC1A701,
0x5C6443B03D44B396, 0x6C6DE24D9D2639EE, 0x1481FFC678D39D22, 0xD1F8DC13F91DF0C5,
0xCA9E1E7DA3EE8304, 0xDD878951D1FF28DB, 0x6012B70FB5C4E1F0, 0x1B66C26E5AF373C1,
0xE3B29EF155505EB8, 0x70157BF7D54934D8, 0x2E32DB58E422A34B, 0x6AA8326C895755E1,
0xB6F430C85E456FC2, 0xFD89E4541110778B, 0x88C12768DAEA19A1, 0xCD8045A9B172FDF3 };

const u64bit SHARK::TE3[256] = {
0x99183E616655B742, 0xB2872032A50D6860, 0x0946F63B060528EF, 0x36612B9A141EF07D,
0x0634DA84DD49579B, 0xFC9C9E9B486C8A57, 0xA63FE3C0744E6FD0, 0xF1515758D8B46BF9,
0x3E82559FCD5197FF, 0x92E12D262BC40177, 0xC3BB433A5A7752C5, 0x21C3852A5183267A,
0x39130725CF528F09, 0x9BA7DB1D2DC12998, 0xC58F99BE873E055E, 0xD9D424498F32656C,
0x27F75FAE8CCA71E1, 0x59B91019A8FC3430, 0xCE768AF9CAAFB36B, 0x9D930199F0887E03,
0x63B07A7EF3706A8E, 0xB5167288A70E7096, 0x40CC1A28E967D22E, 0x4D01D3EB79BF3380,
0x9E896CDB6456AFB4, 0x2548BAD2C75EEF3B, 0xA79A6BFEAB0420BD, 0x9F2CE4E5BB1CE0D9,
0x32EA146282C3393C, 0x6D67DEFFF7765A97, 0x83775912B31080EB, 0xF5DA68A04E69A2B8,
0x1196743498D4819C, 0x0BF913474D91B635, 0x43D6776A7DB90399, 0x444725D07FBA1B6F,
0x6584A0FA2E393D15, 0x3F27DDA1121BD892, 0xF6C005E2DAB7730F, 0x56CB3CA673B04B44,
0x642128C4F1737278, 0xBF4AE9F135D589CE, 0xB038C54EEE99F6BA, 0xF47FE09E9123EDD5,
0x75B75CF069A7F3E4, 0xD419ED8A1FEA84C2, 0x73838674B4EEA47F, 0x498AEC13EF62FAC1,
0x20660D148EC96917, 0xA48006BC3FDAF10A, 0x2F1421AB55851663, 0x0A5C9B7992DBF958,
0xD1375A4C567D02EE, 0x0000000000000000, 0xC842507D17E6E4F0, 0xF3EEB2249320F523,
0xC9E7D843C8ACAB9D, 0xFF86F3D9DCB25BE0, 0xB4B3FAB678443FFB, 0xB19D4D7031D3B9D7,
0x79DF1D0D26355D27, 0x8EBA90D123C86145, 0xAA57A23D3BDCC113, 0xCB583D3F83383547,
0xD871AC7750782A01, 0xE162AB529F2AA508, 0x38B68F1B1018C064, 0x237C60561A17B8A0,
0xA31154063DD9E9FC, 0x713C6308FF7A3AA5, 0x1A6F6773D54537A9, 0x08E37E05D94F6782,
0x357B46D880C021CA, 0x6CC256C1283C15FA, 0xCFD302C715E5FC06, 0xBDF50C8D7E411714,
0x7CF1AACB6FA2DB0B, 0x5240035EE56D8205, 0x7B60F8716DA1C3FD, 0x01A5883EDF4A4F6D,
0xDD5F1BB119EFAC2D, 0x5474D9DA3824D59E, 0x0F722CBFDB4C7F74, 0x17A2AEB0459DD607,
0x37C4A3A4CB54BF10, 0xC21ECB04853D1DA8, 0x4273FF54A2F34CF4, 0xDACE490B1BECB4DB,
0x6AF68C45F5754261, 0x46F8C0AC342E85B5, 0x854383966E59D770, 0x81C8BC6EF8841E31,
0x3BACE25984C611D3, 0x1033FC0A479ECEF1, 0x1C5BBDF7080C6032, 0x7412D4CEB6EDBC89,
0xA8E8474170485FC9, 0xB8DBBB4B37D69138, 0x079152BA020318F6, 0x72260E4A6BA4EB12,
0x905EC85A60509FAD, 0x2DABC4D71E1188B9, 0xD092D27289374D83, 0x610F9F02B8E4F454,
0x02BFE57C4B949EDA, 0x95707F9C29C71981, 0x6FD83B83BCE2C44D, 0x5D322FE13E21FD71,
0x34DECEE65F8A6EA7, 0xCD6CE7BB5E7162DC, 0xFB0DCC214A6F92A1, 0x2EB1A9958ACF590E,
0xDCFA938FC6A5E340, 0x669ECDB8BAE7ECA2, 0x151D4BCC0E0948DD, 0xFD3916A59726C53A,
0x581C982777B67B5D, 0x1BCAEF4D0A0F78C4, 0xDFE0FECD527B32F7, 0x128C19760C0A502B,
0x84E60BA8B113981D, 0x3C3DB0E386C50925, 0x7FEBC789FB7C0ABC, 0x7D5422F5B0E89466,
0xD70380C88B345575, 0xBBC1D609A308408F, 0xE278C6100BF474BF, 0x5E2842A3AAFF2CC6,
0x6B53047B2A3F0D0C, 0xF7658DDC05FD3C62, 0x9A025323F28B66F5, 0x8C0575AD685CFF9F,
0x76AD31B2FD792253, 0x68496939BEE1DCBB, 0x7E4E4FB7243645D1, 0xE44C1C94D6BD2324,
0xBEEF61CFEA9FC6A3, 0x91FB4064BF1AD0C0, 0x052EB7C64997862C, 0x4A9081517BBC2B76,
0x8F1F18EFFC822E28, 0x3A096A675B8C5EBE, 0xEE1087ED4466DA7C, 0x2652D79053803E8C,
0x7099EB36203075C8, 0xC7307CC2CCAA9B84, 0x5C97A7DFE16BB21C, 0x50FFE622AEF91CDF,
0x8DA0FD93B716B0F2, 0x69ECE10761AB93D6, 0x31F07920161DE88B, 0x13299148D3401F46,
0x031A6D4294DED1B7, 0xCCC96F85813B2DB1, 0x14B8C3F2D14307B0, 0x8659EED4FA8706C7,
0xBA645E377C420FE2, 0x2920FB2F88CC41F8, 0x87FC66EA25CD49AA, 0x1EE4588B4398FEE8,
0xECAF62910FF244A6, 0xF817A163DEB14316, 0x45E2ADEEA0F05402, 0x806D345027CE515C,
0x576EB498ACFA0429, 0xA5258E82E090BE67, 0x892BC26B21CB79B3, 0x6E7DB3BD63A88B20,
0x4E1BBEA9ED61E237, 0xADC6F08739DFD9E5, 0x8B9427176A5FE769, 0xA1AEB17A764D7726,
0x4B35096FA4F6641B, 0x22D9E868C55DF7CD, 0x55D151E4E76E9AF3, 0x966A12DEBD19C836,
0x0DCDC9C390D8E1AE, 0xF24B3A1A4C6ABA4E, 0x24ED32EC1814A056, 0xAF7915FB724B473F,
0x2885731157860E95, 0x9C3689A72FC2316E, 0x475D4892EB64CAD8, 0xAC6378B9E6959688,
0xA00B3944A907384B, 0xC695F4FC13E0D4E9, 0x3055F11EC957A7E6, 0x6215F2402C3A25E3,
0xDE4576F38D317D9A, 0x9344A518F48E4E1A, 0x82D2D12C6C5ACF86, 0xEFB50FD39B2C9511,
0xE981D5574665C28A, 0x5F8DCA9D75B563AB, 0xB60C1FCA33D0A121, 0xFE237BE703F8148D,
0xD6A608F6547E1A18, 0xB97E3375E89CDE55, 0xD388BF301DE99C34, 0x5B06F565E368AAEA,
0xF0F4DF6607FE2494, 0x1607268E9AD7996A, 0xAEDC9DC5AD010852, 0xE0C7236C4060EA65,
0xEA9BB815D2BB133D, 0x888E4A55FE8136DE, 0x5AA37D5B3C22E587, 0xC104A64611E3CC1F,
0x515A6E1C71B353B2, 0xC42A118058744A33, 0x7708B98C22336D3E, 0x2A3A966D1C12904F,
0x8A31AF29B515A804, 0xED0AEAAFD0B80BCB, 0x2C0E4CE9C15BC7D4, 0x0C6841FD4F92AEC3,
0x98BDB65FB91FF82F, 0x1F41D0B59CD2B185, 0xB322A80C7A47270D, 0xE6F3F9E89D29BDFE,
0x7AC5704FB2EB8C90, 0xA94DCF7FAF0210A4, 0x787A9533F97F124A, 0xDB6BC135C4A6FBB6,
0x048B3FF896DDC941, 0xE8245D69992F8DE7, 0xE3DD4E2ED4BE3BD2, 0xCAFDB5015C727A2A,
0xB7A997F4EC9AEE4C, 0xE75671D64263F293, 0x2B9F1E53C358DF22, 0x18D0820F9ED1A973,
0xABF22A03E4968E7E, 0xA2B4DC38E293A691, 0x673B458665ADA3CF, 0xF9B2295D01FB0C7B,
0xD22D370EC2A3D359, 0x97CF9AE06253875B, 0x0ED7A48104063019, 0x482F642D3028B5AC,
0xC0A12E78CEA98372, 0x4FBE3697322BAD5A, 0x19750A31419BE61E, 0x41699216362D9D43,
0xD5BC65B4C0A0CBAF, 0xE5E994AA09F76C49, 0xEB3E302B0DF15C50, 0x94D5F7A2F68D56EC,
0x53E58B603A27CD68, 0x3D9838DD598F4648, 0x60AA173C67AEBB39, 0x1DFE35C9D7462F5F,
0x4CA45BD5A6F57CED, 0xBC5084B3A10B5879, 0xFAA8441F9525DDCC, 0x334F9C5C5D897651 };

const u64bit SHARK::TE4[256] = {
0xDA1687A883ADF27E, 0xE35C9378578D9F22, 0x303CA4531637FA40, 0xA088321F74B20375,
0xC9863F3A9ACB95E9, 0x5FCF47C57D0B0ED4, 0x4AA211E4E1280B4B, 0xE1A4C9BA871D1289,
0x4926664759F03A4F, 0xADFB36EDE3707BCA, 0xCF7BD1891F8EF7E1, 0x9735559E8F882792,
0x5932A976F84E6CDC, 0x9DC792BEF547818A, 0x06FDEEB385456208, 0x46AD38771EA2CF5B,
0x5EB36AA41543B27B, 0x8B2EB33CD1BCB511, 0x71105FF6E598EBBC, 0x5441AD846F8C1463,
0x4C5FFF57646D6943, 0xF3485C49F633C9B1, 0x9CBBBFDF9D0F3D25, 0x22D031A067192178,
0xCA0248992213A4ED, 0x19627FB263A9C18F, 0x9330E1EFDA5DC831, 0x1390B89219666797,
0x2EDF18339893E568, 0x6C779435D3E4C590, 0x53C06E568281CAC4, 0x6FF3E3966B3CF494,
0xFE3B58BB61F1B10E, 0x77EDB14560DD89B4, 0x02F85AC2D0908DAB, 0x12EC95F3712EDB38,
0x85D9C06DFEA6FCAA, 0x90B4964C6285F935, 0xF1B0068B26A3441A, 0x729428555D40DAB8,
0x5C4B3066C5D33FD0, 0x5D371D07AD9B837F, 0xA48D866E2167ECD6, 0xB661139D504937EE,
0xA27068DDA4228EDE, 0xF8C6B608E4B4D306, 0x6BF657E73EE91B37, 0xAC871B8C8B38C765,
0x4EA7A595B4FDE4E8, 0x0D7304F297C278BF, 0xB71D3EFC38018B41, 0xAE7F414E5BA84ACE,
0xAF036C2F33E0F661, 0x0000000000000000, 0xB89660CC7F537E55, 0xA675DCACF1F7617D,
0x610490C74426BD2F, 0xC18CA2D83094BE5A, 0x2ADAAC42CD460ACB, 0x7D1F76651A122FAC,
0xC58916A9654151F9, 0xEDABE0297897D699, 0x2D5B6F90204BD46C, 0x26D585D132CCCEDB,
0x9F3FC87C25D70C21, 0xC60D610ADD9960FD, 0x80A0597DC33BAFA6, 0xD0E44088F9625466,
0x1D67CBC3367C2E2C, 0x2C2742F1480368C3, 0x89D6E9FE012C38BA, 0xE9AE54582D42393A,
0x3ECBD702392DB3FB, 0xB5E5643EE89106EA, 0xA882AFFDDEED28C6, 0x1AE60811DB71F08B,
0x924CCC8EB215749E, 0xFCC30279B1613CA5, 0x825803BF13AB220D, 0xD992F00B3B75C37A,
0xC8FA125BF2832946, 0x35453D432BAAA94C, 0xF9BA9B698CFC6FA9, 0x37BD6781FB3A24E7,
0x791AC2144FC7C00F, 0x16E9218224FB349B, 0xDB6AAAC9EBE54ED1, 0xD8EEDD6A533D7FD5,
0x7C635B04725A9303, 0x553D80E507C4A8CC, 0x9A46516C184A5F2D, 0x14117B40F46BB930,
0x1EE3BC608EA41F28, 0x27A9A8B05A847274, 0x4050D6C49BE7AD53, 0x7BE298D69F574DA4,
0x6A8A7A8656A1A798, 0x4D23D2360C25D5EC, 0x1014CF31A1BE5693, 0xB264A7EC059CD84D,
0xEA2A23FB959A083E, 0xF0CC2BEA4EEBF8B5, 0x76919C240895351B, 0x0B8EEA4112871AB7,
0x47D1151676EA73F4, 0xBDEFF9DC42CE2D59, 0x2BA68123A50EB664, 0x057999103D9D530C,
0xE759270902587081, 0xEF53BAEBA8075B32, 0x4FDB88F4DCB55847, 0x6E8FCEF70374483B,
0x1168E250C9F6EA3C, 0x1B9A2570B3394C24, 0x706C72978DD05713, 0x865DB7CE467ECDAE,
0x52BC4337EAC9766B, 0x504419F53A59FBC0, 0x8F2B074D84695AB2, 0x6078BDA62C6E0180,
0x43D4A167233F9C57, 0x0EF773512F1A49BB, 0x0C0F2993FF8AC410, 0x4BDE3C858960B7E4,
0x66855315A92B6388, 0xD360372B41BA6562, 0x584E84179006D073, 0x9B3A7C0D7002E382,
0xA5F1AB0F492F5079, 0x2822F6801DD68760, 0x445562B5CE3242F0, 0xAA7AF53F0E7DA56D,
0x3C338DC0E9BD3E50, 0x3BB24E1204B0E0F7, 0xD59DD998C4FF076A, 0x91C8BB2D0ACD459A,
0x84A5ED0C96EE4005, 0x33B8D3F0AEEFCB44, 0x57C5DA27D7542567, 0x32C4FE91C6A777EB,
0x3439102243E215E3, 0xC7714C6BB5D1DC52, 0x3FB7FA6351650F54, 0x87219AAF2E367101,
0xF5B5B2FA7376ABB9, 0x412CFBA5F3AF11FC, 0xDCEB691B06E89076, 0xBB12176FC78B4F51,
0x73E8053435086617, 0xE220BE193FC5238D, 0xB09CFD2ED50C55E6, 0xB9EA4DAD171BC2FA,
0x9E43E51D4D9FB08E, 0x36C14AE093729848, 0xA9FE829CB6A59469, 0x0405B47155D5EFA3,
0x0AF2C7207ACFA618, 0x7E9B01C6A2CA1EA8, 0xDD97447A6EA02CD9, 0x0781C3D2ED0DDEA7,
0x7866EF75278F7CA0, 0xD1986DE9912AE8C9, 0xCB7E65F84A5B1842, 0xCD838B4BCF1E7A4A,
0xAB06D85E663519C2, 0xD4E1F4F9ACB7BBC5, 0xFDBF2F18D929800A, 0xF23471289E7B751E,
0xBC93D4BD2A8691F6, 0x3D4FA0A181F582FF, 0xBA6E3A0EAFC3F3FE, 0x5AB6DED540965DD8,
0xEB560E9AFDD2B491, 0x0976B083C217971C, 0xECD7CD4810DF6A36, 0x23AC1CC10F519DD7,
0xBE6B8E7FFA161C5D, 0x7FE72CA7CA82A207, 0xC0F08FB958DC02F5, 0x7A9EB5B7F71FF10B,
0xA709F1CD99BFDDD2, 0x8DD35D8F54F9D719, 0x8CAF70EE3CB16BB6, 0xE4DD50AABA804185,
0x83242EDE7BE39EA2, 0x98BE0BAEC8DAD286, 0x690E0D25EE79969C, 0x95CD0F5C5F18AA39,
0x56B9F746BF1C99C8, 0x7469C6E6D805B8B0, 0x8A529E5DB9F409BE, 0xE6250A686A10CC2E,
0x2FA33552F0DB59C7, 0x42A88C064B7720F8, 0x6D0BB954BBAC793F, 0x181E52D30BE17D20,
0xBF17A31E925EA0F2, 0x94B1223D37501696, 0xE8D27939450A8595, 0xCCFFA62AA756C6E5,
0x383639B1BC68D1F3, 0xEE2F978AC04FE79D, 0xA30C45BCCC6A3271, 0x1F9F9101E6ECA387,
0xB1E0D04FBD44E949, 0x242DDF13E25C4370, 0x156D56219C23059F, 0x88AAC49F69648415,
0x6280E764FCFE8C2B, 0xDF6F1EB8BE30A172, 0xE5A17DCBD2C8FD2A, 0xE0D8E4DBEF55AE26,
0x63FCCA0594B63084, 0xA1F41F7E1CFABFDA, 0x295EDBE1759E3BCF, 0x67F97E74C163DF27,
0x038477A3B8D83104, 0xDE1333D9D6781DDD, 0x3ACE63736CF85C58, 0xD619AE3B7C27366E,
0x5BCAF3B428DEE177, 0xB3188A8D6DD464E2, 0x1C1BE6A25E349283, 0x017C2D616848BCAF,
0x8E572A2CEC21E61D, 0xF631C559CBAE9ABD, 0x81DC741CAB731309, 0xFF4775DA09B90DA1,
0xB499495F80D9BA45, 0x0F8B5E304752F514, 0x394A14D0D4206D5C, 0xCE07FCE877C64B4E,
0xF4C99F9B1B3E1716, 0xC4F53BC80D09ED56, 0xC208D57B884C8F5E, 0x080A9DE2AA5F2BB3,
0x314089327E7F46EF, 0xFA3EECCA34245EAD, 0x20286B62B789ACD3, 0x7515EB87B04D041F,
0x513834945211476F, 0x650124B611F3528C, 0x17950CE34CB38834, 0x45294FD4A67AFE5F,
0x21544603DFC1107C, 0x485A4B2631B886E0, 0x6872204486312A33, 0x647D09D779BBEE23,
0x2551F2728A14FFDF, 0xD765835A146F8AC1, 0xD21C1A4A29F2D9CD, 0x99C226CFA0926E29,
0xFB42C1AB5C6CE202, 0xC374F81AE00433F1, 0x964978FFE7C09B3D, 0xF74DE838A3E62612 };

const u64bit SHARK::TE5[256] = {
0x74B87B36B0592C6A, 0x3D82D75DFFB4B81C, 0x8884246715267825, 0xDAF2D8A77ED4E5DE,
0xFEB118650E53F9C7, 0xBD2D1AEA59226B06, 0x26CE87F6DBABB191, 0x32772ECBEB66BD0A,
0xD4BBF82BC5104C8C, 0x055357720C4E03A1, 0xEF5BE62A32D0F6FD, 0xBE1C84C45D186ACA,
0xACC7E4A565A1643C, 0x8DD7731519687B84, 0x11EAFE4F3C830F3A, 0x04EF8E68A358AFE5,
0x40AD9CA1534B930D, 0xE44191D4855A5C0E, 0x6001D20B809420F1, 0x73666B70173B8243,
0x372479B9E728BEAB, 0x45FECBD35F0590AC, 0x7057F55E1301838F, 0xFF0DC17FA1455583,
0x0CC467B810E804DA, 0xB9C29482FA7AC4E3, 0xA003831D754960E6, 0x8A096353BE0AD5AD,
0xDD2CC8E1D9B64BF7, 0xC7DC415052BFEE3E, 0x9F0C137421D17572, 0x35A93E8D4C041323,
0x9A5F44062D9F76D3, 0x71EB2C44BC172FCB, 0x0FF5F99614D20516, 0x7789E518B4632DA6,
0xC99561DCE97B476C, 0x5276FCC06BF29DFB, 0x4A0B32454BD795BA, 0x9274ADD69E2FDDEC,
0x4F5865374799961B, 0xB2D8E37C4DF06E10, 0xC4EDDF7E5685EFF2, 0xB3643A66E2E6C254,
0xD50721316A06E0C8, 0x8BB5BA49111C79E9, 0x2BB639546455190F, 0xF8D3D1390627FBAA,
0x38D1802FF3FABBBD, 0xDFA18FD5729AE67F, 0x4EE4BC2DE88F3A5F, 0xF72628AF12F5FEBC,
0x0AA6AEE4189C06B7, 0x0000000000000000, 0x9EB0CA6E8EC7D936, 0xCB1826E84257EAE4,
0x187DCE8520250841, 0xC28F16225EF1ED9F, 0xC333CF38F1E741DB, 0x4220DB95F8673E85,
0xDC9011FB76A0E7B3, 0x105627559395A37E, 0x2F59B73CC70DB6EA, 0xE112C6A689145FAF,
0x82228A830DBA7E92, 0x2EE56E26681B1AAE, 0x2A0AE04ECB43B54B, 0x47738CE7F4293D24,
0xA7DD935BD22BCECF, 0xD2D93177CD644EE1, 0xEBB4684291885918, 0x0E49208CBBC4A952,
0xA550D46F79076347, 0x411145BBFC5D3F49, 0xE6CCD6E02E76F186, 0x4BB7EB5FE4C139FE,
0x5D8305567F2098ED, 0x95AABD90394D73C5, 0x25FF19D8DF91B05D, 0x86CD04EBAEE2D177,
0x03319E2E043A01CC, 0x6B1BA5F5371E8A02, 0x76353C021B7581E2, 0x64EE5C6323CC8F14,
0x5C3FDC4CD03634A9, 0x6996E2C19C32278A, 0x8938FD7DBA30D461, 0x7B4D82A0A48B297C,
0xBFA05DDEF20EC68E, 0x8EE6ED3B1D527A48, 0x61BD0B112F828CB5, 0x66631B5788E0229C,
0x55A8EC86CC9033D2, 0x1C9240ED837DA7A4, 0x150570279FDBA0DF, 0x53CA25DAC4E431BF,
0xD636BF1F6E3CE104, 0xCAA4FFF2ED4146A0, 0x787C1C8EA0B128B0, 0xAD7B3DBFCAB7C878,
0xFC3C5F51A57F544F, 0xB78BB40E41BE6DB1, 0x8C6BAA0FB67ED7C0, 0xCE4B719A4E19E945,
0xF96F0823A93157EE, 0x7D2F4BFCACFF2B11, 0x3EB34973FB8EB9D0, 0xE39F81922238F227,
0x239DD084D7E5B230, 0x1FA3DEC38747A668, 0xC5510664F99343B6, 0xC829B8C6466DEB28,
0x85FC9AC5AAD8D0BB, 0xB6376D14EEA8C1F5, 0x9D8154408AFDD8FA, 0x3BE01E01F7C0BA71,
0x628C953F2BB88D79, 0x6D796CA93F6A886F, 0xFA5E960DAD0B5622, 0xE5FD48CE2A4CF04A,
0xE7700FFA81605DC2, 0x2DD4F0086C211B62, 0x2221099E78F31E74, 0xDB4E01BDD1C2499A,
0xF417B68116CFFF70, 0xB506F33AEA92C039, 0x514762EE6FC89C37, 0x9C3D8D5A25EB74BE,
0x396D59355CEC17F9, 0xCCC636AEE53544CD, 0x0B1A77FEB78AAAF3, 0xE9392F763AA4F490,
0xAAA52DF96DD56651, 0x46CF55FD5B3F9160, 0xA4EC0D75D611CF03, 0xAFF67A8B619B65F0,
0x3415E797E312BF67, 0x7AF15BBA0B9D8538, 0x811314AD09807F5E, 0x8771DDF101F47D33,
0x969B23BE3D777209, 0xD365E86D6272E2A5, 0x58D05224736E9B4C, 0xC660984AFDA9427A,
0x5414359C63869F96, 0xE885F66C95B258D4, 0x655285798CDA2350, 0x6CC5B5B3907C242B,
0x6FF42B9D944625E7, 0xC0025116F5DD4017, 0xA28EC429DE65CD6E, 0x63304C2584AE213D,
0x7FA20CC807D38699, 0x996EDA2829A5771F, 0x1B4C50AB241F098D, 0x1E1F07D928510A2C,
0x33CBF7D14470114E, 0xB055A448E6DCC398, 0x98D2033286B3DB5B, 0xEC6A780436EAF731,
0xA1BF5A07DA5FCCA2, 0xBAF30AACFE40C52F, 0xF144E1F31A81FCD1, 0xE0AE1FBC2602F3EB,
0x14B9A93D30CD0C9B, 0x596C8B3EDC783708, 0x682A3BDB33248BCE, 0xB87E4D98556C68A7,
0x80AFCDB7A696D31A, 0x5725ABB267BC9E5A, 0x914533F89A15DC20, 0x5EB29B787B1A9921,
0x01BCD91AAF16AC44, 0xC1BE880C5ACBEC53, 0xEDD6A11E99FC5B75, 0x028D4734AB2CAD88,
0x8F5A3421B244D60C, 0x4DD52203ECB53B93, 0x3F0F906954981594, 0xAE4AA391CE8DC9B4,
0x3698A0A3483E12EF, 0xF5AB6F9BB9D95334, 0x082BE9D0B3B0AB3F, 0xD1E8AF59C95E4F2D,
0xD87F9F93D5F84856, 0x6E48F2873B5089A3, 0x2443C0C270871C19, 0xB1E97D5249CA6FDC,
0x7C9392E603E98755, 0x839E5399A2ACD2D6, 0x19C1179F8F33A405, 0xDE1D56CFDD8C4A3B,
0x20AC4EAAD3DFB3FC, 0x1AF089B18B09A5C9, 0x3A5CC71B58D61635, 0x444212C9F0133CE8,
0x72DAB26AB82D2E07, 0x4C69FB1943A397D7, 0xF3C9A6C7B1AD5159, 0x1D2E99F72C6B0BE0,
0xB4BA2A2045846C7D, 0xE22358888D2E5E63, 0x2887A77A606F18C3, 0xA8286ACDC6F9CBD9,
0x5F0E4262D40C3565, 0xEEE73F309DC65AB9, 0x9BE39D1C8289DA97, 0x1634EE099BE1A113,
0xEA08B1583E9EF55C, 0x9727FAA49261DE4D, 0x2C682912C337B726, 0xCFF7A880E10F4501,
0x1788371334F70D57, 0x27725EEC74BD1DD5, 0x3146B0E5EF5CBCC6, 0x099730CA1CA6077B,
0xF2757FDD1EBBFD1D, 0x6AA77CEF98082646, 0xBB4FD3B65156696B, 0x569972A8C8AA321E,
0xA3321D337173612A, 0x50FBBBF4C0DE3073, 0x5A5D1510D84236C4, 0xFD80864B0A69F80B,
0x07DE1046A762AE29, 0xA6614A417D3D628B, 0xD78A6605C12A4D40, 0x67DFC24D27F68ED8,
0xBC91C3F0F634C742, 0xD05476436648E369, 0x493AAC6B4FED9476, 0x12DB606138B90EF6,
0xA994B3D769EF679D, 0x211097B07CC91FB8, 0x30FA69FF404A1082, 0x3C3E0E4750A21458,
0x7504A22C1F4F802E, 0x844043DF05CE7CFF, 0xF0F838E9B5975095, 0x7E1ED5D2A8C52ADD,
0x90F9EAE235037064, 0x0662C95C0874026D, 0x9416648A965BDF81, 0xF69AF1B5BDE352F8,
0x0D78BEA2BFFEA89E, 0x293B7E60CF79B487, 0xD9C346897AEEE412, 0xFBE24F17021DFA66,
0x1367B97B97AFA2B2, 0xAB19F4E3C2C3CA15, 0x48867571E0FB3832, 0x93C874CC313971A8,
0x79C0C5940FA784F4, 0xCD7AEFB44A23E889, 0x439C028F577192C1, 0x5BE1CC0A77549A80 };

const u64bit SHARK::TE6[256] = {
0x714D28D778656928, 0xC88A7C6B84F64F7C, 0xEC43CAC5AB89AACA, 0x777FA38110DC16A3,
0x0F7D5C87E4213B5C, 0x73F051E5F3A1EF51, 0xEA714193C330D541, 0x95E5F3DAE016C4F3,
0x63D3738095A0E173, 0x9825D66F8FF379D6, 0xE8CC38A148F45338, 0xA840B0C025F06BB0,
0x944135C35F748735, 0x74661CAA247AD31C, 0xE7B16426ACD56864, 0xD1E689DF6E6F0589,
0xA73DEC47C1D150EC, 0x64453ECF427BDD3E, 0x0ED99A9E5B43789A, 0x7B1B402DC05BE840,
0x0DC025B56FE5BD25, 0x3F183A284E22293A, 0xA0ABA108160A6CA1, 0x46BE033705BD4703,
0x86DF6E94B2B10F6E, 0xA216D83A9DCEEAD8, 0x129E5B57EDC5885B, 0x7E3074509C445274,
0x7D29CB7BA8E297CB, 0x1611A9330EB871A9, 0x486799A95EFE3F99, 0x9FB39B205828459B,
0xD0424FC6D10D464F, 0xE968FEB8F79610FE, 0x5D6F8FB164E08B8F, 0xAAFDC9F2AE34EDC9,
0x02BD79328BC48679, 0x9B3C6944BB55BC69, 0x6277B5992AC2A2B5, 0x877BA88D0DD34CA8,
0xFA5263F6A531DB63, 0x2E9FDE54974164DE, 0xCDA14816D8E9F548, 0x675C81E476DD1881,
0x2A102C30743C9D2C, 0x37F32BE07DD82E2B, 0x256D70B7901DA670, 0x4CE86BCDBD83C66B,
0x50AFAA040B0536AA, 0xEF5A75EE9F2F6F75, 0xB3913C4644ADA73C, 0x1187E47CD9634DE4,
0xC54A59DEEB13F259, 0x0000000000000000, 0x01A4C619BF6243C6, 0x90CEC7A7BC097EC7,
0xF94BDCDD91971EDC, 0x8E347F5C814B087F, 0xC7F720EC60D77420, 0x354E52D2F61CA852,
0x34EA94CB497EEB94, 0xAE723B964D49143B, 0xF48BF968FE72A3F9, 0xFC60E8A0CD88A4E8,
0x2909931B409A5893, 0xBD48A6D81FEEDFA6, 0x6CAE2F077181DA2F, 0xAD6B84BD79EFD184,
0x18C833AD55FB0933, 0x204644CACC021C44, 0x392AB17E269B56B1, 0x14ACD001857CF7D0,
0x8ABB8D386236F18D, 0xEEFEB3F7204D2CB3, 0xF636805A75B62580, 0x2BB4EA29CB5EDEEA,
0xC653E6F5DFB537E6, 0x8D2DC077B5EDCDC0, 0x31C1A0B6156151A0, 0xF8EF1AC42EF55D1A,
0xDBB0E125D65184E1, 0x82509CF051CCF69C, 0xE33E96424FA89196, 0xDF3F1341352C7D13,
0x8F90B9453E294BB9, 0x1023226566010E22, 0xA58095754A15D695, 0x2C22A7661C85E2A7,
0xE183EF70C46C17EF, 0xAFD6FD8FF22B57FD, 0x471AC52EBADF04C5, 0x4D4CADD402E185AD,
0x916A01BE036B3D01, 0x28AD5502FFF81B55, 0x3657EDF9C2BA6DED, 0xD2FF36F45AC9C036,
0xF1A0CD15A26D19CD, 0xD90D98175D950298, 0xF7924643CAD46646, 0xDD826A73BEE8FB6A,
0x9D0EE212D3ECC3E2, 0xB6BA083B18B21D08, 0x3DA5431AC5E6AF43, 0x08EB11C833FA0711,
0x052B347D5C1FBA34, 0x6FB7902C45271F90, 0x133A9D4E52A7CB9D, 0x6E135635FA455C56,
0x725497FC4CC3AC97, 0xF31DB42729A99FB4, 0x846217A639758917, 0x4B7E26826A58FA26,
0x235FFBE1F8A4D9FB, 0xFF79578BF92E6157, 0xDA14273C6933C727, 0x8B1F4B21DD54B24B,
0x9CAA240B6C8E8024, 0xC1C5ABBA086E0BAB, 0xDE9BD5588A4E3ED5, 0x2D86617FA3E7A161,
0xBFF5DFEA942A59DF, 0x66F847FDC9BF5B47, 0x3B97C84CAD5FD0C8, 0x3EBCFC31F1406AFC,
0xCA3705590F32C905, 0x24C9B6AE2F7FE5B6, 0x408C88616D043888, 0x93D7788C88AFBB78,
0x196CF5B4EA994AF5, 0x9A98AF5D0437FFAF, 0x8C89066E0A8F8E06, 0xAB590FEB1156AE0F,
0xD7D4028906D67A02, 0xE4A8DB0D9873ADDB, 0xC378D28883AA8DD2, 0x4FF1D4E6892503D4,
0xD670C490B9B439C4, 0x65E1F8D6FD199EF8, 0xF2B9723E96CBDC72, 0xB12C4574CF692145,
0x569D215263BC4921, 0x69851B7A2D9E601B, 0x5E76309A50464E30, 0x5FD2F683EF240DF6,
0xD8A95E0EE2F7415E, 0xE29A505BF0CAD250, 0x96FC4CF1D4B0014C, 0x8806F40AE9F277F4,
0x53B6152F3FA3F315, 0x1C47C1C9B686F0C1, 0x80EDE5C2DA0870E5, 0xD5697BBB8D12FC7B,
0xFDC42EB972EAE72E, 0x0BF2AEE3075CC2AE, 0x22FB3DF847C69A3D, 0xBADEEB97C835E3EB,
0xDC26AC6A018AB8AC, 0xBCEC60C1A08C9C60, 0x4231F153E6C0BEF1, 0x337CD9849EA5D7D9,
0x5B5D04E70C59F404, 0x79A6391F4B9F6E39, 0x5212D33680C1B0D3, 0xB5A3B7102C14D8B7,
0x7F94B249232611B2, 0x17B56F2AB1DA326F, 0x59E07DD5879D727D, 0xEBD5878A7C529687,
0xBB7A2D8E7757A02D, 0x0319BF2B34A6C5BF, 0x5CCB49A8DB82C849, 0x1DE307D009E4B307,
0x49C35FB0E19C7C5F, 0x55849E79571A8C9E, 0x7ABF86347F39AB86, 0x9273BE9537CDF8BE,
0xE615A23F13B72BA2, 0x6821DD6392FC23DD, 0x5AF9C2FEB33BB7C2, 0x06328B5668B97F8B,
0x44037A058E79C17A, 0x83F45AE9EEAEB55A, 0x5739E74BDCDE0AE7, 0xFBF6A5EF1A5398A5,
0xE50C1D142711EE1D, 0x1A754A9FDE3F8F4A, 0x7802FF06F4FD2DFF, 0xF52F3F714110E03F,
0x2674CF9CA4BB63CF, 0x60CACCABA10624CC, 0xB088836D700B6283, 0xA6992A5E7EB3132A,
0xA9E476D99A922876, 0x6B386248A65AE662, 0xC2DC14913CC8CE14, 0x76DB6598AFBE5565,
0x32D81F9D21C7941F, 0x21E282D373605F82, 0xC0616DA3B70C486D, 0x616E0AB21E64670A,
0x6D0AE91ECEE399E9, 0x27D009851BD92009, 0xFEDD9192464C2291, 0x45A7BC1C311B82BC,
0x54205860E878CF58, 0xA10F6711A9682F67, 0x9981107630913A10, 0xEDE70CDC14EBE90C,
0x70E9EECEC7072AEE, 0x1F5E7EE28220357E, 0x2F3B184D28232718, 0x41284E78D2667B4E,
0xA424536CF5779553, 0xA3B21E2322ACA91E, 0x4E5512FF36474012, 0x1EFAB8FB3D4276B8,
0x89A2321356903432, 0xCB93C340B0508AC3, 0x306566AFAA031266, 0x4ADAE09BD53AB9E0,
0xC92EBA723B940CBA, 0x094FD7D18C9844D7, 0xCC058E0F678BB68E, 0xD4CDBDA23270BFBD,
0x0A5668FAB83E8168, 0x510B6C1DB467756C, 0xB86392A543F16592, 0x048FF264E37DF9F2,
0x3A330E55123D930E, 0xB235FA5FFBCFE4FA, 0xB9C754BCFC932654, 0x3C0185037A84EC85,
0x0C64E3ACD087FEE3, 0xE02729697B0E5429, 0x07964D4FD7DB3C4D, 0x814923DB656A3323,
0x388E776799F91577, 0x6A9CA4511938A5A4, 0x1BD18C86615DCC8C, 0xB407710993769B71,
0x150816183A1EB416, 0x4395374A59A2FD37, 0xC4EE9FC75471B19F, 0x5844BBCC38FF31BB,
0xCF1C3124532D7331, 0xB71ECE22A7D05ECE, 0xACCF42A4C68D9242, 0x97588AE86BD2428A,
0x75C2DAB39B1890DA, 0x9E175D39E74A065D, 0xF0040B0C1D0F5A0B, 0xCEB8F73DEC4F30F7,
0xBE5119F32B481A19, 0xD35BF0EDE5AB83F0, 0x7C8D0D621780D40D, 0x85C6D1BF8617CAD1 };

const u64bit SHARK::TE7[256] = {
0xB1C742127B66F2A4, 0xCE916098D7A59FC1, 0xC312EF8E2406FA70, 0x956C7DCED81403D5,
0x5A0C9B2318DD9520, 0xAD0D57F51A480E8B, 0xE7B9D05287740B01, 0x0217F9EA2ED81268,
0x4D7CFF19F8CD3A06, 0x44D1772E572B7B67, 0xFB73C5B5E65AF72E, 0x91427AEF84512705,
0x0C720963E4CF6C85, 0x87C398A0732D8117, 0xA17F5E96FE87620E, 0x50476C8B8E8FCF1D,
0xCB4EE1CC9C8CB225, 0x67B2304C91A8B59A, 0x54696BAAD2CAEBCD, 0xDDCF03836BF01437,
0x46C68EC479F3690F, 0x8F9F96E2CBA7C942, 0xE1802E99F5E93DB9, 0x4E9A8086C179215A,
0xF0C9B4686764A427, 0xFD4A3B7E94C7C196, 0xFCBBBD0B83ABC8A2, 0xEBCBD93163BB6784,
0xF9643C5FC882E546, 0xC4DA973041F7C5FC, 0x1AF3EB2C13B3CA97, 0x6E1FB87B3E4EF4FB,
0x5E229C024498B1F0, 0xF516353C2C4D89C3, 0xCC869972F97D8DA9, 0x8D886F08E57FDB2A,
0x1CCA15E7612EFC2F, 0x567E9240FC12F9A5, 0x43190F9032DA44EB, 0xFEAC44E1AD73DACA,
0x07C878BE65F13F8C, 0x618BCE87E3358322, 0xF895BA2ADFEEEC72, 0x751DD5223A913758,
0x59EAE4BC21698E7C, 0xFF5DC294BA1FD3FE, 0x03E67F9F39B41B5C, 0x2292C117D1EFC7C9,
0x8A4017B6808EE4A6, 0xD1BD0AE08F3F78B2, 0x135E631BBC558BF6, 0xEE14586528924A60,
0x8857EE5CAE56F6CE, 0x0000000000000000, 0x0E65F089CA177EED, 0x34132358269361DB,
0x15679DD0CEC8BD4E, 0x800BE01E16DCBE9B, 0x949DFBBBCF780AE1, 0xE397D773DB312FD1,
0xEDF227FA1126513C, 0xB5E945332723D674, 0x53A11314B73BD441, 0x23634762C683CEFD,
0x4B4501D28A500CBE, 0x473708B16E9F603B, 0x1770643AE010AF26, 0xA746A05D8C1A54B6,
0x90B3FC9A933D2E31, 0x35E2A52D31FF68EF, 0xAB34A93E68D53833, 0xD81082D720D939D3,
0xB86ACA25D480B3C5, 0xDFD8FA694528065F, 0x4F6B06F3D615286E, 0x578F1435EB7EF091,
0x9AF80B32056F740C, 0x92A40570BDE53C59, 0xDBF6FD48196D228F, 0x1B026D5904DFC3A3,
0x3C4F2D1A9E19298E, 0xC8A89E53A538A979, 0x991E74AD3CDB6F50, 0x042E07215C4524D0,
0x8E6E1097DCCBC076, 0xE071A8ECE285348D, 0xD784F42BFDA24E0A, 0x7D41DB60821B7F0D,
0x85D4614A5DF5937F, 0xBB8CB5BAED34A899, 0x40FF700F0B6E5FB7, 0x2CF7319E1BF8B924,
0x3A76D3D1EC841F36, 0x4520F15B40477253, 0xF138321D7008AD13, 0x42E889E525B64DDF,
0x65A5C9A6BF70A7F2, 0x208538FDFF37D5A1, 0x410EF67A1C025683, 0x18E412C63D6BD8FF,
0x72D5AD9C5F6008D4, 0x255AB9A9B41EF845, 0x93558305AA89356D, 0x70C2547671B81ABC,
0x3604DAB2084B73B3, 0x05DF81544B292DE4, 0xF2DE4D8249BCB64F, 0x0BBA71DD813E5309,
0xA368A77CD05F7066, 0x796FDC41DE5E5BDD, 0xEC03A18F064A5808, 0x085C0E42B88A4855,
0x274D40439AC6EA2D, 0x31CCA20C6DBA4C3F, 0x322ADD93540E5763, 0xB60F3AAC1E97CD28,
0x7CB05D1595777639, 0xB036C4676C0AFB90, 0x0A4BF7A896525A3D, 0x73242BE9480C01E0,
0x5BFD1D560FB19C14, 0x7B7825ABF08649B5, 0xB7FEBCD909FBC41C, 0x81FA666B01B0B7AF,
0xD25B757FB68B63EE, 0x0D838F16F3A365B1, 0x6A31BF5A620BD02B, 0x26BCC6368DAAE319,
0x9ED60C13592A50DC, 0x581B62C936058748, 0x9CC1F5F977F242B4, 0x83ED9F812F68A5C7,
0x74EC53572DFD3E6C, 0xB3D0BBF855BEE0CC, 0xACFCD1800D2407BF, 0x303D24797AD6450B,
0x7A89A3DEE7EA4081, 0x69D7C0C55BBFCB77, 0x770A2CC814492530, 0x0F9476FCDD7B77D9,
0xAEEB286A23FC15D7, 0x2174BE88E85BDC95, 0xDE297C1C52440F6B, 0xD04C8C9598537186,
0x2EE0C8743520AB4C, 0x977B8424F6CC11BD, 0x10B81C8485E190AA, 0xA4A0DFC2B5AE4FEA,
0x98EFF2D82BB76664, 0xA8D2D6A15161236F, 0xD4628BB4C4165556, 0x682646B04CD3C243,
0x2D06B7EB0C94B010, 0x626DB118DA81987E, 0x2928B0CA50D194C0, 0x6DF9C7E407FAEFA7,
0x1681E24FF77CA612, 0x4952F838A4881ED6, 0x76FBAABD03252C04, 0xC73CE8AF7843DEA0,
0xE82DA6AE5A0F7CD8, 0xC10516640ADEE818, 0x968A0251E1A01889, 0x37F55CC71F277A87,
0xE5AE29B8A9AC1969, 0xCABF67B98BE0BB11, 0xF4E7B3493B2180F7, 0xE9DC20DB4D6375EC,
0x639C376DCDED914A, 0x12AFE56EAB3982C2, 0xC2E369FB336AF344, 0xA6B726289B765D82,
0x14961BA5D9A4B47A, 0xBC44CD0488C59715, 0xD3AAF30AA1E76ADA, 0x28D936BF47BD9DF4,
0xAF1AAE1F34901CE3, 0x2F114E01224CA278, 0xE648562790180235, 0x24AB3FDCA372F171,
0x52509561A057DD75, 0xC6CD6EDA6F2FD794, 0xA08ED8E3E9EB6B3A, 0x09AD8837AFE64161,
0xBDB54B719FA99E21, 0x8C79E97DF213D21E, 0xCF60E6EDC0C996F5, 0x5DC4E39D7D2CAAAC,
0x11499AF1928D999E, 0x5FD31A7753F4B8C4, 0x01F18675176C0934, 0xC52B1145569BCCC8,
0x9F278A664E4659E8, 0x3DBEAB6F897520BA, 0xA2992109C7337952, 0x9B098D4712037D38,
0xC9591826B254A04D, 0x3B8755A4FBE81602, 0xBE5334EEA61D857D, 0x51B6EAFE99E3C629,
0x191594B32A07D1CB, 0x1F2C6A78589AE773, 0x3FA95285A7AD32D2, 0x5C3565E86A40A398,
0xB2213D8D42D2E9F8, 0xEFE5DE103FFE4354, 0x4AB487A79D3C058A, 0xCD771F07EE11849D,
0xBFA2B29BB1718C49, 0xBA7D33CFFA58A1AD, 0x6FEE3E0E2922FDCF, 0x64544FD3A81CAEC6,
0xD9E104A237B530E7, 0xF32FCBF75ED0BF7B, 0x3E58D4F0B0C13BE6, 0xB418C346304FDF40,
0xAAC52F4B7FB93107, 0xDC3E85F67C9C1D03, 0xD5930DC1D37A5C62, 0x0639FECB729D36B8,
0xC0F490111DB2E12C, 0x7EA7A4FFBBAF6451, 0xF6F04AA315F9929F, 0x6643B63986C4BCAE,
0x6C0841911096E693, 0x8425E73F4A999A4B, 0x7133D20366D41388, 0x38612A3BC25C0D5E,
0xB99B4C50C3ECBAF1, 0x1D3B93927642F51B, 0x7F56228AACC36D65, 0x9D30738C609E4B80,
0x48A37E4DB3E417E2, 0x8BB191C397E2ED92, 0x2ACECF5569658F9C, 0xDA077B3D0E012BBB,
0xA55159B7A2C246DE, 0x33DB5BE643625E57, 0x821C19F43804ACF3, 0x3990AC4ED530046A,
0xD675725EEACE473E, 0x789E5A34C93252E9, 0x86321ED564418823, 0xFA8243C0F136FE1A,
0xE45FAFCDBEC0105D, 0x2B3F49207E0986A8, 0xA92350D4460D2A5B, 0x1EDDEC0D4FF6EE47,
0x89A66829B93AFFFA, 0x607A48F2F4598A16, 0x6BC0392F7567D91F, 0xEA3A5F4474D76EB0,
0x5598EDDFC5A6E2F9, 0x4C8D796CEFA13332, 0xF701CCD602959BAB, 0xE2665106CC5D26E5 };

const u64bit SHARK::TD0[256] = {
0xE6126AF05E55AFF3, 0x4B6C893F310B0835, 0xAA4C0E84EBFC8D57, 0xFB9B5C7BF3B3090D,
0x4508A6A9CCBA5CE2, 0xE5D1D2064DC6BDE9, 0x348343755288EDDE, 0xB684505DE46B250C,
0xA8CEDE205A1E91E8, 0x40B89B46F9FA6ACC, 0x8EE1EC1AFAB080BA, 0xDE77D6B7408E0A45,
0x9A3E184C2E455802, 0xBE93FAD23F0955EF, 0x3AE76CE3AF39B909, 0xAD7EE3CF6F5EA7C6,
0x8B51D1F5CFF0B694, 0x70CA8D8E3C43BF99, 0xCCDBA7F8B2A8F6C9, 0x4C5E6474B5A922A4,
0x5D31ADCD541CCC32, 0x9B7F701E8C3456A7, 0x2AC9CD08ECFD593A, 0x8FA0844858C18E1F,
0x32F0C66C745BC9EA, 0xC58D6525CBBB888F, 0x8C633CBE4B529C05, 0xF2CD9EA68AA0774B,
0x2CBA4811CA2E7D0E, 0xE2E33F4DC9649778, 0xF4BE1BBFAC73537F, 0x22DE6787379F29D9,
0x0956C2DD79137E46, 0xE061EFE978868BC7, 0x1CC85ED90F97A85B, 0x31337E9A67C8DBF0,
0x360193D1E36AF161, 0x7FEFCA4A6383E5EB, 0x8535FE633241E243, 0xC3FEE03CED68ACBB,
0x81C4ABDEA570DAC8, 0x67D6C12EFB25753B, 0xA4282112164DD980, 0xCF181F0EA13BE4D3,
0xA98FB672F86F9F4D, 0x5C70C59FF66DC297, 0xB0F7D544C2B80138, 0x0DA79760EE2246CD,
0x3740FB83411BFFC4, 0x24ADE29E114C0DED, 0xF858E48DE0201B17, 0x0E642F96FDB154D7,
0xDDB46E41531D185F, 0x25EC8ACCB33D0348, 0x0282D0A4B1E21CBF, 0x1BFAB3928B3582CA,
0xAFFC336BDEBCBB79, 0x35C22B27F0F9E37B, 0x03C3B8F61393121A, 0xB8E07FCB19DA71DB,
0x99FDA0BA3DD64A18, 0xCE59775C034AEA76, 0x49EE599B80E9148A, 0xFE2B6194C6F33F23,
0x4EDCB4D0044B3E1B, 0xD5A3C4CE887F68BC, 0xDF36BEE5E2FF04E0, 0x171C4CA0C766CAA2,
0x0BD41279C8F162F9, 0xE490BA54EFB7B34C, 0x5B4228D472CFE806, 0x5355825BA9AD98E5,
0x9F8E25A31B056E2C, 0xCD9ACFAA10D9F86C, 0x88926903DC63A48E, 0xB40680F9558939B3,
0x239F0FD595EE277C, 0xEC8710DB34D5C3AF, 0x87B72EC783A3FEFC, 0x632794936C144DB0,
0x46CB1E5FDF294EF8, 0x83467B7A1492C677, 0x9C4D9D5508967C36, 0xD6607C389BEC7AA6,
0x165D24F26517C407, 0xC4CC0D7769CA862A, 0xCBE94AB3360ADC58, 0x847496319030ECE6,
0x7A5FF7A556C3D3C5, 0xC03D58CAFEFBBEA1, 0x76B908971A909BAD, 0x2F79F0E7D9BD6F14,
0x197863363AD79E75, 0xDA86830AD7BF32CE, 0x5A034086D0BEE6A3, 0x97998F2CC0671ECF,
0x552607428F7EBCD1, 0x51D752FF184F845A, 0xBB23C73D0A4963C1, 0x2B88A55A4E8C579F,
0xD80453AE665D2E71, 0xEE05C07F8537DF10, 0x423A4BE248187673, 0xCAA822E1947BD2FD,
0x1ABBDBC029448C6F, 0x96D8E77E6216106A, 0x6266FCC1CE654315, 0x89D301517E12AA2B,
0x730935782FD0AD83, 0x8085C38C0701D46D, 0x6B303E1CB7763D53, 0x3F57510C9A798F27,
0x4449CEFB6ECB5247, 0x48AF31C922981A2F, 0x98BCC8E89FA744BD, 0x69B2EEB8069421EC,
0xEBB5FD90B077E93E, 0x6A71564E150733F6, 0x116FC9B9E1B5EE96, 0x4A2DE16D937A0690,
0xB9A11799BBAB7F7E, 0x9368DA9157562644, 0x718BE5DC9E32B13C, 0xC82AF2452599CE42,
0xB547E8ABF7F83716, 0x33B1AE3ED62AC74F, 0x799C4F534550C1DF, 0x3E16395E38088182,
0x7C2C72BC7010F7F1, 0xF38CF6F428D179EE, 0xD29129850CDD422D, 0x41F9F3145B8B6469,
0x945A37DAD3F40CD5, 0x757AB061090389B7, 0x6554118A4AC76984, 0x7D6D1AEED261F954,
0x01416852A2710EA5, 0xB27505E0735A1D87, 0x77F860C5B8E19508, 0x78DD2701E721CF7A,
0xE12087BBDAF78562, 0x86F6469521D2F059, 0xEF44A82D2746D1B5, 0xBC112A768EEB4950,
0xC2BF886E4F19A21E, 0x307216C8C5B9D555, 0xC96B9A1787E8C0E7, 0xA31ACC5992EFF311,
0xA0D974AF817CE10B, 0xDCF50613F16C16FA, 0xFCA9B1307711239C, 0x57A4D7E63E9CA06E,
0xC64EDDD3D8289A95, 0xA25BA40B309EFDB4, 0x2E3898B57BCC61B1, 0xF5FF73ED0E025DDA,
0xA6AAF1B6A7AFC53F, 0xD9453BFCC42C20D4, 0x9D0CF507AAE77293, 0x290A75FEFF6E4B20,
0xA7EB99E405DECB9A, 0xA1981CFD230DEFAE, 0x12AC714FF226FC8C, 0x743BD833AB728712,
0x6C02D35733D417C2, 0xE9372D340195F581, 0xF77DA349BFE04165, 0x68F386EAA4E52F49,
0x211DDF71240C3BC3, 0x13ED191D5057F229, 0xE8764566A3E4FB24, 0xF9198CDF425115B2,
0xD013F921BD3F5E92, 0x91EA0A35E6B43AFB, 0x0732ED4B84A22A91, 0xEAF495C21206E79B,
0x5214EA090BDC9640, 0x0000000000000000, 0xB3346DB2D12B1322, 0x0CE6FF324C534868,
0xAEBD5B397CCDB5DC, 0x0A957A2B6A806C5C, 0x1F0BE62F1C04BA41, 0x14DFF456D4F5D8B8,
0x58819022615CFA1C, 0x05B03DEF3540362E, 0xE3A2571F6B1599DD, 0x9229B2C3F52728E1,
0xBA62AF6FA8386D64, 0x0673851926D32434, 0x641579D8E8B66721, 0x04F155BD9731388B,
0x9ECF4DF1B9746089, 0x205CB723867D3566, 0x102EA1EB43C4E033, 0x3BA604B10D48B7AC,
0x50963AADBA3E8AFF, 0xAC3F8B9DCD2FA963, 0x7B1E9FF7F4B2DD60, 0xF63CCB1B1D914FC0,
0x7EAEA218C1F2EB4E, 0x5FB37D69E5FED08D, 0x56E5BFB49CEDAECB, 0x2DFB2043685F73AB,
0x61A54437DDF6510F, 0x6FC16BA1204705D8, 0xE75302A2FC24A156, 0x3DD581A82B9B9398,
0xDBC7EB5875CE3C6B, 0x90AB626744C5345E, 0x59C0F870C32DF4B9, 0x6697A97C59547B9E,
0xFDE8D962D5602D39, 0xD3D041D7AEAC4C88, 0x5EF2153B478FDE28, 0xD4E2AC9C2A0E6619,
0x1E4A8E7DBE75B4E4, 0x72485D2A8DA1A326, 0x437B23B0EA6978D6, 0x159E9C047684D61D,
0x0F2547C45FC05A72, 0xF10E265099336551, 0x3C94E9FA89EA9D3D, 0xBFD292809D785B4A,
0x0817AA8FDB6270E3, 0x60E42C657F875FAA, 0x18390B6498A690D0, 0x478A760D7D58405D,
0x284B1DAC5D1F4585, 0xB1B6BD1660C90F9D, 0xD15291731F4E5037, 0x4D1F0C2617D82C01,
0xC70FB5817A599430, 0x6D43BB0591A51967, 0x6E8003F382360B7D, 0x1D89368BADE6A6FE,
0x4F9DDC82A63A30BE, 0xEDC6788996A4CD0A, 0xAB0D66D6498D83F2, 0x54676F102D0FB274,
0xC17C30985C8AB004, 0x3865BC471EDBA5B6, 0x3924D415BCAAAB13, 0x951B5F8871850270,
0x8A10B9A76D81B831, 0xBD5042242C9A47F5, 0xA5694940B43CD725, 0xFF6A09C664823186,
0x8D2254ECE92392A0, 0xB7C5380F461A2BA9, 0x82071328B6E3C8D2, 0xD721146A399D7403,
0xFADA342951C207A8, 0x262F323AA0AE1152, 0xF04F4E023B426BF4, 0x276E5A6802DF1FF7 };

const u64bit SHARK::TD1[256] = {
0x3B4016DBFD16E203, 0x9A7574C51174530A, 0x90012E69C02EC8D3, 0xF44580E3D780E076,
0xF81DEC2B49ECA14B, 0x26CAE3E8A6E3D7EF, 0x0962419E0C41F6AB, 0x54D1EB4070EBD951,
0x865E884B0188EEC8, 0xDF76067EA406FE8A, 0x29849412E594FBA0, 0x461569896869C0F2,
0xB5DDD6B3BBD6724E, 0x0C586CC89E6C413D, 0x6B0AD97054D904EA, 0xA135621EEC62B109,
0x0EEF7E47087EA461, 0xFAAAFEA4DFFE4417, 0xE0AD344E80342331, 0xAB4138B23D382AD0,
0x107390468E90FCFF, 0xBE0885A2218561B9, 0xDBED22957D22C132, 0x2251C7037FC7E857,
0x33835EF8BA5E9C86, 0xB3F1E0D7F4E0A8AA, 0x3FDB32302432DDBB, 0xA719547AA3546BED,
0xE10C3DF3CB3DAB1F, 0x17FEAF9F8AAFAE35, 0x9DF84B1C154B01C0, 0x8364A51D93A5595E,
0x535CD49974D48B9B, 0x01A109BD4B09882E, 0xC4D0C529B0C51182, 0x2E09ABCBE1ABA96A,
0x1F3DE7BCCDE7D0B0, 0x9317355B1D35A5A1, 0x6C87E6A950E65620, 0x8910FFB142FFC287,
0x40395FED275F1A16, 0x7B794936DA49F815, 0xF269B68798B63A92, 0xFD27C17DDBC116DD,
0x8D8BDB5A9BDBFD3F, 0x1BA6C35714C3EF08, 0x6E30F426C6F4B37C, 0x7FE26DDD036DC7AD,
0x14E8B4AD57B4C347, 0xB985BA7B25BA3373, 0xE9CF75D08C75D59A, 0x626898EE5898F241,
0x5B9F9CBA339CF51E, 0xB250E96ABFE92084, 0x165FA622C1A6261B, 0xF5E4895E9C896858,
0xB76AC43C2DC49712, 0x02B7128F9612E55C, 0x1D8AF5335BF535EC, 0x36B973AE28732B10,
0xA8572380E02347A2, 0xF6F2926C4192052A, 0x8C2AD2E7D0D27511, 0xD32E6AB63A6ABFB7,
0xBD1E9E90FC9E0CCB, 0x03161B32DD1B6D72, 0x4DC03A98F23AD305, 0x81D3B79205B7BC02,
0x450372BBB572AD80, 0x2D1FB0F93CB0C418, 0x2A928F20388F96D2, 0x721B08A8D6080EBE,
0x92B63CE6563C2D8F, 0xEB78675F1A6730C6, 0x13658B74538B918D, 0x428E4D62B14DFF4A,
0x88B1F60C09F64AA9, 0x75963771D2375C74, 0x7AD8408B9140703B, 0x57C7F072ADF0B423,
0xE5971918121994A7, 0x5666F9CFE6F93C0D, 0x8F3CC9D50DC91863, 0x1E9CEE0186EE589E,
0x8A06E4839FE4AFF5, 0xB824B3C66EB3BB5D, 0xD1997839AC785AEB, 0x6752B5B8CAB545D7,
0xB47CDF0EF0DFFA60, 0x949A0A82190AF76B, 0xC04BE1C269E12E3A, 0xFC86C8C090C89EF3,
0xE3BB2F7C5D2F4E43, 0x6AABD0CD1FD08CC4, 0x2147DC31A2DC8525, 0xCA3FBB6EB8BBB5E3,
0x48FA17CE60176493, 0x6444AE8A17AE28A5, 0x2B33869D73861EFC, 0xD0387184E771D2C5,
0x7CF476EFDE76AADF, 0x63C9915313917A6F, 0xC929A05C65A0D891, 0xDA4C2B28362B491C,
0xFE31DA4F06DA7BAF, 0xC1EAE87F22E8A614, 0x5C12A36337A3A7D4, 0x18B0D865C9D8827A,
0xE7200B97840B71FB, 0x4BEC0CFCBD0C09E1, 0x0F4E77FA43772C4F, 0x4C613325B9335B2B,
0xF3C8BF3AD3BFB2BC, 0x87FF81F64A8166E6, 0xA38270917A705455, 0x1911D1D882D10A54,
0x44A27B06FE7B25AE, 0x049B24EBD9243FB8, 0xBB32A8F4B3A8D62F, 0x91A027D48B2740FD,
0x3D6C20BFB22038E7, 0xE681022ACF02F9D5, 0xF17FADB545AD57E0, 0xCC138D0AF78D6F07,
0x495B1E732B1EECBD, 0x38560DE9200D8F71, 0xA9F62A3DAB2ACF8C, 0x47B46034236048DC,
0x8E9DC06846C0904D, 0xACCC076B3907781A, 0x32225745F15714A8, 0xD4A3556F3E55ED7D,
0xD7B54E5DE34E800F, 0xDDC114F132141BD6, 0x6D26EF141BEFDE0E, 0x85489379DC9383BA,
0x0BD553119A5313F7, 0x786F520407529567, 0xCB9EB2D3F3B23DCD, 0xA223792C3179DC7B,
0x0A745AACD15A9BD9, 0x710D139A0B1363CC, 0x681CC24289C26998, 0x1A07CAEA5FCA6726,
0x82C5ACA0D8ACD170, 0x25DCF8DA7BF8BA9D, 0xC7C6DE1B6DDE7CF0, 0xC35DFAF0B4FA4348,
0xDED70FC3EF0F76A4, 0x504ACFABA9CFE6E9, 0xC571CC94FBCC99AC, 0x5EA5B1ECA1B14288,
0xAE7B15E4AF159D46, 0xC888A9E12EA950BF, 0xF7539BD10A9B8D04, 0x962D180D8F181237,
0xE43610A559101C89, 0x772125FE4425B928, 0x84E99AC4979A0B94, 0xC667D7A626D7F4DE,
0xEFE343B4C3430F7E, 0xD5025CD2755C6553, 0xA6B85DC7E85DE3C3, 0xD61447E0A8470821,
0x3E7A3B8D6F3B5595, 0x52FDDD243FDD03B5, 0x8072BE2F4EBE342C, 0x12C482C9188219A3,
0x9EEE502EC8506CB2, 0xAD6D0ED6720EF034, 0x59288E35A58E1042, 0xE21A26C11626C66D,
0x247DF16730F132B3, 0xF0DEA4080EA4DFCE, 0x31344C772C4C79DA, 0x4F77281764283659,
0x79CE5BB94C5B1D49, 0x0000000000000000, 0x73BA01159D018690, 0x74373ECC993ED45A,
0xBCBF972DB79784E5, 0x4ED621AA2F21BE77, 0xD95A301AEB30246E, 0x9C5942A15E4289EE,
0x37187A13637AA33E, 0x276BEA55EDEA5FC1, 0x1C2BFC8E10FCBDC2, 0xED54513B5551EA22,
0x20E6D58CE9D50D0B, 0x3AE11F66B61F6A2D, 0x66F3BC0581BCCDF9, 0x2CBEB94477B94C36,
0x99636FF7CC6F3E78, 0x953B033F52037F45, 0xB0E7FBE529FBC5D8, 0x60DF8A61CE8A171D,
0x6F91FD9B8DFD3B52, 0xAAE0310F7631A2FE, 0xBFA98C1F6A8CE997, 0x8BA7ED3ED4ED27DB,
0x98C2664A8766B656, 0x062C36644F36DAE4, 0x5570E2FD3BE2517F, 0xEAD96EE2516EB8E8,
0x419856506C569238, 0x23F0CEBE34CE6079, 0x309545CA6745F1F4, 0x5A3E950778957D30,
0x617E83DC85839F33, 0xFB0BF71994F7CC39, 0x3CCD2902F929B0C9, 0x70AC1A27401AEBE2,
0xCEA49F85619F8A5B, 0x39F704546B04075F, 0x0DF96575D565C913, 0x08C3482347487E85,
0xD28F630B71633799, 0xECF558861E58620C, 0xC2FCF34DFFF3CB66, 0x978C11B0C4119A19,
0x69BDCBFFC2CBE1B6, 0xBA93A149F8A15E01, 0x51EBC616E2C66EC7, 0x078D3FD9043F52CA,
0x58898788EE87986C, 0x4A4D0541F60581CF, 0xE86E7C6DC77C5DB4, 0xEE424A09884A8750,
0xCDB284B7BC84E729, 0x65E5A7375CA7A08B, 0x2FA8A276AAA22144, 0xA0946BA3A76B3927,
0xA5AE46F535468EB1, 0x35AF689CF5684662, 0x28259DAFAE9D738E, 0xCF0596382A960275,
0xB6CBCD8166CD1F3C, 0x7E43646048644F83, 0x9BD47D785A7DDB24, 0x432F44DFFA447764,
0x9F4F59938359E49C, 0x7D557F52957F22F1, 0x76802C430F2C3106, 0xDC601D4C791D93F8,
0x053A2D56922DB796, 0x11D299FBC59974D1, 0xF9BCE59602E52965, 0xD8FB39A7A039AC40,
0x340E6121BE61CE4C, 0x5F04B851EAB8CAA6, 0x5DB3AADE7CAA2FFA, 0x1549BD101CBD4B69,
0xFF90D3F24DD3F381, 0xAFDA1C59E41C1568, 0xB146F25862F24DF6, 0xA40F4F487E4F069F };

const u64bit SHARK::TD2[256] = {
0xA1A35CEBF8F0F94C, 0x2C203D650F3F095D, 0x1A2BDAEE4084A2A7, 0xD32404574D7BCC68,
0xF785BEA594A9ADC4, 0xF2EB54456206949C, 0x3F5E334D0475CED1, 0x5994299B835D1F60,
0x785B7989AC204794, 0x025DA6A2CF461A41, 0xDF1F3A71F01A901B, 0x27284F018BB77637,
0xE1955A6D694C5310, 0x24A1BAF2D9D261AC, 0xE4FBB08D9FE36A48, 0x8D83618EF7CFF011,
0x2AC72276ABF5279E, 0xF9E32621E68EEBF6, 0xBF323FB4D3F86F69, 0xBB888605B8745BEB,
0x70DAFE1E7ACD2F65, 0xD0ADF1A41F1EDBF3, 0x1E91635F2B089625, 0xEE2791B8864818F8,
0x99CE23E4C56C1484, 0xF33F0714FF259946, 0xBD6F99161CBE7528, 0x9F293CF761A63A47,
0xB80173F6EA114C70, 0x6543EF25D54DC62A, 0x39B92C5EA0BFE012, 0x63A4F0367187E8E9,
0x4C0D38A02CDDF62F, 0x07334C4239E92319, 0x43BFF375C3D9BDC7, 0xCA862B4A5F9A7954,
0x5D2E902AE8D12BE2, 0x137E0E280B4AC78C, 0xF162A1B630638307, 0x55AF17BD3E3C4313,
0x358212781DDEBC61, 0x94214E93E52E452D, 0xC18E592EDB12063E, 0xEC7A371A490E02B9,
0x4963D240DA72CF77, 0x41E255D70C9FA786, 0xFF0439324244C535, 0x88ED8B6E0160C949,
0x6C163BE39E83A301, 0xC534E09FB09E32BC, 0x806C0CF9D78DA1B8, 0xDBA583C09B96A499,
0x746047AF11411BE7, 0xF40C4B56C6CCBA5F, 0x6270A367ECA4E533, 0xD41748157492EF71,
0xEFF3C2E91B6B1522, 0x0E66988472274632, 0x534808AE9AF66DD0, 0x8231AA5B18CBBBF9,
0xB2DD52C3F3BA3EC0, 0xDD429CD33F5C8A5A, 0x4E509E02E39BEC6E, 0x26FC1C5016947BED,
0xD9F8256254D0BED8, 0x0955D4C64BCE652B, 0x1610E4C8FDE5FED4, 0x6DC268B203A0AEDB,
0x2E7D9BC7C079131C, 0xC3D3FF8C14541C7F, 0xD64AEEB7BBD4F530, 0xAB7F7DDEE15B8BFC,
0x144D426A32A3E495, 0x8E0A947DA5AAE78A, 0x798F2AD831034A4E, 0x3BE48AFC6FF9FA53,
0x529C5BFF07D5600A, 0xBEE66CE54EDB62B3, 0x931202D1DCC76634, 0x50C1FD5DC8937A4B,
0xA4CDB60B0E5FC014, 0x57F2B11FF17A5952, 0x47054AC4A8558945, 0x5A1DDC68D13808FB,
0x5CFAC37B75F22638, 0xC207ACDD897711A5, 0x289A84D464B33DDF, 0xC05A0A7F46310BE4,
0xE6A6162F50A57009, 0x06E71F13A4CA2EC3, 0x5F733688279731A3, 0xEB497B5870E721A0,
0xB667EB7298360A42, 0xE3C8FCCFA60A4951, 0xE772457ECD867DD3, 0x6978D103682C9A59,
0x0DEF6D77204251A9, 0xC90FDEB90DFF6ECF, 0xD179A2F5823DD629, 0x2FA9C8965D5A1EC6,
0x81B85FA84AAEAC62, 0xDC96CF82A27F8780, 0x602D05C523E2FF72, 0x19A22F1D12E1B53C,
0xE52FE3DC02C06792, 0x58407ACA1E7E12BA, 0x61F95694BEC1F2A8, 0x48B781114751C2AD,
0xAAAB2E8F7C788626, 0x04BAB9B16B8C3482, 0x2DF46E34921C0487, 0x1123A88AC40CDDCD,
0xC6BD156CE2FB2527, 0x7F6835CB95C9648D, 0x83E5F90A85E8B623, 0x4F84CD537EB8E1B4,
0x294ED785F9903005, 0x1CCCC5FDE44E8C64, 0xCB52781BC2B9748E, 0x1D1896AC796D81BE,
0xB30901926E99331A, 0xAD9862CD4591A53F, 0xC8DB8DE890DC6315, 0x7BD28C7AFE45500F,
0x0ADC213519AB72B0, 0xA8F6882DB33E9C67, 0xB5EE1E81CA531DD9, 0x201B0343B25E552E,
0x4036068691BCAA5C, 0xAE11973E17F4B2A4, 0x9EFD6FA6FC85379D, 0x33650D6BB91492A2,
0x3A30D9ADF2DAF789, 0x0C3B3E26BD615C73, 0xF651EDF4098AA01E, 0x710EAD4FE7EE22BF,
0x3138ABC9765288E3, 0x9D749A55AEE02006, 0x6E4B9D4151C5B940, 0x84D6B548BC01953A,
0x360BE78B4FBBABFA, 0xA22AA918AA95EED7, 0xEDAE644BD42D0F63, 0x46D119953576849F,
0x6497BC74486ECBF0, 0xFBBE808329C8F1B7, 0x4AEA27B38817D8EC, 0x5626E24E6C595488,
0x056EEAE0F6AF3958, 0x4558EC6667139304, 0x448CBF37FA309EDE, 0x6F9FCE10CCE6B49A,
0xA0770FBA65D3F496, 0x671E49871A0BDC6B, 0xDA71D09106B5A943, 0x08818797D6ED68F1,
0xA3FEFA4937B6E30D, 0xB080F4613CFC2481, 0x763DE10DDE0701A6, 0x4DD96BF1B1FEFBF5,
0x92C6518041E46BEE, 0x3456412980FDB1BB, 0x981A70B5584F195E, 0x3D0395EFCB33D490,
0xBA5CD55425575631, 0x4B3E74E21534D536, 0x6AF124F03A498DC2, 0x7EBC669A08EA6957,
0x30ECF898EB718539, 0xA922DB7C2E1D91BD, 0x7A06DF2B63665DD5, 0xB154A730A1DF295B,
0xFC8DCCC11021D2AE, 0xCFE8C1AAA935400C, 0x97A8BB60B74B52B6, 0x18767C4C8FC2B8E6,
0x9A47D6179709031F, 0x0000000000000000, 0xAC4C319CD8B2A8E5, 0xB9D520A7773241AA,
0xDECB69206D399DC1, 0x1F45300EB62B9BFF, 0x10F7FBDB592FD017, 0x3E8A601C9956C30B,
0x8502E619212298E0, 0xF5D818075BEFB785, 0x547B44ECA31F4EC9, 0x9CA0C90433C32DDC,
0xE041093CF46F5ECA, 0xA69010A9C119DA55, 0xC769463D7FD828FD, 0xC4E0B3CE2DBD3F66,
0x2575E9A344F16C76, 0x01D453519D230DDA, 0xFA6AD3D2B4EBFC6D, 0xD5C31B44E9B1E2AB,
0xF83775707BADE62C, 0xBCBBCA47819D78F2, 0xD79EBDE626F7F8EA, 0x5BC98F394C1B0521,
0x2246A5E17D184F6F, 0x12AA5D799669CA56, 0x5EA765D9BAB43C79, 0x8939D83F9C43C493,
0x32B15E3A24379F78, 0xE914DDFABFA13BE1, 0x909BF7228EA271AF, 0x73530BED28A838FE,
0xD2F05706D058C1B2, 0xFED06A63DF67C8EF, 0xB43A4DD057701003, 0xA519E55A937CCDCE,
0x75B414FE8C62163D, 0xAFC5C46F8AD7BF7E, 0x2392F6B0E03B42B5, 0x386D7F0F3D9CEDC8,
0x21CF50122F7D58F4, 0x9B9385460A2A0EC5, 0x5115AE0C55B07791, 0x0FB2CBD5EF044BE8,
0xEA9D2809EDC42C7A, 0xCC613459FB505797, 0x426BA0245EFAB01D, 0x1599113BAF80E94F,
0x7D3593695A8F7ECC, 0x0389F5F35265179B, 0x875F40BBEE6482A1, 0x95F51DC2780D48F7,
0x7CE1C038C7AC7316, 0xCE3C92FB34164DD6, 0xCDB5670866735A4D, 0x8AB02DCCCE26D308,
0x914FA47313817C75, 0x8B647E9D5305DED2, 0xD82C7633C9F3B302, 0x728758BCB58B3524,
0xE8C08EAB2282363B, 0x8FDEC72C3889EA50, 0x2B13712736D62A44, 0x3CD7C6BE5610D94A,
0x37DFB4DAD298A620, 0x868B13EA73478F7B, 0xB7B3B82305150798, 0x0B08726484887F6A,
0x1BFF89BFDDA7AF7D, 0x77E9B25C43240C7C, 0xF0B6F2E7AD408EDD, 0x17C4B79960C6F30E,
0x8C5732DF6AECFDCB, 0x68AC8252F50F9783, 0x66CA1AD68728D1B1, 0x6B2577A1A76A8018,
0xE21CAF9E3B29448B, 0xA74443F85C3AD78F, 0xFD599F908D02DF74, 0x967CE8312A685F6C };

const u64bit SHARK::TD3[256] = {
0xFA7B9775BA3AF751, 0x03EF98CB769C2D13, 0x7191CE067072359E, 0xBAB18B6BFF7516A8,
0xE6E5EF4EFBC1065E, 0x7BEC74A3B1D0DBF4, 0x656B4FB907C31C4A, 0x4E8520F99FC86304,
0x8FD8DF31D16DAE58, 0x90A93FC1E60A7244, 0x30AD09F2B449CFC5, 0x8453BE7E91BB5B90,
0x1D68A3D1C08FEAAD, 0x5C54642504B410F6, 0x8061383C8A9E3707, 0xF9940FBECCA6DA42,
0x46E1D97DA982BBDF, 0xFC50521656F7AD77, 0x5E4D2704F35C2647, 0x8BEA5973CA48C2CF,
0xD06323DFA34593BD, 0x62B651306A7A5DCE, 0xA436B0714966D116, 0x4F73FB131EBC78A6,
0x92B07CE011E244F5, 0x33429139C2D5E2D6, 0xCEE418C515565403, 0xD7BE3D56CEFCD239,
0x53ED83285F4789A9, 0xF3E9B51B0D043428, 0x20650E0FD8DD8A86, 0xB6E7F4ADD21AA2E4,
0x6D0FB63D3189C491, 0x0DA0A42CAC1BAFEE, 0x3F14EEFFEFBA569A, 0x13279F361A086850,
0x9B225E8EA6DC878C, 0x6684D772715F3159, 0xA3EBAEF824DF9092, 0xC499A260D4F4BA69,
0xAA798C9693E153EB, 0x50021BE329DBA4BA, 0x949BB983FD2F1ED3, 0xDFDAC4D2F8B60AE2,
0xF0062DD07B98193B, 0xAFBDD13E09B024DE, 0xB95E13A089E93BBB, 0x649D945386B707E8,
0xE4FCAC6F0C2930EF, 0x413CC7F4C43BFA5B, 0x3B2668BDF49F3A0D, 0xE50A77858D5D2B4D,
0x05C45DA89A517735, 0x3EE235156ECE4D38, 0xFE491137A11F9BC6, 0xB7112F47536EB946,
0x07DD1E896DB94184, 0x1AB5BD58AD36AB29, 0x8197E3D60BEA2CA5, 0xAB8F577C12954849,
0x9CFF4007CB65C608, 0xA00436335243BD81, 0xFDA689FCD783B6D5, 0xCCFD5BE4E2BE62B2,
0x75A348446B575909, 0x17151974012D04C7, 0xFB8D4C9F3B4EECF3, 0xAC5249F57F2C09CD,
0x9346A70A90965F57, 0x043286421B256C97, 0x27B81086B564CB02, 0x3569545A2E18B8F0,
0x6B24735EDD449EB7, 0x2193D5E559A99124, 0xC7763AABA268977A, 0xB0CC31CE3ED7F8C2,
0xC939064C78EF1587, 0x16E3C29E80591F65, 0x5DA2BFCF85C00B54, 0x5990398D9EE567C3,
0x67720C98F02B2AFB, 0x54309DA132FEC82D, 0xEAB39088D6AEB212, 0x9682FAA20AC72862,
0xD38CBB14D5D9BEAE, 0x4C9C63D8682055B5, 0xD648E6BC4F88C99B, 0xDC355C198E2A27F1,
0x10C807FD6C944543, 0x450E41B6DF1E96CC, 0x0B8B614F40D6F5C8, 0xD27A60FE54ADA50C,
0x49583E70F2712280, 0x8DC19C10268598E9, 0x5866E2671F917C61, 0x79F537824638ED45,
0xC2B267033839E04F, 0xCB20456D8F072336, 0x2A18B4AA197F64EC, 0xDBE84290E3936675,
0x73888D27879A032F, 0xE8AAD3A9214684A3, 0x6EE02EF64715E982, 0xA996145DE57D7EF8,
0xC8CFDDA6F99B0E25, 0x062BC563ECCD5A26, 0x264ECB6C3410D0A0, 0xB8A8C84A089D2019,
0x7DC7B1C05D1D81D2, 0xD5A77E773914E488, 0x4B417D5105991431, 0xF62DE8B39755431D,
0x993B1DAF5134B13D, 0x82787B1D7D7601B6, 0xE321B2E66190716B, 0xB5086C66A4868FF7,
0x9EE603263C8DF0B9, 0x349F8FB0AF6CA352, 0x5B897AAC690D5172, 0x7C316A2ADC699A70,
0xD451A59DB860FF2A, 0x706715ECF1062E3C, 0x838EA0F7FC021A14, 0x57DF056A4462E53E,
0xCF12C32F94224FA1, 0xED6E8E01BB17F396, 0x915FE42B677E69E6, 0x89F31A523DA0F47E,
0xE71334A47AB51DFC, 0xA860CFB76409655A, 0x9F10D8CCBDF9EB1B, 0xEF77CD204CFFC527,
0xF862D4544DD2C1E0, 0x8A1C82994B3CD96D, 0xAE4B0AD488C43F7C, 0x98CDC645D040AA9F,
0x7FDEF2E1AAF5B763, 0x4717029728F6A07D, 0x745593AEEA2342AB, 0xEE8116CACD8BDE85,
0x727E56CD06EE188D, 0x227C4D2E2F35BC37, 0x977421488BB333C0, 0xA21D7512A5AB8B30,
0xBB4750817E010D0A, 0x6CF96DD7B0FDDF33, 0x2801F78BEE97525D, 0x1C9E783B41FBF10F,
0x9D099BED4A11DDAA, 0x7A1AAF4930A4C056, 0x32B44AD343A1F974, 0x3CFB763499267B89,
0xB2D572EFC93FCE73, 0x63408ADAEB0E466C, 0xADA4921FFE58126F, 0x5FBBFCEE72283DE5,
0x6AD2A8B45C308515, 0x0C567FC62D6FB44C, 0x956D62697C5B0571, 0x25A153A7428CFDB3,
0x150C5A55F6C53276, 0xE2D7690CE0E46AC9, 0xDA1E997A62E77DD7, 0xF5C27078E1C96E0E,
0xC344BCE9B94DFBED, 0x60AF12119D926B7F, 0xA1F2EDD9D337A623, 0xCAD69E870E733894,
0x3770177BD9F08E41, 0xA5C06B9BC812CAB4, 0x1F71E0F03767DC1C, 0x44F89A5C5E6A8D6E,
0x6159C9FB1CE670DD, 0x8E2E04DB5019B5FA, 0x8805C1B8BCD4EFDC, 0xE138F1C7967847DA,
0x4AB7A6BB84ED0F93, 0x0000000000000000, 0x38C9F0768203171E, 0x1B4366B22C42B08B,
0x7803EC68C74CF6E7, 0xEC9855EB3A63E834, 0xBE830D29E4507A3F, 0x2DC5AA2374C62568,
0xA62FF350BE8EE7A7, 0x764CD08F1DCB741A, 0x8C3747FAA7F1834B, 0x0FB9E70D5BF3995F,
0x55C6464BB38AD38F, 0xF7DB3359162158BF, 0xD195F8352231881F, 0x0992226EB73EC379,
0x14FA81BF77B129D4, 0x48AEE59A73053922, 0x2457884DC3F8E611, 0xFFBFCADD206B8064,
0xB4FEB78C25F29455, 0x864AFD5F66536D21, 0x6F16F51CC661F220, 0xDE2C1F3879C21140,
0x195A2593DBAA863A, 0x2E2A32E8025A087B, 0x432584D533D3CCEA, 0x2C3371C9F5B23ECA,
0xA7D928BA3FFAFC05, 0x42D35F3FB2A7D748, 0x85A5659410CF4032, 0x0864F984364AD8DB,
0xF21F6EF18C702F8A, 0xF1F0F63AFAEC0299, 0xD9F101B1147B50C4, 0x2FDCE902832E13D9,
0x4D6AB832E9544E17, 0xE0CE2A2D170C5C78, 0x51F4C009A8AFBF18, 0x68CBEB95ABD8B3A4,
0xC15DFFC84EA5CD5C, 0x02194321F7E836B1, 0x113EDC17EDE05EE1, 0x521B58C2DE33920B,
0x9AD4856427A89C2E, 0x5629DE80C516FE9C, 0x77BA0B659CBF6FB8, 0x238A96C4AE41A795,
0x12D144DC9B7C73F2, 0xD807DA5B950F4B66, 0x3686CC91588495E3, 0x18ACFE795ADE9D98,
0x5A7FA146E8794AD0, 0xC680E141231C8CD8, 0x1E873B1AB613C7BE, 0xF434AB9260BD75AC,
0xCD0B800E63CA7910, 0xBC9A4E0813B84C8E, 0x3D0DADDE1852602B, 0x40CA1C1E454FE1F9,
0x0A7DBAA5C1A2EE6A, 0x693D307F2AACA806, 0x0E4F3CE7DA8782FD, 0xBD6C95E292CC572C,
0x3AD0B35775EB21AF, 0x7E28290B2B81ACC1, 0x01F6DBEA81741BA2, 0x87BC26B5E7277683,
0x393F2B9C03770CBC, 0xDDC387F30F5E3C53, 0xEB454B6257DAA9B0, 0xB323A905484BD5D1,
0xB13AEA24BFA3E360, 0x315BD218353DD467, 0x2BEE6F40980B7F4E, 0xE95C0843A0329F01,
0xC56F798A5580A1CB, 0xBF75D6C36524619D, 0x29F72C616FE349FF, 0xC0AB2422CFD1D6FE };

const u64bit SHARK::TD4[256] = {
0x561FC423E957943C, 0x014287CA69079288, 0x2F086129DFCD1D21, 0xC537D4AEA044FD99,
0xF1E8C3BFD7C8A457, 0x2971998A5CDF9BFB, 0x23FA649A2CE9E460, 0x3AA9E9C356A6716A,
0xD6EFA4E7AA3D1708, 0x705A24B1FDA5B5EB, 0x101E0CE2B170A9FC, 0x7CA821020E814CAA,
0x0BC97ADA1931ED13, 0x34DF1711778C59CE, 0xD35020EF9226D2BF, 0x575D43E9805006B4,
0x91ACEBEC9B1DB840, 0x549B3F423B5945D9, 0x99A3ED9D3925163E, 0x7917A50A369A891D,
0xE372343CB4B6DC4E, 0x8D40E2BDD949E8FD, 0xCFBC29BED0728202, 0x969794857108AC12,
0xDD26DE3DB30CFA1B, 0x115C8B28D8773B74, 0xE9F9C92CC480A3D5, 0x4DC8B21B4116D0D3,
0x316093194F979C79, 0x5124BB4A0342806E, 0xB31408BCDEF3CEA8, 0xC1CAD76CF158AAA6,
0x88FF66B5E1522D4A, 0xA8C37E8476B28A47, 0x15A188EA896B6C4B, 0xA24883940684F5DC,
0xDA1DA1545919EE49, 0x22B8E35045EE76E8, 0x6106AF9925D28E9F, 0xEF80318F4792250F,
0x663DD0F0CFC79ACD, 0x302214D326900EF1, 0xDFA2255C61022BFE, 0xE6CDB0348CAD19F9,
0x50663C806A4512E6, 0x65FBAC5B74CED9A0, 0xC4755364C9436F11, 0x8FC419DC0B473918,
0x5C9439339961EBA7, 0x3F166DCB6EBDB4DD, 0xBA59890715CCF25E, 0xF0AA4475BECF36DF,
0x03C67CABBB09436D, 0xB99FF5ACAEC5B133, 0xF9E7C5CE75F00A29, 0x6DF4AA2AD6F677DE,
0xAEBA8627F5A00C9D, 0xA573FCFDEC91E18E, 0x7F6E5DA9B5880FC7, 0xCA03ADB6E86947B5,
0x74A72773ACB9E2D4, 0x604428534CD51C17, 0xF8A542041CF798A1, 0x448533A08A29EC25,
0x80F060C4436A8334, 0x0DB082799A236BC9, 0xFA21B965CEF94944, 0x64B92B911DC94B28,
0x7118A37B94A22763, 0xAFF801ED9CA79E15, 0x1DAE8E9B2B53C235, 0x13D870490A79EA91,
0x8A7B9DD4335CFCAF, 0x1F2A75FAF95D13D0, 0xEEC2B6452E95B787, 0xC34E2C0D23567B43,
0x47434F0B3120AF48, 0xA18EFF3FBD8DB6B1, 0x98E16A57502284B6, 0x37196BBACC851AA3,
0x8E869E166240AB90, 0x9FDA153EBA3790E4, 0xF515C07D86D4F368, 0x72DEDFD02FAB640E,
0xE230B3F6DDB14EC6, 0x97D5134F180F3E9A, 0xE1F6CF5D66B80DAB, 0xE78F37FEE5AA8B71,
0xA30A045E6F836754, 0x90EE6C26F21A2AC8, 0xAA4785E5A4BC5BA2, 0x4E0ECEB0FA1F93BE,
0x94136FE4A3067DF7, 0x7B935E6BE49458F8, 0x9B2716FCEB2BC7DB, 0x840D63061276D40B,
0xED04CAEE959CF4EA, 0xEA3FB5877F89E0B8, 0xB56DF01F5DE14872, 0x4935B1D9100A87EC,
0x82749BA5916452D1, 0x58693AF1C87DBC98, 0x89BDE17F8855BFC2, 0x677F573AA6C00845,
0xEB7D324D168E7230, 0x0284FB61D20ED1E5, 0xB190F3DD0CFD1F4D, 0x684B2E22EEEDB269,
0x2BF562EB8ED14A1E, 0xE0B448970FBF9F23, 0x396F9568EDAF3207, 0x52E2C7E1B84BC303,
0x77615BD817B0A1B9, 0x7E2CDA63DC8F9D4F, 0xF22EBF146CC1E73A, 0xC08850A6985F382E,
0xD9DBDDFFE210AD24, 0xBFE60D0F2DD737E9, 0x9A659136822C5553, 0x87CB1FADA97F9766,
0x4C8A35D12811425B, 0x83361C6FF863C059, 0xD212A725FB214037, 0x9E9892F4D330026C,
0x45C7B46AE32E7EAD, 0x5BAF465A7374FFF5, 0xDC6459F7DA0B6893, 0xD46B5F867833C6ED,
0x5DD6BEF9F066792F, 0xCB412A7C816ED53D, 0x75E5A0B9C5BE705C, 0xF6D3BCD63DDDB005,
0xFB633EAFA7FEDBCC, 0xD529D84C11345465, 0xC9C5D11D536004D8, 0xDB5F269E301E7CC1,
0x86899867C07805EE, 0x3D9296AABCB36538, 0x2CCE1D8264C45E4C, 0x5AEDC1901A736D7D,
0x2E4AE6E3B6CA8FA9, 0x1E68F230905A8158, 0xDEE0A2960805B976, 0xCD38D2DF027C53E7,
0x6909A9E887EA20E1, 0x24C11BF3C6FCF032, 0x18110A9313480782, 0xA7F7079C3E9F306B,
0xD8995A358B173FAC, 0x854FE4CC7B714683, 0xBD62F66EFFD9E60C, 0x14E30F20E06CFEC3,
0x6E32D6816DFF34B3, 0x217E9FFBFEE73585, 0xC88756D73A679650, 0x359D90DB1E8BCB46,
0x2645E09214F221D7, 0x04FD03C2511C573F, 0x739C581A46ACF686, 0xB0D2741765FA8DC5,
0xA0CC78F5D48A2439, 0x5E10C2524B6F3A42, 0xE50BCC9F37A45A94, 0x53A0402BD14C518B,
0x413AB7A8B2322992, 0x203C183197E0A70D, 0xCC7A55156B7BC16F, 0x4601C8C158273DC0,
0xBEA48AC544D0A561, 0x638254F8F7DC5F7A, 0xA6B580565798A2E3, 0x3CD01160D5B4F7B0,
0x8C026577B04E7A75, 0x7AD1D9A18D93CA70, 0x785522C05F9D1B95, 0x5F5245982268A8CA,
0x9551E82ECA01EF7F, 0x0000000000000000, 0xBB1B0ECD7CCB60D6, 0x094D81BBCB3F3CF6,
0x28331E4035D80973, 0xF7913B1C54DA228D, 0x6ACFD5433CE3638C, 0x1BD77638A84144EF,
0x62C0D3329EDBCDF2, 0x81B2E70E2A6D11BC, 0xD7AD232DC33A8580, 0x05BF8408381BC5B7,
0x33E468789D994D9C, 0xFEDCBAA79FE51E7B, 0x4F4C497A93180136, 0x073B7F69EA151452,
0x0CF205B3F324F941, 0x382D12A284A8A08F, 0x1CEC0951425450BD, 0x55D9B888525ED751,
0x6CB62DE0BFF1E556, 0xD1D4DB8E4028035A, 0x25839C39AFFB62BA, 0x4AF3CD72AB03C481,
0xA4317B3785967306, 0x1A95F1F2C146D667, 0x926A97472014FB2D, 0xB7E90B7E8FEF9997,
0xCEFEAE74B975108A, 0x3E54EA0107BA2655, 0xD0965C44292F91D2, 0xAB05022FCDBBC92A,
0xFD1AC60C24EC5D16, 0xFC5841C64DEBCF9E, 0xE4494B555EA3C81C, 0xB6AB8CB4E6E80B1F,
0x3BEB6E093FA1E3E2, 0xF36C38DE05C675B2, 0x9C1C6995013ED389, 0x8B391A1E5A5B6E27,
0xEC464D24FC9B6662, 0xAD7CFA8C4EA94FF0, 0x0F347918482DBA2C, 0x9D5EEE5F68394101,
0x7623DC127EB73331, 0x32A6EFB2F49EDF14, 0x2D8C9A480DC3CCC4, 0xB2568F76B7F45C20,
0x0E76FED2212A28A4, 0x48773613790D1564, 0x129AF783637E7819, 0x080F0671A238AE7E,
0x365BEC70A582882B, 0x42FCCB03093B6AFF, 0x0A8BFD1070367F9B, 0xFF9E3D6DF6E28CF3,
0xE8BB4EE6AD87315D, 0xC7B32FCF724A2C7C, 0xB8DD7266C7C223BB, 0x9328108D491369A5,
0x0679F8A3831286DA, 0x270767587DF5B35F, 0xA981F94E1FB518CF, 0x6B8D528955E4F104,
0x1667F44132622F26, 0x2AB7E521E7D6D896, 0xAC3E7D4627AEDD78, 0x7DEAA6C86786DE22,
0x1725738B5B65BDAE, 0x4BB14AB8C2045609, 0x592BBD3BA17A2E10, 0xC20CABC74A51E9CB,
0x6F70514B04F8A63B, 0xBC2071A496DE7484, 0x19538D597A4F950A, 0xF45747B7EFD361E0,
0x43BE4CC9603CF877, 0xC6F1A8051B4DBEF4, 0xB42F77D534E6DAFA, 0x40783062DB35BB1A };

const u64bit SHARK::TD5[256] = {
0xF5A96C292DEB0A4E, 0x211C9DF6EE653C51, 0x04DE5DDCBEEEF596, 0xE1E5B06F7457C19F,
0x74CA30F014A54FB6, 0xC296F9F7C5457D85, 0x7D4EE08A484D10B0, 0xAE87F2D0BF9B13AD,
0x8DF4BB480E89AFB7, 0x2D8B7A67D9A2D61E, 0x0F3559C8BD712ADB, 0x541BC7312F013338,
0x9EC4848B636D5164, 0x952F809F60F28E29, 0x28984D8CB28D6357, 0xD4B5F1DFC38E361F,
0x5674135F7076B373, 0xB791A330042172EC, 0xAB94C53BD4B4A6E4, 0xF17731F59305FFD8,
0x39C7A621801E1DCF, 0x20D1F7C13BA47C8E, 0x5E3DA912F95FACAA, 0xB1202A82E5B80731,
0x13303FC36DE4FED3, 0x2E29C43E5314168A, 0x861FBF5C0D1670FA, 0x6458B16AF3F771F1,
0x3043765BDCF642C9, 0x12FD55F4B825BE0C, 0x0A266E23D65E9F92, 0x6595DB5D2636312E,
0x85BD010587A0B06E, 0x9BD7B3600842E42D, 0xAA59AF0C0175E63B, 0x240FAA1D854A8918,
0xF464061EF82A4A91, 0x5C527D7CA6282CE1, 0x03A2BE598AB6C094, 0x40571B7776BDF8E9,
0xE4F687841F7874D6, 0x115FEBAD32937E98, 0x5108F0DA442E8671, 0x9CAB50E53C1AD12F,
0x33E1C8025640825D, 0x87D2D56BD8D73025, 0xC0F92D999A32FDCE, 0x62E938D8126E042C,
0x4A717554A0E3677B, 0x0BEB0414039FDF4D, 0xD6DA25B19CF9B654, 0x55D6AD06FAC073E7,
0x632452EFC7AF44F3, 0xB5FE775E5B56F2A7, 0x892AE694B0675A21, 0x7A32030F7C1525B2,
0x5D9F174B73E96C3E, 0xC35B93C010843D5A, 0x373F95DEE8AE77CB, 0xFB515FD6455B604A,
0xA9FB11558BC326AF, 0x22BE23AF64D3FCC5, 0xA8367B625E026670, 0xB8A4FAF8B9505837,
0x785DD7612362A5F9, 0x588C20A018C6D977, 0xEA0EB47B77C81ED2, 0xA6CE489D36B20C74,
0x0C97E79137C7EA4F, 0x7C838ABD9D8C506F, 0x57B97968A5B7F3AC, 0x6C110B277ADE6E28,
0xC785CE1CAE6AC8CC, 0x1581B6718C7D8B0E, 0x614B868198D8C4B8, 0x27AD14440FFC498C,
0xDB80A8177EFF1CC4, 0x472BF8F242E5CDEB, 0x8A8858CD3AD19AB5, 0xF60BD270A75DCADA,
0x43F5A52EFC0B387D, 0x6DDC6110AF1F2EF7, 0xF0BA5BC246C4BF07, 0x6FB3B57EF068AEBC,
0x18DB3BD76E7B219E, 0x903CB7740BDD3B60, 0x7BFF6938A9D4656D, 0xBDB7CD13D27FED7E,
0x051337EB6B2FB549, 0x77688EA99E138F22, 0xD9EF7C7921889C8F, 0x077CE38534583502,
0xF318E59BCC727F93, 0xB34FFEECBACF877A, 0xE9AC0A22FD7EDE46, 0xFC2DBC5371035548,
0x026FD46E5F77804B, 0xE53BEDB3CAB93409, 0xCC6ECA08ADF51781, 0xE028DA58A1968140,
0x3A6518780AA8DD5B, 0xCE011E66F28297CA, 0xA4A19CF369C58C3F, 0xC5EA1A72F11D4887,
0xC427704524DC0858, 0x4238CF1929CA78A2, 0x481EA13AFF94E730, 0xDF5EF5CBC011E952,
0x80AE36EEEC8F0527, 0x5AE3F4CE47B1593C, 0xCDA3A03F7834575E, 0x71D9071B7F8AFAFF,
0xCADF43BA4C6C625C, 0x1623082806CB4B9A, 0x17EE621FD30A0B45, 0x448946ABC8530D7F,
0x974054F13F850E62, 0x73B6D37520FD7AB4, 0xC8B097D4131BE217, 0x9F09EEBCB6AC11BB,
0x45442C9C1D924DA0, 0x1B79858EE4CDE10A, 0x0984D07A5CE85F06, 0x4CC0FCE6417A12A6,
0x99B8670E57356466, 0xAD254C89352DD339, 0x322CA2358381C282, 0xCFCC74512743D715,
0x6B6DE8A24E865B2A, 0xDA4DC220AB3E5C1B, 0x88E78CA365A61AFE, 0x939E092D816BFBF4,
0xCB12298D99AD2283, 0xEED0E9A7C926EB44, 0x98750D3982F424B9, 0xD5789BE8164F76C0,
0xBE15734A58C92DEA, 0x49D3CB0D2A55A7EF, 0x67FA0F337941B165, 0x8C39D17FDB48EF68,
0x25C2C02A508BC9C7, 0x349D2B876218B75F, 0x70146D2CAA4BBA20, 0x1C05660BD095D408,
0xFE42683D2E74D503, 0x9A1AD957DD83A4F2, 0xF2D58FAC19B33F4C, 0x81635CD9394E45F8,
0xB65CC907D1E03233, 0xDD3121A59F666919, 0x318E1C6C09370216, 0x8B4532FAEF10DA6A,
0x191651E0BBBA6141, 0x3F762F9361876812, 0xB96990CF6C9118E8, 0xB4331D698E97B278,
0xD822164EF449DC50, 0x84706B325261F0B1, 0x4EAF28881E0D92ED, 0x69023CCC11F1DB61,
0x66376504AC80F1BA, 0x0849BA4D89291FD9, 0xFF8F020AFBB595DC, 0x50C59AED91EFC6AE,
0x1DC80C3C055494D7, 0x1E6AB2658FE25443, 0x3D19FBFD3EF0E859, 0xFA9C35E1909A2095,
0x52AA4E83CE9846E5, 0x419A7140A37CB836, 0xA07FC12FD72B79A9, 0x68CF56FBC4309BBE,
0x01CD6A37D5C140DF, 0x9253631A54AABB2B, 0xD06BAC037D60C389, 0x295527BB674C2388,
0xD204786D221743C2, 0x0000000000000000, 0xF7C6B847729C8A05, 0xDCFC4B924AA729C6,
0xE38A64012B2041D4, 0xB28294DB6F0EC7A5, 0x9D663AD2E9DB91F0, 0x91F1DD43DE1C7BBF,
0x6086ECB64D198467, 0x59414A97CD0799A8, 0xACE826BEE0EC93E6, 0xA56CF6C4BC04CCE0,
0x727BB942F53C3A6B, 0x6E7EDF4925A9EE63, 0x26607E73DA3D0953, 0xE75439DD95CEB442,
0x7990BD56F6A3E526, 0xECBF3DC996516B0F, 0x76A5E49E4BD2CFFD, 0x968D3EC6EA444EBD,
0x5B2E9EF9927019E3, 0x6AA082959B471BF5, 0xBB0644A133E698A3, 0x830C88B76639C5B3,
0xE2470E36FEE1010B, 0xB0ED40B5307947EE, 0x355041B0B7D9F780, 0x8E560511843F6F23,
0x7F2134E4173A90FB, 0x2AF799E2EDFAE31C, 0x4BBC1F63752227A4, 0xF8F3E18FCFEDA0DE,
0x0D5A8DA6E206AA90, 0x2C4610500C6396C1, 0xDE939FFC15D0A98D, 0xAF4A98E76A5A5372,
0x8F9B6F2651FE2FFC, 0x36F2FFE93D6F3714, 0x0EF833FF68B06A04, 0xE69953EA400FF49D,
0x23734998B112BC1A, 0x3EBB45A4B44628CD, 0x1AB4EFB9310CA1D5, 0x2FE4AE0986D55655,
0xEBC3DE4CA2095E0D, 0x536724B41B59063A, 0x46E692C597248D34, 0x2B3AF3D5383BA3C3,
0x3BA8724FDF699D84, 0xC13447AE4FF3BD11, 0x4D0D96D194BB5279, 0xFDE0D664A4C21597,
0xD7174F864938F68B, 0x7EEC5ED3C2FBD024, 0xBFD8197D8D086D35, 0x4F6242BFCBCCD232,
0xA70322AAE3734CAB, 0xA3DD7F765D9DB93D, 0x94E2EAA8B533CEF6, 0x144CDC4659BCCBD1,
0xC648A42B7BAB8813, 0xF93E8BB81A2CE001, 0xBACB2E96E627D87C, 0xBC7AA72407BEADA1,
0xC97DFDE3C6DAA2C8, 0xA1B2AB1802EA3976, 0x1FA7D8525A23149C, 0x75075AC7C1640F69,
0xE861601528BF9E99, 0xA2101541885CF9E2, 0xEF1D83901CE7AB9B, 0x06B189B2E19975DD,
0x380ACC1655DF5D10, 0x1092819AE7523E47, 0xD3C9125AF7D6031D, 0xD1A6C634A8A18356,
0x5FF0C3252C9EEC75, 0x82C1E280B3F8856C, 0xED7257FE43902BD0, 0x3CD491CAEB31A886 };

const u64bit SHARK::TD6[256] = {
0x94AF9EB6FAD9E7DF, 0x9208AE5E03C94DDD, 0x1D8DE8D67158480B, 0xFD093CD2BA147AF8,
0xA45CEB22E6597CCF, 0x9BBDE6E77BF113DA, 0xE4EDF4B465FFFE5C, 0x7125622E4E8D2A2F,
0x1791B81B8F68430D, 0xB56A63D1902195C0, 0xA980832B30D2EE67, 0x4C0A7FB384862397,
0xED58BC0D1DC7A05B, 0x5955D7F05C4D0637, 0xD2B9B1C8806FCF4E, 0x06A730E8F910AA02,
0xB8B60BD846AA0768, 0x45BF370AFCBE7D90, 0x16F6B0375EC370A1, 0x892276608B81AFD4,
0xDCCCC1B5D0EC08E7, 0xE856949162DF5F58, 0x82592E81A41A977E, 0xAC8EABB74FCA1164,
0xFAC9041692AFE356, 0x3B882D75331BA3BA, 0xA39CD3E6CEE2E561, 0xD077A190D7CCA9E3,
0x9C7DDE23534A8A74, 0x80973ED9F3B9F1D3, 0xCE535132209CB4E9, 0xAA299B5FB6DABB66,
0x2D7E9D426DD8D31B, 0x8A8B6E140D89FAD5, 0x6CA88AF83FD56224, 0xF5DB7C4713871753,
0xEEF1A4799BCFF55A, 0x76E55AEA6636B381, 0x8EE24EA4A33A367A, 0x25ACDDD7C44BBEB0,
0x9ADAEECBAA5A2076, 0x0E75707D5083C7A9, 0x2BD9ADAA94C87919, 0x19E4C866DFEB84A4,
0x129F9087F070BC0E, 0xD9C2E929AFF4F7E4, 0x6F01928CB9DD3725, 0x39463D2D64B8C517,
0xEBFF8CE5E4D70A59, 0xB40D6BFD418AA66C, 0xF21B44833B3C8EFD, 0x3654457CE5903112,
0x431807E205AED792, 0xB10343613E92596F, 0x0A1C50CDFE300B06, 0x778252C6B79D802D,
0x0CBB60250720A104, 0xE1E3DC281AE7015F, 0x0F1278518128F405, 0x47712752AB1D1B3D,
0xE24AC45C9CEF545E, 0x1CEAE0FAA0F37BA7, 0x9814FE93FDF946DB, 0xEC3FB421CC6C93F7,
0x833E26AD75B1A4D2, 0x6B68B23C176EFB8A, 0x4904572FFB9EDC94, 0x4BCA4777AC3DBA39,
0x2762CD8F93E8D81D, 0x9EB3CE7B04E9ECD9, 0xC2E8311727BC15ED, 0xEA9884C9357C39F5,
0xFC6E34FE6BBF4954, 0x13F898AB21DB8FA2, 0xB7A47389C782F36D, 0x7B3932E3B0BD2129,
0xAF27B3C3C9C24465, 0xB6C37BA51629C0C1, 0x84FE1E695D0A3D7C, 0x1A4DD01259E3D1A5,
0xAB4E9373677188CA, 0x90C6BE06546A2B70, 0xF37C4CAFEA97BD51, 0x647ACA6D96460F8F,
0x4EC46FEBD325453A, 0x3E8605E94C035CB9, 0x0DDC6809D68B92A8, 0x8BEC6638DC22C979,
0x67D3D219104E5A8E, 0x2ABEA58645634AB5, 0x5B9BC7A80BEE609A, 0x936FA672D2627E71,
0x7D9E020B49AD8B2B, 0x5832DFDC8DE6359B, 0xC7E6198B58A4EAEE, 0xD41E8120797F654C,
0xF4BC746BC22C24FF, 0xE084D404CB4C32F3, 0x48635F032A35EF38, 0x8757061DDB02687D,
0x522E8F1173D63E9D, 0xBCDF2B68E819CBC7, 0xBF76331C6E119EC6, 0x08D24095A9936DAB,
0x728C7A5AC8857F2E, 0xD110A9BC06679A4F, 0x1F43F88E26FB2EA6, 0xB2AA5B15B89A0C6E,
0x4AAD4F5B7D968995, 0x9FD4C657D542DF75, 0x323D65CC4B23FDBD, 0xC38F393BF6172641,
0xA152C3BE994183CC, 0x9D1AD60F82E1B9D8, 0xE744ECC0E3F7AB5D, 0x38213501B513F6BB,
0xADE9A39B9E6122C8, 0x37334D50343B02BE, 0x55EEB7D55B6DA733, 0x970686C27CD1B2DE,
0x427F0FCED405E43E, 0xC026214F701F7340, 0x40B11F9683A68293, 0x02CE105857A366AD,
0x7E371A7FCFA5DE2A, 0xFFC72C8AEDB71C55, 0x68C1AA489166AE8B, 0xC68111A7890FD942,
0x79F722BBE71E4784, 0xD579890CA8D456E0, 0x70426A029F261983, 0xB0644B4DEF396AC3,
0xDB0CF971F8579149, 0x5489BFF98AC6949F, 0x046920B0AEB3CCAF, 0x7CF90A279806B887,
0x050E289C7F18FF03, 0x651DC24147ED3C23, 0x5E95EF3474F69F99, 0x6DCF82D4EE7E5188,
0x8F854688729105D6, 0x81F036F52212C27F, 0xB9D103F4970134C4, 0x5349873DA27D0D31,
0x20A2F54BBB5341B3, 0xF0D554DB6C9FE850, 0x07C038C428BB99AE, 0x30F375941C809B10,
0x3FE10DC59DA86F15, 0x46162F7E7AB62891, 0xE623E4EC325C98F1, 0xFEA024A63C1C2FF9,
0x349A5524B23357BF, 0x35FD5D0863986413, 0x96618EEEAD7A8172, 0xCB5D79AE5F844BEA,
0x21C5FD676AF8721F, 0x5720A78D0CCEC19E, 0xF6726433958F4252, 0x8D4B56D02532637B,
0x24CBD5FB15E08D1C, 0x3AEF2559E2B09016, 0x5AFCCF84DA455336, 0x51879765F5DE6B9C,
0x2917BDF2C36B1FB4, 0xA7F5F356605129CE, 0xC1412963A1B440EC, 0x3D2F1D9DCA0B09B8,
0xA53BE30E37F24F63, 0x5FF2E718A55DAC35, 0xA2FBDBCA1F49D6CD, 0xF7156C1F442471FE,
0x7A5E3ACF61161285, 0xCA3A71828E2F7846, 0x1B2AD83E8848E209, 0xA8E78B07E179DDCB,
0xEF96AC554A64C6F6, 0x0000000000000000, 0x6013EADD38F5C320, 0x3C4815B11BA03A14,
0x09B548B978385E07, 0x226CE513ECF0271E, 0x63BAF2A9BEFD9621, 0x44D83F262D154E3C,
0xCDFA4946A694E1E8, 0x113688F37678E90F, 0x859916458CA10ED0, 0xC52809D30F078C43,
0x4D6D779F552D103B, 0x1E24F0A2F7501D0A, 0x0167082CD1AB33AC, 0x1438A06F0960160C,
0xF9601C6214A7B657, 0xA035CB9248EAB060, 0x50E09F4924755830, 0xD7B79954FF77304D,
0xE58AFC98B454CDF0, 0x03A9187486085501, 0x62DDFA856F56A58D, 0xC44F01FFDEACBFEF,
0x73EB7276192E4C82, 0xD6D091782EDC03E1, 0xFBAE0C3A4304D0FA, 0x9973F6BF2C527577,
0x105180DFA7D3DAA3, 0x2605C5A34243EBB1, 0x91A1B62A85C118DC, 0xC99369F608272D47,
0x5D3CF740F2FECA98, 0xCF34591EF1378745, 0xC8F461DAD98C1EEB, 0x0B7B58E12F9B38AA,
0xE32DCC704D4467F2, 0x754C429EE03EE680, 0xD3DEB9E451C4FCE2, 0x6E669AA068760489,
0x66B4DA35C1E56922, 0x4FA367C7028E7696, 0xBA781B80110961C5, 0x41D617BA520DB13F,
0x335A6DE09A88CE11, 0xDF65D9C156E45DE6, 0xCC9D416A773FD244, 0x5C5BFF6C2355F934,
0x2870B5DE12C02C18, 0x155FA843D8CB25A0, 0x78902A9736B57428, 0xAE40BBEF186977C9,
0x88457E4C5A2A9C78, 0x6A0FBA10C6C5C826, 0x7F5012531E0EED86, 0x8C2C5EFCF49950D7,
0x31947DB8CD2BA8BC, 0x2C19956EBC73E0B7, 0x230BED3F3D5B14B2, 0x69A6A26440CD9D27,
0x86300E310AA95BD1, 0xB3CD533969313FC2, 0x1883C04A0E40B708, 0xF1B25CF7BD34DBFC,
0x2FB08D1A3A7BB5B6, 0xD8A5E1057E5FC448, 0xDDABC99901473B4B, 0xDE02D1ED874F6E4A,
0xBDB8234439B2F86B, 0x5647AFA1DD65F232, 0x2ED78536EBD0861A, 0xE9319CBDB3746CF4,
0xA692FB7AB1FA1A62, 0x742B4AB23195D52C, 0x95C8969A2B72D473, 0x6174E2F1E95EF08C,
0xF807144EC50C85FB, 0xBE113B30BFBAAD6A, 0xDA6BF15D29FCA2E5, 0xBB1F13ACC0A25269 };

const u64bit SHARK::TD7[256] = {
0xC22B27F0F9E37BF9, 0x93FAD23F0955EF09, 0x32ED4B84A22A91A2, 0x3898B57BCC61B1CC,
0x55825BA9AD98E5AD, 0xB2EEB8069421EC94, 0xC7EB5875CE3C6BCE, 0x4B1DAC5D1F45851F,
0xC16BA1204705D847, 0xC5380F461A2BA91A, 0xB908971A909BAD90, 0x303E1CB7763D5376,
0xE6FF324C53486853, 0x6D1AEED261F95461, 0x0193D1E36AF1616A, 0x51D1F5CFF0B694F0,
0x29B2C3F52728E127, 0x112A768EEB4950EB, 0x8FB672F86F9F4D6F, 0xF0C66C745BC9EA5B,
0x3F8B9DCD2FA9632F, 0x65BC471EDBA5B6DB, 0x4D9D5508967C3696, 0x3A4BE24818767318,
0x2794936C144DB014, 0x2AF2452599CE4299, 0x4A8E7DBE75B4E475, 0x9DDC82A63A30BE3A,
0xADE29E114C0DED4C, 0xD1D2064DC6BDE9C6, 0x7DA349BFE04165E0, 0x6B9A1787E8C0E7E8,
0xA54437DDF6510FF6, 0x2254ECE92392A023, 0x79F0E7D9BD6F14BD, 0x57510C9A798F2779,
0x346DB2D12B13222B, 0x54118A4AC76984C7, 0xEFCA4A6383E5EB83, 0xCA8D8E3C43BF9943,
0xFC336BDEBCBB79BC, 0x3E184C2E45580245, 0xF495C21206E79B06, 0xFF73ED0E025DDA02,
0x4228D472CFE806CF, 0xBCC8E89FA744BDA7, 0xAB626744C5345EC5, 0xB6BD1660C90F9DC9,
0xB72EC783A3FEFCA3, 0x8BE5DC9E32B13C32, 0x485D2A8DA1A326A1, 0xC6788996A4CD0AA4,
0x40FB83411BFFC41B, 0x08A6A9CCBA5CE2BA, 0xF386EAA4E52F49E5, 0x1ACC5992EFF311EF,
0xA2571F6B1599DD15, 0x44A82D2746D1B546, 0x70C59FF66DC2976D, 0x8D6525CBBB888FBB,
0x963AADBA3E8AFF3E, 0x7C30985C8AB0048A, 0x607C389BEC7AA6EC, 0xA822E1947BD2FD7B,
0x034086D0BEE6A3BE, 0x66FCC1CE65431565, 0xB37D69E5FED08DFE, 0x2F323AA0AE1152AE,
0x56C2DD79137E4613, 0x31ADCD541CCC321C, 0xDFF456D4F5D8B8F5, 0xF9F3145B8B64698B,
0x764566A3E4FB24E4, 0x0CF507AAE77293E7, 0x59775C034AEA764A, 0xB89B46F9FA6ACCFA,
0xE8D962D5602D3960, 0x17AA8FDB6270E362, 0x1C4CA0C766CAA266, 0x2DE16D937A06907A,
0x2547C45FC05A72C0, 0x0FB5817A59943059, 0x0680F9558939B389, 0x16395E3808818208,
0xAC714FF226FC8C26, 0xA9B1307711239C11, 0xEC8ACCB33D03483D, 0x6C893F310B08350B,
0xC4ABDEA570DAC870, 0xBA4811CA2E7D0E2E, 0xF155BD9731388B31, 0xDD2701E721CF7A21,
0xE94AB3360ADC580A, 0x23C73D0A4963C149, 0x5CB723867D35667D, 0x5042242C9A47F59A,
0x198CDF425115B251, 0x0A75FEFF6E4B206E, 0xFDA0BA3DD64A18D6, 0xCEDE205A1E91E81E,
0xD041D7AEAC4C88AC, 0xE42C657F875FAA87, 0x36BEE5E2FF04E0FF, 0x6FC9B9E1B5EE96B5,
0x998F2CC0671ECF67, 0xD301517E12AA2B12, 0xAEA218C1F2EB4EF2, 0xDA342951C207A8C2,
0x61EFE978868BC786, 0x7F701E8C3456A734, 0x0BE62F1C04BA4104, 0x9129850CDD422DDD,
0xD6C12EFB25753B25, 0xE33F4DC964977864, 0x1579D8E8B66721B6, 0xF860C5B8E19508E1,
0x7496319030ECE630, 0x88A55A4E8C579F8C, 0xCF4DF1B974608974, 0x10B9A76D81B83181,
0x0E26509933655133, 0x43BB0591A51967A5, 0x926903DC63A48E63, 0x9C4F534550C1DF50,
0x3BD833AB72871272, 0xA4D7E63E9CA06E9C, 0xB46E41531D185F1D, 0x126AF05E55AFF355,
0x24D415BCAAAB13AA, 0x1E9FF7F4B2DD60B2, 0x05C07F8537DF1037, 0x467B7A1492C67792,
0x2087BBDAF78562F7, 0x819022615CFA1C5C, 0xCD9EA68AA0774BA0, 0xA79760EE2246CD22,
0x8343755288EDDE88, 0x58E48DE0201B1720, 0x7216C8C5B9D555B9, 0x372D340195F58195,
0xA11799BBAB7F7EAB, 0x9F0FD595EE277CEE, 0x676F102D0FB2740F, 0x9E9C047684D61D84,
0x49CEFB6ECB5247CB, 0xD41279C8F162F9F1, 0x1F0C2617D82C01D8, 0x97A97C59547B9E54,
0xE76CE3AF39B90939, 0xC3B8F61393121A93, 0x5BA40B309EFDB49E, 0xEA0A35E6B43AFBB4,
0x5A37DAD3F40CD5F4, 0x14EA090BDC9640DC, 0x5E6474B5A922A4A9, 0xFEE03CED68ACBB68,
0x071328B6E3C8D2E3, 0x5302A2FC24A15624, 0x85C38C0701D46D01, 0x3D58CAFEFBBEA1FB,
0x84505DE46B250C6B, 0x642F96FDB154D7B1, 0xBF886E4F19A21E19, 0x02D35733D417C2D4,
0x68DA915756264456, 0x8710DB34D5C3AFD5, 0x0D66D6498D83F28D, 0x7B23B0EA6978D669,
0x1B5F887185027085, 0x3CCB1B1D914FC091, 0x0453AE665D2E715D, 0xCB1E5FDF294EF829,
0xF6469521D2F059D2, 0xB03DEF3540362E40, 0x633CBE4B529C0552, 0xF7D544C2B80138B8,
0x7AB061090389B703, 0x0000000000000000, 0xDBA7F8B2A8F6C9A8, 0x35FE633241E24341,
0x21146A399D74039D, 0xD581A82B9B93989B, 0x0935782FD0AD83D0, 0x5FF7A556C3D3C5C3,
0xAF31C922981A2F98, 0x90BA54EFB7B34CB7, 0x5291731F4E50374E, 0xC0F870C32DF4B92D,
0x7EE3CF6F5EA7C65E, 0xE07FCB19DA71DBDA, 0x4EDDD3D8289A9528, 0x13F921BD3F5E923F,
0xF50613F16C16FA6C, 0x981CFD230DEFAE0D, 0x4C0E84EBFC8D57FC, 0x82D0A4B1E21CBFE2,
0x89368BADE6A6FEE6, 0xD292809D785B4A78, 0x47E8ABF7F83716F8, 0x8E25A31B056E2C05,
0xD752FF184F845A4F, 0xCC0D7769CA862ACA, 0x694940B43CD7253C, 0x2EA1EB43C4E033C4,
0xDE6787379F29D99F, 0x181F0EA13BE4D33B, 0x416852A2710EA571, 0x62AF6FA8386D6438,
0xA0844858C18E1FC1, 0x337E9A67C8DBF0C8, 0x2C72BC7010F7F110, 0xBD5B397CCDB5DCCD,
0xD8E77E6216106A16, 0x86830AD7BF32CEBF, 0x4F4E023B426BF442, 0xE5BFB49CEDAECBED,
0x8A760D7D58405D58, 0xE2AC9C2A0E66190E, 0xB5FD90B077E93E77, 0xDCB4D0044B3E1B4B,
0x453BFCC42C20D42C, 0xED191D5057F22957, 0xE1EC1AFAB080BAB0, 0xEE599B80E9148AE9,
0x2607428F7EBCD17E, 0x5D24F26517C40717, 0x6A09C66482318682, 0xA604B10D48B7AC48,
0xBE1BBFAC73537F73, 0x282112164DD9804D, 0x7505E0735A1D875A, 0x73851926D32434D3,
0xD974AF817CE10B7C, 0xEB99E405DECB9ADE, 0x9B5C7BF3B3090DB3, 0xFAB3928B3582CA35,
0x8003F382360B7D36, 0x94E9FA89EA9D3DEA, 0xB1AE3ED62AC74F2A, 0x9ACFAA10D9F86CD9,
0x390B6498A690D0A6, 0xF2153B478FDE288F, 0x71564E150733F607, 0xA3C4CE887F68BC7F,
0xAAF1B6A7AFC53FAF, 0x1DDF71240C3BC30C, 0x77D6B7408E0A458E, 0x2B6194C6F33F23F3,
0xC9CD08ECFD593AFD, 0xC85ED90F97A85B97, 0x8CF6F428D179EED1, 0x957A2B6A806C5C80,
0xBBDBC029448C6F44, 0x7863363AD79E75D7, 0x6E5A6802DF1FF7DF, 0xFB2043685F73AB5F };

}
