/*************************************************
* S-Box and Diffusion Tables for Square          *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#include <opencl/square.h>

namespace OpenCL {

const byte Square::SE[256] = {
0xB1, 0xCE, 0xC3, 0x95, 0x5A, 0xAD, 0xE7, 0x02, 0x4D, 0x44, 0xFB, 0x91, 0x0C,
0x87, 0xA1, 0x50, 0xCB, 0x67, 0x54, 0xDD, 0x46, 0x8F, 0xE1, 0x4E, 0xF0, 0xFD,
0xFC, 0xEB, 0xF9, 0xC4, 0x1A, 0x6E, 0x5E, 0xF5, 0xCC, 0x8D, 0x1C, 0x56, 0x43,
0xFE, 0x07, 0x61, 0xF8, 0x75, 0x59, 0xFF, 0x03, 0x22, 0x8A, 0xD1, 0x13, 0xEE,
0x88, 0x00, 0x0E, 0x34, 0x15, 0x80, 0x94, 0xE3, 0xED, 0xB5, 0x53, 0x23, 0x4B,
0x47, 0x17, 0xA7, 0x90, 0x35, 0xAB, 0xD8, 0xB8, 0xDF, 0x4F, 0x57, 0x9A, 0x92,
0xDB, 0x1B, 0x3C, 0xC8, 0x99, 0x04, 0x8E, 0xE0, 0xD7, 0x7D, 0x85, 0xBB, 0x40,
0x2C, 0x3A, 0x45, 0xF1, 0x42, 0x65, 0x20, 0x41, 0x18, 0x72, 0x25, 0x93, 0x70,
0x36, 0x05, 0xF2, 0x0B, 0xA3, 0x79, 0xEC, 0x08, 0x27, 0x31, 0x32, 0xB6, 0x7C,
0xB0, 0x0A, 0x73, 0x5B, 0x7B, 0xB7, 0x81, 0xD2, 0x0D, 0x6A, 0x26, 0x9E, 0x58,
0x9C, 0x83, 0x74, 0xB3, 0xAC, 0x30, 0x7A, 0x69, 0x77, 0x0F, 0xAE, 0x21, 0xDE,
0xD0, 0x2E, 0x97, 0x10, 0xA4, 0x98, 0xA8, 0xD4, 0x68, 0x2D, 0x62, 0x29, 0x6D,
0x16, 0x49, 0x76, 0xC7, 0xE8, 0xC1, 0x96, 0x37, 0xE5, 0xCA, 0xF4, 0xE9, 0x63,
0x12, 0xC2, 0xA6, 0x14, 0xBC, 0xD3, 0x28, 0xAF, 0x2F, 0xE6, 0x24, 0x52, 0xC6,
0xA0, 0x09, 0xBD, 0x8C, 0xCF, 0x5D, 0x11, 0x5F, 0x01, 0xC5, 0x9F, 0x3D, 0xA2,
0x9B, 0xC9, 0x3B, 0xBE, 0x51, 0x19, 0x1F, 0x3F, 0x5C, 0xB2, 0xEF, 0x4A, 0xCD,
0xBF, 0xBA, 0x6F, 0x64, 0xD9, 0xF3, 0x3E, 0xB4, 0xAA, 0xDC, 0xD5, 0x06, 0xC0,
0x7E, 0xF6, 0x66, 0x6C, 0x84, 0x71, 0x38, 0xB9, 0x1D, 0x7F, 0x9D, 0x48, 0x8B,
0x2A, 0xDA, 0xA5, 0x33, 0x82, 0x39, 0xD6, 0x78, 0x86, 0xFA, 0xE4, 0x2B, 0xA9,
0x1E, 0x89, 0x60, 0x6B, 0xEA, 0x55, 0x4C, 0xF7, 0xE2 };

const byte Square::SD[256] = {
0x35, 0xBE, 0x07, 0x2E, 0x53, 0x69, 0xDB, 0x28, 0x6F, 0xB7, 0x76, 0x6B, 0x0C,
0x7D, 0x36, 0x8B, 0x92, 0xBC, 0xA9, 0x32, 0xAC, 0x38, 0x9C, 0x42, 0x63, 0xC8,
0x1E, 0x4F, 0x24, 0xE5, 0xF7, 0xC9, 0x61, 0x8D, 0x2F, 0x3F, 0xB3, 0x65, 0x7F,
0x70, 0xAF, 0x9A, 0xEA, 0xF5, 0x5B, 0x98, 0x90, 0xB1, 0x87, 0x71, 0x72, 0xED,
0x37, 0x45, 0x68, 0xA3, 0xE3, 0xEF, 0x5C, 0xC5, 0x50, 0xC1, 0xD6, 0xCA, 0x5A,
0x62, 0x5F, 0x26, 0x09, 0x5D, 0x14, 0x41, 0xE8, 0x9D, 0xCE, 0x40, 0xFD, 0x08,
0x17, 0x4A, 0x0F, 0xC7, 0xB4, 0x3E, 0x12, 0xFC, 0x25, 0x4B, 0x81, 0x2C, 0x04,
0x78, 0xCB, 0xBB, 0x20, 0xBD, 0xF9, 0x29, 0x99, 0xA8, 0xD3, 0x60, 0xDF, 0x11,
0x97, 0x89, 0x7E, 0xFA, 0xE0, 0x9B, 0x1F, 0xD2, 0x67, 0xE2, 0x64, 0x77, 0x84,
0x2B, 0x9E, 0x8A, 0xF1, 0x6D, 0x88, 0x79, 0x74, 0x57, 0xDD, 0xE6, 0x39, 0x7B,
0xEE, 0x83, 0xE1, 0x58, 0xF2, 0x0D, 0x34, 0xF8, 0x30, 0xE9, 0xB9, 0x23, 0x54,
0x15, 0x44, 0x0B, 0x4D, 0x66, 0x3A, 0x03, 0xA2, 0x91, 0x94, 0x52, 0x4C, 0xC3,
0x82, 0xE7, 0x80, 0xC0, 0xB6, 0x0E, 0xC2, 0x6C, 0x93, 0xEC, 0xAB, 0x43, 0x95,
0xF6, 0xD8, 0x46, 0x86, 0x05, 0x8C, 0xB0, 0x75, 0x00, 0xCC, 0x85, 0xD7, 0x3D,
0x73, 0x7A, 0x48, 0xE4, 0xD1, 0x59, 0xAD, 0xB8, 0xC6, 0xD0, 0xDC, 0xA1, 0xAA,
0x02, 0x1D, 0xBF, 0xB5, 0x9F, 0x51, 0xC4, 0xA5, 0x10, 0x22, 0xCF, 0x01, 0xBA,
0x8F, 0x31, 0x7C, 0xAE, 0x96, 0xDA, 0xF0, 0x56, 0x47, 0xD4, 0xEB, 0x4E, 0xD9,
0x13, 0x8E, 0x49, 0x55, 0x16, 0xFF, 0x3B, 0xF4, 0xA4, 0xB2, 0x06, 0xA0, 0xA7,
0xFB, 0x1B, 0x6E, 0x3C, 0x33, 0xCD, 0x18, 0x5E, 0x6A, 0xD5, 0xA6, 0x21, 0xDE,
0xFE, 0x2A, 0x1C, 0xF3, 0x0A, 0x1A, 0x19, 0x27, 0x2D };

const byte Square::Log[256] = {
0x00, 0x00, 0x01, 0x86, 0x02, 0x0D, 0x87, 0x4C, 0x03, 0xD2, 0x0E, 0xAE, 0x88,
0x22, 0x4D, 0x93, 0x04, 0x1A, 0xD3, 0xCB, 0x0F, 0x98, 0xAF, 0xA8, 0x89, 0xF0,
0x23, 0x59, 0x4E, 0x35, 0x94, 0x09, 0x05, 0x8F, 0x1B, 0x6E, 0xD4, 0x39, 0xCC,
0xBB, 0x10, 0x68, 0x99, 0x77, 0xB0, 0xDF, 0xA9, 0x72, 0x8A, 0xFA, 0xF1, 0xA0,
0x24, 0x52, 0x5A, 0x60, 0x4F, 0x2F, 0x36, 0xDC, 0x95, 0x32, 0x0A, 0x1F, 0x06,
0xA5, 0x90, 0x49, 0x1C, 0x5D, 0x6F, 0xB8, 0xD5, 0xC1, 0x3A, 0xB5, 0xCD, 0x63,
0xBC, 0x3D, 0x11, 0x44, 0x69, 0x81, 0x9A, 0x27, 0x78, 0xC4, 0xB1, 0xE6, 0xE0,
0xEA, 0xAA, 0x55, 0x73, 0xD8, 0x8B, 0xF6, 0xFB, 0x16, 0xF2, 0xF4, 0xA1, 0x40,
0x25, 0x42, 0x53, 0xE4, 0x5B, 0xA3, 0x61, 0xBF, 0x50, 0xF8, 0x30, 0x2D, 0x37,
0x8D, 0xDD, 0x66, 0x96, 0x18, 0x33, 0xEE, 0x0B, 0xFD, 0x20, 0xD0, 0x07, 0x57,
0xA6, 0xC9, 0x91, 0xAC, 0x4A, 0x84, 0x1D, 0xDA, 0x5E, 0x9E, 0x70, 0x75, 0xB9,
0x6C, 0xD6, 0xE8, 0xC2, 0x7F, 0x3B, 0xB3, 0xB6, 0x47, 0xCE, 0xEC, 0x64, 0x2B,
0xBD, 0xE2, 0x3E, 0x14, 0x12, 0x29, 0x45, 0x7D, 0x6A, 0x9C, 0x82, 0xC7, 0x9B,
0xC6, 0x28, 0x7C, 0x79, 0x7A, 0xC5, 0x7B, 0xB2, 0x46, 0xE7, 0x7E, 0xE1, 0x13,
0xEB, 0x2A, 0xAB, 0x83, 0x56, 0xC8, 0x74, 0x6B, 0xD9, 0x9D, 0x8C, 0x65, 0xF7,
0x2C, 0xFC, 0xCF, 0x17, 0xED, 0xF3, 0x3F, 0xF5, 0x15, 0xA2, 0xBE, 0x41, 0xE3,
0x26, 0xC3, 0x43, 0x80, 0x54, 0xD7, 0xE5, 0xE9, 0x5C, 0xB7, 0xA4, 0x48, 0x62,
0x3C, 0xC0, 0xB4, 0x51, 0x5F, 0xF9, 0x9F, 0x31, 0x1E, 0x2E, 0xDB, 0x38, 0xBA,
0x8E, 0x6D, 0xDE, 0x71, 0x67, 0x76, 0x97, 0xA7, 0x19, 0xCA, 0x34, 0x08, 0xEF,
0x58, 0x0C, 0x4B, 0xFE, 0x85, 0x21, 0x92, 0xD1, 0xAD };

const byte Square::ALog[255] = {
0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0xF5, 0x1F, 0x3E, 0x7C, 0xF8,
0x05, 0x0A, 0x14, 0x28, 0x50, 0xA0, 0xB5, 0x9F, 0xCB, 0x63, 0xC6, 0x79, 0xF2,
0x11, 0x22, 0x44, 0x88, 0xE5, 0x3F, 0x7E, 0xFC, 0x0D, 0x1A, 0x34, 0x68, 0xD0,
0x55, 0xAA, 0xA1, 0xB7, 0x9B, 0xC3, 0x73, 0xE6, 0x39, 0x72, 0xE4, 0x3D, 0x7A,
0xF4, 0x1D, 0x3A, 0x74, 0xE8, 0x25, 0x4A, 0x94, 0xDD, 0x4F, 0x9E, 0xC9, 0x67,
0xCE, 0x69, 0xD2, 0x51, 0xA2, 0xB1, 0x97, 0xDB, 0x43, 0x86, 0xF9, 0x07, 0x0E,
0x1C, 0x38, 0x70, 0xE0, 0x35, 0x6A, 0xD4, 0x5D, 0xBA, 0x81, 0xF7, 0x1B, 0x36,
0x6C, 0xD8, 0x45, 0x8A, 0xE1, 0x37, 0x6E, 0xDC, 0x4D, 0x9A, 0xC1, 0x77, 0xEE,
0x29, 0x52, 0xA4, 0xBD, 0x8F, 0xEB, 0x23, 0x46, 0x8C, 0xED, 0x2F, 0x5E, 0xBC,
0x8D, 0xEF, 0x2B, 0x56, 0xAC, 0xAD, 0xAF, 0xAB, 0xA3, 0xB3, 0x93, 0xD3, 0x53,
0xA6, 0xB9, 0x87, 0xFB, 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x75, 0xEA,
0x21, 0x42, 0x84, 0xFD, 0x0F, 0x1E, 0x3C, 0x78, 0xF0, 0x15, 0x2A, 0x54, 0xA8,
0xA5, 0xBF, 0x8B, 0xE3, 0x33, 0x66, 0xCC, 0x6D, 0xDA, 0x41, 0x82, 0xF1, 0x17,
0x2E, 0x5C, 0xB8, 0x85, 0xFF, 0x0B, 0x16, 0x2C, 0x58, 0xB0, 0x95, 0xDF, 0x4B,
0x96, 0xD9, 0x47, 0x8E, 0xE9, 0x27, 0x4E, 0x9C, 0xCD, 0x6F, 0xDE, 0x49, 0x92,
0xD1, 0x57, 0xAE, 0xA9, 0xA7, 0xBB, 0x83, 0xF3, 0x13, 0x26, 0x4C, 0x98, 0xC5,
0x7F, 0xFE, 0x09, 0x12, 0x24, 0x48, 0x90, 0xD5, 0x5F, 0xBE, 0x89, 0xE7, 0x3B,
0x76, 0xEC, 0x2D, 0x5A, 0xB4, 0x9D, 0xCF, 0x6B, 0xD6, 0x59, 0xB2, 0x91, 0xD7,
0x5B, 0xB6, 0x99, 0xC7, 0x7B, 0xF6, 0x19, 0x32, 0x64, 0xC8, 0x65, 0xCA, 0x61,
0xC2, 0x71, 0xE2, 0x31, 0x62, 0xC4, 0x7D, 0xFA };

const u32bit Square::TE0[256] = {
0x97B1B126UL, 0x69CECEA7UL, 0x73C3C3B0UL, 0xDF95954AUL, 0xB45A5AEEUL,
0xAFADAD02UL, 0x3BE7E7DCUL, 0x04020206UL, 0x9A4D4DD7UL, 0x884444CCUL,
0x03FBFBF8UL, 0xD7919146UL, 0x180C0C14UL, 0xFB87877CUL, 0xB7A1A116UL,
0xA05050F0UL, 0x63CBCBA8UL, 0xCE6767A9UL, 0xA85454FCUL, 0x4FDDDD92UL,
0x8C4646CAUL, 0xEB8F8F64UL, 0x37E1E1D6UL, 0x9C4E4ED2UL, 0x15F0F0E5UL,
0x0FFDFDF2UL, 0x0DFCFCF1UL, 0x23EBEBC8UL, 0x07F9F9FEUL, 0x7DC4C4B9UL,
0x341A1A2EUL, 0xDC6E6EB2UL, 0xBC5E5EE2UL, 0x1FF5F5EAUL, 0x6DCCCCA1UL,
0xEF8D8D62UL, 0x381C1C24UL, 0xAC5656FAUL, 0x864343C5UL, 0x09FEFEF7UL,
0x0E070709UL, 0xC26161A3UL, 0x05F8F8FDUL, 0xEA75759FUL, 0xB25959EBUL,
0x0BFFFFF4UL, 0x06030305UL, 0x44222266UL, 0xE18A8A6BUL, 0x57D1D186UL,
0x26131335UL, 0x29EEEEC7UL, 0xE588886DUL, 0x00000000UL, 0x1C0E0E12UL,
0x6834345CUL, 0x2A15153FUL, 0xF5808075UL, 0xDD949449UL, 0x33E3E3D0UL,
0x2FEDEDC2UL, 0x9FB5B52AUL, 0xA65353F5UL, 0x46232365UL, 0x964B4BDDUL,
0x8E4747C9UL, 0x2E171739UL, 0xBBA7A71CUL, 0xD5909045UL, 0x6A35355FUL,
0xA3ABAB08UL, 0x45D8D89DUL, 0x85B8B83DUL, 0x4BDFDF94UL, 0x9E4F4FD1UL,
0xAE5757F9UL, 0xC19A9A5BUL, 0xD1929243UL, 0x43DBDB98UL, 0x361B1B2DUL,
0x783C3C44UL, 0x65C8C8ADUL, 0xC799995EUL, 0x0804040CUL, 0xE98E8E67UL,
0x35E0E0D5UL, 0x5BD7D78CUL, 0xFA7D7D87UL, 0xFF85857AUL, 0x83BBBB38UL,
0x804040C0UL, 0x582C2C74UL, 0x743A3A4EUL, 0x8A4545CFUL, 0x17F1F1E6UL,
0x844242C6UL, 0xCA6565AFUL, 0x40202060UL, 0x824141C3UL, 0x30181828UL,
0xE4727296UL, 0x4A25256FUL, 0xD3939340UL, 0xE0707090UL, 0x6C36365AUL,
0x0A05050FUL, 0x11F2F2E3UL, 0x160B0B1DUL, 0xB3A3A310UL, 0xF279798BUL,
0x2DECECC1UL, 0x10080818UL, 0x4E272769UL, 0x62313153UL, 0x64323256UL,
0x99B6B62FUL, 0xF87C7C84UL, 0x95B0B025UL, 0x140A0A1EUL, 0xE6737395UL,
0xB65B5BEDUL, 0xF67B7B8DUL, 0x9BB7B72CUL, 0xF7818176UL, 0x51D2D283UL,
0x1A0D0D17UL, 0xD46A6ABEUL, 0x4C26266AUL, 0xC99E9E57UL, 0xB05858E8UL,
0xCD9C9C51UL, 0xF3838370UL, 0xE874749CUL, 0x93B3B320UL, 0xADACAC01UL,
0x60303050UL, 0xF47A7A8EUL, 0xD26969BBUL, 0xEE777799UL, 0x1E0F0F11UL,
0xA9AEAE07UL, 0x42212163UL, 0x49DEDE97UL, 0x55D0D085UL, 0x5C2E2E72UL,
0xDB97974CUL, 0x20101030UL, 0xBDA4A419UL, 0xC598985DUL, 0xA5A8A80DUL,
0x5DD4D489UL, 0xD06868B8UL, 0x5A2D2D77UL, 0xC46262A6UL, 0x5229297BUL,
0xDA6D6DB7UL, 0x2C16163AUL, 0x924949DBUL, 0xEC76769AUL, 0x7BC7C7BCUL,
0x25E8E8CDUL, 0x77C1C1B6UL, 0xD996964FUL, 0x6E373759UL, 0x3FE5E5DAUL,
0x61CACAABUL, 0x1DF4F4E9UL, 0x27E9E9CEUL, 0xC66363A5UL, 0x24121236UL,
0x71C2C2B3UL, 0xB9A6A61FUL, 0x2814143CUL, 0x8DBCBC31UL, 0x53D3D380UL,
0x50282878UL, 0xABAFAF04UL, 0x5E2F2F71UL, 0x39E6E6DFUL, 0x4824246CUL,
0xA45252F6UL, 0x79C6C6BFUL, 0xB5A0A015UL, 0x1209091BUL, 0x8FBDBD32UL,
0xED8C8C61UL, 0x6BCFCFA4UL, 0xBA5D5DE7UL, 0x22111133UL, 0xBE5F5FE1UL,
0x02010103UL, 0x7FC5C5BAUL, 0xCB9F9F54UL, 0x7A3D3D47UL, 0xB1A2A213UL,
0xC39B9B58UL, 0x67C9C9AEUL, 0x763B3B4DUL, 0x89BEBE37UL, 0xA25151F3UL,
0x3219192BUL, 0x3E1F1F21UL, 0x7E3F3F41UL, 0xB85C5CE4UL, 0x91B2B223UL,
0x2BEFEFC4UL, 0x944A4ADEUL, 0x6FCDCDA2UL, 0x8BBFBF34UL, 0x81BABA3BUL,
0xDE6F6FB1UL, 0xC86464ACUL, 0x47D9D99EUL, 0x13F3F3E0UL, 0x7C3E3E42UL,
0x9DB4B429UL, 0xA1AAAA0BUL, 0x4DDCDC91UL, 0x5FD5D58AUL, 0x0C06060AUL,
0x75C0C0B5UL, 0xFC7E7E82UL, 0x19F6F6EFUL, 0xCC6666AAUL, 0xD86C6CB4UL,
0xFD848479UL, 0xE2717193UL, 0x70383848UL, 0x87B9B93EUL, 0x3A1D1D27UL,
0xFE7F7F81UL, 0xCF9D9D52UL, 0x904848D8UL, 0xE38B8B68UL, 0x542A2A7EUL,
0x41DADA9BUL, 0xBFA5A51AUL, 0x66333355UL, 0xF1828273UL, 0x7239394BUL,
0x59D6D68FUL, 0xF0787888UL, 0xF986867FUL, 0x01FAFAFBUL, 0x3DE4E4D9UL,
0x562B2B7DUL, 0xA7A9A90EUL, 0x3C1E1E22UL, 0xE789896EUL, 0xC06060A0UL,
0xD66B6BBDUL, 0x21EAEACBUL, 0xAA5555FFUL, 0x984C4CD4UL, 0x1BF7F7ECUL,
0x31E2E2D3UL };

const u32bit Square::TE1[256] = {
0x2697B1B1UL, 0xA769CECEUL, 0xB073C3C3UL, 0x4ADF9595UL, 0xEEB45A5AUL,
0x02AFADADUL, 0xDC3BE7E7UL, 0x06040202UL, 0xD79A4D4DUL, 0xCC884444UL,
0xF803FBFBUL, 0x46D79191UL, 0x14180C0CUL, 0x7CFB8787UL, 0x16B7A1A1UL,
0xF0A05050UL, 0xA863CBCBUL, 0xA9CE6767UL, 0xFCA85454UL, 0x924FDDDDUL,
0xCA8C4646UL, 0x64EB8F8FUL, 0xD637E1E1UL, 0xD29C4E4EUL, 0xE515F0F0UL,
0xF20FFDFDUL, 0xF10DFCFCUL, 0xC823EBEBUL, 0xFE07F9F9UL, 0xB97DC4C4UL,
0x2E341A1AUL, 0xB2DC6E6EUL, 0xE2BC5E5EUL, 0xEA1FF5F5UL, 0xA16DCCCCUL,
0x62EF8D8DUL, 0x24381C1CUL, 0xFAAC5656UL, 0xC5864343UL, 0xF709FEFEUL,
0x090E0707UL, 0xA3C26161UL, 0xFD05F8F8UL, 0x9FEA7575UL, 0xEBB25959UL,
0xF40BFFFFUL, 0x05060303UL, 0x66442222UL, 0x6BE18A8AUL, 0x8657D1D1UL,
0x35261313UL, 0xC729EEEEUL, 0x6DE58888UL, 0x00000000UL, 0x121C0E0EUL,
0x5C683434UL, 0x3F2A1515UL, 0x75F58080UL, 0x49DD9494UL, 0xD033E3E3UL,
0xC22FEDEDUL, 0x2A9FB5B5UL, 0xF5A65353UL, 0x65462323UL, 0xDD964B4BUL,
0xC98E4747UL, 0x392E1717UL, 0x1CBBA7A7UL, 0x45D59090UL, 0x5F6A3535UL,
0x08A3ABABUL, 0x9D45D8D8UL, 0x3D85B8B8UL, 0x944BDFDFUL, 0xD19E4F4FUL,
0xF9AE5757UL, 0x5BC19A9AUL, 0x43D19292UL, 0x9843DBDBUL, 0x2D361B1BUL,
0x44783C3CUL, 0xAD65C8C8UL, 0x5EC79999UL, 0x0C080404UL, 0x67E98E8EUL,
0xD535E0E0UL, 0x8C5BD7D7UL, 0x87FA7D7DUL, 0x7AFF8585UL, 0x3883BBBBUL,
0xC0804040UL, 0x74582C2CUL, 0x4E743A3AUL, 0xCF8A4545UL, 0xE617F1F1UL,
0xC6844242UL, 0xAFCA6565UL, 0x60402020UL, 0xC3824141UL, 0x28301818UL,
0x96E47272UL, 0x6F4A2525UL, 0x40D39393UL, 0x90E07070UL, 0x5A6C3636UL,
0x0F0A0505UL, 0xE311F2F2UL, 0x1D160B0BUL, 0x10B3A3A3UL, 0x8BF27979UL,
0xC12DECECUL, 0x18100808UL, 0x694E2727UL, 0x53623131UL, 0x56643232UL,
0x2F99B6B6UL, 0x84F87C7CUL, 0x2595B0B0UL, 0x1E140A0AUL, 0x95E67373UL,
0xEDB65B5BUL, 0x8DF67B7BUL, 0x2C9BB7B7UL, 0x76F78181UL, 0x8351D2D2UL,
0x171A0D0DUL, 0xBED46A6AUL, 0x6A4C2626UL, 0x57C99E9EUL, 0xE8B05858UL,
0x51CD9C9CUL, 0x70F38383UL, 0x9CE87474UL, 0x2093B3B3UL, 0x01ADACACUL,
0x50603030UL, 0x8EF47A7AUL, 0xBBD26969UL, 0x99EE7777UL, 0x111E0F0FUL,
0x07A9AEAEUL, 0x63422121UL, 0x9749DEDEUL, 0x8555D0D0UL, 0x725C2E2EUL,
0x4CDB9797UL, 0x30201010UL, 0x19BDA4A4UL, 0x5DC59898UL, 0x0DA5A8A8UL,
0x895DD4D4UL, 0xB8D06868UL, 0x775A2D2DUL, 0xA6C46262UL, 0x7B522929UL,
0xB7DA6D6DUL, 0x3A2C1616UL, 0xDB924949UL, 0x9AEC7676UL, 0xBC7BC7C7UL,
0xCD25E8E8UL, 0xB677C1C1UL, 0x4FD99696UL, 0x596E3737UL, 0xDA3FE5E5UL,
0xAB61CACAUL, 0xE91DF4F4UL, 0xCE27E9E9UL, 0xA5C66363UL, 0x36241212UL,
0xB371C2C2UL, 0x1FB9A6A6UL, 0x3C281414UL, 0x318DBCBCUL, 0x8053D3D3UL,
0x78502828UL, 0x04ABAFAFUL, 0x715E2F2FUL, 0xDF39E6E6UL, 0x6C482424UL,
0xF6A45252UL, 0xBF79C6C6UL, 0x15B5A0A0UL, 0x1B120909UL, 0x328FBDBDUL,
0x61ED8C8CUL, 0xA46BCFCFUL, 0xE7BA5D5DUL, 0x33221111UL, 0xE1BE5F5FUL,
0x03020101UL, 0xBA7FC5C5UL, 0x54CB9F9FUL, 0x477A3D3DUL, 0x13B1A2A2UL,
0x58C39B9BUL, 0xAE67C9C9UL, 0x4D763B3BUL, 0x3789BEBEUL, 0xF3A25151UL,
0x2B321919UL, 0x213E1F1FUL, 0x417E3F3FUL, 0xE4B85C5CUL, 0x2391B2B2UL,
0xC42BEFEFUL, 0xDE944A4AUL, 0xA26FCDCDUL, 0x348BBFBFUL, 0x3B81BABAUL,
0xB1DE6F6FUL, 0xACC86464UL, 0x9E47D9D9UL, 0xE013F3F3UL, 0x427C3E3EUL,
0x299DB4B4UL, 0x0BA1AAAAUL, 0x914DDCDCUL, 0x8A5FD5D5UL, 0x0A0C0606UL,
0xB575C0C0UL, 0x82FC7E7EUL, 0xEF19F6F6UL, 0xAACC6666UL, 0xB4D86C6CUL,
0x79FD8484UL, 0x93E27171UL, 0x48703838UL, 0x3E87B9B9UL, 0x273A1D1DUL,
0x81FE7F7FUL, 0x52CF9D9DUL, 0xD8904848UL, 0x68E38B8BUL, 0x7E542A2AUL,
0x9B41DADAUL, 0x1ABFA5A5UL, 0x55663333UL, 0x73F18282UL, 0x4B723939UL,
0x8F59D6D6UL, 0x88F07878UL, 0x7FF98686UL, 0xFB01FAFAUL, 0xD93DE4E4UL,
0x7D562B2BUL, 0x0EA7A9A9UL, 0x223C1E1EUL, 0x6EE78989UL, 0xA0C06060UL,
0xBDD66B6BUL, 0xCB21EAEAUL, 0xFFAA5555UL, 0xD4984C4CUL, 0xEC1BF7F7UL,
0xD331E2E2UL };

const u32bit Square::TE2[256] = {
0xB12697B1UL, 0xCEA769CEUL, 0xC3B073C3UL, 0x954ADF95UL, 0x5AEEB45AUL,
0xAD02AFADUL, 0xE7DC3BE7UL, 0x02060402UL, 0x4DD79A4DUL, 0x44CC8844UL,
0xFBF803FBUL, 0x9146D791UL, 0x0C14180CUL, 0x877CFB87UL, 0xA116B7A1UL,
0x50F0A050UL, 0xCBA863CBUL, 0x67A9CE67UL, 0x54FCA854UL, 0xDD924FDDUL,
0x46CA8C46UL, 0x8F64EB8FUL, 0xE1D637E1UL, 0x4ED29C4EUL, 0xF0E515F0UL,
0xFDF20FFDUL, 0xFCF10DFCUL, 0xEBC823EBUL, 0xF9FE07F9UL, 0xC4B97DC4UL,
0x1A2E341AUL, 0x6EB2DC6EUL, 0x5EE2BC5EUL, 0xF5EA1FF5UL, 0xCCA16DCCUL,
0x8D62EF8DUL, 0x1C24381CUL, 0x56FAAC56UL, 0x43C58643UL, 0xFEF709FEUL,
0x07090E07UL, 0x61A3C261UL, 0xF8FD05F8UL, 0x759FEA75UL, 0x59EBB259UL,
0xFFF40BFFUL, 0x03050603UL, 0x22664422UL, 0x8A6BE18AUL, 0xD18657D1UL,
0x13352613UL, 0xEEC729EEUL, 0x886DE588UL, 0x00000000UL, 0x0E121C0EUL,
0x345C6834UL, 0x153F2A15UL, 0x8075F580UL, 0x9449DD94UL, 0xE3D033E3UL,
0xEDC22FEDUL, 0xB52A9FB5UL, 0x53F5A653UL, 0x23654623UL, 0x4BDD964BUL,
0x47C98E47UL, 0x17392E17UL, 0xA71CBBA7UL, 0x9045D590UL, 0x355F6A35UL,
0xAB08A3ABUL, 0xD89D45D8UL, 0xB83D85B8UL, 0xDF944BDFUL, 0x4FD19E4FUL,
0x57F9AE57UL, 0x9A5BC19AUL, 0x9243D192UL, 0xDB9843DBUL, 0x1B2D361BUL,
0x3C44783CUL, 0xC8AD65C8UL, 0x995EC799UL, 0x040C0804UL, 0x8E67E98EUL,
0xE0D535E0UL, 0xD78C5BD7UL, 0x7D87FA7DUL, 0x857AFF85UL, 0xBB3883BBUL,
0x40C08040UL, 0x2C74582CUL, 0x3A4E743AUL, 0x45CF8A45UL, 0xF1E617F1UL,
0x42C68442UL, 0x65AFCA65UL, 0x20604020UL, 0x41C38241UL, 0x18283018UL,
0x7296E472UL, 0x256F4A25UL, 0x9340D393UL, 0x7090E070UL, 0x365A6C36UL,
0x050F0A05UL, 0xF2E311F2UL, 0x0B1D160BUL, 0xA310B3A3UL, 0x798BF279UL,
0xECC12DECUL, 0x08181008UL, 0x27694E27UL, 0x31536231UL, 0x32566432UL,
0xB62F99B6UL, 0x7C84F87CUL, 0xB02595B0UL, 0x0A1E140AUL, 0x7395E673UL,
0x5BEDB65BUL, 0x7B8DF67BUL, 0xB72C9BB7UL, 0x8176F781UL, 0xD28351D2UL,
0x0D171A0DUL, 0x6ABED46AUL, 0x266A4C26UL, 0x9E57C99EUL, 0x58E8B058UL,
0x9C51CD9CUL, 0x8370F383UL, 0x749CE874UL, 0xB32093B3UL, 0xAC01ADACUL,
0x30506030UL, 0x7A8EF47AUL, 0x69BBD269UL, 0x7799EE77UL, 0x0F111E0FUL,
0xAE07A9AEUL, 0x21634221UL, 0xDE9749DEUL, 0xD08555D0UL, 0x2E725C2EUL,
0x974CDB97UL, 0x10302010UL, 0xA419BDA4UL, 0x985DC598UL, 0xA80DA5A8UL,
0xD4895DD4UL, 0x68B8D068UL, 0x2D775A2DUL, 0x62A6C462UL, 0x297B5229UL,
0x6DB7DA6DUL, 0x163A2C16UL, 0x49DB9249UL, 0x769AEC76UL, 0xC7BC7BC7UL,
0xE8CD25E8UL, 0xC1B677C1UL, 0x964FD996UL, 0x37596E37UL, 0xE5DA3FE5UL,
0xCAAB61CAUL, 0xF4E91DF4UL, 0xE9CE27E9UL, 0x63A5C663UL, 0x12362412UL,
0xC2B371C2UL, 0xA61FB9A6UL, 0x143C2814UL, 0xBC318DBCUL, 0xD38053D3UL,
0x28785028UL, 0xAF04ABAFUL, 0x2F715E2FUL, 0xE6DF39E6UL, 0x246C4824UL,
0x52F6A452UL, 0xC6BF79C6UL, 0xA015B5A0UL, 0x091B1209UL, 0xBD328FBDUL,
0x8C61ED8CUL, 0xCFA46BCFUL, 0x5DE7BA5DUL, 0x11332211UL, 0x5FE1BE5FUL,
0x01030201UL, 0xC5BA7FC5UL, 0x9F54CB9FUL, 0x3D477A3DUL, 0xA213B1A2UL,
0x9B58C39BUL, 0xC9AE67C9UL, 0x3B4D763BUL, 0xBE3789BEUL, 0x51F3A251UL,
0x192B3219UL, 0x1F213E1FUL, 0x3F417E3FUL, 0x5CE4B85CUL, 0xB22391B2UL,
0xEFC42BEFUL, 0x4ADE944AUL, 0xCDA26FCDUL, 0xBF348BBFUL, 0xBA3B81BAUL,
0x6FB1DE6FUL, 0x64ACC864UL, 0xD99E47D9UL, 0xF3E013F3UL, 0x3E427C3EUL,
0xB4299DB4UL, 0xAA0BA1AAUL, 0xDC914DDCUL, 0xD58A5FD5UL, 0x060A0C06UL,
0xC0B575C0UL, 0x7E82FC7EUL, 0xF6EF19F6UL, 0x66AACC66UL, 0x6CB4D86CUL,
0x8479FD84UL, 0x7193E271UL, 0x38487038UL, 0xB93E87B9UL, 0x1D273A1DUL,
0x7F81FE7FUL, 0x9D52CF9DUL, 0x48D89048UL, 0x8B68E38BUL, 0x2A7E542AUL,
0xDA9B41DAUL, 0xA51ABFA5UL, 0x33556633UL, 0x8273F182UL, 0x394B7239UL,
0xD68F59D6UL, 0x7888F078UL, 0x867FF986UL, 0xFAFB01FAUL, 0xE4D93DE4UL,
0x2B7D562BUL, 0xA90EA7A9UL, 0x1E223C1EUL, 0x896EE789UL, 0x60A0C060UL,
0x6BBDD66BUL, 0xEACB21EAUL, 0x55FFAA55UL, 0x4CD4984CUL, 0xF7EC1BF7UL,
0xE2D331E2UL };

const u32bit Square::TE3[256] = {
0xB1B12697UL, 0xCECEA769UL, 0xC3C3B073UL, 0x95954ADFUL, 0x5A5AEEB4UL,
0xADAD02AFUL, 0xE7E7DC3BUL, 0x02020604UL, 0x4D4DD79AUL, 0x4444CC88UL,
0xFBFBF803UL, 0x919146D7UL, 0x0C0C1418UL, 0x87877CFBUL, 0xA1A116B7UL,
0x5050F0A0UL, 0xCBCBA863UL, 0x6767A9CEUL, 0x5454FCA8UL, 0xDDDD924FUL,
0x4646CA8CUL, 0x8F8F64EBUL, 0xE1E1D637UL, 0x4E4ED29CUL, 0xF0F0E515UL,
0xFDFDF20FUL, 0xFCFCF10DUL, 0xEBEBC823UL, 0xF9F9FE07UL, 0xC4C4B97DUL,
0x1A1A2E34UL, 0x6E6EB2DCUL, 0x5E5EE2BCUL, 0xF5F5EA1FUL, 0xCCCCA16DUL,
0x8D8D62EFUL, 0x1C1C2438UL, 0x5656FAACUL, 0x4343C586UL, 0xFEFEF709UL,
0x0707090EUL, 0x6161A3C2UL, 0xF8F8FD05UL, 0x75759FEAUL, 0x5959EBB2UL,
0xFFFFF40BUL, 0x03030506UL, 0x22226644UL, 0x8A8A6BE1UL, 0xD1D18657UL,
0x13133526UL, 0xEEEEC729UL, 0x88886DE5UL, 0x00000000UL, 0x0E0E121CUL,
0x34345C68UL, 0x15153F2AUL, 0x808075F5UL, 0x949449DDUL, 0xE3E3D033UL,
0xEDEDC22FUL, 0xB5B52A9FUL, 0x5353F5A6UL, 0x23236546UL, 0x4B4BDD96UL,
0x4747C98EUL, 0x1717392EUL, 0xA7A71CBBUL, 0x909045D5UL, 0x35355F6AUL,
0xABAB08A3UL, 0xD8D89D45UL, 0xB8B83D85UL, 0xDFDF944BUL, 0x4F4FD19EUL,
0x5757F9AEUL, 0x9A9A5BC1UL, 0x929243D1UL, 0xDBDB9843UL, 0x1B1B2D36UL,
0x3C3C4478UL, 0xC8C8AD65UL, 0x99995EC7UL, 0x04040C08UL, 0x8E8E67E9UL,
0xE0E0D535UL, 0xD7D78C5BUL, 0x7D7D87FAUL, 0x85857AFFUL, 0xBBBB3883UL,
0x4040C080UL, 0x2C2C7458UL, 0x3A3A4E74UL, 0x4545CF8AUL, 0xF1F1E617UL,
0x4242C684UL, 0x6565AFCAUL, 0x20206040UL, 0x4141C382UL, 0x18182830UL,
0x727296E4UL, 0x25256F4AUL, 0x939340D3UL, 0x707090E0UL, 0x36365A6CUL,
0x05050F0AUL, 0xF2F2E311UL, 0x0B0B1D16UL, 0xA3A310B3UL, 0x79798BF2UL,
0xECECC12DUL, 0x08081810UL, 0x2727694EUL, 0x31315362UL, 0x32325664UL,
0xB6B62F99UL, 0x7C7C84F8UL, 0xB0B02595UL, 0x0A0A1E14UL, 0x737395E6UL,
0x5B5BEDB6UL, 0x7B7B8DF6UL, 0xB7B72C9BUL, 0x818176F7UL, 0xD2D28351UL,
0x0D0D171AUL, 0x6A6ABED4UL, 0x26266A4CUL, 0x9E9E57C9UL, 0x5858E8B0UL,
0x9C9C51CDUL, 0x838370F3UL, 0x74749CE8UL, 0xB3B32093UL, 0xACAC01ADUL,
0x30305060UL, 0x7A7A8EF4UL, 0x6969BBD2UL, 0x777799EEUL, 0x0F0F111EUL,
0xAEAE07A9UL, 0x21216342UL, 0xDEDE9749UL, 0xD0D08555UL, 0x2E2E725CUL,
0x97974CDBUL, 0x10103020UL, 0xA4A419BDUL, 0x98985DC5UL, 0xA8A80DA5UL,
0xD4D4895DUL, 0x6868B8D0UL, 0x2D2D775AUL, 0x6262A6C4UL, 0x29297B52UL,
0x6D6DB7DAUL, 0x16163A2CUL, 0x4949DB92UL, 0x76769AECUL, 0xC7C7BC7BUL,
0xE8E8CD25UL, 0xC1C1B677UL, 0x96964FD9UL, 0x3737596EUL, 0xE5E5DA3FUL,
0xCACAAB61UL, 0xF4F4E91DUL, 0xE9E9CE27UL, 0x6363A5C6UL, 0x12123624UL,
0xC2C2B371UL, 0xA6A61FB9UL, 0x14143C28UL, 0xBCBC318DUL, 0xD3D38053UL,
0x28287850UL, 0xAFAF04ABUL, 0x2F2F715EUL, 0xE6E6DF39UL, 0x24246C48UL,
0x5252F6A4UL, 0xC6C6BF79UL, 0xA0A015B5UL, 0x09091B12UL, 0xBDBD328FUL,
0x8C8C61EDUL, 0xCFCFA46BUL, 0x5D5DE7BAUL, 0x11113322UL, 0x5F5FE1BEUL,
0x01010302UL, 0xC5C5BA7FUL, 0x9F9F54CBUL, 0x3D3D477AUL, 0xA2A213B1UL,
0x9B9B58C3UL, 0xC9C9AE67UL, 0x3B3B4D76UL, 0xBEBE3789UL, 0x5151F3A2UL,
0x19192B32UL, 0x1F1F213EUL, 0x3F3F417EUL, 0x5C5CE4B8UL, 0xB2B22391UL,
0xEFEFC42BUL, 0x4A4ADE94UL, 0xCDCDA26FUL, 0xBFBF348BUL, 0xBABA3B81UL,
0x6F6FB1DEUL, 0x6464ACC8UL, 0xD9D99E47UL, 0xF3F3E013UL, 0x3E3E427CUL,
0xB4B4299DUL, 0xAAAA0BA1UL, 0xDCDC914DUL, 0xD5D58A5FUL, 0x06060A0CUL,
0xC0C0B575UL, 0x7E7E82FCUL, 0xF6F6EF19UL, 0x6666AACCUL, 0x6C6CB4D8UL,
0x848479FDUL, 0x717193E2UL, 0x38384870UL, 0xB9B93E87UL, 0x1D1D273AUL,
0x7F7F81FEUL, 0x9D9D52CFUL, 0x4848D890UL, 0x8B8B68E3UL, 0x2A2A7E54UL,
0xDADA9B41UL, 0xA5A51ABFUL, 0x33335566UL, 0x828273F1UL, 0x39394B72UL,
0xD6D68F59UL, 0x787888F0UL, 0x86867FF9UL, 0xFAFAFB01UL, 0xE4E4D93DUL,
0x2B2B7D56UL, 0xA9A90EA7UL, 0x1E1E223CUL, 0x89896EE7UL, 0x6060A0C0UL,
0x6B6BBDD6UL, 0xEAEACB21UL, 0x5555FFAAUL, 0x4C4CD498UL, 0xF7F7EC1BUL,
0xE2E2D331UL };

const u32bit Square::TD0[256] = {
0xE368BC02UL, 0x5585620CUL, 0x2A3F2331UL, 0x61AB13F7UL, 0x98D46D72UL,
0x21CB9A19UL, 0x3C22A461UL, 0x459D3DCDUL, 0x05FDB423UL, 0x2BC4075FUL,
0x9B2C01C0UL, 0x3DD9800FUL, 0x486C5C74UL, 0xF97F7E85UL, 0xF173AB1FUL,
0xB6EDDE0EUL, 0x283C6BEDUL, 0x4997781AUL, 0x9F2A918DUL, 0xC9579F33UL,
0xA907A8AAUL, 0xA50DED7DUL, 0x7C422D8FUL, 0x764DB0C9UL, 0x4D91E857UL,
0xCEA963CCUL, 0xB4EE96D2UL, 0x3028E1B6UL, 0x0DF161B9UL, 0xBD196726UL,
0x419BAD80UL, 0xC0A06EC7UL, 0x5183F241UL, 0x92DBF034UL, 0x6FA21EFCUL,
0x8F32CE4CUL, 0x13E03373UL, 0x69A7C66DUL, 0xE56D6493UL, 0xBF1A2FFAUL,
0xBB1CBFB7UL, 0x587403B5UL, 0xE76E2C4FUL, 0x5D89B796UL, 0xE89C052AUL,
0x446619A3UL, 0x342E71FBUL, 0x0FF22965UL, 0xFE81827AUL, 0xB11322F1UL,
0xA30835ECUL, 0xCD510F7EUL, 0xFF7AA614UL, 0x5C7293F8UL, 0x2FC29712UL,
0xF370E3C3UL, 0x992F491CUL, 0xD1431568UL, 0xC2A3261BUL, 0x88CC32B3UL,
0x8ACF7A6FUL, 0xB0E8069FUL, 0x7A47F51EUL, 0xD2BB79DAUL, 0xE6950821UL,
0x4398E55CUL, 0xD0B83106UL, 0x11E37BAFUL, 0x7E416553UL, 0xCCAA2B10UL,
0xD8B4E49CUL, 0x6456A7D4UL, 0xFB7C3659UL, 0x724B2084UL, 0xEA9F4DF6UL,
0x6A5FAADFUL, 0x2DC1DFCEUL, 0x70486858UL, 0xCAAFF381UL, 0x0605D891UL,
0x5A774B69UL, 0x94DE28A5UL, 0x39DF1042UL, 0x813BC347UL, 0xFC82CAA6UL,
0x23C8D2C5UL, 0x03F86CB2UL, 0x080CD59AUL, 0xDAB7AC40UL, 0x7DB909E1UL,
0x3824342CUL, 0xCF5247A2UL, 0xDCB274D1UL, 0x63A85B2BUL, 0x35D55595UL,
0x479E7511UL, 0x15E5EBE2UL, 0x4B9430C6UL, 0x4A6F14A8UL, 0x91239C86UL,
0x4C6ACC39UL, 0x5F8AFF4AUL, 0x0406904DUL, 0xEE99DDBBUL, 0x1E1152CAUL,
0xAAFFC418UL, 0xEB646998UL, 0x07FEFCFFUL, 0x8B345E01UL, 0x567D0EBEUL,
0xBAE79BD9UL, 0x4263C132UL, 0x75B5DC7BUL, 0x97264417UL, 0x67AECB66UL,
0x95250CCBUL, 0xEC9A9567UL, 0x57862AD0UL, 0x60503799UL, 0xB8E4D305UL,
0x65AD83BAUL, 0x19EFAE35UL, 0xA4F6C913UL, 0xC15B4AA9UL, 0x873E1BD6UL,
0xA0F0595EUL, 0x18148A5BUL, 0xAF02703BUL, 0xAB04E076UL, 0xDD4950BFUL,
0xDF4A1863UL, 0xC6A5B656UL, 0x853D530AUL, 0xFA871237UL, 0x77B694A7UL,
0x4665517FUL, 0xED61B109UL, 0x1BECE6E9UL, 0xD5458525UL, 0xF5753B52UL,
0x7FBA413DUL, 0x27CE4288UL, 0xB2EB4E43UL, 0xD6BDE997UL, 0x527B9EF3UL,
0x62537F45UL, 0x2C3AFBA0UL, 0x7BBCD170UL, 0xB91FF76BUL, 0x121B171DUL,
0xFD79EEC8UL, 0x3A277CF0UL, 0x0C0A45D7UL, 0x96DD6079UL, 0x2233F6ABUL,
0xACFA1C89UL, 0xC8ACBB5DUL, 0xA10B7D30UL, 0xD4BEA14BUL, 0xBEE10B94UL,
0x25CD0A54UL, 0x547E4662UL, 0xA2F31182UL, 0x17E6A33EUL, 0x263566E6UL,
0xC3580275UL, 0x83388B9BUL, 0x7844BDC2UL, 0x020348DCUL, 0x4F92A08BUL,
0x2E39B37CUL, 0x4E6984E5UL, 0xF0888F71UL, 0x362D3927UL, 0x9CD2FD3FUL,
0x01FB246EUL, 0x893716DDUL, 0x00000000UL, 0xF68D57E0UL, 0xE293986CUL,
0x744EF815UL, 0x9320D45AUL, 0xAD0138E7UL, 0xD3405DB4UL, 0x1A17C287UL,
0xB3106A2DUL, 0x5078D62FUL, 0xF48E1F3CUL, 0xA70EA5A1UL, 0x71B34C36UL,
0x9AD725AEUL, 0x5E71DB24UL, 0x161D8750UL, 0xEF62F9D5UL, 0x8D318690UL,
0x1C121A16UL, 0xA6F581CFUL, 0x5B8C6F07UL, 0x37D61D49UL, 0x6E593A92UL,
0x84C67764UL, 0x86C53FB8UL, 0xD746CDF9UL, 0xE090D0B0UL, 0x29C74F83UL,
0xE49640FDUL, 0x0E090D0BUL, 0x6DA15620UL, 0x8EC9EA22UL, 0xDB4C882EUL,
0xF776738EUL, 0xB515B2BCUL, 0x10185FC1UL, 0x322BA96AUL, 0x6BA48EB1UL,
0xAEF95455UL, 0x406089EEUL, 0x6655EF08UL, 0xE9672144UL, 0x3E21ECBDUL,
0x2030BE77UL, 0xF28BC7ADUL, 0x80C0E729UL, 0x141ECF8CUL, 0xBCE24348UL,
0xC4A6FE8AUL, 0x31D3C5D8UL, 0xB716FA60UL, 0x5380BA9DUL, 0xD94FC0F2UL,
0x1DE93E78UL, 0x24362E3AUL, 0xE16BF4DEUL, 0xCB54D7EFUL, 0x09F7F1F4UL,
0x82C3AFF5UL, 0x0BF4B928UL, 0x9D29D951UL, 0xC75E9238UL, 0xF8845AEBUL,
0x90D8B8E8UL, 0xDEB13C0DUL, 0x33D08D04UL, 0x685CE203UL, 0xC55DDAE4UL,
0x3BDC589EUL, 0x0A0F9D46UL, 0x3FDAC8D3UL, 0x598F27DBUL, 0xA8FC8CC4UL,
0x79BF99ACUL, 0x6C5A724EUL, 0x8CCAA2FEUL, 0x9ED1B5E3UL, 0x1FEA76A4UL,
0x73B004EAUL };

const u32bit Square::TD1[256] = {
0x02E368BCUL, 0x0C558562UL, 0x312A3F23UL, 0xF761AB13UL, 0x7298D46DUL,
0x1921CB9AUL, 0x613C22A4UL, 0xCD459D3DUL, 0x2305FDB4UL, 0x5F2BC407UL,
0xC09B2C01UL, 0x0F3DD980UL, 0x74486C5CUL, 0x85F97F7EUL, 0x1FF173ABUL,
0x0EB6EDDEUL, 0xED283C6BUL, 0x1A499778UL, 0x8D9F2A91UL, 0x33C9579FUL,
0xAAA907A8UL, 0x7DA50DEDUL, 0x8F7C422DUL, 0xC9764DB0UL, 0x574D91E8UL,
0xCCCEA963UL, 0xD2B4EE96UL, 0xB63028E1UL, 0xB90DF161UL, 0x26BD1967UL,
0x80419BADUL, 0xC7C0A06EUL, 0x415183F2UL, 0x3492DBF0UL, 0xFC6FA21EUL,
0x4C8F32CEUL, 0x7313E033UL, 0x6D69A7C6UL, 0x93E56D64UL, 0xFABF1A2FUL,
0xB7BB1CBFUL, 0xB5587403UL, 0x4FE76E2CUL, 0x965D89B7UL, 0x2AE89C05UL,
0xA3446619UL, 0xFB342E71UL, 0x650FF229UL, 0x7AFE8182UL, 0xF1B11322UL,
0xECA30835UL, 0x7ECD510FUL, 0x14FF7AA6UL, 0xF85C7293UL, 0x122FC297UL,
0xC3F370E3UL, 0x1C992F49UL, 0x68D14315UL, 0x1BC2A326UL, 0xB388CC32UL,
0x6F8ACF7AUL, 0x9FB0E806UL, 0x1E7A47F5UL, 0xDAD2BB79UL, 0x21E69508UL,
0x5C4398E5UL, 0x06D0B831UL, 0xAF11E37BUL, 0x537E4165UL, 0x10CCAA2BUL,
0x9CD8B4E4UL, 0xD46456A7UL, 0x59FB7C36UL, 0x84724B20UL, 0xF6EA9F4DUL,
0xDF6A5FAAUL, 0xCE2DC1DFUL, 0x58704868UL, 0x81CAAFF3UL, 0x910605D8UL,
0x695A774BUL, 0xA594DE28UL, 0x4239DF10UL, 0x47813BC3UL, 0xA6FC82CAUL,
0xC523C8D2UL, 0xB203F86CUL, 0x9A080CD5UL, 0x40DAB7ACUL, 0xE17DB909UL,
0x2C382434UL, 0xA2CF5247UL, 0xD1DCB274UL, 0x2B63A85BUL, 0x9535D555UL,
0x11479E75UL, 0xE215E5EBUL, 0xC64B9430UL, 0xA84A6F14UL, 0x8691239CUL,
0x394C6ACCUL, 0x4A5F8AFFUL, 0x4D040690UL, 0xBBEE99DDUL, 0xCA1E1152UL,
0x18AAFFC4UL, 0x98EB6469UL, 0xFF07FEFCUL, 0x018B345EUL, 0xBE567D0EUL,
0xD9BAE79BUL, 0x324263C1UL, 0x7B75B5DCUL, 0x17972644UL, 0x6667AECBUL,
0xCB95250CUL, 0x67EC9A95UL, 0xD057862AUL, 0x99605037UL, 0x05B8E4D3UL,
0xBA65AD83UL, 0x3519EFAEUL, 0x13A4F6C9UL, 0xA9C15B4AUL, 0xD6873E1BUL,
0x5EA0F059UL, 0x5B18148AUL, 0x3BAF0270UL, 0x76AB04E0UL, 0xBFDD4950UL,
0x63DF4A18UL, 0x56C6A5B6UL, 0x0A853D53UL, 0x37FA8712UL, 0xA777B694UL,
0x7F466551UL, 0x09ED61B1UL, 0xE91BECE6UL, 0x25D54585UL, 0x52F5753BUL,
0x3D7FBA41UL, 0x8827CE42UL, 0x43B2EB4EUL, 0x97D6BDE9UL, 0xF3527B9EUL,
0x4562537FUL, 0xA02C3AFBUL, 0x707BBCD1UL, 0x6BB91FF7UL, 0x1D121B17UL,
0xC8FD79EEUL, 0xF03A277CUL, 0xD70C0A45UL, 0x7996DD60UL, 0xAB2233F6UL,
0x89ACFA1CUL, 0x5DC8ACBBUL, 0x30A10B7DUL, 0x4BD4BEA1UL, 0x94BEE10BUL,
0x5425CD0AUL, 0x62547E46UL, 0x82A2F311UL, 0x3E17E6A3UL, 0xE6263566UL,
0x75C35802UL, 0x9B83388BUL, 0xC27844BDUL, 0xDC020348UL, 0x8B4F92A0UL,
0x7C2E39B3UL, 0xE54E6984UL, 0x71F0888FUL, 0x27362D39UL, 0x3F9CD2FDUL,
0x6E01FB24UL, 0xDD893716UL, 0x00000000UL, 0xE0F68D57UL, 0x6CE29398UL,
0x15744EF8UL, 0x5A9320D4UL, 0xE7AD0138UL, 0xB4D3405DUL, 0x871A17C2UL,
0x2DB3106AUL, 0x2F5078D6UL, 0x3CF48E1FUL, 0xA1A70EA5UL, 0x3671B34CUL,
0xAE9AD725UL, 0x245E71DBUL, 0x50161D87UL, 0xD5EF62F9UL, 0x908D3186UL,
0x161C121AUL, 0xCFA6F581UL, 0x075B8C6FUL, 0x4937D61DUL, 0x926E593AUL,
0x6484C677UL, 0xB886C53FUL, 0xF9D746CDUL, 0xB0E090D0UL, 0x8329C74FUL,
0xFDE49640UL, 0x0B0E090DUL, 0x206DA156UL, 0x228EC9EAUL, 0x2EDB4C88UL,
0x8EF77673UL, 0xBCB515B2UL, 0xC110185FUL, 0x6A322BA9UL, 0xB16BA48EUL,
0x55AEF954UL, 0xEE406089UL, 0x086655EFUL, 0x44E96721UL, 0xBD3E21ECUL,
0x772030BEUL, 0xADF28BC7UL, 0x2980C0E7UL, 0x8C141ECFUL, 0x48BCE243UL,
0x8AC4A6FEUL, 0xD831D3C5UL, 0x60B716FAUL, 0x9D5380BAUL, 0xF2D94FC0UL,
0x781DE93EUL, 0x3A24362EUL, 0xDEE16BF4UL, 0xEFCB54D7UL, 0xF409F7F1UL,
0xF582C3AFUL, 0x280BF4B9UL, 0x519D29D9UL, 0x38C75E92UL, 0xEBF8845AUL,
0xE890D8B8UL, 0x0DDEB13CUL, 0x0433D08DUL, 0x03685CE2UL, 0xE4C55DDAUL,
0x9E3BDC58UL, 0x460A0F9DUL, 0xD33FDAC8UL, 0xDB598F27UL, 0xC4A8FC8CUL,
0xAC79BF99UL, 0x4E6C5A72UL, 0xFE8CCAA2UL, 0xE39ED1B5UL, 0xA41FEA76UL,
0xEA73B004UL };

const u32bit Square::TD2[256] = {
0xBC02E368UL, 0x620C5585UL, 0x23312A3FUL, 0x13F761ABUL, 0x6D7298D4UL,
0x9A1921CBUL, 0xA4613C22UL, 0x3DCD459DUL, 0xB42305FDUL, 0x075F2BC4UL,
0x01C09B2CUL, 0x800F3DD9UL, 0x5C74486CUL, 0x7E85F97FUL, 0xAB1FF173UL,
0xDE0EB6EDUL, 0x6BED283CUL, 0x781A4997UL, 0x918D9F2AUL, 0x9F33C957UL,
0xA8AAA907UL, 0xED7DA50DUL, 0x2D8F7C42UL, 0xB0C9764DUL, 0xE8574D91UL,
0x63CCCEA9UL, 0x96D2B4EEUL, 0xE1B63028UL, 0x61B90DF1UL, 0x6726BD19UL,
0xAD80419BUL, 0x6EC7C0A0UL, 0xF2415183UL, 0xF03492DBUL, 0x1EFC6FA2UL,
0xCE4C8F32UL, 0x337313E0UL, 0xC66D69A7UL, 0x6493E56DUL, 0x2FFABF1AUL,
0xBFB7BB1CUL, 0x03B55874UL, 0x2C4FE76EUL, 0xB7965D89UL, 0x052AE89CUL,
0x19A34466UL, 0x71FB342EUL, 0x29650FF2UL, 0x827AFE81UL, 0x22F1B113UL,
0x35ECA308UL, 0x0F7ECD51UL, 0xA614FF7AUL, 0x93F85C72UL, 0x97122FC2UL,
0xE3C3F370UL, 0x491C992FUL, 0x1568D143UL, 0x261BC2A3UL, 0x32B388CCUL,
0x7A6F8ACFUL, 0x069FB0E8UL, 0xF51E7A47UL, 0x79DAD2BBUL, 0x0821E695UL,
0xE55C4398UL, 0x3106D0B8UL, 0x7BAF11E3UL, 0x65537E41UL, 0x2B10CCAAUL,
0xE49CD8B4UL, 0xA7D46456UL, 0x3659FB7CUL, 0x2084724BUL, 0x4DF6EA9FUL,
0xAADF6A5FUL, 0xDFCE2DC1UL, 0x68587048UL, 0xF381CAAFUL, 0xD8910605UL,
0x4B695A77UL, 0x28A594DEUL, 0x104239DFUL, 0xC347813BUL, 0xCAA6FC82UL,
0xD2C523C8UL, 0x6CB203F8UL, 0xD59A080CUL, 0xAC40DAB7UL, 0x09E17DB9UL,
0x342C3824UL, 0x47A2CF52UL, 0x74D1DCB2UL, 0x5B2B63A8UL, 0x559535D5UL,
0x7511479EUL, 0xEBE215E5UL, 0x30C64B94UL, 0x14A84A6FUL, 0x9C869123UL,
0xCC394C6AUL, 0xFF4A5F8AUL, 0x904D0406UL, 0xDDBBEE99UL, 0x52CA1E11UL,
0xC418AAFFUL, 0x6998EB64UL, 0xFCFF07FEUL, 0x5E018B34UL, 0x0EBE567DUL,
0x9BD9BAE7UL, 0xC1324263UL, 0xDC7B75B5UL, 0x44179726UL, 0xCB6667AEUL,
0x0CCB9525UL, 0x9567EC9AUL, 0x2AD05786UL, 0x37996050UL, 0xD305B8E4UL,
0x83BA65ADUL, 0xAE3519EFUL, 0xC913A4F6UL, 0x4AA9C15BUL, 0x1BD6873EUL,
0x595EA0F0UL, 0x8A5B1814UL, 0x703BAF02UL, 0xE076AB04UL, 0x50BFDD49UL,
0x1863DF4AUL, 0xB656C6A5UL, 0x530A853DUL, 0x1237FA87UL, 0x94A777B6UL,
0x517F4665UL, 0xB109ED61UL, 0xE6E91BECUL, 0x8525D545UL, 0x3B52F575UL,
0x413D7FBAUL, 0x428827CEUL, 0x4E43B2EBUL, 0xE997D6BDUL, 0x9EF3527BUL,
0x7F456253UL, 0xFBA02C3AUL, 0xD1707BBCUL, 0xF76BB91FUL, 0x171D121BUL,
0xEEC8FD79UL, 0x7CF03A27UL, 0x45D70C0AUL, 0x607996DDUL, 0xF6AB2233UL,
0x1C89ACFAUL, 0xBB5DC8ACUL, 0x7D30A10BUL, 0xA14BD4BEUL, 0x0B94BEE1UL,
0x0A5425CDUL, 0x4662547EUL, 0x1182A2F3UL, 0xA33E17E6UL, 0x66E62635UL,
0x0275C358UL, 0x8B9B8338UL, 0xBDC27844UL, 0x48DC0203UL, 0xA08B4F92UL,
0xB37C2E39UL, 0x84E54E69UL, 0x8F71F088UL, 0x3927362DUL, 0xFD3F9CD2UL,
0x246E01FBUL, 0x16DD8937UL, 0x00000000UL, 0x57E0F68DUL, 0x986CE293UL,
0xF815744EUL, 0xD45A9320UL, 0x38E7AD01UL, 0x5DB4D340UL, 0xC2871A17UL,
0x6A2DB310UL, 0xD62F5078UL, 0x1F3CF48EUL, 0xA5A1A70EUL, 0x4C3671B3UL,
0x25AE9AD7UL, 0xDB245E71UL, 0x8750161DUL, 0xF9D5EF62UL, 0x86908D31UL,
0x1A161C12UL, 0x81CFA6F5UL, 0x6F075B8CUL, 0x1D4937D6UL, 0x3A926E59UL,
0x776484C6UL, 0x3FB886C5UL, 0xCDF9D746UL, 0xD0B0E090UL, 0x4F8329C7UL,
0x40FDE496UL, 0x0D0B0E09UL, 0x56206DA1UL, 0xEA228EC9UL, 0x882EDB4CUL,
0x738EF776UL, 0xB2BCB515UL, 0x5FC11018UL, 0xA96A322BUL, 0x8EB16BA4UL,
0x5455AEF9UL, 0x89EE4060UL, 0xEF086655UL, 0x2144E967UL, 0xECBD3E21UL,
0xBE772030UL, 0xC7ADF28BUL, 0xE72980C0UL, 0xCF8C141EUL, 0x4348BCE2UL,
0xFE8AC4A6UL, 0xC5D831D3UL, 0xFA60B716UL, 0xBA9D5380UL, 0xC0F2D94FUL,
0x3E781DE9UL, 0x2E3A2436UL, 0xF4DEE16BUL, 0xD7EFCB54UL, 0xF1F409F7UL,
0xAFF582C3UL, 0xB9280BF4UL, 0xD9519D29UL, 0x9238C75EUL, 0x5AEBF884UL,
0xB8E890D8UL, 0x3C0DDEB1UL, 0x8D0433D0UL, 0xE203685CUL, 0xDAE4C55DUL,
0x589E3BDCUL, 0x9D460A0FUL, 0xC8D33FDAUL, 0x27DB598FUL, 0x8CC4A8FCUL,
0x99AC79BFUL, 0x724E6C5AUL, 0xA2FE8CCAUL, 0xB5E39ED1UL, 0x76A41FEAUL,
0x04EA73B0UL };

const u32bit Square::TD3[256] = {
0x68BC02E3UL, 0x85620C55UL, 0x3F23312AUL, 0xAB13F761UL, 0xD46D7298UL,
0xCB9A1921UL, 0x22A4613CUL, 0x9D3DCD45UL, 0xFDB42305UL, 0xC4075F2BUL,
0x2C01C09BUL, 0xD9800F3DUL, 0x6C5C7448UL, 0x7F7E85F9UL, 0x73AB1FF1UL,
0xEDDE0EB6UL, 0x3C6BED28UL, 0x97781A49UL, 0x2A918D9FUL, 0x579F33C9UL,
0x07A8AAA9UL, 0x0DED7DA5UL, 0x422D8F7CUL, 0x4DB0C976UL, 0x91E8574DUL,
0xA963CCCEUL, 0xEE96D2B4UL, 0x28E1B630UL, 0xF161B90DUL, 0x196726BDUL,
0x9BAD8041UL, 0xA06EC7C0UL, 0x83F24151UL, 0xDBF03492UL, 0xA21EFC6FUL,
0x32CE4C8FUL, 0xE0337313UL, 0xA7C66D69UL, 0x6D6493E5UL, 0x1A2FFABFUL,
0x1CBFB7BBUL, 0x7403B558UL, 0x6E2C4FE7UL, 0x89B7965DUL, 0x9C052AE8UL,
0x6619A344UL, 0x2E71FB34UL, 0xF229650FUL, 0x81827AFEUL, 0x1322F1B1UL,
0x0835ECA3UL, 0x510F7ECDUL, 0x7AA614FFUL, 0x7293F85CUL, 0xC297122FUL,
0x70E3C3F3UL, 0x2F491C99UL, 0x431568D1UL, 0xA3261BC2UL, 0xCC32B388UL,
0xCF7A6F8AUL, 0xE8069FB0UL, 0x47F51E7AUL, 0xBB79DAD2UL, 0x950821E6UL,
0x98E55C43UL, 0xB83106D0UL, 0xE37BAF11UL, 0x4165537EUL, 0xAA2B10CCUL,
0xB4E49CD8UL, 0x56A7D464UL, 0x7C3659FBUL, 0x4B208472UL, 0x9F4DF6EAUL,
0x5FAADF6AUL, 0xC1DFCE2DUL, 0x48685870UL, 0xAFF381CAUL, 0x05D89106UL,
0x774B695AUL, 0xDE28A594UL, 0xDF104239UL, 0x3BC34781UL, 0x82CAA6FCUL,
0xC8D2C523UL, 0xF86CB203UL, 0x0CD59A08UL, 0xB7AC40DAUL, 0xB909E17DUL,
0x24342C38UL, 0x5247A2CFUL, 0xB274D1DCUL, 0xA85B2B63UL, 0xD5559535UL,
0x9E751147UL, 0xE5EBE215UL, 0x9430C64BUL, 0x6F14A84AUL, 0x239C8691UL,
0x6ACC394CUL, 0x8AFF4A5FUL, 0x06904D04UL, 0x99DDBBEEUL, 0x1152CA1EUL,
0xFFC418AAUL, 0x646998EBUL, 0xFEFCFF07UL, 0x345E018BUL, 0x7D0EBE56UL,
0xE79BD9BAUL, 0x63C13242UL, 0xB5DC7B75UL, 0x26441797UL, 0xAECB6667UL,
0x250CCB95UL, 0x9A9567ECUL, 0x862AD057UL, 0x50379960UL, 0xE4D305B8UL,
0xAD83BA65UL, 0xEFAE3519UL, 0xF6C913A4UL, 0x5B4AA9C1UL, 0x3E1BD687UL,
0xF0595EA0UL, 0x148A5B18UL, 0x02703BAFUL, 0x04E076ABUL, 0x4950BFDDUL,
0x4A1863DFUL, 0xA5B656C6UL, 0x3D530A85UL, 0x871237FAUL, 0xB694A777UL,
0x65517F46UL, 0x61B109EDUL, 0xECE6E91BUL, 0x458525D5UL, 0x753B52F5UL,
0xBA413D7FUL, 0xCE428827UL, 0xEB4E43B2UL, 0xBDE997D6UL, 0x7B9EF352UL,
0x537F4562UL, 0x3AFBA02CUL, 0xBCD1707BUL, 0x1FF76BB9UL, 0x1B171D12UL,
0x79EEC8FDUL, 0x277CF03AUL, 0x0A45D70CUL, 0xDD607996UL, 0x33F6AB22UL,
0xFA1C89ACUL, 0xACBB5DC8UL, 0x0B7D30A1UL, 0xBEA14BD4UL, 0xE10B94BEUL,
0xCD0A5425UL, 0x7E466254UL, 0xF31182A2UL, 0xE6A33E17UL, 0x3566E626UL,
0x580275C3UL, 0x388B9B83UL, 0x44BDC278UL, 0x0348DC02UL, 0x92A08B4FUL,
0x39B37C2EUL, 0x6984E54EUL, 0x888F71F0UL, 0x2D392736UL, 0xD2FD3F9CUL,
0xFB246E01UL, 0x3716DD89UL, 0x00000000UL, 0x8D57E0F6UL, 0x93986CE2UL,
0x4EF81574UL, 0x20D45A93UL, 0x0138E7ADUL, 0x405DB4D3UL, 0x17C2871AUL,
0x106A2DB3UL, 0x78D62F50UL, 0x8E1F3CF4UL, 0x0EA5A1A7UL, 0xB34C3671UL,
0xD725AE9AUL, 0x71DB245EUL, 0x1D875016UL, 0x62F9D5EFUL, 0x3186908DUL,
0x121A161CUL, 0xF581CFA6UL, 0x8C6F075BUL, 0xD61D4937UL, 0x593A926EUL,
0xC6776484UL, 0xC53FB886UL, 0x46CDF9D7UL, 0x90D0B0E0UL, 0xC74F8329UL,
0x9640FDE4UL, 0x090D0B0EUL, 0xA156206DUL, 0xC9EA228EUL, 0x4C882EDBUL,
0x76738EF7UL, 0x15B2BCB5UL, 0x185FC110UL, 0x2BA96A32UL, 0xA48EB16BUL,
0xF95455AEUL, 0x6089EE40UL, 0x55EF0866UL, 0x672144E9UL, 0x21ECBD3EUL,
0x30BE7720UL, 0x8BC7ADF2UL, 0xC0E72980UL, 0x1ECF8C14UL, 0xE24348BCUL,
0xA6FE8AC4UL, 0xD3C5D831UL, 0x16FA60B7UL, 0x80BA9D53UL, 0x4FC0F2D9UL,
0xE93E781DUL, 0x362E3A24UL, 0x6BF4DEE1UL, 0x54D7EFCBUL, 0xF7F1F409UL,
0xC3AFF582UL, 0xF4B9280BUL, 0x29D9519DUL, 0x5E9238C7UL, 0x845AEBF8UL,
0xD8B8E890UL, 0xB13C0DDEUL, 0xD08D0433UL, 0x5CE20368UL, 0x5DDAE4C5UL,
0xDC589E3BUL, 0x0F9D460AUL, 0xDAC8D33FUL, 0x8F27DB59UL, 0xFC8CC4A8UL,
0xBF99AC79UL, 0x5A724E6CUL, 0xCAA2FE8CUL, 0xD1B5E39EUL, 0xEA76A41FUL,
0xB004EA73UL };

}
