/*************************************************
* SymmetricKey Source File                       *
* (C) 1999-2001 The OpenCL Project               *
*************************************************/

#include <opencl/symkey.h>
#include <opencl/encoder.h>

namespace OpenCL {

/*************************************************
* Create a SymmetricKey from RNG output          *
*************************************************/
void SymmetricKey::change(RandomNumberGenerator& rng, u32bit length)
   {
   key.create(length);
   rng.randomize(key, length);
   }

/*************************************************
* Create a SymmeticKey from a hex string         *
*************************************************/
void SymmetricKey::change(const std::string& hex)
   {
   if(hex.length() % 2 != 0)
      throw InvalidArgument("SymmeticKey: hex string must encode full bytes");
   key.create(hex.length() / 2);
   for(u32bit j = 0; j != key.size(); j++)
      Hex::decode((byte*)hex.c_str() + 2*j, key[j]);
   }

}
