using System;

using Org.BouncyCastle.Math;
using Org.BouncyCastle.Math.EC;

namespace Org.BouncyCastle.Asn1.X9
{
    public sealed class X9IntegerConverter
    {
		private X9IntegerConverter()
		{
		}

		public static int GetByteLength(
            ECFieldElement fe)
        {
            if (fe is FpFieldElement)
            {
                FpFieldElement ep = (FpFieldElement) fe;

				return (ep.Q.BitLength + 7) / 8;
            }

			F2mFieldElement em = (F2mFieldElement)fe;

			return (em.M + 7) / 8;
        }

		public static byte[] IntegerToBytes(
            BigInteger	s,
            int			qLength)
        {
            byte[] bytes = s.ToByteArray();

			if (qLength < bytes.Length)
            {
                byte[] tmp = new byte[qLength];

                Array.Copy(bytes, bytes.Length - tmp.Length, tmp, 0, tmp.Length);

                return tmp;
            }

			if (qLength > bytes.Length)
            {
                byte[] tmp = new byte[qLength];

                Array.Copy(bytes, 0, tmp, tmp.Length - bytes.Length, bytes.Length);

                return tmp;
            }

			return bytes;
        }
    }
}
