/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerId;

public class SignerInformation {
    private SignerId sid = new SignerId();
    private AlgorithmIdentifier digestAlgorithm;
    private AlgorithmIdentifier encryptionAlgorithm;
    private ASN1Set signedAttributes;
    private ASN1Set unsignedAttributes;
    private CMSProcessable content;
    private byte[] signature;
    private DERObjectIdentifier contentType;

    SignerInformation(SignerInfo signerInfo, DERObjectIdentifier dERObjectIdentifier, CMSProcessable cMSProcessable) {
        this.contentType = dERObjectIdentifier;
        try {
            SignerIdentifier signerIdentifier = signerInfo.getSID();
            if (signerIdentifier.isTagged()) {
                ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance((Object)signerIdentifier.getId());
                this.sid.setSubjectKeyIdentifier(aSN1OctetString.getOctets());
            } else {
                IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)signerIdentifier.getId());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
                aSN1OutputStream.writeObject((Object)issuerAndSerialNumber.getName());
                this.sid.setIssuer(byteArrayOutputStream.toByteArray());
                this.sid.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid sid in SignerInfo");
        }
        this.digestAlgorithm = signerInfo.getDigestAlgorithm();
        this.signedAttributes = signerInfo.getAuthenticatedAttributes();
        this.unsignedAttributes = signerInfo.getUnauthenticatedAttributes();
        this.encryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm();
        this.signature = signerInfo.getEncryptedDigest().getOctets();
        this.content = cMSProcessable;
    }

    private byte[] encodeObj(DEREncodable dEREncodable) throws IOException {
        if (dEREncodable != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)dEREncodable);
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public SignerId getSID() {
        return this.sid;
    }

    public String getDigestAlgOID() {
        return this.digestAlgorithm.getObjectId().getId();
    }

    public byte[] getDigestAlgParams() {
        try {
            return this.encodeObj(this.digestAlgorithm.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting digest parameters " + exception);
        }
    }

    public String getEncryptionAlgOID() {
        return this.encryptionAlgorithm.getObjectId().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this.encryptionAlgorithm.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encyrption parameters " + exception);
        }
    }

    String getDigestAlgName() {
        String string = this.getDigestAlgOID();
        if ("1.2.840.113549.2.5".equals(string)) {
            return "MD5";
        }
        if ("1.3.14.3.2.26".equals(string)) {
            return "SHA1";
        }
        return string;
    }

    String getEncryptionAlgName() {
        String string = this.getEncryptionAlgOID();
        if ("1.2.840.10040.4.3".equals(string)) {
            return "DSA";
        }
        if ("1.2.840.113549.1.1.1".equals(string)) {
            return "RSA";
        }
        return string;
    }

    public AttributeTable getSignedAttributes() {
        if (this.signedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.signedAttributes);
    }

    public AttributeTable getUnsignedAttributes() {
        if (this.unsignedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.unsignedAttributes);
    }

    public byte[] getSignature() {
        return this.signature;
    }

    private boolean doVerify(MessageDigest messageDigest, Signature signature, PublicKey publicKey, AttributeTable attributeTable) throws CMSException {
        try {
            signature.initVerify(publicKey);
            if (this.signedAttributes == null) {
                this.content.write(new CMSSignedDataGenerator.SigOutputStream(signature));
            } else {
                this.content.write(new CMSSignedDataGenerator.DigOutputStream(messageDigest));
                byte[] byArray = messageDigest.digest();
                Attribute attribute = attributeTable.get(CMSAttributes.messageDigest);
                Attribute attribute2 = attributeTable.get(CMSAttributes.contentType);
                if (attribute == null) {
                    throw new SignatureException("no hash for content found in signed attributes");
                }
                if (attribute2 == null) {
                    throw new SignatureException("no content type id found in signed attributes");
                }
                byte[] byArray2 = ((ASN1OctetString)attribute.getAttrValues().getObjectAt(0)).getOctets();
                if (!MessageDigest.isEqual(byArray, byArray2)) {
                    throw new SignatureException("content hash found in signed attributes different");
                }
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)attribute2.getAttrValues().getObjectAt(0);
                if (!dERObjectIdentifier.equals((Object)this.contentType)) {
                    throw new SignatureException("contentType in signed attributes different");
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)byteArrayOutputStream);
                dEROutputStream.writeObject((Object)this.signedAttributes);
                dEROutputStream.close();
                signature.update(byteArrayOutputStream.toByteArray());
            }
            return signature.verify(this.getSignature());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key not appropriate to signature in message.", invalidKeyException);
        }
        catch (IOException iOException) {
            throw new CMSException("can't process mime object to create signature.", iOException);
        }
        catch (SignatureException signatureException) {
            throw new CMSException("invalid signature format in message.", signatureException);
        }
    }

    public boolean verify(PublicKey publicKey, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        MessageDigest messageDigest;
        Signature signature;
        if (string != null) {
            signature = Signature.getInstance(this.getDigestAlgName() + "with" + this.getEncryptionAlgName(), string);
            messageDigest = MessageDigest.getInstance(this.getDigestAlgName(), string);
        } else {
            signature = Signature.getInstance(this.getDigestAlgName() + "with" + this.getEncryptionAlgName());
            messageDigest = MessageDigest.getInstance(this.getDigestAlgName());
        }
        return this.doVerify(messageDigest, signature, publicKey, this.getSignedAttributes());
    }

    public boolean verify(X509Certificate x509Certificate, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateExpiredException, CertificateNotYetValidException, CMSException {
        Attribute attribute;
        MessageDigest messageDigest;
        Signature signature;
        if (string != null) {
            signature = Signature.getInstance(this.getDigestAlgName() + "with" + this.getEncryptionAlgName(), string);
            messageDigest = MessageDigest.getInstance(this.getDigestAlgName(), string);
        } else {
            signature = Signature.getInstance(this.getDigestAlgName() + "with" + this.getEncryptionAlgName());
            messageDigest = MessageDigest.getInstance(this.getDigestAlgName());
        }
        AttributeTable attributeTable = this.getSignedAttributes();
        if (attributeTable != null && (attribute = attributeTable.get(CMSAttributes.signingTime)) != null) {
            Time time = Time.getInstance((Object)attribute.getAttrValues().getObjectAt(0));
            x509Certificate.checkValidity(time.getDate());
        }
        return this.doVerify(messageDigest, signature, x509Certificate.getPublicKey(), attributeTable);
    }
}

