/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS7SignedData;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.X509V1CertificateGenerator;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PKCS7SignedDataTest
implements Test {
    byte[] sample1 = Base64.decode((String)"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");
    byte[] sample2 = Base64.decode((String)"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");

    public TestResult checkCreation() {
        Object object;
        Object object2;
        Object object3;
        X509Certificate x509Certificate;
        PublicKey publicKey;
        PrivateKey privateKey;
        Object object4;
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
        RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16), new BigInteger("9f66f6b05410cd503b2709e88115d55daced94d1a34d4e32bf824d0dde6028ae79c5f07b580f5dce240d7111f7ddb130a7945cd7d957d1920994da389f490c89", 16), new BigInteger("c0a0758cdf14256f78d4708c86becdead1b50ad4ad6c5c703e2168fbf37884cb", 16), new BigInteger("f01734d7960ea60070f1b06f2bb81bfac48ff192ae18451d5e56c734a5aab8a5", 16), new BigInteger("b54bb9edff22051d9ee60f9351a48591b6500a319429c069a3e335a1d6171391", 16), new BigInteger("d3d83daf2a0cecd3367ae6f8ae1aeb82e9ac2f816c6fc483533d8297dd7884cd", 16), new BigInteger("b8f52fc6f38593dabb661d3f50f8897f8106eee68b1bce78a95b132b4e5b5d19", 16));
        try {
            object4 = KeyFactory.getInstance("RSA", "BC");
            privateKey = ((KeyFactory)object4).generatePrivate(rSAPrivateCrtKeySpec);
            publicKey = ((KeyFactory)object4).generatePublic(rSAPublicKeySpec);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": error setting up keys - " + exception.toString());
        }
        object4 = new Hashtable();
        ((Hashtable)object4).put(X509Name.C, "AU");
        ((Hashtable)object4).put(X509Name.O, "The Legion of the Bouncy Castle");
        ((Hashtable)object4).put(X509Name.L, "Melbourne");
        ((Hashtable)object4).put(X509Name.ST, "Victoria");
        ((Hashtable)object4).put(X509Name.E, "feedback-crypto@bouncycastle.org");
        Vector<DERObjectIdentifier> vector = new Vector<DERObjectIdentifier>();
        Vector<String> vector2 = new Vector<String>();
        vector.addElement(X509Name.C);
        vector.addElement(X509Name.O);
        vector.addElement(X509Name.L);
        vector.addElement(X509Name.ST);
        vector.addElement(X509Name.E);
        vector2.addElement("AU");
        vector2.addElement("The Legion of the Bouncy Castle");
        vector2.addElement("Melbourne");
        vector2.addElement("Victoria");
        vector2.addElement("feedback-crypto@bouncycastle.org");
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        x509V3CertificateGenerator.setSerialNumber(BigInteger.valueOf(1L));
        x509V3CertificateGenerator.setIssuerDN((X509Name)new X509Principal((Hashtable)object4));
        x509V3CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        x509V3CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        x509V3CertificateGenerator.setSubjectDN((X509Name)new X509Principal((Hashtable)object4));
        x509V3CertificateGenerator.setPublicKey(publicKey);
        x509V3CertificateGenerator.setSignatureAlgorithm("MD5WithRSAEncryption");
        try {
            x509Certificate = x509V3CertificateGenerator.generateX509Certificate(privateKey);
            x509Certificate.checkValidity(new Date());
            x509Certificate.verify(publicKey);
            object3 = new ByteArrayInputStream(x509Certificate.getEncoded());
            object2 = new DERInputStream((InputStream)object3);
            object = new ByteArrayInputStream(x509Certificate.getEncoded());
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
            Certificate[] certificateArray = new Certificate[]{x509Certificate};
            PKCS7SignedData pKCS7SignedData = new PKCS7SignedData(privateKey, certificateArray, "MD5");
            byte[] byArray = Hex.decode((String)"0102030405060708091011121314");
            pKCS7SignedData.update(byArray, 0, byArray.length);
            byte[] byArray2 = pKCS7SignedData.getEncoded();
            pKCS7SignedData = new PKCS7SignedData(byArray2);
            pKCS7SignedData.update(byArray, 0, byArray.length);
            if (!pKCS7SignedData.verify()) {
                return new SimpleTestResult(false, "PKCS7 verification failed");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": error setting generating cert - " + exception.toString());
        }
        x509Certificate = new X509V1CertificateGenerator();
        x509Certificate.setSerialNumber(BigInteger.valueOf(1L));
        x509Certificate.setIssuerDN((X509Name)new X509Principal(vector, (Hashtable)object4));
        x509Certificate.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        x509Certificate.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
        x509Certificate.setSubjectDN((X509Name)new X509Principal(vector, vector2));
        x509Certificate.setPublicKey(publicKey);
        x509Certificate.setSignatureAlgorithm("MD5WithRSAEncryption");
        try {
            object3 = x509Certificate.generateX509Certificate(privateKey);
            ((X509Certificate)object3).checkValidity(new Date());
            ((Certificate)object3).verify(publicKey);
            object2 = new ByteArrayInputStream(((Certificate)object3).getEncoded());
            object = CertificateFactory.getInstance("X.509", "BC");
            object3 = (X509Certificate)((CertificateFactory)object).generateCertificate((InputStream)object2);
            if (!((X509Certificate)object3).getIssuerDN().equals(((X509Certificate)object3).getSubjectDN())) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": name comparison fails");
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": error setting generating cert - " + exception.toString());
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    public String getName() {
        return "PKCS7SignedData";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PKCS7SignedDataTest pKCS7SignedDataTest = new PKCS7SignedDataTest();
        TestResult testResult = pKCS7SignedDataTest.perform();
        System.out.println(testResult.toString());
    }

    public TestResult parseTest(byte[] byArray) {
        try {
            PKCS7SignedData pKCS7SignedData = new PKCS7SignedData(byArray);
            Certificate[] certificateArray = pKCS7SignedData.getCertificates();
            return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": exception - " + exception.toString());
        }
    }

    public TestResult perform() {
        TestResult testResult = this.parseTest(this.sample1);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.parseTest(this.sample2);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return this.checkCreation();
    }
}

