/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.jce.cert.CRLSelector;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CertificateFactory;
import org.bouncycastle.jce.cert.CollectionCertStoreParameters;
import org.bouncycastle.jce.cert.X509CRLSelector;
import org.bouncycastle.jce.cert.X509CertSelector;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class CertStoreTest
implements Test {
    public TestResult perform() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance((String)"X.509", (String)"BC");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)new ByteArrayInputStream(CertPathTest.rootCertBin));
            X509Certificate x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate((InputStream)new ByteArrayInputStream(CertPathTest.interCertBin));
            X509Certificate x509Certificate3 = (X509Certificate)certificateFactory.generateCertificate((InputStream)new ByteArrayInputStream(CertPathTest.finalCertBin));
            X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL((InputStream)new ByteArrayInputStream(CertPathTest.rootCrlBin));
            X509CRL x509CRL2 = (X509CRL)certificateFactory.generateCRL((InputStream)new ByteArrayInputStream(CertPathTest.interCrlBin));
            ArrayList<X509Extension> arrayList = new ArrayList<X509Extension>();
            arrayList.add(x509Certificate);
            arrayList.add(x509Certificate2);
            arrayList.add(x509Certificate3);
            arrayList.add(x509CRL);
            arrayList.add(x509CRL2);
            CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
            CertStore certStore = CertStore.getInstance((String)"Collection", (CertStoreParameters)collectionCertStoreParameters);
            X509CertSelector x509CertSelector = new X509CertSelector();
            x509CertSelector.setSubject(x509Certificate.getSubjectDN().getName());
            Collection collection = certStore.getCertificates((CertSelector)x509CertSelector);
            if (collection.size() != 1 || !collection.contains(x509Certificate)) {
                return new SimpleTestResult(false, this.getName() + ": rootCert not found by subjectDN");
            }
            x509CertSelector = new X509CertSelector();
            x509CertSelector.setSubject(x509Certificate.getSubjectDN().getName());
            x509CertSelector.setSubject(x509CertSelector.getSubjectAsBytes());
            collection = certStore.getCertificates((CertSelector)x509CertSelector);
            if (collection.size() != 1 || !collection.contains(x509Certificate)) {
                return new SimpleTestResult(false, this.getName() + ": rootCert not found by encoded subjectDN");
            }
            x509CertSelector = new X509CertSelector();
            x509CertSelector.setSubjectPublicKey(x509Certificate.getPublicKey().getEncoded());
            collection = certStore.getCertificates((CertSelector)x509CertSelector);
            if (collection.size() != 1 || !collection.contains(x509Certificate)) {
                return new SimpleTestResult(false, this.getName() + ": rootCert not found by encoded public key");
            }
            x509CertSelector = new X509CertSelector();
            x509CertSelector.setIssuer(x509Certificate.getSubjectDN().getName());
            collection = certStore.getCertificates((CertSelector)x509CertSelector);
            if (collection.size() != 2) {
                return new SimpleTestResult(false, this.getName() + ": did not found 2 certs");
            }
            if (!collection.contains(x509Certificate)) {
                return new SimpleTestResult(false, this.getName() + ": rootCert not found");
            }
            if (!collection.contains(x509Certificate2)) {
                return new SimpleTestResult(false, this.getName() + ": interCert not found");
            }
            X509CRLSelector x509CRLSelector = new X509CRLSelector();
            x509CRLSelector.addIssuerName(x509CRL.getIssuerDN().getName());
            Collection collection2 = certStore.getCRLs((CRLSelector)x509CRLSelector);
            if (collection2.size() != 1 || !collection2.contains(x509CRL)) {
                return new SimpleTestResult(false, this.getName() + ": rootCrl not found");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "CertStore";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertStoreTest certStoreTest = new CertStoreTest();
        TestResult testResult = certStoreTest.perform();
        System.out.println(testResult.toString());
    }
}

