/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.Hashtable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class KeyStoreTest
implements Test {
    static char[] passwd = new char[]{'h', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd'};

    public TestResult keyStoreTest(String string) {
        try {
            Object object;
            ByteArrayInputStream byteArrayInputStream;
            Object object2;
            KeyStore keyStore = KeyStore.getInstance(string, "BC");
            keyStore.load(null, null);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(1024, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
            RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
            BigInteger bigInteger = rSAPrivateKey.getModulus();
            BigInteger bigInteger2 = rSAPrivateKey.getPrivateExponent();
            Hashtable<DERObjectIdentifier, String> hashtable = new Hashtable<DERObjectIdentifier, String>();
            hashtable.put(X509Principal.C, "AU");
            hashtable.put(X509Principal.O, "The Legion of the Bouncy Castle");
            hashtable.put(X509Principal.L, "Melbourne");
            hashtable.put(X509Principal.ST, "Victoria");
            hashtable.put(X509Principal.EmailAddress, "feedback-crypto@bouncycastle.org");
            X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
            x509V3CertificateGenerator.setSerialNumber(BigInteger.valueOf(1L));
            x509V3CertificateGenerator.setIssuerDN((X509Name)new X509Principal(hashtable));
            x509V3CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
            x509V3CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 50000L));
            x509V3CertificateGenerator.setSubjectDN((X509Name)new X509Principal(hashtable));
            x509V3CertificateGenerator.setPublicKey((PublicKey)rSAPublicKey);
            x509V3CertificateGenerator.setSignatureAlgorithm("MD5WithRSAEncryption");
            Certificate[] certificateArray = new Certificate[1];
            try {
                object2 = x509V3CertificateGenerator.generateX509Certificate((PrivateKey)rSAPrivateKey);
                ((X509Certificate)object2).checkValidity(new Date());
                ((Certificate)object2).verify(rSAPublicKey);
                byteArrayInputStream = new ByteArrayInputStream(((Certificate)object2).getEncoded());
                object = CertificateFactory.getInstance("X.509", "BC");
                object2 = (X509Certificate)((CertificateFactory)object).generateCertificate(byteArrayInputStream);
                certificateArray[0] = object2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new SimpleTestResult(false, this.getName() + ": error generating cert - " + exception.toString());
            }
            keyStore.setKeyEntry("private", rSAPrivateKey, passwd, certificateArray);
            object2 = new ByteArrayOutputStream();
            keyStore.store((OutputStream)object2, passwd);
            byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
            keyStore = KeyStore.getInstance(string, "BC");
            keyStore.load(byteArrayInputStream, passwd);
            rSAPrivateKey = (RSAPrivateKey)keyStore.getKey("private", passwd);
            if (!rSAPrivateKey.getModulus().equals(bigInteger)) {
                return new SimpleTestResult(false, this.getName() + ": private key modulus wrong");
            }
            if (!rSAPrivateKey.getPrivateExponent().equals(bigInteger2)) {
                return new SimpleTestResult(false, this.getName() + ": private key exponent wrong");
            }
            object = keyStore.getCertificateChain("private")[0];
            ((Certificate)object).verify(rSAPublicKey);
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
        }
    }

    public String getName() {
        return "KeyStore";
    }

    public TestResult perform() {
        TestResult testResult = this.keyStoreTest("BKS");
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.keyStoreTest("UBER");
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyStoreTest keyStoreTest = new KeyStoreTest();
        TestResult testResult = keyStoreTest.perform();
        System.out.println(testResult.toString());
    }
}

