/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERBMPString
extends DERObject
implements DERString {
    String string;

    public DERBMPString(String string) {
        this.string = string;
    }

    public DERBMPString(byte[] byArray) {
        try {
            this.string = new String(byArray, "UnicodeBig");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString());
        }
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        while (n != cArray.length) {
            byArray[2 * n] = (byte)((cArray[n] & 0xFF00) >> 8);
            byArray[2 * n + 1] = (byte)cArray[n];
            ++n;
        }
        dEROutputStream.writeEncoded(30, byArray);
    }

    public String getString() {
        return this.string;
    }
}

